package ext {

[Native("Ext.ComponentManager", require)]
/**
 * Provides a registry of all Components (instances of →<code>ext.Component</code> or any subclass
 * thereof) on a page so that they can be easily accessed by <i>component</i> (→<code>ext.Component</code>)
 * →<code>ext.Component.id</code> (see →<code>get()</code>, or the convenience method
 * →<code>ext.Ext.getCmp()</code>).
 * <p>This object also provides a registry of available Component <i>classes</i> indexed by a
 * mnemonic code known as the Component's →<code>ext.Component.xtype</code>. The <code>xtype</code>
 * provides a way to avoid instantiating child Components when creating a full, nested
 * config object for a complete Ext page.</p>
 * <p>A child Component may be specified simply as a <i>config object</i> as long as the correct
 * <code>→ext.Component.xtype</code> is specified so that if and when the Component
 * needs rendering, the correct type can be looked up for lazy instantiation.</p>
 * @see ext.Component
 * @see ext.Component#id
 * @see SComponentManager#get()
 * @see ext.SExt#getCmp() ext.Ext.getCmp()
 * @see ext.Component#xtype
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html Original Ext JS documentation of 'Ext.ComponentManager'
 */
public const ComponentManager:SComponentManager = new SComponentManager;
}