package ext {
import ext.container.Container;
import ext.form.field.IField;

[Native("Ext.Editor", require)]
/**
 * @see ext.events.Editor_value_startValueEvent.BEFORE_COMPLETE
 * @eventType ext.events.Editor_value_startValueEvent.BEFORE_COMPLETE
 */
[Event(name='onBeforeComplete', type='ext.events.Editor_value_startValueEvent')]
/**
 * @see ext.events.Editor_boundEl_valueEvent.BEFORE_START_EDIT
 * @eventType ext.events.Editor_boundEl_valueEvent.BEFORE_START_EDIT
 */
[Event(name='onBeforeStartEdit', type='ext.events.Editor_boundEl_valueEvent')]
/**
 * @see ext.events.Editor_value_startValueEvent.CANCEL_EDIT
 * @eventType ext.events.Editor_value_startValueEvent.CANCEL_EDIT
 */
[Event(name='onCancelEdit', type='ext.events.Editor_value_startValueEvent')]
/**
 * @see ext.events.Editor_value_startValueEvent.COMPLETE
 * @eventType ext.events.Editor_value_startValueEvent.COMPLETE
 */
[Event(name='onComplete', type='ext.events.Editor_value_startValueEvent')]
/**
 * @see ext.events.Editor_field_eventEvent.SPECIAL_KEY
 * @eventType ext.events.Editor_field_eventEvent.SPECIAL_KEY
 */
[Event(name='onSpecialKey', type='ext.events.Editor_field_eventEvent')]
/**
 * @see ext.events.Editor_boundEl_valueEvent.START_EDIT
 * @eventType ext.events.Editor_boundEl_valueEvent.START_EDIT
 */
[Event(name='onStartEdit', type='ext.events.Editor_boundEl_valueEvent')]
/**
 * The Editor class is used to provide inline editing for elements on the page. The editor
 * is backed by a →<code>ext.form.field.Field</code> that will be displayed to edit the underlying
 * content. The editor is a floating Component, when the editor is shown it is automatically
 * aligned to display over the top of the bound element it is editing. The Editor contains several
 * options for how to handle key presses:
 * <ul>
 * <li>→<code>completeOnEnter</code></li>
 * <li>→<code>cancelOnEsc</code></li>
 * <li>→<code>swallowKeys</code></li>
 * </ul>
 * <p>It also has options for how to use the value once the editor has been activated:</p>
 * <ul>
 * <li>→<code>revertInvalid</code></li>
 * <li>→<code>ignoreNoChange</code></li>
 * <li>→<code>updateEl</code></li>
 * </ul>
 * <p>Sample usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var form = Ext.create('Ext.form.Panel', {
 *     renderTo: Ext.getBody(),
 *     width: 380,
 *     height: 400,
 *     title: 'User Details',
 *     bodyPadding: 10,
 *     items: [{
 *         html: 'Double-Click on the header title, this, or the field label to edit',
 *         height:30
 *     },{
 *         fieldLabel: 'First Name',
 *         name: 'firstname',
 *         xtype: 'textfield'
 *     }]
 * });
 *
 * var editor = new Ext.Editor({
 *     // update the innerHTML of the bound element
 *     // when editing completes
 *     updateEl: true,
 *     alignment: 'l-l',
 *     autoSize: {
 *         width: 'boundEl'
 *     },
 *     field: {
 *         xtype: 'textfield'
 *     }
 * });
 *
 * form.header.getTitle().textEl.on('dblclick', function(e, t) {
 *     editor.startEdit(t);
 * });
 *
 * form.getTargetEl().on('dblclick', function(e, t) {
 *     editor.startEdit(t);
 *     // Manually focus, since clicking on the label will focus the text field
 *     editor.field.focus(50, true);
 * });
 * </pre>
 * @see ext.form.field.Field
 * @see #completeOnEnter
 * @see #cancelOnEsc
 * @see #swallowKeys
 * @see #revertInvalid
 * @see #ignoreNoChange
 * @see #updateEl
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html Original Ext JS documentation of 'Ext.Editor'
 */
public class Editor extends Container {
  /**
   * @param config @inheritDoc
   */
  public function Editor(config:Editor = null) {
    super();
  }

  [ExtConfig]
  /**
   * The position to align to (see →<code>ext.util.Positionable.alignTo()</code> for more details).
   * @default 'c-c?'
   * @see ext.util.Positionable#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-alignment Original Ext JS documentation of 'alignment'
   */
  public native function get alignment():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alignment(value:String):void;

  [ExtConfig]
  /**
   * True to <i>complete the editing process</i> (→<code>completeEdit()</code>) if in edit mode when focus exits
   * from this Editor's hierarchy.
   * @default true
   * @see #completeEdit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-allowBlur Original Ext JS documentation of 'allowBlur'
   */
  public native function get allowBlur():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowBlur(value:Boolean):void;

  [ExtConfig]
  /**
   * True for the editor to automatically adopt the size of the underlying field. Otherwise,
   * an object can be passed to indicate where to get each dimension. The available properties
   * are 'boundEl' and 'field'. If a dimension is not specified, it will use the underlying
   * height/width specified on the editor object.
   * Examples:
   * <pre>
   * autoSize: true // The editor will be sized to the height/width of the field
   *
   * height: 21,
   * autoSize: {
   *     width: 'boundEl' // The width will be determined by the width of the boundEl,
   *                      // the height from the editor (21)
   * }
   *
   * autoSize: {
   *     width: 'field', // Width from the field
   *     height: 'boundEl' // Height from the boundEl
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-autoSize Original Ext JS documentation of 'autoSize'
   */
  public native function get autoSize():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoSize(value:*):void;

  [ExtConfig]
  /**
   * True to cancel the edit when the escape key is pressed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-cancelOnEsc Original Ext JS documentation of 'cancelOnEsc'
   */
  public native function get cancelOnEsc():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cancelOnEsc(value:Boolean):void;

  [ExtConfig]
  /**
   * True to complete the edit when the enter key is pressed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-completeOnEnter Original Ext JS documentation of 'completeOnEnter'
   */
  public native function get completeOnEnter():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set completeOnEnter(value:Boolean):void;

  [ExtConfig]
  /**
   * True to constrain the editor to the viewport
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  override public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set constrain(value:Boolean):void;

  /**
   * True if this editor is currently active.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#property-editing Original Ext JS documentation of 'editing'
   */
  public native function get editing():Boolean;

  [ExtConfig]
  /**
   * The Field object (or descendant) or config object for field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-field Original Ext JS documentation of 'field'
   */
  public native function get field():IField;

  [ExtConfig]
  /**
   * @private
   */
  public native function set field(value:IField):void;

  [ExtConfig]
  /**
   * False to keep the bound element visible while the editor is displayed
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-hideEl Original Ext JS documentation of 'hideEl'
   */
  public native function get hideEl():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideEl(value:Boolean):void;

  [ExtConfig]
  /**
   * True to skip the edit completion process (no save, no events fired) if the user completes
   * an edit and the value has not changed. Applies only to string values - edits for other
   * data types will never be ignored.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-ignoreNoChange Original Ext JS documentation of 'ignoreNoChange'
   */
  public native function get ignoreNoChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreNoChange(value:Boolean):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * The offsets to use when aligning (see →<code>ext.util.Positionable.alignTo()</code> for more details.
   * @default [
   *     0,
   *     0
   * ]
   * @see ext.util.Positionable#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-offsets Original Ext JS documentation of 'offsets'
   */
  public native function get offsets():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set offsets(value:Array):void;

  [ExtConfig]
  /**
   * An element to render to.
   * @default document.body
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-parentEl Original Ext JS documentation of 'parentEl'
   */
  public native function get parentEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set parentEl(value:*):void;

  [ExtConfig]
  /**
   * True to automatically revert the field value and cancel the edit when the user completes
   * an edit and the field validation fails
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-revertInvalid Original Ext JS documentation of 'revertInvalid'
   */
  public native function get revertInvalid():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set revertInvalid(value:Boolean):void;

  [ExtConfig]
  /**
   * "sides" for sides/bottom only, "frame" for 4-way shadow, and "drop" for bottom-right shadow.
   * @default 'frame'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  override public native function get shadow():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shadow(value:*):void;

  [ExtConfig]
  /**
   * Handle the keydown/keypress events so they don't propagate
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-swallowKeys Original Ext JS documentation of 'swallowKeys'
   */
  public native function get swallowKeys():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set swallowKeys(value:Boolean):void;

  [ExtConfig]
  /**
   * True to update the innerHTML of the bound element when the update completes
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-updateEl Original Ext JS documentation of 'updateEl'
   */
  public native function get updateEl():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set updateEl(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The data value of the underlying field
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:Object):void;

  /**
   * Cancels the editing process and hides the editor without persisting any changes. The field
   * value will be reverted to the original starting value.
   * @param remainVisible Override the default behavior and keep the editor
   * visible after cancel
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-cancelEdit Original Ext JS documentation of 'cancelEdit'
   */
  public native function cancelEdit(remainVisible:Boolean = false):void;

  /**
   * Ends the editing process, persists the changed value to the underlying field, and hides
   * the editor.
   * @param remainVisible Override the default behavior and keep the editor
   * visible after edit
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-completeEdit Original Ext JS documentation of 'completeEdit'
   */
  public native function completeEdit(remainVisible:Boolean = false):void;

  /**
   * Gets the data value of the editor
   * @return The data value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():*;

  /**
   * Realigns the editor to the bound field based on the current alignment config value.
   * @param autoSize True to size the field to the dimensions of the bound
   * element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-realign Original Ext JS documentation of 'realign'
   */
  public native function realign(autoSize:Boolean = false):void;

  /**
   * Sets the data value of the editor
   * @param value Any valid value supported by the underlying field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  public native function setValue(value:*):void;

  /**
   * Starts the editing process and shows the editor.
   * @param el The element to edit
   * @param value A value to initialize the editor with. If a value
   * is not provided, it defaults to the innerHTML of el.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#method-startEdit Original Ext JS documentation of 'startEdit'
   */
  public native function startEdit(el:*, value:String = null):void;
}
}