package ext {
import ext.mixin.Observable;

[Native("Ext.ElementLoader", require)]
/**
 * @see ext.events.ElementLoader_optionsEvent.BEFORE_LOAD
 * @eventType ext.events.ElementLoader_optionsEvent.BEFORE_LOAD
 */
[Event(name='onBeforeLoad', type='ext.events.ElementLoader_optionsEvent')]
/**
 * @see ext.events.ElementLoader_response_optionsEvent.EXCEPTION
 * @eventType ext.events.ElementLoader_response_optionsEvent.EXCEPTION
 */
[Event(name='onException', type='ext.events.ElementLoader_response_optionsEvent')]
/**
 * @see ext.events.ElementLoader_response_optionsEvent.LOAD
 * @eventType ext.events.ElementLoader_response_optionsEvent.LOAD
 */
[Event(name='onLoad', type='ext.events.ElementLoader_response_optionsEvent')]
/**
 * A class used to load remote content to an Element. Sample usage:
 * <pre>
 * Ext.get('el').load({
 *     url: 'myPage.php',
 *     scripts: true,
 *     params: {
 *         id: 1
 *     }
 * });
 * </pre>
 * <p>In general this class will not be instanced directly, rather the
 * →<code>ext.dom.Element.load()</code> method will be used.</p>
 * @see ext.dom.Element#load()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html Original Ext JS documentation of 'Ext.ElementLoader'
 */
public class ElementLoader extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function ElementLoader(config:ElementLoader = null) {
    super();
  }

  [ExtConfig]
  /**
   * Any additional options to be passed to the request, for example timeout or headers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-ajaxOptions Original Ext JS documentation of 'ajaxOptions'
   */
  public native function get ajaxOptions():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ajaxOptions(value:Object):void;

  [ExtConfig]
  /**
   * <code>true</code> to have the loader make a request as soon as it is created.
   * This argument can also be a set of options that will be passed to →<code>load()</code>
   * when it is called.
   * @default false
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-autoLoad Original Ext JS documentation of 'autoLoad'
   */
  public native function get autoLoad():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoLoad(value:*):void;

  [ExtConfig]
  /**
   * Params that will be attached to every request. These parameters
   * will not be overridden by any params in the load options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-baseParams Original Ext JS documentation of 'baseParams'
   */
  public native function get baseParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseParams(value:Object):void;

  [ExtConfig]
  /**
   * A function to be called when a load request finishes.
   * Will be called with the following config parameters:
   * <ul>
   * <li>this - The ElementLoader instance.</li>
   * <li>success - True if successful request.</li>
   * <li>response - The response object.</li>
   * <li>options - Ajax options.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-callback Original Ext JS documentation of 'callback'
   */
  public native function get callback():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set callback(value:*):void;

  [ExtConfig]
  /**
   * A function to be called when a load request fails.
   * Will be called with the following config parameters:
   * <ul>
   * <li>this - The ElementLoader instance.</li>
   * <li>response - The response object.</li>
   * <li>options - Ajax options.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-failure Original Ext JS documentation of 'failure'
   */
  public native function get failure():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set failure(value:*):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated ElementLoader,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#property-isLoader Original Ext JS documentation of 'isLoader'
   */
  public native function get isLoader():Boolean;

  /**
   * @private
   */
  public native function set isLoader(value:Boolean):void;

  [ExtConfig]
  /**
   * True or a string to show when the element is loading.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-loadMask Original Ext JS documentation of 'loadMask'
   */
  public native function get loadMask():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadMask(value:*):void;

  [ExtConfig]
  /**
   * Any params to be attached to the Ajax request. These parameters will
   * be overridden by any params in the load options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-params Original Ext JS documentation of 'params'
   */
  public native function get params():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set params(value:Object):void;

  [ExtConfig]
  /**
   * A custom function to render the content to the element. The function should
   * return false if the renderer could not be applied. The passed parameters are:
   * <ul>
   * <li>The loader</li>
   * <li>The response</li>
   * <li>The active request</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-renderer Original Ext JS documentation of 'renderer'
   */
  public native function get renderer():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderer(value:Function):void;

  [ExtConfig]
  /**
   * The scope to execute the →<code>renderer</code> function in.
   * @see #renderer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-rendererScope Original Ext JS documentation of 'rendererScope'
   */
  public native function get rendererScope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rendererScope(value:Object):void;

  [ExtConfig]
  /**
   * The scope to execute the →<code>success</code> and →<code>failure</code> functions in.
   * @see #success
   * @see #failure
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * True to parse any inline script tags in the response.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-scripts Original Ext JS documentation of 'scripts'
   */
  public native function get scripts():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scripts(value:Boolean):void;

  [ExtConfig]
  /**
   * A function to be called when a load request is successful.
   * Will be called with the following config parameters:
   * <ul>
   * <li>this - The ElementLoader instance.</li>
   * <li>response - The response object.</li>
   * <li>options - Ajax options.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-success Original Ext JS documentation of 'success'
   */
  public native function get success():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set success(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The target element for the loader. It can be the DOM element, the id or an
   * →<code>ext.dom.Element</code>.
   * @default null
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-target Original Ext JS documentation of 'target'
   * @see #getTarget()
   * @see #setTarget()
   */
  public native function get target():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set target(value:*):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The url to retrieve the content from.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  /**
   * Aborts the active load request
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-abort Original Ext JS documentation of 'abort'
   */
  public native function abort():void;

  /**
   * Destroys the loader. Any active requests will be aborted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the target of this loader.
   * @return The target or null if none exists.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget():Component;

  /**
   * Checks whether the loader is automatically refreshing. See →<code>startAutoRefresh()</code>.
   * @return True if the loader is automatically refreshing
   * @see #startAutoRefresh()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-isAutoRefreshing Original Ext JS documentation of 'isAutoRefreshing'
   */
  public native function isAutoRefreshing():Boolean;

  /**
   * Loads new data from the server.
   * @param options The options for the request. They can be any configuration option
   * that can be specified for the class, with the exception of the target option. Note that any
   * options passed to the method will override any class defaults.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-load Original Ext JS documentation of 'load'
   */
  public native function load(options:Object):void;

  /**
   * Sets an →<code>ext.dom.Element</code> as the target of this loader.
   * Note that if the target is changed, any active requests will be aborted.
   * @param target The element or its ID.
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-setTarget Original Ext JS documentation of 'setTarget'
   */
  public native function setTarget(target:*):void;

  /**
   * Automatically refreshes the content over a specified period.
   * @param interval The interval to refresh in ms.
   * @param options The options to pass to the load method.
   * See →<code>load()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-startAutoRefresh Original Ext JS documentation of 'startAutoRefresh'
   * @see #load()
   */
  public native function startAutoRefresh(interval:Number, options:Object = null):void;

  /**
   * Clears any auto refresh. See →<code>startAutoRefresh()</code>.
   * @see #startAutoRefresh()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#method-stopAutoRefresh Original Ext JS documentation of 'stopAutoRefresh'
   */
  public native function stopAutoRefresh():void;
}
}