package ext {

[Native("Ext", require)]
/**
 * The Ext namespace (global object) encapsulates all classes, singletons, and
 * utility methods provided by Sencha's libraries.
 * <p>Most user interface Components are at a lower level of nesting in the namespace,
 * but many common utility functions are provided as direct properties of the Ext namespace.</p>
 * <p>Also many frequently used methods from other classes are provided as shortcuts
 * within the Ext namespace. For example →<code>ext.Ext.getCmp()</code> aliases
 * →<code>ext.ComponentManager.get()</code>.</p>
 * <p>Many applications are initiated with →<code>ext.Ext.application()</code> which is
 * called once the DOM is ready. This ensures all scripts have been loaded, preventing
 * dependency issues. For example:</p>
 * <pre>
 *  Ext.application({
 *      name: 'MyApp',
 *
 *      launch: function () {
 *          Ext.Msg.alert(this.getName(), 'Ready to go!');
 *      }
 *  });
 * </pre>
 * <p><b><a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a></b> is a free tool
 * for helping you generate and build Ext JS (and Sencha Touch) applications. See
 * <code>→ext.app.Application</code> for more information about creating an app.</p>
 * <p>A lower-level technique that does not use the <code>→ext.app.Application</code> architecture is
 * →<code>ext.Ext.onReady()</code>.</p>
 * <p>You can also discuss concepts and issues with others on the
 * <a href="http://www.sencha.com/forum/">Sencha Forums</a>.</p>
 * @see ext.SExt#getCmp() ext.Ext.getCmp()
 * @see ext.SComponentManager#get() ext.ComponentManager.get()
 * @see ext.SExt#application() ext.Ext.application()
 * @see ext.app.Application
 * @see ext.SExt#onReady() ext.Ext.onReady()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html Original Ext JS documentation of 'Ext'
 */
public const Ext:SExt = new SExt;
}