package ext {

[Native("Ext.Class", require)]
/**
 * This is a low level factory that is used by →<code>ext.Ext.define()</code> and should not be used
 * directly in application code.
 * <p>The configs of this class are intended to be used in <code>Ext.define</code> calls to describe the class you
 * are declaring. For example:</p>
 * <pre>
 * Ext.define('App.util.Thing', {
 *     extend: 'App.util.Other',
 *
 *     alias: 'util.thing',
 *
 *     config: {
 *         foo: 42
 *     }
 * });
 * </pre>
 * <p>Ext.Class is the factory and <b>not</b> the superclass of everything. For the base class
 * that <b>all</b> classes inherit from, see →<code>ext.Base</code>.</p>
 * @see ext.SExt#define() ext.Ext.define()
 * @see ext.Base
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html Original Ext JS documentation of 'Ext.Class'
 */
public class ExtClass extends Object {
  /**
   * Create a new anonymous class.
   * @param Class
   * @param data An object represent the properties of this class
   * @param onCreated Optional, the callback function to be executed when this class
   * is fully created. Note that the creation process can be asynchronous depending
   * on the pre-processors used.
   * @return The newly created class
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public native function ExtClass(Class:*, data:Object, onCreated:Function);

  [ExtConfig]
  /**
   * List of short aliases for class names. An alias consists of a namespace and a name
   * concatenated by a period as &lt;namespace&gt;.&lt;name&gt;
   * <ul>
   * <li><b>namespace</b> - The namespace describes what kind of alias this is and must be
   * all lowercase.</li>
   * <li><b>name</b> - The name of the alias which allows the lazy-instantiation via the
   * alias. The name shouldn't contain any periods.</li>
   * </ul>
   * <p>A list of namespaces and the usages are:</p>
   * <ul>
   * <li><b>feature</b> - <i>Grid</i> (→<code>ext.grid.GridPanel</code>) features</li>
   * <li><b>plugin</b> - Plugins</li>
   * <li><b>store</b> - →<code>ext.data.Store</code></li>
   * <li><b>widget</b> - Components</li>
   * </ul>
   * <p>Most useful for defining xtypes for widgets:</p>
   * <pre>
   * Ext.define('MyApp.CoolPanel', {
   *     extend: 'Ext.panel.Panel',
   *     alias: ['widget.coolpanel'],
   *     title: 'Yeah!'
   * });
   *
   * // Using Ext.create
   * Ext.create('widget.coolpanel');
   *
   * // Using the shorthand for defining widgets by xtype
   * Ext.widget('panel', {
   *     items: [
   *         {xtype: 'coolpanel', html: 'Foo'},
   *         {xtype: 'coolpanel', html: 'Bar'}
   *     ]
   * });
   * </pre>
   * @see ext.grid.GridPanel
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-alias Original Ext JS documentation of 'alias'
   */
  public native function get alias():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alias(value:*):void;

  [ExtConfig]
  /**
   * Defines alternate names for this class. For example:
   * <pre>
   * Ext.define('Developer', {
   *     alternateClassName: ['Coder', 'Hacker'],
   *     code: function(msg) {
   *         alert('Typing... ' + msg);
   *     }
   * });
   *
   * var joe = Ext.create('Developer');
   * joe.code('stackoverflow');
   *
   * var rms = Ext.create('Hacker');
   * rms.code('hack hack');
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-alternateClassName Original Ext JS documentation of 'alternateClassName'
   */
  public native function get alternateClassName():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alternateClassName(value:*):void;

  [ExtConfig]
  /**
   * This configuration works in a very similar manner to the →<code>config</code> option.
   * The difference is that the configurations are only ever processed when the first instance
   * of that class is created. The processed value is then stored on the class prototype and
   * will not be processed on subsequent instances of the class. Getters/setters will be generated
   * in exactly the same way as →<code>config</code>.
   * <p>This option is useful for expensive objects that can be shared across class instances.
   * The class itself ensures that the creation only occurs once.</p>
   * @see #config
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-cachedConfig Original Ext JS documentation of 'cachedConfig'
   */
  public native function get cachedConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cachedConfig(value:Object):void;

  [ExtConfig]
  /**
   * List of configuration options with their default values.
   * <p><b>Note:</b> You need to make sure →<code>ext.Base.initConfig()</code> is called from your constructor
   * if you are defining your own class or singleton, unless you are extending a Component.
   * Otherwise the generated getter and setter methods will not be initialized.</p>
   * <p>Each config item will have its own setter and getter method automatically generated inside
   * the class prototype during class creation time, if the class does not have those methods
   * explicitly defined.</p>
   * <p>As an example, let's convert the name property of a Person class to be a config item, then
   * add extra age and gender items.</p>
   * <pre>
   * Ext.define('My.sample.Person', {
   *     config: {
   *         name: 'Mr. Unknown',
   *         age: 0,
   *         gender: 'Male'
   *     },
   *
   *     constructor: function(config) {
   *         this.initConfig(config);
   *
   *         return this;
   *     }
   *
   *     // ...
   * });
   * </pre>
   * <p>Within the class, this.name still has the default value of "Mr. Unknown". However, it's now
   * publicly accessible without sacrificing encapsulation, via setter and getter methods.</p>
   * <pre>
   * var jacky = new My.sample.Person({
   *     name: "Jacky",
   *     age: 35
   * });
   *
   * alert(jacky.getAge());      // alerts 35
   * alert(jacky.getGender());   // alerts "Male"
   *
   * jacky.setName("Mr. Nguyen");
   * alert(jacky.getName());     // alerts "Mr. Nguyen"
   * </pre>
   * <p>Notice that we changed the class constructor to invoke this.initConfig() and pass in the
   * provided config object. Two key things happened:</p>
   * <ul>
   * <li>The provided config object when the class is instantiated is recursively merged with
   * the default config object.</li>
   * <li>All corresponding setter methods are called with the merged values.</li>
   * </ul>
   * <p>Beside storing the given values, throughout the frameworks, setters generally have two key
   * responsibilities:</p>
   * <ul>
   * <li>Filtering / validation / transformation of the given value before it's actually stored
   * within the instance.</li>
   * <li>Notification (such as firing events) / post-processing after the value has been set,
   * or changed from a previous value.</li>
   * </ul>
   * <p>By standardize this common pattern, the default generated setters provide two extra template
   * methods that you can put your own custom logic into, i.e: an "applyFoo" and "updateFoo"
   * method for a "foo" config item, which are executed before and after the value is actually
   * set, respectively. Back to the example class, let's validate that age must be a valid
   * positive number, and fire an 'agechange' if the value is modified.</p>
   * <pre>
   * Ext.define('My.sample.Person', {
   *     config: {
   *         // ...
   *     },
   *
   *     constructor: {
   *         // ...
   *     },
   *
   *     applyAge: function(age) {
   *         if (typeof age !== 'number' || age &lt; 0) {
   *             console.warn("Invalid age, must be a positive number");
   *             return;
   *         }
   *
   *         return age;
   *     },
   *
   *     updateAge: function(newAge, oldAge) {
   *         // age has changed from "oldAge" to "newAge"
   *         this.fireEvent('agechange', this, newAge, oldAge);
   *     }
   *
   *     // ...
   * });
   *
   * var jacky = new My.sample.Person({
   *     name: "Jacky",
   *     age: 'invalid'
   * });
   *
   * alert(jacky.getAge());      // alerts 0
   *
   * alert(jacky.setAge(-100));  // alerts 0
   * alert(jacky.getAge());      // alerts 0
   *
   * alert(jacky.setAge(35));    // alerts 0
   * alert(jacky.getAge());      // alerts 35
   * </pre>
   * <p>In other words, when leveraging the config feature, you mostly never need to define setter
   * and getter methods explicitly. Instead, "apply&#42;" and "update&#42;" methods should be implemented
   * where necessary. Your code will be consistent throughout and only contain the minimal logic
   * that you actually care about.</p>
   * <p>When it comes to inheritance, the default config of the parent class is automatically,
   * recursively merged with the child's default config. The same applies for mixins.</p>
   * @see ext.Base#initConfig()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-config Original Ext JS documentation of 'config'
   */
  public native function get config():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set config(value:Object):void;

  [ExtConfig]
  /**
   * Config options defined within <code>→eventedConfig</code> will auto-generate the setter /
   * getter methods (see →<code>config</code> for more information on
   * auto-generated getter / setter methods). Additionally, when an
   * <code>→eventedConfig</code> is set it will also fire a before{cfg}change and {cfg}change
   * event when the value of the eventedConfig is changed from its originally
   * defined value.
   * <p><b>Note:</b> When creating a custom class you'll need to extend Ext.Evented</p>
   * <p>Example custom class:</p>
   * <pre>
   * Ext.define('MyApp.util.Test', {
   *     extend: 'Ext.Evented',
   *
   *     eventedConfig: {
   *         foo: null
   *     }
   * });
   * </pre>
   * <p>In this example, the <code>foo</code> config will initially be null. Changing it via
   * <code>setFoo</code> will fire the <code>beforefoochange</code> event. The call to the setter can be
   * halted by returning <code>false</code> from a listener on the <b>before</b> event.</p>
   * <pre>
   * var test = Ext.create('MyApp.util.Test', {
   *     listeners: {
   *         beforefoochange: function (instance, newValue, oldValue) {
   *             return newValue !== 'bar';
   *         },
   *         foochange: function (instance, newValue, oldValue) {
   *            console.log('foo changed to:', newValue);
   *         }
   *     }
   * });
   *
   * test.setFoo('bar');
   * </pre>
   * <p>The <code>before</code> event handler can be used to validate changes to <code>foo</code>.
   * Returning <code>false</code> will prevent the setter from changing the value of the
   * config. In the previous example the <code>beforefoochange</code> handler returns false
   * so <code>foo</code> will not be updated and <code>foochange</code> will not be fired.</p>
   * <pre>
   * test.setFoo('baz');
   * </pre>
   * <p>Setting <code>foo</code> to 'baz' will not be prevented by the <code>before</code> handler. Foo
   * will be set to the value: 'baz' and the <code>foochange</code> event will be fired.</p>
   * @see #eventedConfig
   * @see #config
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-eventedConfig Original Ext JS documentation of 'eventedConfig'
   */
  public native function get eventedConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set eventedConfig(value:Object):void;

  [ExtConfig]
  /**
   * The parent class that this class extends. For example:
   * <pre>
   * Ext.define('Person', {
   *     say: function(text) { alert(text); }
   * });
   *
   * Ext.define('Developer', {
   *     extend: 'Person',
   *     say: function(text) { this.callParent(["print "+text]); }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-extend Original Ext JS documentation of 'extend'
   */
  public native function get extend():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set extend(value:String):void;

  [ExtConfig]
  /**
   * List of inheritable static methods for this class.
   * Otherwise just like →<code>statics</code> but subclasses inherit these methods.
   * @see #statics
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-inheritableStatics Original Ext JS documentation of 'inheritableStatics'
   */
  public native function get inheritableStatics():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inheritableStatics(value:Object):void;

  [ExtConfig]
  /**
   * List of classes to mix into this class. For example:
   * <pre>
   * Ext.define('CanSing', {
   *      sing: function() {
   *          alert("For he's a jolly good fellow...")
   *      }
   * });
   *
   * Ext.define('Musician', {
   *      mixins: ['CanSing']
   * })
   * </pre>
   * <p>In this case the Musician class will get a <code>sing</code> method from CanSing mixin.</p>
   * <p>But what if the Musician already has a <code>sing</code> method? Or you want to mix
   * in two classes, both of which define <code>sing</code>? In such a cases it's good
   * to define mixins as an object, where you assign a name to each mixin:</p>
   * <pre>
   * Ext.define('Musician', {
   *      mixins: {
   *          canSing: 'CanSing'
   *      },
   *
   *      sing: function() {
   *          // delegate singing operation to mixin
   *          this.mixins.canSing.sing.call(this);
   *      }
   * })
   * </pre>
   * <p>In this case the <code>sing</code> method of Musician will overwrite the
   * mixed in <code>sing</code> method. But you can access the original mixed in method
   * through special <code>→mixins</code> property.</p>
   * @see #mixins
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-mixins Original Ext JS documentation of 'mixins'
   */
  public native function get mixins():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mixins(value:*):void;

  [ExtConfig("override")]
  /**
   * Overrides members of the specified <code>target</code> class.
   * <p><b>NOTE:</b> the overridden class must have been defined using
   * →<code>ext.Ext.define()</code> in order to use the <code>→override_</code> config.</p>
   * <p>Methods defined on the overriding class will not automatically call the methods of
   * the same name in the ancestor class chain. To call the parent's method of the
   * same name you must call →<code>ext.Base.callParent()</code>. To skip the
   * method of the overridden class and call its parent you will instead call
   * →<code>ext.Base.callSuper()</code>.</p>
   * <p>See →<code>ext.Ext.define()</code> for additional usage examples.</p>
   * @see ext.SExt#define() ext.Ext.define()
   * @see #override_
   * @see ext.Base#callParent()
   * @see ext.Base#callSuper()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-override Original Ext JS documentation of 'override'
   */
  public native function get override_():String;

  [ExtConfig("override")]
  /**
   * @private
   */
  public native function set override_(value:String):void;

  [ExtConfig]
  /**
   * The <code>→privates</code> config is a list of methods intended to be used internally by the
   * framework. Methods are placed in a <code>→privates</code> block to prevent developers from
   * accidentally overriding framework methods in custom classes.
   * <pre>
   * Ext.define('Computer', {
   *     privates: {
   *         runFactory: function(brand) {
   *             // internal only processing of brand passed to factory
   *             this.factory(brand);
   *         }
   *     },
   *
   *     factory: function (brand) {}
   * });
   * </pre>
   * <p>In order to override a method from a <code>→privates</code> block, the overridden method must
   * also be placed in a <code>→privates</code> block within the override class.</p>
   * <pre>
   * Ext.define('Override.Computer', {
   *     override: 'Computer',
   *     privates: {
   *         runFactory: function() {
   *             // overriding logic
   *         }
   *     }
   * });
   * </pre>
   * @see #privates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-privates Original Ext JS documentation of 'privates'
   */
  public native function get privates():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set privates(value:Object):void;

  /**
   * The prototype of this class.
   */
  public native function get prototype():Object;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * List of classes that have to be loaded before instantiating this class.
   * For example:
   * <pre>
   * Ext.define('Mother', {
   *     requires: ['Child'],
   *     giveBirth: function() {
   *         // we can be sure that child class is available.
   *         return new Child();
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-requires Original Ext JS documentation of 'requires'
   */
  public native function get requires():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set requires(value:Array):void;

  [ExtConfig]
  /**
   * When set to true, the class will be instantiated as singleton. For example:
   * <pre>
   * Ext.define('Logger', {
   *     singleton: true,
   *     log: function(msg) {
   *         console.log(msg);
   *     }
   * });
   *
   * Logger.log('Hello');
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-singleton Original Ext JS documentation of 'singleton'
   */
  public native function get singleton():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set singleton(value:Boolean):void;

  [ExtConfig]
  /**
   * List of static methods for this class. For example:
   * <pre>
   * Ext.define('Computer', {
   *      statics: {
   *          factory: function(brand) {
   *              // 'this' in static methods refer to the class itself
   *              return new this(brand);
   *          }
   *      },
   *
   *      constructor: function() { ... }
   * });
   *
   * var dellComputer = Computer.factory('Dell');
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-statics Original Ext JS documentation of 'statics'
   */
  public native function get statics():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set statics(value:Object):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * List of optional classes to load together with this class. These aren't neccessarily loaded
   * before this class is created, but are guaranteed to be available before Ext.onReady
   * listeners are invoked. For example:
   * <pre>
   * Ext.define('Mother', {
   *     uses: ['Child'],
   *     giveBirth: function() {
   *         // This code might, or might not work:
   *         // return new Child();
   *
   *         // Instead use Ext.create() to load the class at the spot if not loaded already:
   *         return Ext.create('Child');
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-uses Original Ext JS documentation of 'uses'
   */
  public native function get uses():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set uses(value:Array):void;

  [ExtConfig]
  /**
   * <b>Note:</b> Only applies to →<code>ext.Component</code> derived classes when used as
   * a config in →<code>ext.Ext.define()</code>.
   * <p>This property provides a shorter alternative to creating objects than using a full
   * class name. Using <code>→xtype</code> is the most common way to define component instances,
   * especially in a container. For example, the items in a form containing text fields
   * could be created explicitly like so:</p>
   * <pre>
   *  items: [
   *      Ext.create('Ext.form.field.Text', {
   *          fieldLabel: 'Foo'
   *      }),
   *      Ext.create('Ext.form.field.Text', {
   *          fieldLabel: 'Bar'
   *      }),
   *      Ext.create('Ext.form.field.Number', {
   *          fieldLabel: 'Num'
   *      })
   *  ]
   * </pre>
   * <p>But by using <code>→xtype</code>, the above becomes:</p>
   * <pre>
   *  items: [
   *      {
   *          xtype: 'textfield',
   *          fieldLabel: 'Foo'
   *      },
   *      {
   *          xtype: 'textfield',
   *          fieldLabel: 'Bar'
   *      },
   *      {
   *          xtype: 'numberfield',
   *          fieldLabel: 'Num'
   *      }
   *  ]
   * </pre>
   * <p>When the <code>→xtype</code> is common to many items, →<code>ext.container.Container.defaultType</code>
   * is another way to specify the <code>→xtype</code> for all items that don't have an explicit <code>→xtype</code>:</p>
   * <pre>
   *  defaultType: 'textfield',
   *  items: [
   *      { fieldLabel: 'Foo' },
   *      { fieldLabel: 'Bar' },
   *      { fieldLabel: 'Num', xtype: 'numberfield' }
   *  ]
   * </pre>
   * <p>Each member of the <code>items</code> array is now just a "configuration object". These objects
   * are used to create and configure component instances. A configuration object can be
   * manually used to instantiate a component using →<code>ext.Ext.widget()</code>:</p>
   * <pre>
   *  var text1 = Ext.create('Ext.form.field.Text', {
   *      fieldLabel: 'Foo'
   *  });
   *
   *  // or alternatively:
   *
   *  var text1 = Ext.widget({
   *      xtype: 'textfield',
   *      fieldLabel: 'Foo'
   *  });
   * </pre>
   * <p>This conversion of configuration objects into instantiated components is done when
   * a container is created as part of its {Ext.container.AbstractContainer#initComponent}
   * process. As part of the same process, the <code>items</code> array is converted from its raw
   * array form into a →<code>ext.util.MixedCollection</code> instance.</p>
   * <p>You can define your own <code>→xtype</code> on a custom <i>component</i> (→<code>ext.Component</code>) by specifying
   * the <code>→xtype</code> property in →<code>ext.Ext.define()</code>. For example:</p>
   * <pre>
   * Ext.define('MyApp.PressMeButton', {
   *     extend: 'Ext.button.Button',
   *     xtype: 'pressmebutton',
   *     text: 'Press Me'
   * });
   * </pre>
   * <p>Care should be taken when naming an <code>→xtype</code> in a custom component because there is
   * a single, shared scope for all xtypes. Third part components should consider using
   * a prefix to avoid collisions.</p>
   * <pre>
   * Ext.define('Foo.form.CoolButton', {
   *     extend: 'Ext.button.Button',
   *     xtype: 'ux-coolbutton',
   *     text: 'Cool!'
   * });
   * </pre>
   * <p>See →<code>null</code> for list of all available xtypes.</p>
   * @see ext.Component
   * @see ext.SExt#define() ext.Ext.define()
   * @see #xtype
   * @see ext.container.Container#defaultType
   * @see ext.SExt#widget() ext.Ext.widget()
   * @see ext.util.MixedCollection
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Class.html#cfg-xtype Original Ext JS documentation of 'xtype'
   */
  public native function get xtype():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set xtype(value:String):void;
}
}