package ext {

[Native("Ext.GlobalEvents", require)]
/**
 * An <code>→ext.mixin.Observable</code> through which Ext fires global events.
 * <p>Ext.on() and Ext.un() are shorthand for →<code>addListener()</code> and →<code>removeListener()</code>
 * on this Observable. For example, to listen for the idle event:</p>
 * <pre>
 * Ext.on('idle', function() {
 *     // do something
 * });
 * </pre>
 * @see ext.mixin.Observable
 * @see SGlobalEvents#addListener()
 * @see SGlobalEvents#removeListener()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html Original Ext JS documentation of 'Ext.GlobalEvents'
 */
public const GlobalEvents:SGlobalEvents = new SGlobalEvents;
}