package ext {

[Mixin("ext.ProgressBase")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html Original Ext JS documentation of 'Ext.ProgressBase'
 * @see ext.ProgressBase
 */
public interface IProgressBase {
  [ExtConfig]
  [Bindable] /**
   * A template used to create this ProgressBar's background text given two values...
   * <ul>
   * <li><code>→value</code> - The raw progress value between 0 and 1</li>
   * <li><code>percent</code> - The value as a percentage between 0 and 100</li>
   * </ul>
   * @default null
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-textTpl Original Ext JS documentation of 'textTpl'
   * @see #getTextTpl()
   * @see #setTextTpl()
   */
  function get textTpl():*;

  [ExtConfig]
  [Bindable] function set textTpl(value:*):void;

  [ExtConfig]
  [Bindable] /**
   * A floating point value between 0 and 1 (e.g., .5)
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  function get value():Number;

  [ExtConfig]
  [Bindable] function set value(value:Number):void;

  /**
   * Returns the value of <code>textTpl</code>.
   * @see #textTpl
   */
  function getTextTpl():*;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  function getValue():Number;

  /**
   * Sets the value of <code>textTpl</code>.
   * @param textTpl The new value.
   * @see #textTpl
   */
  function setTextTpl(textTpl:*):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  function setValue(value:Number):void;
}
}