package ext {

[Rename("Ext.IPromise")]
public interface IPromise {
  /**
   * Used to specify onFulfilled and onRejected callbacks that will be
   * notified when the future value becomes available.
   * <p>Those callbacks can subsequently transform the value that was
   * fulfilled or the error that was rejected. Each call to <code>→then()</code>
   * returns a new Promise of that transformed value; i.e., a Promise
   * that is fulfilled with the callback return value or rejected with
   * any error thrown by the callback.</p>
   * @param onFulfilled Callback to execute to transform a fulfillment value.
   * @param onRejected Callback to execute to transform a rejection reason.
   * @param onProgress Callback to execute to transform a progress value.
   * @return Promise that is fulfilled with the callback return value or rejected with
   * any error thrown by the callback.
   * @see #then()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html#method-then Original Ext JS documentation of 'then'
   */
  function then(onFulfilled:Function = null, onRejected:Function = null, onProgress:Function = null):IPromise;
}
}
