package ext {

[Native("Ext.Img", require)]
/**
 * Simple helper class for easily creating image components. This renders an image tag to
 * the DOM with the configured src.
 * <p><b><i>Example usage:</i></b></p>
 * <pre>
 * var changingImage = Ext.create('Ext.Img', {
 *     src: 'http://www.sencha.com/img/20110215-feat-html5.png',
 *     width: 184,
 *     height: 90,
 *     renderTo: Ext.getBody()
 * });
 *
 * // change the src of the image programmatically
 * changingImage.setSrc('http://www.sencha.com/img/20110215-feat-perf.png');
 * </pre>
 * <p>By default, only an img element is rendered and that is this component's primary
 * <i>element</i> (→<code>ext.Component.getEl()</code>). If the →<code>ext.Component.autoEl</code> property
 * is other than 'img' (the default), the a child img element will be added to the primary
 * element. This can be used to create a wrapper element around the img.</p>
 * <p><b><i>Wrapping the img in a div:</i></b></p>
 * <pre>
 * var wrappedImage = Ext.create('Ext.Img', {
 *     src: 'http://www.sencha.com/img/20110215-feat-html5.png',
 *     autoEl: 'div', // wrap in a div
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b><i>Using a glyph</i></b></p>
 * <pre>
 * var glyphImage = Ext.create('Ext.Img', {
 *     glyph: 'xf015&#64;FontAwesome',     // the "home" icon
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b><i>Image Dimensions</i></b></p>
 * <p>You should include height and width dimensions for any image owned by a parent
 * container. By omitting dimensions, an owning container will not know how to
 * size and position the image in the initial layout.</p>
 * @see ext.Component#getEl()
 * @see ext.Component#autoEl
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html Original Ext JS documentation of 'Ext.Img'
 */
public class Img extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Img(config:Img = null) {
    super();
  }

  [ExtConfig]
  /**
   * The descriptive text for non-visual UI description.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-alt Original Ext JS documentation of 'alt'
   * @see #setAlt()
   */
  public native function get alt():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set alt(value:String):void;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default 'img'
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'img'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to serve as the image. If this option is used
   * The image will be rendered using a div with innerHTML set to the html entity
   * for the given character code. The default font-family for glyphs can be set
   * globally using →<code>ext.Ext.setGlyphFontFamily()</code>. Alternatively,
   * this config option accepts a string with the charCode and font-family separated by
   * the <code>&#64;</code> symbol. For example '65&#64;My Font Family'.
   * @default null
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-glyphorig Original Ext JS documentation of 'glyphorig'
   */
  public native function get glyphorig():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set glyphorig(value:*):void;

  [ExtConfig]
  /**
   * Optional CSS classes to add to the img element.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-imgCls Original Ext JS documentation of 'imgCls'
   */
  public native function get imgCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set imgCls(value:String):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The source of this image. See →<code>ext.Ext.resolveResource()</code> for details on
   * locating application resources.
   * @see ext.SExt#resolveResource() ext.Ext.resolveResource()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-src Original Ext JS documentation of 'src'
   * @see #getSrc()
   * @see #setSrc()
   */
  public native function get src():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set src(value:String):void;

  [ExtConfig]
  /**
   * Specifies additional information about the image.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#cfg-title Original Ext JS documentation of 'title'
   * @see #setTitle()
   */
  public native function get title():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set title(value:String):void;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Returns the size of the image as an object.
   * @since 6.2.0
   * @return The size and aspect ratio of the image.
   * <ul>
   * <li><code>aspect:Number</code> (optional) —
   * The aspect ration of the image (<code>width / height</code>).
   * </li>
   * <li><code>height:Number</code> (optional) —
   * The height of the image.
   * </li>
   * <li><code>width:Number</code> (optional) —
   * The width of the image.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#method-getNaturalSize Original Ext JS documentation of 'getNaturalSize'
   */
  public native function getNaturalSize():Object;

  /**
   * Returns the value of <code>src</code>.
   * @see #src
   */
  public native function getSrc():String;

  /**
   * Updates the →<code>alt</code> of the image.
   * @see #alt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#method-setAlt Original Ext JS documentation of 'setAlt'
   */
  public native function setAlt(alt:String):void;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Sets the value of <code>src</code>.
   * @param src The new value.
   * @see #src
   */
  public native function setSrc(src:String):void;

  /**
   * Updates the →<code>title</code> of the image.
   * @see #title
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Img.html#method-setTitle Original Ext JS documentation of 'setTitle'
   */
  public native function setTitle(title:String):void;
}
}