package ext {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.util.IStoreHolder;

[Native("Ext.LoadMask", require)]
/**
 * A modal, floating Component which may be shown above a specified →<code>ext.Component</code>
 * while loading data. When shown, the configured owning Component will be covered with a modality
 * mask, and the LoadMask's →<code>msg</code> will be displayed centered, accompanied by a spinner image.
 * <p>If the →<code>store</code> config option is specified, the masking will be automatically shown
 * and then hidden synchronized with the Store's loading process.</p>
 * <p>Because this is a floating Component, its z-index will be managed by the global
 * <i>ZIndexManager</i> (→<code>ext.WindowManager</code>) object, and upon show, it will place itsef at the top
 * of the hierarchy.</p>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var myPanel = new Ext.panel.Panel({
 *     renderTo : document.body,
 *     height   : 100,
 *     width    : 200,
 *     title    : 'Foo'
 * });
 *
 * var myMask = new Ext.LoadMask({
 *     msg    : 'Please wait...',
 *     target : myPanel
 * });
 *
 * myMask.show();
 * </pre>
 * @see ext.Component
 * @see #msg
 * @see #store
 * @see ext.#WindowManager ext.WindowManager
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html Original Ext JS documentation of 'Ext.LoadMask'
 */
public class LoadMask extends Component implements IStoreHolder {
  /**
   * Creates new LoadMask.
   * @param config The config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function LoadMask(config:LoadMask = null) {
    super();
  }

  /**
   * @inheritDoc
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @inheritDoc
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated LoadMask, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#property-isLoadMask Original Ext JS documentation of 'isLoadMask'
   */
  public native function get isLoadMask():Boolean;

  /**
   * @private
   */
  public native function set isLoadMask(value:Boolean):void;

  [ExtConfig]
  /**
   * The text to display in a centered loading message box.
   * @default "Loading..."
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-msg Original Ext JS documentation of 'msg'
   */
  public native function get msg():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set msg(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> to enable an iframe shim for this LoadMask to keep
   * windowed objects from showing through.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-shim Original Ext JS documentation of 'shim'
   */
  override public native function get shim():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shim(value:Boolean):void;

  [ExtConfig]
  /**
   * Optional Store to which the mask is bound. The mask is displayed when a load request
   * is issued, and hidden on either load success, or load fail.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-store Original Ext JS documentation of 'store'
   * @see #setStore()
   */
  public native function get store():Store;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set store(value:Store):void;

  [ExtConfig]
  /**
   * The Component you wish to mask. The the mask will be
   * automatically sized upon Component resize, and the message box will be kept centered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():Component;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:Component):void;

  [ExtConfig]
  /**
   * Whether or not to use a loading message class or simply mask the bound element.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-useMsg Original Ext JS documentation of 'useMsg'
   */
  public native function get useMsg():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useMsg(value:Boolean):void;

  [ExtConfig]
  /**
   * True to mask the <i>targetEl</i> (→<code>ext.Component.getTargetEl()</code>) of the bound Component.
   * By default, the <i>el</i> (→<code>ext.Component.getEl()</code>) will be masked.
   * @default false
   * @see ext.Component#getTargetEl()
   * @see ext.Component#getEl()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#cfg-useTargetEl Original Ext JS documentation of 'useTargetEl'
   */
  public native function get useTargetEl():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useTargetEl(value:Boolean):void;

  /**
   * Changes the data store bound to this LoadMask.
   * @param store The store to bind or ID of the store.
   * When no store given (or when <code>null</code> or <code>undefined</code> passed), unbinds the existing store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.LoadMask.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}