package ext {

[Native("Ext.Loader", require)]
/**
 * This class provides dynamic loading support for JavaScript classes. Application code
 * does not typically need to call <code>→ext.Loader</code> except perhaps to configure path mappings
 * when not using <a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a>.
 * <pre>
 *  Ext.Loader.setPath('MyApp', 'app');
 * </pre>
 * <p>When using Sencha Cmd, this is handled by the "bootstrap" provided by the application
 * build script and such configuration is not necessary.</p>
 * <p><b>Typical Usage</b></p>
 * <p>The <code>→ext.Loader</code> is most often used behind the scenes to satisfy class references in
 * class declarations. Like so:</p>
 * <pre>
 *  Ext.define('MyApp.view.Main', {
 *      extend: 'Ext.panel.Panel',
 *
 *      mixins: [
 *          'MyApp.util.Mixin'
 *      ],
 *
 *      requires: [
 *          'Ext.grid.Panel'
 *      ],
 *
 *      uses: [
 *          'MyApp.util.Stuff'
 *      ]
 *  });
 * </pre>
 * <p>In all of these cases, <code>→ext.Loader</code> is used internally to resolve these class names
 * and ensure that the necessary class files are loaded.</p>
 * <p>During development, these files are loaded individually for optimal debugging. For a
 * production use, <a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a> will replace
 * all of these strings with the actual resolved class references because it ensures that
 * the classes are all contained in the build in the correct order. In development, these
 * files will not be loaded until the <code>MyApp.view.Main</code> class indicates they are needed
 * as shown above.</p>
 * <p><b>Loading Classes</b></p>
 * <p>You can also use <code>→ext.Loader</code> directly to load classes or files. The simplest form of
 * use is <code>→ext.Ext.require()</code>.</p>
 * <p>For example:</p>
 * <pre>
 *  Ext.require('MyApp.view.Main', function () {
 *      // On callback, the MyApp.view.Main class is now loaded
 *
 *      var view = new MyApp.view.Main();
 *  });
 * </pre>
 * <p>You can alternatively require classes by alias or wildcard.</p>
 * <pre>
 * Ext.require('widget.window');
 *
 * Ext.require(['widget.window', 'layout.border', 'Ext.data.Connection']);
 *
 * Ext.require(['widget.&#42;', 'layout.&#42;', 'Ext.data.&#42;']);
 * </pre>
 * <p>The callback function is optional.</p>
 * <p><b>Note</b> Using <code>Ext.require</code> at global scope will cause <code>→ext.Ext.onReady()</code> and
 * <code>→ext.app.Application.launch()</code> methods to be deferred until the required classes
 * are loaded. It is these cases where the callback function is most often unnecessary.</p>
 * <p><b><i>Using Excludes</i></b></p>
 * <p>Alternatively, you can exclude what you don't need:</p>
 * <pre>
 * // Include everything except Ext.tree.&#42;
 * Ext.exclude('Ext.tree.&#42;').require('&#42;');
 *
 * // Include all widgets except widget.checkbox&#42; (this will exclude
 * // widget.checkbox, widget.checkboxfield, widget.checkboxgroup, etc.)
 * Ext.exclude('widget.checkbox&#42;').require('widget.&#42;');
 * </pre>
 * <p><b>Dynamic Instantiation</b></p>
 * <p>Another feature enabled by <code>→ext.Loader</code> is instantiation using class names or aliases.</p>
 * <p>For example:</p>
 * <pre>
 *  var win = Ext.create({
 *      xtype: 'window',
 *
 *      // or
 *      // xclass: 'Ext.window.Window'
 *
 *      title: 'Hello'
 *  });
 * </pre>
 * <p>This form of creation can be useful if the type to create (<code>window</code> in the above) is
 * not known statically. Internally, <code>→ext.Ext.create()</code> may need to <i>synchronously</i>
 * load the desired class and its requirements. Doing this will generate a warning in
 * the console:</p>
 * <pre>
 *  [Ext.Loader] Synchronously loading 'Ext.window.Window'...
 * </pre>
 * <p>If you see these in your debug console, you should add the indicated class(es) to the
 * appropriate <code>requires</code> array (as above) or make an <code>→ext.Ext.require()</code> call.</p>
 * <p><b>Note</b> Using <code>→ext.Ext.create()</code> has some performance overhead and is best reserved
 * for cases where the target class is not known until run-time.</p>
 * @see ext.#Loader ext.Loader
 * @see ext.SExt#require() ext.Ext.require()
 * @see ext.SExt#onReady() ext.Ext.onReady()
 * @see ext.app.Application#launch()
 * @see ext.SExt#create() ext.Ext.create()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html Original Ext JS documentation of 'Ext.Loader'
 */
public const Loader:SLoader = new SLoader;
}