package ext {

[Native("Ext.Manifest", require)]
/**
 * <b>This is not a real JavaScript class and cannot be created. This is for documentation purposes
 * only.</b>
 * <p>This documentation is for →<code>ext.Ext.manifest</code></p>
 * @see ext.SExt#manifest ext.Ext.manifest
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Manifest.html Original Ext JS documentation of 'Ext.Manifest'
 */
public class Manifest extends Object {
  [ExtConfig]
  /**
   * An object keyed by package name with the value being to desired compatibility level as a
   * version number. If this is just a string, this version is assumed to apply to the framework.
   * Setting this value to less than 5 for 'ext' will enable the compatibility layer to assist
   * in the application upgrade process. For details on the upgrade process, see the
   * (Upgrade Guide)[#/guides/upgrade_50].
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Manifest.html#cfg-compatibility Original Ext JS documentation of 'compatibility'
   */
  public native function get compatibility():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set compatibility(value:*):void;

  [ExtConfig]
  /**
   * An object configuring the debugging characteristics of the framework. See <code>Ext.debugConfig</code>
   * which is set to this value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Manifest.html#cfg-debug Original Ext JS documentation of 'debug'
   */
  public native function get debug():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set debug(value:Object):void;

  [ExtConfig]
  /**
   * An object that allows developers to pass values into templates used to populate
   * →<code>null.requiredScripts</code>.
   * <p>Here is an example of passing a key along to <code>Ext.ux.google.Map</code>.</p>
   * <pre>
   *  "mashup": {
   *      "map": {  // the xtype
   *          "key": "[GOOGLE_MAPS_KEY]"
   *      }
   *  }
   * </pre>
   * @see null#requiredScripts
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Manifest.html#cfg-mashup Original Ext JS documentation of 'mashup'
   */
  public native function get mashup():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mashup(value:Object):void;

  [ExtConfig]
  /**
   * An object keyed by package name with the value being a subset of the package's <code>"package.json"</code>
   * descriptor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Manifest.html#cfg-packages Original Ext JS documentation of 'packages'
   */
  public native function get packages():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set packages(value:Object):void;
}
}