package ext {
import ext.window.MessageBoxWindow;

[Native("Ext.MessageBox", require="Ext.window.MessageBox")]
/**
 * Utility class for generating different styles of message boxes. The singleton instance,
 * Ext.MessageBox alias <code>→ext.MessageBox</code> can also be used.
 * <p>Note that a MessageBox is asynchronous. Unlike a regular JavaScript <code>→alert()</code> (which will halt
 * browser execution), showing a MessageBox will not cause the code to stop. For this reason,
 * if you have code that should only run <i>after</i> some user feedback from the MessageBox,
 * you must use a callback function (see the <code>function</code> parameter for →<code>show()</code>
 * for more details).</p>
 * <p>Basic alert</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.Msg.alert('Status', 'Changes saved successfully.');
 * </pre>
 * <p>Prompt for user data and process the result using a callback</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.Msg.prompt('Name', 'Please enter your name:', function(btn, text){
 *     if (btn == 'ok'){
 *         // process text value and close...
 *     }
 * });
 * </pre>
 * <p>Show a dialog using config options</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.Msg.show({
 *     title:'Save Changes?',
 *     message: 'You are closing a tab that has unsaved changes. Do you want to save changes?',
 *     buttons: Ext.Msg.YESNOCANCEL,
 *     icon: Ext.Msg.QUESTION,
 *     fn: function(btn) {
 *         if (btn === 'yes') {
 *             console.log('Yes pressed');
 *         } else if (btn === 'no') {
 *             console.log('No pressed');
 *         } else {
 *             console.log('Cancel pressed');
 *         }
 *     }
 * });
 * </pre>
 * <p>Showing Ext.Msg while it's already shown will cause the visible instance to be
 * overwritten with the newly passed config. While this may be the desired outcome, you
 * can also create a new MessageBox that can exist alongside the Ext.Msg
 * singleton instance.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var myMsg = Ext.create('Ext.window.MessageBox', {
 *     // set closeAction to 'destroy' if this instance is not
 *     // intended to be reused by the application
 *     closeAction: 'destroy'
 * }).show({
 *     title: 'Custom MessageBox Instance',
 *     message: 'I can exist along with Ext.Msg'
 * });
 *
 * Ext.Msg.alert('Overlapping', 'Ext.Msg instance');
 * </pre>
 * <p><b><i>Static Values</i></b></p>
 * <p>The following values can be utilized by Ext.window.MessageBox and Ext.Msg:</p>
 * <pre>
 * OK    : {text: 'OK',     itemId: 'ok'}
 * YES   : {text: 'Yes',    itemId: 'yes'}
 * NO    : {text: 'No',     itemId: 'no'}
 * CANCEL: {text: 'Cancel', itemId: 'cancel'}
 *
 * INFO    : Ext.baseCSSPrefix + 'msgbox-info'
 * WARNING : Ext.baseCSSPrefix + 'msgbox-warning'
 * QUESTION: Ext.baseCSSPrefix + 'msgbox-question'
 * ERROR   : Ext.baseCSSPrefix + 'msgbox-error'
 *
 * OKCANCEL: [
 *     {text: 'Cancel', itemId: 'cancel'},
 *     {text: 'OK',     itemId: 'ok'}
 * ]
 *
 * YESNOCANCEL: [
 *     {text: 'Cancel', itemId: 'cancel'},
 *     {text: 'No',     itemId: 'no'},
 *     {text: 'Yes',    itemId: 'yes'}
 * ]
 *
 * YESNO: [
 *     {text: 'No',  itemId: 'no'},
 *     {text: 'Yes', itemId: 'yes'}
 * ]
 * </pre>
 * @see ext.#MessageBox ext.MessageBox
 * @see SMessageBox#alert()
 * @see SMessageBox#show()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.MessageBox.html Original Ext JS documentation of 'Ext.MessageBox'
 */
public const MessageBox:MessageBoxWindow = new MessageBoxWindow();
}