package ext {

[Native("Ext.Progress", require)]
/**
 * <b>Example:</b>...
 * <pre>
 * Ext.create({
 *     xtype: 'grid',
 *     title: 'Simpsons',
 *     store: {
 *         data: [
 *             { name: 'Lisa', progress: .159 },
 *             { name: 'Bart', progress: .216 },
 *             { name: 'Homer', progress: .55 },
 *             { name: 'Maggie', progress: .167 },
 *             { name: 'Marge', progress: .145 }
 *         ]
 *     },
 *     columns: [
 *         { text: 'Name',  dataIndex: 'name' },
 *         {
 *             text: 'Progress',
 *             xtype: 'widgetcolumn',
 *             width: 120,
 *             dataIndex: 'progress',
 *             widget: {
 *                 xtype: 'progress'
 *             }
 *         }
 *     ],
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Progress.html Original Ext JS documentation of 'Ext.Progress'
 */
public class Progress extends Widget implements IProgressBase {
  /**
   * @param config @inheritDoc
   */
  public function Progress(config:Progress = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set animate(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specify as <code>true</code> to have this progress bar animate to new extent when updated.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Progress.html#cfg-animate Original Ext JS documentation of 'animate'
   * @see #getAnimate()
   * @see #setAnimate()
   */
  public native function get animated():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * The background text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Progress.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A template used to create this ProgressBar's background text given two values...
   * <ul>
   * <li><code>→value</code> - The raw progress value between 0 and 1</li>
   * <li><code>percent</code> - The value as a percentage between 0 and 100</li>
   * </ul>
   * @default null
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-textTpl Original Ext JS documentation of 'textTpl'
   * @see #getTextTpl()
   * @see #setTextTpl()
   */
  public native function get textTpl():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set textTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A floating point value between 0 and 1 (e.g., .5)
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:Number):void;

  /**
   * Returns the value of <code>animate</code>.
   * @see #animate
   */
  public native function getAnimate():Boolean;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>textTpl</code>.
   * @see #textTpl
   */
  public native function getTextTpl():*;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():Number;

  /**
   * Sets the value of <code>animate</code>.
   * @param animate The new value.
   * @see #animate
   */
  public native function setAnimate(animate:Boolean):void;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):void;

  /**
   * Sets the value of <code>textTpl</code>.
   * @param textTpl The new value.
   * @see #textTpl
   */
  public native function setTextTpl(textTpl:*):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:Number):void;
}
}