package ext {

[Native("Ext.ProgressBar", require)]
/**
 * @see ext.events.ProgressBar_value_textEvent.UPDATE
 * @eventType ext.events.ProgressBar_value_textEvent.UPDATE
 */
[Event(name='onUpdate', type='ext.events.ProgressBar_value_textEvent')]
/**
 * An updateable progress bar component. The progress bar supports two different modes: manual
 * and automatic.
 * <p>In manual mode, you are responsible for showing, updating (via →<code>updateProgress()</code>)
 * and clearing the progress bar as needed from your own code. This method is most appropriate
 * when you want to show progress throughout an operation that has predictable points of interest
 * at which you can update the control.</p>
 * <p>In automatic mode, you simply call →<code>wait()</code> and let the progress bar run indefinitely,
 * only clearing it once the operation is complete. You can optionally have the progress bar
 * wait for a specific amount of time and then clear itself. Automatic mode is most appropriate
 * for timed operations or asynchronous operations in which you have no need for indicating
 * intermediate progress.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var p = Ext.create('Ext.ProgressBar', {
 *    renderTo: Ext.getBody(),
 *    width: 300
 * });
 *
 * // Wait for 5 seconds, then update the status el (progress bar will auto-reset)
 * p.wait({
 *     interval: 500, //bar will move fast!
 *     duration: 50000,
 *     increment: 15,
 *     text: 'Updating...',
 *     scope: this,
 *     fn: function(){
 *         p.updateText('Done!');
 *     }
 * });
 * </pre>
 * @see #updateProgress()
 * @see #wait()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html Original Ext JS documentation of 'Ext.ProgressBar'
 */
public class ProgressBar extends Component implements IProgressBase {
  /**
   * @param config @inheritDoc
   */
  public function ProgressBar(config:ProgressBar = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to animate the progress bar during transitions, or an animation configuration
   * (see the →<code>animate()</code> method for details).
   * @default false
   * @see #animate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animated(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to the progress bar's wrapper element.
   * @default 'x-progress'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The progress bar element's id (defaults to an auto-generated id)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   */
  override public native function get id():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set id(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The text shown in the progress bar.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#cfg-text Original Ext JS documentation of 'text'
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  /**
   * The element to render the progress text to (defaults to the progress bar's internal
   * text element)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#cfg-textEl Original Ext JS documentation of 'textEl'
   */
  public native function get textEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set textEl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A template used to create this ProgressBar's background text given two values...
   * <ul>
   * <li><code>→value</code> - The raw progress value between 0 and 1</li>
   * <li><code>percent</code> - The value as a percentage between 0 and 100</li>
   * </ul>
   * @default null
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-textTpl Original Ext JS documentation of 'textTpl'
   * @see #getTextTpl()
   * @see #setTextTpl()
   */
  public native function get textTpl():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set textTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A floating point value between 0 and 1 (e.g., .5)
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBase.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:Number):void;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>textTpl</code>.
   * @see #textTpl
   */
  public native function getTextTpl():*;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():Number;

  /**
   * Returns true if the progress bar is currently in a →<code>wait()</code> operation
   * @return True if waiting, else false
   * @see #wait()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#method-isWaiting Original Ext JS documentation of 'isWaiting'
   */
  public native function isWaiting():Boolean;

  /**
   * Resets the progress bar value to 0 and text to empty string. If hide = true,
   * the progress bar will also be hidden (using the →<code>hideMode</code> property internally).
   * @param hide True to hide the progress bar.
   * @default false
   * @return this
   * @see #hideMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset(hide:Boolean = false):ProgressBar;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):void;

  /**
   * Sets the value of <code>textTpl</code>.
   * @param textTpl The new value.
   * @see #textTpl
   */
  public native function setTextTpl(textTpl:*):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:Number):void;

  /**
   * Updates the progress bar value, and optionally its text.
   * <p>If the text argument is not specified, then the →<code>textTpl</code> will be used to generate
   * the text. If there is no <code>→textTpl</code>, any existing text value will be unchanged. To blank out
   * existing text, pass <code>""</code>.</p>
   * <p>Note that even if the progress bar value exceeds 1, it will never automatically reset --
   * you are responsible for determining when the progress is complete and
   * calling →<code>reset()</code> to clear and/or hide the control.</p>
   * @param value A floating point value between 0 and 1 (e.g., .5)
   * @default 0
   * @param text The string to display in the progress text element
   * @default ''
   * @param animate Whether to animate the transition of the progress bar.
   * If this value is not specified, the default for the class is used
   * @default false
   * @return this
   * @see #textTpl
   * @see #reset()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#method-updateProgress Original Ext JS documentation of 'updateProgress'
   */
  public native function updateProgress(value:Number = 0, text:String = '', animate:Boolean = false):ProgressBar;

  /**
   * Updates the progress bar text. If specified, textEl will be updated, otherwise
   * the progress bar itself will display the updated text.
   * @param text The string to display in the progress text element
   * @default ''
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#method-updateText Original Ext JS documentation of 'updateText'
   */
  public native function updateText(text:String = ''):ProgressBar;

  /**
   * Initiates an auto-updating progress bar. A duration can be specified, in which case
   * the progress bar will automatically reset after a fixed amount of time and optionally call
   * a callback function if specified. If no duration is passed in, then the progress bar will run
   * indefinitely and must be manually cleared by calling →<code>reset()</code>.
   * <p>Example usage:</p>
   * <pre>
   * var p = new Ext.ProgressBar({
   *    renderTo: 'my-el'
   * });
   *
   * // Wait for 5 seconds, then update the status el (progress bar will auto-reset)
   * var p = Ext.create('Ext.ProgressBar', {
   *    renderTo: Ext.getBody(),
   *    width: 300
   * });
   *
   * // Wait for 5 seconds, then update the status el (progress bar will auto-reset)
   * p.wait({
   *    interval: 500, // bar will move fast!
   *    duration: 50000,
   *    increment: 15,
   *    text: 'Updating...',
   *    scope: this,
   *    fn: function() {
   *       p.updateText('Done!');
   *    }
   * });
   *
   * // Or update indefinitely until some async action completes, then reset manually
   * p.wait();
   * myAction.on('complete', function() {
   *     p.reset();
   *     p.updateText('Done!');
   * });
   * </pre>
   * @param config Configuration options
   * <ul>
   * <li><code>duration:Number</code> (optional) —
   * The length of time in milliseconds that the progress bar
   * should run before resetting itself (defaults to undefined, in which case it will run
   * indefinitely until reset is called)
   * </li>
   * <li><code>interval:Number</code> (optional) —
   * The length of time in milliseconds between each progress
   * update (defaults to 1000 ms)
   * </li>
   * <li><code>animate:Boolean</code> (optional) —
   * Whether to animate the transition of the progress bar.
   * If this value is not specified, the default for the class is used.
   * </li>
   * <li><code>increment:Number</code> (optional) —
   * The number of progress update segments to display within
   * the progress bar (defaults to 10). If the bar reaches the end and is still updating, it will
   * automatically wrap back to the beginning.
   * </li>
   * <li><code>text:String</code> (optional) —
   * Optional text to display in the progress bar element
   * (defaults to '').
   * </li>
   * <li><code>fn:Function</code> (optional) —
   * A callback function to execute after the progress bar finishes
   * auto-updating. The function will be called with no arguments. This function will be ignored
   * if duration is not specified since in that case the progress bar can only be stopped
   * programmatically, so any required function should be called by the same code after it resets
   * the progress bar.
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope that is passed to the callback function (only applies
   * when duration and fn are both passed).
   * </li>
   * </ul>
   * @return this
   * @see #reset()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ProgressBar.html#method-wait Original Ext JS documentation of 'wait'
   */
  public native function wait(config:Object = null):ProgressBar;
}
}