package ext {
import ext.mixin.IResponsive;

[Native("Ext.Responsive", require)]
/**
 * This is an override, not a class. To use <code>→ext.Responsive</code> you simply require it:
 * <pre>
 *  Ext.application({
 *      requires: [
 *          'Ext.Responsive'
 *      ],
 *
 *      // ...
 *  });
 * </pre>
 * <p>Once required, this override mixes in →<code>ext.mixin.Responsive</code> into <code>→ext.Component</code>
 * and <code>→ext.Widget</code> so that these classes both gain the
 * →<code>ext.mixin.Responsive.responsiveConfig</code> and
 * →<code>ext.mixin.Responsive.responsiveFormulas</code> configs.</p>
 * @see ext.Responsive
 * @see ext.mixin.Responsive
 * @see ext.Component
 * @see ext.Widget
 * @see ext.mixin.Responsive#responsiveConfig
 * @see ext.mixin.Responsive#responsiveFormulas
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Responsive.html Original Ext JS documentation of 'Ext.Responsive'
 */
public class Responsive {
}
}