package ext {
import ext.data.Connection;

[Native]
/**
 * A singleton instance of an <code>→ext.data.Connection</code>. This class is used to
 * communicate with your server side code. It can be used as follows:
 * <pre>
 *  Ext.Ajax.request({
 *      url: 'ajax_demo/sample.json',
 *
 *      success: function(response, opts) {
 *          var obj = Ext.decode(response.responseText);
 *          console.dir(obj);
 *      },
 *
 *      failure: function(response, opts) {
 *          console.log('server-side failure with status code ' + response.status);
 *      }
 *  });
 * </pre>
 * <p>Default options for all requests can be set by changing a property on the Ext.Ajax class:</p>
 * <pre>
 *  Ext.Ajax.setTimeout(60000); // 60 seconds
 * </pre>
 * <p>Any options specified in the request method for the Ajax request will override any
 * defaults set on the <code>→ext.Ajax</code> singleton. In the code sample below, the timeout for the
 * request will be 60 seconds.</p>
 * <pre>
 *  Ext.Ajax.setTimeout(120000); // 120 seconds
 *
 *  Ext.Ajax.request({
 *      url: 'page.aspx',
 *      timeout: 60000
 *  });
 * </pre>
 * <p>In general, this class will be used for all Ajax requests in your application. The main
 * reason for creating a separate <code>→ext.data.Connection</code> is for a series of
 * requests that share common settings that are different to all other requests in the
 * application.</p>
 * <p>Type of singleton Ajax.</p>
 * @see ext.data.Connection
 * @see ext.#Ajax ext.Ajax
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Ajax.html Original Ext JS documentation of 'Ext.Ajax'
 */
public class SAjax extends Connection {
  /**
   * @inheritDoc
   */
  public function SAjax(config:Connection = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * An object containing properties which are used as extra parameters to each request made
   * by this object. Session information and other data that you need
   * to pass with each request are commonly put here.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Ajax.html#property-extraParams Original Ext JS documentation of 'extraParams'
   * @see #getExtraParams()
   * @see #setExtraParams()
   */
  override public native function get extraParams():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set extraParams(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default HTTP method to be used for requests. Note that this is case-sensitive and
   * should be all caps (if not set but params are present will use <code>POST</code>, otherwise will
   * use <code>GET</code>.)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Ajax.html#property-method Original Ext JS documentation of 'method'
   * @see #getMethod()
   * @see #setMethod()
   */
  override public native function get method():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set method(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default URL to be used for requests to the server.
   * If the server receives all requests through one URL, setting this once is easier than
   * entering it on every request.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Ajax.html#property-url Original Ext JS documentation of 'url'
   */
  override public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set url(value:String):void;

  /**
   * Returns the value of <code>autoAbort</code>.
   * @see #autoAbort
   */
  override public native function getAutoAbort():Boolean;

  /**
   * Returns the value of <code>defaultHeaders</code>.
   * @see #defaultHeaders
   */
  override public native function getDefaultHeaders():Object;

  /**
   * Returns the value of <code>disableCaching</code>.
   * @see #disableCaching
   */
  override public native function getDisableCaching():Boolean;

  /**
   * Returns the value of <code>extraParams</code>.
   * @see #extraParams
   */
  override public native function getExtraParams():Object;

  /**
   * Returns the value of <code>method</code>.
   * @see #method
   */
  override public native function getMethod():String;

  /**
   * Returns the value of <code>timeout</code>.
   * @see #timeout
   */
  override public native function getTimeout():Number;

  /**
   * Sets the value of <code>autoAbort</code>.
   * @param autoAbort The new value.
   * @see #autoAbort
   */
  override public native function setAutoAbort(autoAbort:Boolean):void;

  /**
   * Sets the value of <code>defaultHeaders</code>.
   * @param defaultHeaders The new value.
   * @see #defaultHeaders
   */
  override public native function setDefaultHeaders(defaultHeaders:Object):void;

  /**
   * Sets the value of <code>disableCaching</code>.
   * @param disableCaching The new value.
   * @see #disableCaching
   */
  override public native function setDisableCaching(disableCaching:Boolean):void;

  /**
   * Sets the value of <code>extraParams</code>.
   * @param extraParams The new value.
   * @see #extraParams
   */
  override public native function setExtraParams(extraParams:Object):void;

  /**
   * Sets the value of <code>method</code>.
   * @param method The new value.
   * @see #method
   */
  override public native function setMethod(method:String):void;

  /**
   * Sets the value of <code>timeout</code>.
   * @param timeout The new value.
   * @see #timeout
   */
  override public native function setTimeout(timeout:Number):void;
}
}