package ext {

[Native]
/**
 * A set of useful static methods to deal with arrays; provide missing methods for
 * older browsers.
 * <p>Type of singleton ArrayUtil.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html Original Ext JS documentation of 'Ext.Array'
 * @see ext.#ArrayUtil ext.ArrayUtil
 */
public class SArrayUtil extends Object {
  /**
   * This method returns the index that a given item would be inserted into the
   * given (sorted) <code>array</code>. Note that the given <code>item</code> may or may not be in the
   * array. This method will return the index of where the item <i>should</i> be.
   * <p>For example:</p>
   * <pre>
   *  var array = [ 'A', 'D', 'G', 'K', 'O', 'R', 'X' ];
   *  var index = Ext.Array.binarySearch(array, 'E');
   *
   *  console.log('index: ' + index);
   *  // logs "index: 2"
   *
   *  array.splice(index, 0, 'E');
   *
   *  console.log('array : ' + array.join(''));
   *  // logs "array: ADEGKORX"
   * </pre>
   * @param array The array to search.
   * @param item The item that you want to insert into the <code>array</code>.
   * @param begin The first index in the <code>array</code> to consider.
   * @default 0
   * @param end (Default array.length) The index that marks the end of the range
   * to consider. The item at this index is <i>not</i> considered.
   * @default array.length
   * @param compareFn The comparison function that matches the sort
   * order of the <code>array</code>. The default <code>compareFn</code> compares items using less-than
   * and greater-than operators.
   * @return The index for the given item in the given array based on
   * the current sorters.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-binarySearch Original Ext JS documentation of 'binarySearch'
   */
  public native function binarySearch(array:Array, item:Object, begin:Number = 0, end:Number = NaN, compareFn:Function = null):Number;

  /**
   * Filter through an array and remove empty item as defined in
   * →<code>ext.Ext.isEmpty()</code>.
   * <p>See →<code>ext.ArrayUtil.filter()</code></p>
   * @return results
   * @see ext.SExt#isEmpty() ext.Ext.isEmpty()
   * @see ext.SArrayUtil#filter() ext.ArrayUtil.filter()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-clean Original Ext JS documentation of 'clean'
   */
  public native function clean(array:Array):Array;

  /**
   * Clone a flat array without referencing the previous one. Note that this is different
   * from <code>Ext.clone</code> since it doesn't handle recursive cloning. It's simply a convenient,
   * easy-to-remember method for <code>Array.prototype.slice.call(array)</code>.
   * @param array The array.
   * @return The clone array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone(array:Array):Array;

  /**
   * Checks whether or not the given <code>array</code> contains the specified <code>item</code>.
   * @param array The array to check.
   * @param item The item to find.
   * @return <code>true</code> if the array contains the item, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(array:Array, item:Object):Boolean;

  /**
   * Perform a set difference A-B by subtracting all items in array B from array A.
   * @return difference
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-difference Original Ext JS documentation of 'difference'
   */
  public native function difference(arrayA:Array, arrayB:Array):Array;

  /**
   * Iterates an array or an iterable value and invoke the given callback function for each
   * item.
   * <pre>
   * var countries = ['Vietnam', 'Singapore', 'United States', 'Russia'];
   *
   * Ext.Array.each(countries, function(name, index, countriesItSelf) {
   *     console.log(name);
   * });
   *
   * var sum = function() {
   *     var sum = 0;
   *
   *     Ext.Array.each(arguments, function(value) {
   *         sum += value;
   *     });
   *
   *     return sum;
   * };
   *
   * sum(1, 2, 3); // returns 6
   * </pre>
   * <p>The iteration can be stopped by returning <code>false</code> from the callback function.
   * Returning <code>undefined</code> (i.e <code>return;</code>) will only exit the callback function and
   * proceed with the next iteration of the loop.</p>
   * <pre>
   * Ext.Array.each(countries, function(name, index, countriesItSelf) {
   *     if (name === 'Singapore') {
   *         return false; // break here
   *     }
   * });
   * </pre>
   * <p>→<code>ext.Ext.each()</code> is alias for →<code>ext.ArrayUtil.each()</code></p>
   * @param array The value to be iterated. If this
   * argument is not iterable, the callback function is called once.
   * @param fn The callback function. If it returns <code>false</code>, the iteration
   * stops and this method returns the current <code>index</code>. Returning <code>undefined</code> (i.e
   * <code>return;</code>) will only exit the callback function and proceed with the next iteration
   * in the loop.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The item at the current <code>index</code> in the passed <code>array</code>
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The current <code>index</code> within the <code>array</code>
   * </li>
   * <li><code>allItems:Array</code> (optional) —
   * The <code>array</code> itself which was passed as the first argument
   * </li>
   * <li><code>return:Boolean</code> (optional) —
   * Return <code>false</code> to stop iteration.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the specified function is
   * executed.
   * @param reverse Reverse the iteration order (loop from the end to the
   * beginning).
   * @default false
   * @return If all array entries were iterated, this will be <code>true. If iteration was halted early because the passed fuction returned</code>false`, this will
   * be the index at which iteration was halted.
   * @see ext.SExt#each() ext.Ext.each()
   * @see ext.SArrayUtil#each() ext.ArrayUtil.each()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(array:*, fn:Function, scope:Object = null, reverse:Boolean = false):*;

  /**
   * Shallow compares the contents of 2 arrays using strict equality.
   * @return <code>true</code> if the arrays are equal.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-equals Original Ext JS documentation of 'equals'
   */
  public native function equals(array1:Array, array2:Array):Boolean;

  /**
   * Removes items from an array. This is functionally equivalent to the splice method
   * of Array, but works around bugs in IE8's splice method and does not copy the
   * removed elements in order to return them (because very often they are ignored).
   * @param array The Array on which to replace.
   * @param index The index in the array at which to operate.
   * @param removeCount The number of items to remove at index.
   * @return The array passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-erase Original Ext JS documentation of 'erase'
   */
  public native function erase(array:Array, index:Number, removeCount:Number):Array;

  /**
   * Executes the specified function for each array element until the function returns
   * a falsy value. If such an item is found, the function will return <code>false</code> immediately.
   * Otherwise, it will return <code>true</code>.
   * @param array
   * @param fn Callback function for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * Current item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * Index of the item.
   * </li>
   * <li><code>array:Array</code> (optional) —
   * The whole array that's being iterated.
   * </li>
   * </ul>
   * @param scope Callback function scope.
   * @return <code>true</code> if no false value is returned by the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-every Original Ext JS documentation of 'every'
   */
  public native function every(array:Array, fn:Function, scope:Object = null):Boolean;

  /**
   * Creates a new array with all of the elements of this array for which
   * the provided filtering function returns a truthy value.
   * @param array
   * @param fn Callback function for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * Current item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * Index of the item.
   * </li>
   * <li><code>array:Array</code> (optional) —
   * The whole array that's being iterated.
   * </li>
   * </ul>
   * @param scope Callback function scope.
   * @return results
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-filter Original Ext JS documentation of 'filter'
   */
  public native function filter(array:Array, fn:Function, scope:Object = null):Array;

  /**
   * Returns the first item in the array which elicits a truthy return value from the
   * passed selection function.
   * @param array The array to search
   * @param fn The selection function to execute for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * The array item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of the array item.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the
   * function is executed. Defaults to the array
   * @return The first item in the array which returned true from the selection
   * function, or null if none was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-findBy Original Ext JS documentation of 'findBy'
   */
  public native function findBy(array:Array, fn:Function, scope:Object = null):Object;

  /**
   * Recursively flattens into 1-d Array. Injects Arrays inline.
   * @param array The array to flatten
   * @return The 1-d array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-flatten Original Ext JS documentation of 'flatten'
   */
  public native function flatten(array:Array):Array;

  /**
   * Iterates an array and invoke the given callback function for each item. Note that this
   * will simply delegate to the native <code>Array.prototype.forEach</code> method if supported. It
   * doesn't support stopping the iteration by returning <code>false</code> in the callback function
   * like →<code>ext.ArrayUtil.each()</code>. However, performance could be much better in modern
   * browsers comparing with →<code>ext.ArrayUtil.each()</code>
   * @param array The array to iterate.
   * @param fn The callback function.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The item at the current <code>index</code> in the passed <code>array</code>.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The current <code>index</code> within the <code>array</code>.
   * </li>
   * <li><code>allItems:Array</code> (optional) —
   * The <code>array</code> itself which was passed as the first argument.
   * </li>
   * </ul>
   * @param scope The execution scope (<code>this</code>) in which the
   * specified function is executed.
   * @see ext.SArrayUtil#each() ext.ArrayUtil.each()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-forEach Original Ext JS documentation of 'forEach'
   */
  public native function forEach(array:Array, fn:Function, scope:Object = null):void;

  /**
   * Converts a value to an array if it's not already an array. Returns:
   * <ul>
   * <li>An empty array if given value is <code>undefined</code> or <code>null</code></li>
   * <li>Itself if given value is already an array</li>
   * <li>An array copy if given value is <i>iterable</i> (→<code>ext.Ext.isIterable()</code>) (arguments, NodeList
   * and alike)</li>
   * <li>An array with one item which is the given value, otherwise</li>
   * </ul>
   * @param value The value to convert to an array if it's not already is an array.
   * @param newReference <code>true</code> to clone the given array and return a new
   * reference if necessary.
   * @return array
   * @see ext.SExt#isIterable() ext.Ext.isIterable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-from Original Ext JS documentation of 'from'
   */
  public native function from(value:Object, newReference:Boolean = false):Array;

  /**
   * Push an item into the array only if the array doesn't contain it yet.
   * @param array The array.
   * @param item The item to include.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-include Original Ext JS documentation of 'include'
   */
  public native function include_(array:Array, item:Object):void;

  /**
   * Get the index of the provided <code>item</code> in the given <code>array</code>, a supplement for the
   * missing arrayPrototype.indexOf in Internet Explorer.
   * @param array The array to check.
   * @param item The item to find.
   * @param from The index at which to begin the search.
   * @return The index of item in the array (or -1 if it is not found).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(array:Array, item:Object, from:Number = NaN):Number;

  /**
   * Inserts items in to an array.
   * @param array The Array in which to insert.
   * @param index The index in the array at which to operate.
   * @param items The array of items to insert at index.
   * @return The array passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-insert Original Ext JS documentation of 'insert'
   */
  public native function insert(array:Array, index:Number, items:Array):Array;

  /**
   * Merge multiple arrays into one with unique items that exist in all of the arrays.
   * @return intersect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-intersect Original Ext JS documentation of 'intersect'
   */
  public native function intersect(array1:Array, array2:Array, etc:Array):Array;

  /**
   * Creates a new array with the results of calling a provided function on every element
   * in this array.
   * @param array
   * @param fn Callback function for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * Current item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * Index of the item.
   * </li>
   * <li><code>array:Array</code> (optional) —
   * The whole array that's being iterated.
   * </li>
   * </ul>
   * @param scope Callback function scope
   * @return results
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-map Original Ext JS documentation of 'map'
   */
  public native function map(array:Array, fn:Function, scope:Object = null):Array;

  /**
   * Returns the maximum value in the Array.
   * @param array The Array from which to select the maximum value.
   * @param comparisonFn a function to perform the comparison which
   * determines maximization.
   * If omitted the "&gt;" operator will be used.
   * <b>Note:</b> gt = 1; eq = 0; lt = -1
   * <ul>
   * <li><code>max</code> (optional) —
   * Current maximum value.
   * </li>
   * <li><code>item</code> (optional) —
   * The value to compare with the current maximum.
   * </li>
   * </ul>
   * @return maxValue The maximum value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-max Original Ext JS documentation of 'max'
   */
  public native function max(array:*, comparisonFn:Function = null):Object;

  /**
   * Calculates the mean of all items in the array.
   * @param array The Array to calculate the mean value of.
   * @return The mean.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-mean Original Ext JS documentation of 'mean'
   */
  public native function mean(array:Array):Number;

  /**
   * Merge multiple arrays into one with unique items.
   * <p>→<code>ext.ArrayUtil.union()</code> is alias for →<code>ext.ArrayUtil.merge()</code></p>
   * @return merged
   * @see ext.SArrayUtil#union() ext.ArrayUtil.union()
   * @see ext.SArrayUtil#merge() ext.ArrayUtil.merge()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-merge Original Ext JS documentation of 'merge'
   */
  public native function merge(array1:Array, array2:Array, ...etc):Array;

  /**
   * Returns the minimum value in the Array.
   * @param array The Array from which to select the minimum value.
   * @param comparisonFn a function to perform the comparison which
   * determines minimization.
   * If omitted the "&lt;" operator will be used.
   * <b>Note:</b> gt = 1; eq = 0; lt = -1
   * <ul>
   * <li><code>min</code> (optional) —
   * Current minimum value.
   * </li>
   * <li><code>item</code> (optional) —
   * The value to compare with the current minimum.
   * </li>
   * </ul>
   * @return minValue The minimum value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-min Original Ext JS documentation of 'min'
   */
  public native function min(array:*, comparisonFn:Function = null):Object;

  /**
   * A function used to sort an array by numeric value. By default, javascript array values
   * are coerced to strings when sorting, which can be problematic when using numeric values.
   * To ensure that the values are sorted numerically, this method can be passed to the sort
   * method:
   * <pre>
   * Ext.Array.sort(myArray, Ext.Array.numericSortFn);
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-numericSortFn Original Ext JS documentation of 'numericSortFn'
   */
  public native function numericSortFn(a:*, b:*):void;

  /**
   * Plucks the value of a property from each item in the Array. Example:
   * <pre>
   * // [el1.className, el2.className, ..., elN.className]
   * Ext.Array.pluck(Ext.query("p"), "className");
   * </pre>
   * @param array The Array of items to pluck the value from.
   * @param propertyName The property name to pluck from each element.
   * @return The value from each item in the Array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-pluck Original Ext JS documentation of 'pluck'
   */
  public native function pluck(array:*, propertyName:String):Array;

  /**
   * Pushes new items onto the end of an Array.
   * <p>Passed parameters may be single items, or arrays of items. If an Array is found in the
   * argument list, all its elements are pushed into the end of the target Array.</p>
   * @param target The Array onto which to push new items
   * @param elements The elements to add to the array. Each parameter may
   * be an Array, in which case all the elements of that Array will be pushed into the end
   * of the destination Array.
   * @return An array containing all the new items push onto the end.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-push Original Ext JS documentation of 'push'
   */
  public native function push(target:Array, ...elements):Array;

  /**
   * This method applies the <code>reduceFn</code> function against an accumulator and each
   * value of the <code>array</code> (from left-to-right) to reduce it to a single value.
   * <p>If no <code>initialValue</code> is specified, the first element of the array is used as
   * the initial value. For example:</p>
   * <pre>
   *  function reducer (previous, value, index) {
   *      console.log('[' + index + ']: (' + previous + ',' + value + '}');
   *      return previous &#42; 10 + value;
   *  }
   *
   *  v = Ext.Array.reduce([2, 3, 4], reducer);
   *  console.log('v = ' + v);
   *
   *  &gt; [1]: (2, 3)
   *  &gt; [2]: (23, 4)
   *  &gt; v = 234
   *
   *  v = Ext.Array.reduce([2, 3, 4], reducer, 1);
   *  console.log('v = ' + v);
   *
   *  &gt; [0]: (1, 2)
   *  &gt; [1]: (12, 3)
   *  &gt; [2]: (123, 4)
   *  &gt; v = 1234
   * </pre>
   * @since 6.0.0
   * @param array The array to process.
   * @param reduceFn The reducing callback function.
   * <ul>
   * <li><code>previous</code> (optional) —
   * The previous value.
   * </li>
   * <li><code>value</code> (optional) —
   * The current value.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index in the array of the current <code>value</code>.
   * </li>
   * <li><code>array:Array</code> (optional) —
   * The array to being processed.
   * </li>
   * </ul>
   * @param initialValue The starting value.
   * @return The reduced value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-reduce Original Ext JS documentation of 'reduce'
   */
  public native function reduce(array:Array, reduceFn:Function, initialValue:* = undefined):*;

  /**
   * Removes the specified item from the array if it exists.
   * @param array The array.
   * @param item The item to remove.
   * @return The passed array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(array:Array, item:Object):Array;

  /**
   * Removes item/s at the specified index.
   * @param array The array.
   * @param index The index of the item to be removed.
   * @param count The number of items to be removed.
   * @default 1
   * @return The passed array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-removeAt Original Ext JS documentation of 'removeAt'
   */
  public native function removeAt(array:Array, index:Number, count:Number = 1):Array;

  /**
   * Replaces items in an array. This is functionally equivalent to the splice method
   * of Array, but works around bugs in IE8's splice method and is often more convenient
   * to call because it accepts an array of items to insert rather than use a variadic
   * argument list.
   * @param array The Array on which to replace.
   * @param index The index in the array at which to operate.
   * @param removeCount The number of items to remove at index (can be 0).
   * @param insert An array of items to insert at index.
   * @return The array passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-replace Original Ext JS documentation of 'replace'
   */
  public native function replace(array:Array, index:Number, removeCount:Number, insert:Array = null):Array;

  /**
   * Returns a shallow copy of a part of an array. This is equivalent to the native
   * call <code>Array.prototype.slice.call(array, begin, end)</code>. This is often used when "array"
   * is "arguments" since the arguments object does not supply a slice method but can
   * be the context object to <code>Array.prototype.slice</code>.
   * @param array The array (or arguments object).
   * @param begin The index at which to begin. Negative values are offsets from
   * the end of the array.
   * @param end The index at which to end. The copied items do not include
   * end. Negative values are offsets from the end of the array. If end is omitted,
   * all items up to the end of the array are copied.
   * @return The copied piece of the array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-slice Original Ext JS documentation of 'slice'
   */
  public native function slice(array:Array, begin:Number, end:Number):Array;

  /**
   * Executes the specified function for each array element until the function returns
   * a truthy value. If such an item is found, the function will return <code>true</code> immediately.
   * Otherwise, it will return <code>false</code>.
   * @param array
   * @param fn Callback function for each item.
   * <ul>
   * <li><code>item</code> (optional) —
   * Current item.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * Index of the item.
   * </li>
   * <li><code>array:Array</code> (optional) —
   * The whole array that's being iterated.
   * </li>
   * </ul>
   * @param scope Callback function scope.
   * @return <code>true</code> if the callback function returns a truthy value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-some Original Ext JS documentation of 'some'
   */
  public native function some(array:Array, fn:Function, scope:Object = null):Boolean;

  /**
   * Sorts the elements of an Array in a stable manner (equivalently keyed values do not move
   * relative to each other). By default, this method sorts the elements alphabetically and
   * ascending.
   * <b>Note:</b> This method modifies the passed array, in the same manner as the
   * native javascript Array.sort.
   * @param array The array to sort.
   * @param sortFn The comparison function.
   * <ul>
   * <li><code>a</code> (optional) —
   * The first item to compare.
   * </li>
   * <li><code>b</code> (optional) —
   * The second item to compare.
   * </li>
   * <li><code>return:Number</code> (optional) —
   * <code>-1</code> if a &lt; b, <code>1</code> if a &gt; b, otherwise <code>0</code>.
   * </li>
   * </ul>
   * @return The sorted array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-sort Original Ext JS documentation of 'sort'
   */
  public native function sort(array:Array, sortFn:Function = null):Array;

  /**
   * Replaces items in an array. This is equivalent to the splice method of Array, but
   * works around bugs in IE8's splice method. The signature is exactly the same as the
   * splice method except that the array is the first argument. All arguments following
   * removeCount are inserted in the array at index.
   * @param array The Array on which to replace.
   * @param index The index in the array at which to operate.
   * @param removeCount The number of items to remove at index (can be 0).
   * @param elements The elements to add to the array. If you don't specify
   * any elements, splice simply removes elements from the array.
   * @return An array containing the removed items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-splice Original Ext JS documentation of 'splice'
   */
  public native function splice(array:Array, index:Number, removeCount:Number, ...elements):Array;

  /**
   * Calculates the sum of all items in the given array.
   * @param array The Array to calculate the sum value of.
   * @return The sum.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-sum Original Ext JS documentation of 'sum'
   */
  public native function sum(array:Array):Number;

  /**
   * Converts any iterable (numeric indices and a length property) into a true array.
   * <pre>
   * function test() {
   *     var args = Ext.Array.toArray(arguments),
   *         fromSecondToLastArgs = Ext.Array.toArray(arguments, 1);
   *
   *     alert(args.join(' '));
   *     alert(fromSecondToLastArgs.join(' '));
   * }
   *
   * test('just', 'testing', 'here'); // alerts 'just testing here';
   *                                  // alerts 'testing here';
   *
   * // will convert the NodeList into an array
   * Ext.Array.toArray(document.getElementsByTagName('div'));
   * Ext.Array.toArray('splitted'); // returns ['s', 'p', 'l', 'i', 't', 't', 'e', 'd']
   * Ext.Array.toArray('splitted', 0, 3); // returns ['s', 'p', 'l']
   * </pre>
   * <p>→<code>ext.Ext.toArray()</code> is alias for →<code>ext.ArrayUtil.toArray()</code></p>
   * @param iterable the iterable object to be turned into a true Array.
   * @param start a zero-based index that specifies the start of extraction.
   * @default 0
   * @param end a 1-based index that specifies the end of extraction.
   * @default -1
   * @see ext.SExt#toArray() ext.Ext.toArray()
   * @see ext.SArrayUtil#toArray() ext.ArrayUtil.toArray()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-toArray Original Ext JS documentation of 'toArray'
   */
  public native function toArray(iterable:Object, start:Number = 0, end:Number = -1):Array;

  /**
   * Creates a map (object) keyed by the elements of the given array. The values in
   * the map are the index+1 of the array element. For example:
   * <pre>
   *  var map = Ext.Array.toMap(['a','b','c']);
   *
   *  // map = { a: 1, b: 2, c: 3 };
   * </pre>
   * <p>Or a key property can be specified:</p>
   * <pre>
   *  var map = Ext.Array.toMap([
   *          { name: 'a' },
   *          { name: 'b' },
   *          { name: 'c' }
   *      ], 'name');
   *
   *  // map = { a: 1, b: 2, c: 3 };
   * </pre>
   * <p>Lastly, a key extractor can be provided:</p>
   * <pre>
   *  var map = Ext.Array.toMap([
   *          { name: 'a' },
   *          { name: 'b' },
   *          { name: 'c' }
   *      ], function(obj) { return obj.name.toUpperCase(); });
   *
   *  // map = { A: 1, B: 2, C: 3 };
   * </pre>
   * @param strings The strings from which to create the map.
   * @param getKey Name of the object property to use
   * as a key or a function to extract the key.
   * @param scope Value of <code>this</code> inside callback specified for <code>getKey</code>.
   * @return The resulting map.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-toMap Original Ext JS documentation of 'toMap'
   */
  public native function toMap(strings:*, getKey:* = undefined, scope:Object = null):Object;

  /**
   * Creates a map (object) keyed by a property of elements of the given array. The values in
   * the map are the array element. For example:
   * <pre>
   *  var map = Ext.Array.toValueMap(['a','b','c']);
   *
   *  // map = { a: 'a', b: 'b', c: 'c' };
   * </pre>
   * <p>Or a key property can be specified:</p>
   * <pre>
   *  var map = Ext.Array.toValueMap([
   *          { name: 'a' },
   *          { name: 'b' },
   *          { name: 'c' }
   *      ], 'name');
   *
   *  // map = { a: {name: 'a'}, b: {name: 'b'}, c: {name: 'c'} };
   * </pre>
   * <p>Lastly, a key extractor can be provided:</p>
   * <pre>
   *  var map = Ext.Array.toValueMap([
   *          { name: 'a' },
   *          { name: 'b' },
   *          { name: 'c' }
   *      ], function(obj) { return obj.name.toUpperCase(); });
   *
   *  // map = { A: {name: 'a'}, B: {name: 'b'}, C: {name: 'c'} };
   * </pre>
   * @param array The Array to create the map from.
   * @param getKey Name of the object property to use
   * as a key or a function to extract the key.
   * @param scope Value of this inside callback. This parameter is only
   * passed when <code>getKey</code> is a function. If <code>getKey</code> is not a function, the 3rd
   * argument is <code>arrayify</code>.
   * @param arrayify Pass <code>1</code> to create arrays for all map entries
   * or <code>2</code> to create arrays for map entries that have 2 or more items with the
   * same key. This only applies when <code>getKey</code> is specified. By default the map will
   * hold the last entry with a given key.
   * @return The resulting map.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-toValueMap Original Ext JS documentation of 'toValueMap'
   */
  public native function toValueMap(array:Array, getKey:* = undefined, scope:Object = null, arrayify:Number = NaN):Object;

  /**
   * Merge multiple arrays into one with unique items.
   * <p>→<code>ext.ArrayUtil.union()</code> is alias for →<code>ext.ArrayUtil.merge()</code></p>
   * @return merged
   * @see ext.SArrayUtil#union() ext.ArrayUtil.union()
   * @see ext.SArrayUtil#merge() ext.ArrayUtil.merge()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-union Original Ext JS documentation of 'union'
   */
  public native function union(array1:Array, array2:Array, ...etc):Array;

  /**
   * Returns a new array with unique items.
   * @return results
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Array.html#method-unique Original Ext JS documentation of 'unique'
   */
  public native function unique(array:Array):Array;
}
}