package ext {
import ext.mixin.IBufferableMixin;

[Native]
/**
 * Provides a registry of all Components (instances of →<code>ext.Component</code> or any subclass
 * thereof) on a page so that they can be easily accessed by <i>component</i> (→<code>ext.Component</code>)
 * →<code>ext.Component.id</code> (see →<code>get()</code>, or the convenience method
 * →<code>ext.Ext.getCmp()</code>).
 * <p>This object also provides a registry of available Component <i>classes</i> indexed by a
 * mnemonic code known as the Component's →<code>ext.Component.xtype</code>. The <code>xtype</code>
 * provides a way to avoid instantiating child Components when creating a full, nested
 * config object for a complete Ext page.</p>
 * <p>A child Component may be specified simply as a <i>config object</i> as long as the correct
 * <code>→ext.Component.xtype</code> is specified so that if and when the Component
 * needs rendering, the correct type can be looked up for lazy instantiation.</p>
 * <p>Type of singleton ComponentManager.</p>
 * @see ext.Component
 * @see ext.Component#id
 * @see SComponentManager#get()
 * @see ext.SExt#getCmp() ext.Ext.getCmp()
 * @see ext.Component#xtype
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html Original Ext JS documentation of 'Ext.ComponentManager'
 * @see ext.#ComponentManager ext.ComponentManager
 */
public class SComponentManager extends Base implements IBufferableMixin {
  /**
   * Creates a new Component from the specified config object using the config object's
   * <code>xtype</code> to determine the class to instantiate.
   * @param config A configuration object for the Component you wish to create.
   * @param defaultType The <code>xtype</code> to use if the config object does not
   * contain a <code>xtype</code>. (Optional if the config contains a <code>xtype</code>).
   * @return The newly instantiated Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-create Original Ext JS documentation of 'create'
   */
  public native function create(config:Object, defaultType:String = null):Component;

  /**
   * Executes the specified function once for each item in the collection.
   * @param fn The function to execute.
   * <ul>
   * <li><code>key:String</code> (optional) —
   * The key of the item
   * </li>
   * <li><code>value:Number</code> (optional) —
   * The value of the item
   * </li>
   * <li><code>length:Number</code> (optional) —
   * The total number of items in the collection &#42;&#42; Removed
   * in 5.0 &#42;&#42;
   * </li>
   * <li><code>return:Boolean</code> (optional) —
   * False to cease iteration.
   * </li>
   * </ul>
   * @param scope The scope to execute in. Defaults to <code>this</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object):void;

  /**
   * Returns an item by id.
   * @param id The id of the item
   * @return The item, undefined if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(id:String):Component;

  /**
   * Returns an array of all components
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-getAll Original Ext JS documentation of 'getAll'
   */
  public native function getAll():Array;

  /**
   * Gets the number of items in the collection.
   * @return The number of items in the collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Registers a function that will be called (a single time) when an item with the specified
   * id is added to the manager. This will happen on instantiation.
   * @param id The item id
   * @param fn The callback function. Called with a single parameter, the item.
   * @param scope The scope ('this' reference) in which the callback is executed.
   * Defaults to the item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentManager.html#method-onAvailable Original Ext JS documentation of 'onAvailable'
   */
  public native function onAvailable(id:String, fn:Function, scope:Object = null):void;
}
}