package ext {
import js.Event;
import js.HTMLElement;

[Deprecated(message="Please use the Ext.dom.Element api to attach listeners to DOM Elements\n", since="5.0.0")]
[Native]
/**
 * Registers event handlers on DOM elements.
 * <p>This class is deprecated. Please use the Ext.dom.Element api to attach listeners to
 * DOM Elements. For example:</p>
 * <pre>
 * var element = Ext.get('myId');
 *
 * element.on('click', function(e) {
 *     // event handling logic here
 * });
 * </pre>
 * <p>Type of singleton EventManager.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html Original Ext JS documentation of 'Ext.EventManager'
 * @see ext.#EventManager ext.EventManager
 */
public class SEventManager extends Base {
  /**
   * Appends an event handler to an element. The shorthand version →<code>on()</code> is equivalent.
   * Typically you will use →<code>ext.dom.Element.addListener()</code> directly on an Element in favor of
   * calling this version.
   * <p>→<code>ext.EventManager.on()</code> is an alias for →<code>ext.EventManager.addListener()</code>.</p>
   * @param element The html element or id to assign
   * the event handler to.
   * @param eventName The name of the event to listen for.
   * May also be an object who's property names are event names.
   * @param fn The handler function the event invokes. A String parameter
   * is assumed to be method name in <code>scope</code> object, or Element object if no scope is provided.
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The <i>EventObject</i> (→<code>ext.event.Event</code>) describing
   * the event.
   * </li>
   * <li><code>target:ext.dom.Element</code> (optional) —
   * The Element which was the target of the event.
   * Note that this may be filtered by using the <code>delegate</code> option.
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options object from the addListener call.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the handler function
   * is executed. Defaults to the Element.
   * @param options An object containing handler configuration properties.
   * This may contain any of the following properties (See →<code>ext.dom.Element.addListener()</code>
   * for examples of how to use these options.):
   * <ul>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the handler function
   * is executed. Defaults to the Element.
   * </li>
   * <li><code>delegate:String</code> (optional) —
   * A simple selector to filter the target or look for
   * a descendant of the target. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * </li>
   * <li><code>stopEvent:Boolean</code> (optional) —
   * True to stop the event. That is stop propagation,
   * and prevent the default action.
   * </li>
   * <li><code>preventDefault:Boolean</code> (optional) —
   * True to prevent the default action
   * </li>
   * <li><code>stopPropagation:Boolean</code> (optional) —
   * True to prevent event propagation
   * </li>
   * <li><code>normalized:Boolean</code> (optional) —
   * False to pass a browser event to the handler function
   * instead of an Ext.event.Event
   * </li>
   * <li><code>delay:Number</code> (optional) —
   * The number of milliseconds to delay the invocation of the
   * handler after te event fires.
   * </li>
   * <li><code>single:Boolean</code> (optional) —
   * True to add a handler to handle just the next firing of the
   * event, and then remove itself.
   * </li>
   * <li><code>buffer:Number</code> (optional) —
   * Causes the handler to be scheduled to run in an
   * →<code>ext.util.DelayedTask</code> delayed by the specified number of milliseconds. If the event
   * fires again within that time, the original handler is <i>not</i> invoked, but the new handler
   * is scheduled in its place.
   * </li>
   * <li><code>target:ext.dom.Element</code> (optional) —
   * Only call the handler if the event was fired
   * on the target Element, <i>not</i> if the event was bubbled up from a child node.
   * </li>
   * <li><code>capture:Boolean</code> (optional) —
   * <code>true</code> to initiate capture which will fire the listeners
   * on the target Element <i>before</i> any descendant Elements. Normal events start with the target
   * element and propagate upward to ancestor elements, whereas captured events propagate
   * from the top of the DOM downward to descendant elements. This option is the same
   * as the useCapture parameter in the javascript addEventListener method.
   * </li>
   * </ul>
   * @see SEventManager#on()
   * @see ext.dom.Element#addListener()
   * @see ext.SEventManager#on() ext.EventManager.on()
   * @see ext.SEventManager#addListener() ext.EventManager.addListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-addListener Original Ext JS documentation of 'addListener'
   * @see ext.event.Event
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   * @see ext.util.DelayedTask
   */
  public native function addListener(element:*, eventName:String, fn:Function, scope:Object = null, options:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Get the id of the element. If one has not been assigned, automatically assign it.
   * @param element The element to get the id for.
   * @return id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getId Original Ext JS documentation of 'getId'
   */
  public native function getId(element:*):String;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Gets the x coordinate from the event
   * @param event The event
   * @return The x coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getPageX Original Ext JS documentation of 'getPageX'
   */
  public native function getPageX(event:Object):Number;

  [ArrayElementType("Number")]
  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Gets the x &amp; y coordinate from the event
   * @param event The event
   * @return The x/y coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getPageXY Original Ext JS documentation of 'getPageXY'
   */
  public native function getPageXY(event:Object):Array;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Gets the y coordinate from the event
   * @param event The event
   * @return The y coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getPageY Original Ext JS documentation of 'getPageY'
   */
  public native function getPageY(event:Object):Number;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Gets the related target from the event.
   * @param event The event
   * @return The related target.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getRelatedTarget Original Ext JS documentation of 'getRelatedTarget'
   */
  public native function getRelatedTarget(event:Object):HTMLElement;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Gets the target of the event.
   * @param event The event
   * @return target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget(event:Object):HTMLElement;

  /**
   * Appends an event handler to an element. The shorthand version →<code>on()</code> is equivalent.
   * Typically you will use →<code>ext.dom.Element.addListener()</code> directly on an Element in favor of
   * calling this version.
   * <p>→<code>ext.EventManager.on()</code> is an alias for →<code>ext.EventManager.addListener()</code>.</p>
   * @param element The html element or id to assign
   * the event handler to.
   * @param eventName The name of the event to listen for.
   * May also be an object who's property names are event names.
   * @param fn The handler function the event invokes. A String parameter
   * is assumed to be method name in <code>scope</code> object, or Element object if no scope is provided.
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The <i>EventObject</i> (→<code>ext.event.Event</code>) describing
   * the event.
   * </li>
   * <li><code>target:ext.dom.Element</code> (optional) —
   * The Element which was the target of the event.
   * Note that this may be filtered by using the <code>delegate</code> option.
   * </li>
   * <li><code>options:Object</code> (optional) —
   * The options object from the addListener call.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the handler function
   * is executed. Defaults to the Element.
   * @param options An object containing handler configuration properties.
   * This may contain any of the following properties (See →<code>ext.dom.Element.addListener()</code>
   * for examples of how to use these options.):
   * <ul>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the handler function
   * is executed. Defaults to the Element.
   * </li>
   * <li><code>delegate:String</code> (optional) —
   * A simple selector to filter the target or look for
   * a descendant of the target. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * </li>
   * <li><code>stopEvent:Boolean</code> (optional) —
   * True to stop the event. That is stop propagation,
   * and prevent the default action.
   * </li>
   * <li><code>preventDefault:Boolean</code> (optional) —
   * True to prevent the default action
   * </li>
   * <li><code>stopPropagation:Boolean</code> (optional) —
   * True to prevent event propagation
   * </li>
   * <li><code>normalized:Boolean</code> (optional) —
   * False to pass a browser event to the handler function
   * instead of an Ext.event.Event
   * </li>
   * <li><code>delay:Number</code> (optional) —
   * The number of milliseconds to delay the invocation of the
   * handler after te event fires.
   * </li>
   * <li><code>single:Boolean</code> (optional) —
   * True to add a handler to handle just the next firing of the
   * event, and then remove itself.
   * </li>
   * <li><code>buffer:Number</code> (optional) —
   * Causes the handler to be scheduled to run in an
   * →<code>ext.util.DelayedTask</code> delayed by the specified number of milliseconds. If the event
   * fires again within that time, the original handler is <i>not</i> invoked, but the new handler
   * is scheduled in its place.
   * </li>
   * <li><code>target:ext.dom.Element</code> (optional) —
   * Only call the handler if the event was fired
   * on the target Element, <i>not</i> if the event was bubbled up from a child node.
   * </li>
   * <li><code>capture:Boolean</code> (optional) —
   * <code>true</code> to initiate capture which will fire the listeners
   * on the target Element <i>before</i> any descendant Elements. Normal events start with the target
   * element and propagate upward to ancestor elements, whereas captured events propagate
   * from the top of the DOM downward to descendant elements. This option is the same
   * as the useCapture parameter in the javascript addEventListener method.
   * </li>
   * </ul>
   * @see SEventManager#on()
   * @see ext.dom.Element#addListener()
   * @see ext.SEventManager#on() ext.EventManager.on()
   * @see ext.SEventManager#addListener() ext.EventManager.addListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-on Original Ext JS documentation of 'on'
   * @see ext.event.Event
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   * @see ext.util.DelayedTask
   */
  public native function on(element:*, eventName:String, fn:* = undefined, scope:Object = null, options:Object = null):void;

  [Deprecated(replacement="on", since="5.0.0")]
  /**
   * Adds a listener to be notified when the browser window is resized and provides resize event
   * buffering (100 milliseconds), passes new viewport width and height to handlers.
   * @param fn The handler function the window resize event invokes.
   * @param scope The scope (<code>this</code> reference) in which the handler
   * function executes. Defaults to the browser window.
   * @param options Options object as passed to →<code>ext.dom.Element.addListener()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-onWindowResize Original Ext JS documentation of 'onWindowResize'
   * @see ext.dom.Element#addListener()
   */
  public native function onWindowResize(fn:Function, scope:Object = null, options:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Adds a listener to be notified when the browser window is unloaded.
   * @param fn The handler function the window unload event invokes.
   * @param scope The scope (<code>this</code> reference) in which the handler
   * function executes. Defaults to the browser window.
   * @param options Options object as passed to →<code>ext.dom.Element.addListener()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-onWindowUnload Original Ext JS documentation of 'onWindowUnload'
   * @see ext.dom.Element#addListener()
   */
  public native function onWindowUnload(fn:Function, scope:Object = null, options:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Prevents the browsers default handling of the event.
   * @param event The event to prevent the default
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function preventDefault(event:Event):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Recursively removes all previous added listeners from an element and its children.
   * Typically you will use →<code>ext.dom.Element.clearListeners()</code> directly on an Element
   * in favor of calling this method.
   * @param element The id or html element from which
   * to remove all event handlers.
   * @param eventName The name of the event.
   * @see ext.dom.Element#clearListeners()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-purgeElement Original Ext JS documentation of 'purgeElement'
   */
  public native function purgeElement(element:*, eventName:String = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Removes all event handers from an element. Typically you will use →<code>ext.dom.Element.clearListeners()</code> directly on an Element in favor of calling this method.
   * @param element The id or html element from which
   * to remove all event handlers.
   * @see ext.dom.Element#clearListeners()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  public native function removeAll(element:*):void;

  /**
   * Removes an event handler from an element. The shorthand version →<code>un()</code> is equivalent.
   * Typically you will use →<code>ext.dom.Element.removeListener()</code> directly on an Element in favor
   * of calling this version.
   * <p>→<code>ext.EventManager.on()</code> is an alias for →<code>ext.EventManager.addListener()</code>.</p>
   * @param element The id or html element from which
   * to remove the listener.
   * @param eventName The name of the event.
   * @param fn The handler function to remove. <b>This must be a reference to the
   * function passed into the →<code>addListener()</code> call.</b>
   * @param scope If a scope (<code>this</code> reference) was specified when the listener
   * was added, then this must refer to the same object.
   * @see SEventManager#un()
   * @see ext.dom.Element#removeListener()
   * @see ext.SEventManager#on() ext.EventManager.on()
   * @see ext.SEventManager#addListener() ext.EventManager.addListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-removeListener Original Ext JS documentation of 'removeListener'
   * @see SEventManager#addListener()
   */
  public native function removeListener(element:*, eventName:String, fn:Function, scope:Object = null, options:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Removes the passed window resize listener.
   * @param fn The method the event invokes
   * @param scope The scope of handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-removeResizeListener Original Ext JS documentation of 'removeResizeListener'
   */
  public native function removeResizeListener(fn:Function, scope:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Removes the passed window unload listener.
   * @param fn The method the event invokes
   * @param scope The scope of handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-removeUnloadListener Original Ext JS documentation of 'removeUnloadListener'
   */
  public native function removeUnloadListener(fn:Function, scope:Object = null):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Stop the event (preventDefault and stopPropagation)
   * @param event The event to stop
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-stopEvent Original Ext JS documentation of 'stopEvent'
   */
  public native function stopEvent(event:Event):void;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Cancels bubbling of the event.
   * @param event The event to stop bubbling.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-stopPropagation Original Ext JS documentation of 'stopPropagation'
   */
  public native function stopPropagation(event:Event):void;

  /**
   * Removes an event handler from an element. The shorthand version →<code>un()</code> is equivalent.
   * Typically you will use →<code>ext.dom.Element.removeListener()</code> directly on an Element in favor
   * of calling this version.
   * <p>→<code>ext.EventManager.on()</code> is an alias for →<code>ext.EventManager.addListener()</code>.</p>
   * @param element The id or html element from which
   * to remove the listener.
   * @param eventName The name of the event.
   * @param fn The handler function to remove. <b>This must be a reference to the
   * function passed into the →<code>addListener()</code> call.</b>
   * @param scope If a scope (<code>this</code> reference) was specified when the listener
   * was added, then this must refer to the same object.
   * @see SEventManager#un()
   * @see ext.dom.Element#removeListener()
   * @see ext.SEventManager#on() ext.EventManager.on()
   * @see ext.SEventManager#addListener() ext.EventManager.addListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.EventManager.html#method-un Original Ext JS documentation of 'un'
   * @see SEventManager#addListener()
   */
  public native function un(element:*, eventName:String, fn:Function, scope:Object = null, options:Object = null):void;
}
}