package ext {
import ext.app.Application;
import ext.container.Container;
import ext.data.Store;
import ext.dom.Element;

import js.HTMLElement;

[Native]
/**
 * The Ext namespace (global object) encapsulates all classes, singletons, and
 * utility methods provided by Sencha's libraries.
 * <p>Most user interface Components are at a lower level of nesting in the namespace,
 * but many common utility functions are provided as direct properties of the Ext namespace.</p>
 * <p>Also many frequently used methods from other classes are provided as shortcuts
 * within the Ext namespace. For example →<code>ext.Ext.getCmp()</code> aliases
 * →<code>ext.ComponentManager.get()</code>.</p>
 * <p>Many applications are initiated with →<code>ext.Ext.application()</code> which is
 * called once the DOM is ready. This ensures all scripts have been loaded, preventing
 * dependency issues. For example:</p>
 * <pre>
 *  Ext.application({
 *      name: 'MyApp',
 *
 *      launch: function () {
 *          Ext.Msg.alert(this.getName(), 'Ready to go!');
 *      }
 *  });
 * </pre>
 * <p><b><a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a></b> is a free tool
 * for helping you generate and build Ext JS (and Sencha Touch) applications. See
 * <code>→ext.app.Application</code> for more information about creating an app.</p>
 * <p>A lower-level technique that does not use the <code>→ext.app.Application</code> architecture is
 * →<code>ext.Ext.onReady()</code>.</p>
 * <p>You can also discuss concepts and issues with others on the
 * <a href="http://www.sencha.com/forum/">Sencha Forums</a>.</p>
 * <p>Type of singleton Ext.</p>
 * @see ext.SExt#getCmp() ext.Ext.getCmp()
 * @see ext.SComponentManager#get() ext.ComponentManager.get()
 * @see ext.SExt#application() ext.Ext.application()
 * @see ext.app.Application
 * @see ext.SExt#onReady() ext.Ext.onReady()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html Original Ext JS documentation of 'Ext'
 * @see ext.#Ext ext.Ext
 */
public class SExt extends Object {
  /**
   * URL to a 1x1 transparent gif image used by Ext to create inline icons with
   * CSS background images.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-BLANK_IMAGE_URL Original Ext JS documentation of 'BLANK_IMAGE_URL'
   */
  public native function get BLANK_IMAGE_URL():String;

  /**
   * @private
   */
  public native function set BLANK_IMAGE_URL(value:String):void;

  /**
   * URL to a blank file used by Ext when in secure mode for iframe src and onReady src
   * to prevent the IE insecure content warning (<code>'about:blank'</code>, except for IE
   * in secure mode, which is <code>'javascript:""'</code>).
   * @default Ext.isSecure && Ext.isIE ? 'javascript:\'\'' : 'about:blank'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-SSL_SECURE_URL Original Ext JS documentation of 'SSL_SECURE_URL'
   */
  public native function get SSL_SECURE_URL():String;

  /**
   * @private
   */
  public native function set SSL_SECURE_URL(value:String):void;

  /**
   * Indicates whether to use native browser parsing for JSON methods.
   * This option is ignored if the browser does not support native JSON methods.
   * <p><b>Note:</b> Native JSON methods will not work with objects that have functions.
   * Also, property names must be quoted, otherwise the data will not parse.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-USE_NATIVE_JSON Original Ext JS documentation of 'USE_NATIVE_JSON'
   */
  public native function get USE_NATIVE_JSON():Boolean;

  /**
   * @private
   */
  public native function set USE_NATIVE_JSON(value:Boolean):void;

  /**
   * The base prefix to use for all <code>→ext.Ext</code> components. To configure this property, you should
   * use the Ext.buildSettings object before the framework is loaded:
   * <pre>
   * Ext.buildSettings = {
   *     baseCSSPrefix : 'abc-'
   * };
   * </pre>
   * <p>or you can change it before any components are rendered:</p>
   * <pre>
   * Ext.baseCSSPrefix = Ext.buildSettings.baseCSSPrefix = 'abc-';
   * </pre>
   * <p>This will change what CSS classes components will use and you should
   * then recompile the SASS changing the <code>$prefix</code> SASS variable to match.</p>
   * @default 'x-'
   * @see ext.#Ext ext.Ext
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-baseCSSPrefix Original Ext JS documentation of 'baseCSSPrefix'
   */
  public native function get baseCSSPrefix():String;

  /**
   * @private
   */
  public native function set baseCSSPrefix(value:String):void;

  /**
   * The current version of Chrome (0 if the browser is not Chrome).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-chromeVersion Original Ext JS documentation of 'chromeVersion'
   */
  public native function get chromeVersion():Number;

  [ExtConfig]
  /**
   * This object is used to enable or disable debugging for classes or namespaces. The
   * default instance looks like this:
   * <pre>
   *  Ext.debugConfig = {
   *      hooks: {
   *          '&#42;': true
   *      }
   *  };
   * </pre>
   * <p>Typically applications will set this in their <code>"app.json"</code> like so:</p>
   * <pre>
   *  {
   *      "debug": {
   *          "hooks": {
   *              // Default for all namespaces:
   *              '&#42;': true,
   *
   *              // Except for Ext namespace which is disabled
   *              'Ext': false,
   *
   *              // Except for Ext.layout namespace which is enabled
   *              'Ext.layout': true
   *          }
   *      }
   *  }
   * </pre>
   * <p>Alternatively, because this property is consumed very early in the load process of
   * the framework, this can be set in a <code>script</code> tag that is defined prior to loading
   * the framework itself.</p>
   * <p>For example, to enable debugging for the <code>Ext.layout</code> namespace only:</p>
   * <pre>
   *  var Ext = Ext || {};
   *  Ext.debugConfig = {
   *      hooks: {
   *          //...
   *      }
   *  };
   * </pre>
   * <p>For any class declared, the longest matching namespace specified determines if its
   * <code>debugHooks</code> will be enabled. The default setting is specified by the '&#42;' property.</p>
   * <p><b>NOTE:</b> This option only applies to debug builds. All debugging is disabled in
   * production builds.</p>
   * @default Ext.debugConfig || manifest.debug || {
   *     hooks: {
   *         '&#42;': true
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#cfg-debugConfig Original Ext JS documentation of 'debugConfig'
   */
  public native function get debugConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set debugConfig(value:Object):void;

  /**
   * A reusable empty function.
   * @default emptyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-emptyFn Original Ext JS documentation of 'emptyFn'
   */
  public native function get emptyFn():Function;

  /**
   * @private
   */
  public native function set emptyFn(value:Function):void;

  /**
   * A zero length string which will pass a truth test. Useful for passing to methods
   * which use a truth test to reject <i>falsy</i> values where a string value must be
   * cleared.
   * @default new String()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-emptyString Original Ext JS documentation of 'emptyString'
   */
  public native function get emptyString():*;

  /**
   * @private
   */
  public native function set emptyString(value:*):void;

  [Deprecated(message="This property is no longer necessary, so no replacement is required.\n", since="6.0.2")]
  /**
   * This property is provided for backward
   * compatibility with previous versions of Ext JS. Accessibility is always enabled
   * in Ext JS 6.0+.
   * <p>This property is deprecated. To disable WAI-ARIA compatibility warnings,
   * override <code>Ext.ariaWarn</code> function in your application startup code:</p>
   * <pre>
   *  Ext.application({
   *      launch: function() {
   *          Ext.ariaWarn = Ext.emptyFn;
   *      }
   *  });
   * </pre>
   * <p>For stricter compatibility with WAI-ARIA requirements, replace <code>Ext.ariaWarn</code>
   * with a function that will raise an error instead:</p>
   * <pre>
   *  Ext.application({
   *      launch: function() {
   *          Ext.ariaWarn = function(target, msg) {
   *              Ext.raise({
   *                  msg: msg,
   *                  component: target
   *              });
   *          };
   *      }
   *  });
   * </pre>
   * @default true
   * @since 6.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-enableAria Original Ext JS documentation of 'enableAria'
   */
  public native function get enableAria():Boolean;

  /**
   * @private
   */
  public native function set enableAria(value:Boolean):void;

  /**
   * True if the →<code>ext.fx.Anim</code> Class is available.
   * @default true
   * @see ext.fx.Anim
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-enableFx Original Ext JS documentation of 'enableFx'
   */
  public native function get enableFx():Boolean;

  /**
   * @private
   */
  public native function set enableFx(value:Boolean):void;

  /**
   * <code>true</code> to automatically uncache orphaned Ext.Elements periodically. If set to
   * <code>false</code>, the application will be required to clean up orphaned Ext.Elements and
   * it's listeners as to not cause memory leakage.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-enableGarbageCollector Original Ext JS documentation of 'enableGarbageCollector'
   */
  public native function get enableGarbageCollector():*;

  /**
   * @private
   */
  public native function set enableGarbageCollector(value:*):void;

  [ExtConfig]
  /**
   * When set to <code>true</code>, focus styling will be applied to focused elements based on the
   * user interaction mode: when keyboard was used to focus an element, focus styling
   * will be visible but not when element was focused otherwise (e.g. with mouse, touch,
   * or programmatically). The →<code>keyboardMode</code> property will then reflect the last
   * user interaction mode.
   * Setting this option to <code>false</code> disables keyboard mode tracking and results in focus
   * styling always being applied to focused elements, which is pre-Ext JS 6.5 behavior.
   * <p>Defaults to <code>false</code> in desktop environments, <code>true</code> on mobile devices.</p>
   * @default Ext.isModern || !Ext.os.is.Desktop
   * @since 6.6.0
   * @see SExt#keyboardMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#cfg-enableKeyboardMode Original Ext JS documentation of 'enableKeyboardMode'
   */
  public native function get enableKeyboardMode():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableKeyboardMode(value:Boolean):void;

  /**
   * True to automatically purge event listeners during garbageCollection.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-enableListenerCollection Original Ext JS documentation of 'enableListenerCollection'
   */
  public native function get enableListenerCollection():*;

  /**
   * @private
   */
  public native function set enableListenerCollection(value:*):void;

  [ArrayElementType("String")]
  /**
   * An array containing extra enumerables for old browsers
   * @default enumerables
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-enumerables Original Ext JS documentation of 'enumerables'
   */
  public native function get enumerables():Array;

  /**
   * @private
   */
  public native function set enumerables(value:Array):void;

  /**
   * The current version of Firefox (0 if the browser is not Firefox).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-firefoxVersion Original Ext JS documentation of 'firefoxVersion'
   */
  public native function get firefoxVersion():Number;

  /**
   * This indicate the start timestamp of current cycle.
   * It is only reliable during dom-event-initiated cycles and
   * →<code>ext.draw.Animator</code> initiated cycles.
   * @default Ext.now()
   * @see ext.draw.#Animator ext.draw.Animator
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-frameStartTime Original Ext JS documentation of 'frameStartTime'
   */
  public native function get frameStartTime():*;

  /**
   * @private
   */
  public native function set frameStartTime(value:*):void;

  /**
   * A reusable identity function that simply returns its first argument.
   * @default identityFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-identityFn Original Ext JS documentation of 'identityFn'
   */
  public native function get identityFn():Function;

  /**
   * @private
   */
  public native function set identityFn(value:Function):void;

  /**
   * The current version of IE (0 if the browser is not IE). This does not account
   * for the documentMode of the current page, which is factored into →<code>isIE8</code>,
   * and →<code>isIE9</code>. Thus this is not always true:
   * <pre>
   * Ext.isIE8 == (Ext.ieVersion == 8)
   * </pre>
   * @see SExt#isIE8
   * @see SExt#isIE9
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-ieVersion Original Ext JS documentation of 'ieVersion'
   */
  public native function get ieVersion():Number;

  /**
   * True if the detected browser is Chrome.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isChrome Original Ext JS documentation of 'isChrome'
   */
  public native function get isChrome():Boolean;

  /**
   * <code>true</code> when the document body is ready for use.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isDomReady Original Ext JS documentation of 'isDomReady'
   */
  public native function get isDomReady():Boolean;

  /**
   * True if the detected browser is Edge.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isEdge Original Ext JS documentation of 'isEdge'
   */
  public native function get isEdge():Boolean;

  /**
   * True if the detected browser uses the Gecko layout engine (e.g. Mozilla, Firefox).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isGecko Original Ext JS documentation of 'isGecko'
   */
  public native function get isGecko():Boolean;

  /**
   * True if the detected browser is Internet Explorer.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE Original Ext JS documentation of 'isIE'
   */
  public native function get isIE():Boolean;

  /**
   * True if the detected browser is Internet Explorer 10.x.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE10 Original Ext JS documentation of 'isIE10'
   */
  public native function get isIE10():Boolean;

  /**
   * True if the detected browser is Internet Explorer 10.x or lower.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE10m Original Ext JS documentation of 'isIE10m'
   */
  public native function get isIE10m():Boolean;

  /**
   * True if the detected browser is Internet Explorer 10.x or higher.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE10p Original Ext JS documentation of 'isIE10p'
   */
  public native function get isIE10p():Boolean;

  /**
   * True if the detected browser is Internet Explorer 11.x.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE11 Original Ext JS documentation of 'isIE11'
   */
  public native function get isIE11():Boolean;

  /**
   * True if the detected browser is Internet Explorer 11.x or lower.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE11m Original Ext JS documentation of 'isIE11m'
   */
  public native function get isIE11m():Boolean;

  /**
   * True if the detected browser is Internet Explorer 11.x or higher.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE11p Original Ext JS documentation of 'isIE11p'
   */
  public native function get isIE11p():Boolean;

  /**
   * True if the detected browser is Internet Explorer 8.x.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE8 Original Ext JS documentation of 'isIE8'
   */
  public native function get isIE8():Boolean;

  /**
   * True if the detected browser is Internet Explorer 8.x or lower.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE8m Original Ext JS documentation of 'isIE8m'
   */
  public native function get isIE8m():Boolean;

  /**
   * True if the detected browser is Internet Explorer 8.x or higher.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE8p Original Ext JS documentation of 'isIE8p'
   */
  public native function get isIE8p():Boolean;

  /**
   * True if the detected browser is Internet Explorer 9.x.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE9 Original Ext JS documentation of 'isIE9'
   */
  public native function get isIE9():Boolean;

  /**
   * True if the detected browser is Internet Explorer 9.x or lower.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE9m Original Ext JS documentation of 'isIE9m'
   */
  public native function get isIE9m():Boolean;

  /**
   * True if the detected browser is Internet Explorer 9.x or higher.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isIE9p Original Ext JS documentation of 'isIE9p'
   */
  public native function get isIE9p():Boolean;

  /**
   * True if the detected platform is Linux.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isLinux Original Ext JS documentation of 'isLinux'
   */
  public native function get isLinux():Boolean;

  /**
   * True if the detected platform is Mac OS.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isMac Original Ext JS documentation of 'isMac'
   */
  public native function get isMac():Boolean;

  /**
   * True if the detected browser is Opera.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isOpera Original Ext JS documentation of 'isOpera'
   */
  public native function get isOpera():Boolean;

  /**
   * <code>true</code> when <code>→isDomReady</code> is true and the Framework is ready for use.
   * @see SExt#isDomReady
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isReady Original Ext JS documentation of 'isReady'
   */
  public native function get isReady():Boolean;

  /**
   * True if the detected browser is Safari.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isSafari Original Ext JS documentation of 'isSafari'
   */
  public native function get isSafari():Boolean;

  /**
   * True if the page is running over SSL
   * @default /^https/i.test(window.location.protocol)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isSecure Original Ext JS documentation of 'isSecure'
   */
  public native function get isSecure():Boolean;

  /**
   * <code>true</code> if browser is using strict mode.
   * @default document.compatMode === "CSS1Compat"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isStrict Original Ext JS documentation of 'isStrict'
   */
  public native function get isStrict():Boolean;

  /**
   * @private
   */
  public native function set isStrict(value:Boolean):void;

  /**
   * True if the detected browser uses WebKit.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isWebKit Original Ext JS documentation of 'isWebKit'
   */
  public native function get isWebKit():Boolean;

  /**
   * True if the detected platform is Windows.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-isWindows Original Ext JS documentation of 'isWindows'
   */
  public native function get isWindows():Boolean;

  /**
   * A flag which indicates that the last UI interaction from the user was a keyboard gesture
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-keyboardMode Original Ext JS documentation of 'keyboardMode'
   */
  public native function get keyboardMode():Boolean;

  /**
   * @private
   */
  public native function set keyboardMode(value:Boolean):void;

  [ExtConfig]
  /**
   * This object is initialized prior to loading the framework
   * and contains settings and other information describing the application.
   * <p>For applications built using Sencha Cmd, this is produced from the <code>"app.json"</code>
   * file with information extracted from all of the required packages' <code>"package.json"</code>
   * files. This can be set to a string when your application is using the
   * (microloader)[#/guide/microloader]. In this case, the string of "foo" will be
   * requested as <code>"foo.json"</code> and the object in that JSON file will parsed and set
   * as this object.</p>
   * @default manifest
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#cfg-manifest Original Ext JS documentation of 'manifest'
   */
  public native function get manifest():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set manifest(value:*):void;

  /**
   * The name of the property in the global namespace (The <code>window</code> in browser
   * environments) which refers to the current instance of Ext.
   * This is usually <code>"Ext"</code>, but if a sandboxed build of ExtJS is being used, this will be
   * an alternative name.
   * If code is being generated for use by <code>eval</code> or to create a <code>new Function</code>, and the
   * global instance of Ext must be referenced, this is the name that should be built
   * into the code.
   * @default 'Ext'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * The current version of Opera (0 if the browser is not Opera).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-operaVersion Original Ext JS documentation of 'operaVersion'
   */
  public native function get operaVersion():Number;

  /**
   * This object contains properties that describe the current device or platform. These
   * values can be used in <code>→ext.ExtClass.platformConfig</code> as well as
   * <code>→ext.mixin.Responsive.responsiveConfig</code> statements.
   * <p>This object can be modified to include tags that are useful for the application. To
   * add custom properties, it is advisable to use a sub-object. For example:</p>
   * <pre>
   *  Ext.platformTags.app = {
   *      mobile: true
   *  };
   * </pre>
   * <ul>
   * <li><code>phone:Boolean</code> (optional)</li>
   * <li><code>tablet:Boolean</code> (optional)</li>
   * <li><code>desktop:Boolean</code> (optional)</li>
   * <li><code>touch:Boolean</code> (optional) —
   * Indicates touch inputs are available.
   * </li>
   * <li><code>safari:Boolean</code> (optional)</li>
   * <li><code>chrome:Boolean</code> (optional)</li>
   * <li><code>windows:Boolean</code> (optional)</li>
   * <li><code>firefox:Boolean</code> (optional)</li>
   * <li><code>ios:Boolean</code> (optional) —
   * True for iPad, iPhone and iPod.
   * </li>
   * <li><code>android:Boolean</code> (optional)</li>
   * <li><code>blackberry:Boolean</code> (optional)</li>
   * <li><code>tizen:Boolean</code> (optional)</li>
   * </ul>
   * @see ext.ExtClass#platformConfig
   * @see ext.mixin.Responsive#responsiveConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-platformTags Original Ext JS documentation of 'platformTags'
   */
  public native function get platformTags():Object;

  /**
   * @private
   */
  public native function set platformTags(value:Object):void;

  /**
   * A reusable empty function for use as <code>privates</code> members.
   * <pre>
   *  Ext.define('MyClass', {
   *      nothing: Ext.emptyFn,
   *
   *      privates: {
   *          privateNothing: Ext.privateFn
   *      }
   *  });
   * </pre>
   * @default privateFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-privateFn Original Ext JS documentation of 'privateFn'
   */
  public native function get privateFn():Function;

  /**
   * @private
   */
  public native function set privateFn(value:Function):void;

  /**
   * The current version of Safari (0 if the browser is not Safari).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-safariVersion Original Ext JS documentation of 'safariVersion'
   */
  public native function get safariVersion():Number;

  /**
   * Set this to true before onReady to prevent any styling from being added to
   * the body element. By default a few styles such as font-family, and color
   * are added to the body element via a "x-body" class. When this is set to
   * <code>true</code> the "x-body" class is not added to the body element, but is added
   * to the elements of root-level containers instead.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-scopeCss Original Ext JS documentation of 'scopeCss'
   */
  public native function get scopeCss():Boolean;

  /**
   * @private
   */
  public native function set scopeCss(value:Boolean):void;

  /**
   * A flag which indicates that the last UI interaction from the user was a touch gesture
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-touchMode Original Ext JS documentation of 'touchMode'
   */
  public native function get touchMode():Boolean;

  /**
   * @private
   */
  public native function set touchMode(value:Boolean):void;

  /**
   * Set to <code>true</code> to use a →<code>ext.util.Floating.shim</code> on all floating Components
   * and <i>LoadMasks</i> (→<code>ext.LoadMask</code>)
   * @default false
   * @see ext.util.Floating#shim
   * @see ext.LoadMask
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-useShims Original Ext JS documentation of 'useShims'
   */
  public native function get useShims():Boolean;

  /**
   * @private
   */
  public native function set useShims(value:Boolean):void;

  /**
   * The current version of WebKit (0 if the browser does not use WebKit).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#property-webKitVersion Original Ext JS documentation of 'webKitVersion'
   */
  public native function get webKitVersion():Number;

  /**
   * Applies event listeners to elements by selectors when the document is ready.
   * The event name is specified with an <code>&#64;</code> suffix.
   * <pre>
   * Ext.addBehaviors({
   *     // add a listener for click on all anchors in element with id foo
   *     '#foo a&#64;click': function(e, t){
   *         // do something
   *     },
   *
   *     // add the same listener to multiple selectors (separated by comma BEFORE the &#64;)
   *     '#foo a, #bar span.some-class&#64;mouseover': function(){
   *         // do something
   *     }
   * });
   * </pre>
   * @param obj The list of behaviors to apply
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-addBehaviors Original Ext JS documentation of 'addBehaviors'
   */
  public native function addBehaviors(obj:Object):void;

  [ArrayElementType("ext.Component")]
  /**
   * Same as →<code>ext.ComponentQuery.query()</code>.
   * @param selector The selector string to filter returned Components.
   * @param root The Container within which to perform the query.
   * If omitted, all Components within the document are included in the search.
   * <p>This parameter may also be an array of Components to filter according to the selector.</p>
   * @return The matched Components.
   * @see ext.SComponentQuery#query() ext.ComponentQuery.query()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-all Original Ext JS documentation of 'all'
   */
  public native function all(selector:String, root:Container = null):Array;

  /**
   * Loads Ext.app.Application class and starts it up with given configuration after the
   * page is ready.
   * <p>See <code>→ext.app.Application</code> for details.</p>
   * @param config Application config object or name of a class derived
   * from Ext.app.Application.
   * @see ext.app.Application
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-application Original Ext JS documentation of 'application'
   */
  public native function application(config:*):void;

  /**
   * Copies all the properties of <code>config</code> to the specified <code>object</code>. There are two levels
   * of defaulting supported:
   * <pre>
   *  Ext.apply(obj, { a: 1 }, { a: 2 });
   *  //obj.a === 1
   *
   *  Ext.apply(obj, {  }, { a: 2 });
   *  //obj.a === 2
   * </pre>
   * <p>Note that if recursive merging and cloning without referencing the original objects
   * or arrays is needed, use →<code>ext.ObjectUtil.merge()</code> instead.</p>
   * @param object The receiver of the properties.
   * @param config The primary source of the properties.
   * @param defaults An object that will also be applied for default values.
   * @return returns <code>object</code>.
   * @see ext.SObjectUtil#merge() ext.ObjectUtil.merge()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-apply Original Ext JS documentation of 'apply'
   */
  public native function apply(object:Object, config:Object, defaults:Object = null):Object;

  /**
   * Copies all the properties of config to object if they don't already exist.
   * @param object The receiver of the properties
   * @param config The source of the properties
   * @return returns obj
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-applyIf Original Ext JS documentation of 'applyIf'
   */
  public native function applyIf(object:Object, config:Object):Object;

  /**
   * Schedules the specified callback function to be executed on the next turn of the
   * event loop. Where available, this method uses the browser's <code>setImmediate</code> API. If
   * not available, this method substitutes <code>setTimeout(0)</code>. Though not a perfect
   * replacement for <code>setImmediate</code> it is sufficient for many use cases.
   * <p>For more details see <a href="https://developer.mozilla.org/en-US/docs/Web/API/Window/setImmediate">MDN</a>.</p>
   * @param fn Callback function.
   * @param scope The scope for the callback (<code>this</code> pointer).
   * @param parameters Additional parameters to pass to <code>fn</code>.
   * @return A cancellation id for <code>→ext.Ext.unasap()</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-asap Original Ext JS documentation of 'asap'
   * @see ext.SExt#unasap() ext.Ext.unasap()
   */
  public native function asap(fn:Function, scope:Object = null, parameters:Array = null):Number;

  [Deprecated(message="Use `Ext.unasap` instead.\n", since="6.5.1")]
  /**
   * Cancels a previously scheduled call to <code>→ext.Ext.asap()</code>.
   * @param id The id returned by <code>→ext.Ext.asap()</code>.
   * @see ext.SExt#asap() ext.Ext.asap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-asapCancel Original Ext JS documentation of 'asapCancel'
   */
  public native function asapCancel(id:Number):void;

  /**
   * Utility wrapper that suspends layouts of all components for the duration of a given
   * function.
   * @param fn The function to execute.
   * @param scope The scope (<code>this</code> reference) in which the specified function
   * is executed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-batchLayouts Original Ext JS documentation of 'batchLayouts'
   */
  public native function batchLayouts(fn:Function, scope:Object = null):void;

  /**
   * Create a new function from the provided <code>fn</code>, change <code>this</code> to the provided scope,
   * optionally overrides arguments for the call. Defaults to the arguments passed by
   * the caller.
   * <p>→<code>ext.Ext.bind()</code> is alias for →<code>ext.FunctionUtil.bind()</code></p>
   * <p><b>NOTE:</b> This method is similar to the native <code>bind()</code> method. The major difference
   * is in the way the parameters are passed. This method expects an array of parameters,
   * and if supplied, it does not automatically pass forward parameters from the bound
   * function:</p>
   * <pre>
   *  function foo (a, b, c) {
   *      console.log(a, b, c);
   *  }
   *
   *  var nativeFn = foo.bind(this, 1, 2);
   *  var extFn = Ext.Function.bind(foo, this, [1, 2]);
   *
   *  nativeFn(3); // 1, 2, 3
   *  extFn(3); // 1, 2, undefined
   * </pre>
   * <p>This method is unavailable natively on IE8 and IE/Quirks but Ext JS provides a
   * "polyfill" to emulate the important features of the standard <code>→bind()</code> method. In
   * particular, the polyfill only provides binding of "this" and optional arguments.</p>
   * @param fn The function to delegate.
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed.
   * <b>If omitted, defaults to the global environment object (usually the browser <code>window</code>).</b>
   * @param args Overrides arguments for the call. (Defaults to
   * the arguments passed by the caller).
   * @param appendArgs if <code>true</code> the <code>args</code> are appended to the
   * arguments passed to the returned wrapper (by default these arguments are ignored).
   * If a number then the <code>args</code> are inserted at the specified position.
   * @return The bound wrapper function.
   * @see ext.SExt#bind() ext.Ext.bind()
   * @see ext.SFunctionUtil#bind() ext.FunctionUtil.bind()
   * @see SExt#bind()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-bind Original Ext JS documentation of 'bind'
   */
  public native function bind(fn:Function, scope:Object = null, args:Array = null, appendArgs:* = undefined):Function;

  /**
   * Execute a callback function in a particular scope. If <code>→callback()</code> argument is a
   * function reference, that is called. If it is a string, the string is assumed to
   * be the name of a method on the given <code>scope</code>. If no function is passed the call
   * is ignored.
   * <p>For example, these calls are equivalent:</p>
   * <pre>
   *  var myFunc = this.myFunc;
   *
   *  Ext.callback('myFunc', this, [arg1, arg2]);
   *  Ext.callback(myFunc, this, [arg1, arg2]);
   *
   *  Ext.isFunction(myFunc) &amp;&amp; this.myFunc(arg1, arg2);
   * </pre>
   * @param callback The callback function to execute or the name of
   * the callback method on the provided <code>scope</code>.
   * @param scope The scope in which <code>→callback()</code> should be invoked. If <code>→callback()</code>
   * is a string this object provides the method by that name. If this is <code>null</code> then
   * the <code>caller</code> is used to resolve the scope to a <code>ViewController</code> or the proper
   * <code>defaultListenerScope</code>.
   * @param args The arguments to pass to the function.
   * @param delay Pass a number to delay the call by a number of milliseconds.
   * @param caller The object calling the callback. This is used to resolve
   * named methods when no explicit <code>scope</code> is provided.
   * @param defaultScope (Default caller) The default scope to return if none is found.
   * @default caller
   * @return The value returned by the callback or <code>undefined</code> (if there is a <code>delay</code>
   * or if the <code>→callback()</code> is not a function).
   * @see SExt#callback()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-callback Original Ext JS documentation of 'callback'
   */
  public native function callback(callback:*, scope:Object = null, args:Array = null, delay:Number = NaN, caller:Object = null, defaultScope:Object = null):*;

  /**
   * This method checks the registered package versions against the provided version
   * <code>specs</code>. A <code>spec</code> is either a string or an object indicating a boolean operator.
   * This method accepts either form or an array of these as the first argument. The
   * second argument applies only when the first is an array and indicates whether
   * all <code>specs</code> must match or just one.
   * <p><b><i>Package Version Specifications</i></b></p>
   * <p>The string form of a <code>spec</code> is used to indicate a version or range of versions
   * for a particular package. This form of <code>spec</code> consists of three (3) parts:</p>
   * <ul>
   * <li>Package name followed by "&#64;". If not provided, the framework is assumed.</li>
   * <li>Minimum version.</li>
   * <li>Maximum version.</li>
   * </ul>
   * <p>At least one version number must be provided. If both minimum and maximum are
   * provided, these must be separated by a "-".</p>
   * <p>Some examples of package version specifications:</p>
   * <pre>
   *  4.2.2           (exactly version 4.2.2 of the framework)
   *  4.2.2+          (version 4.2.2 or higher of the framework)
   *  4.2.2-          (version 4.2.2 or higher of the framework)
   *  4.2.1 - 4.2.3   (versions from 4.2.1 up to 4.2.3 of the framework)
   *  - 4.2.2         (any version up to version 4.2.1 of the framework)
   *
   *  foo&#64;1.0         (exactly version 1.0 of package "foo")
   *  foo&#64;1.0-1.3     (versions 1.0 up to 1.3 of package "foo")
   * </pre>
   * <p><b>NOTE:</b> This syntax is the same as that used in Sencha Cmd's package
   * requirements declarations.</p>
   * <p><b><i>Boolean Operator Specifications</i></b></p>
   * <p>Instead of a string, an object can be used to describe a boolean operation to
   * perform on one or more <code>specs</code>. The operator is either <b><code>and</code></b> or <b><code>or</code></b>
   * and can contain an optional <b><code>not</code></b>.</p>
   * <p>For example:</p>
   * <pre>
   *  {
   *      not: true,  // negates boolean result
   *      and: [
   *          '4.2.2',
   *          'foo&#64;1.0.1 - 2.0.1'
   *      ]
   *  }
   * </pre>
   * <p>Each element of the array can in turn be a string or object spec. In other
   * words, the value is passed to this method (recursively) as the first argument
   * so these two calls are equivalent:</p>
   * <pre>
   *  Ext.checkVersion({
   *      not: true,  // negates boolean result
   *      and: [
   *          '4.2.2',
   *          'foo&#64;1.0.1 - 2.0.1'
   *      ]
   *  });
   *
   *  !Ext.checkVersion([
   *          '4.2.2',
   *          'foo&#64;1.0.1 - 2.0.1'
   *      ], true);
   * </pre>
   * <p><b><i>Examples</i></b></p>
   * <pre>
   *  // A specific framework version
   *  Ext.checkVersion('4.2.2');
   *
   *  // A range of framework versions:
   *  Ext.checkVersion('4.2.1-4.2.3');
   *
   *  // A specific version of a package:
   *  Ext.checkVersion('foo&#64;1.0.1');
   *
   *  // A single spec that requires both a framework version and package
   *  // version range to match:
   *  Ext.checkVersion({
   *      and: [
   *          '4.2.2',
   *          'foo&#64;1.0.1-1.0.2'
   *      ]
   *  });
   *
   *  // These checks can be nested:
   *  Ext.checkVersion({
   *      and: [
   *          '4.2.2',  // exactly version 4.2.2 of the framework &#42;AND&#42;
   *          {
   *              // either (or both) of these package specs:
   *              or: [
   *                  'foo&#64;1.0.1-1.0.2',
   *                  'bar&#64;3.0+'
   *              ]
   *          }
   *      ]
   *  });
   * </pre>
   * <p><b><i>Version Comparisons</i></b></p>
   * <p>Version comparsions are assumed to be "prefix" based. That is to say, <code>"foo&#64;1.2"</code>
   * matches any version of "foo" that has a major version 1 and a minor version of 2.</p>
   * <p>This also applies to ranges. For example <code>"foo&#64;1.2-2.2"</code> matches all versions
   * of "foo" from 1.2 up to 2.2 regardless of the specific patch and build.</p>
   * <p><b><i>Use in Overrides</i></b></p>
   * <p>This methods primary use is in support of conditional overrides on an
   * <code>Ext.define</code> declaration.</p>
   * @param specs A version specification string, an object
   * containing <code>or</code> or <code>and</code> with a value that is equivalent to <code>specs</code> or an array
   * of either of these.
   * @param matchAll Pass <code>true</code> to require all specs to match.
   * @default false
   * @return True if <code>specs</code> matches the registered package versions.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-checkVersion Original Ext JS documentation of 'checkVersion'
   */
  public native function checkVersion(specs:*, matchAll:Boolean = false):Boolean;

  [Deprecated(replacement="clean", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.clean()</code>
   * Filter through an array and remove empty item as defined in
   * →<code>ext.Ext.isEmpty()</code>.
   * <p>See →<code>ext.ArrayUtil.filter()</code></p>
   * @return results
   * @see ext.SArrayUtil#clean() ext.ArrayUtil.clean()
   * @see ext.SExt#isEmpty() ext.Ext.isEmpty()
   * @see ext.SArrayUtil#filter() ext.ArrayUtil.filter()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-clean Original Ext JS documentation of 'clean'
   */
  public native function clean(array:Array):Array;

  /**
   * Clone simple variables including array, {}-like objects, DOM nodes and Date without
   * keeping the old reference. A reference for the object itself is returned if it's not
   * a direct descendant of Object. For model cloning, see
   * →<code>ext.data.Model.copy()</code>.
   * @param item The variable to clone
   * @param cloneDom <code>true</code> to clone DOM nodes.
   * @default true
   * @return clone
   * @see ext.data.Model#copy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone(item:Object, cloneDom:Boolean = true):Object;

  /**
   * Coerces the first value if possible so that it is comparable to the second value.
   * <p>Coercion only works between the basic atomic data types String, Boolean, Number, Date, null
   * and undefined. Numbers and numeric strings are coerced to Dates using the value
   * as the millisecond era value.</p>
   * <p>Strings are coerced to Dates by parsing using the
   * →<code>ext.DateUtil.defaultFormat</code>.</p>
   * <p>For example</p>
   * <pre>
   * Ext.coerce('false', true);
   * </pre>
   * <p>returns the boolean value <code>false</code> because the second parameter is of type <code>→Boolean</code>.</p>
   * @param from The value to coerce
   * @param to The value it must be compared against
   * @return The coerced value.
   * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
   * @see Boolean
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-coerce Original Ext JS documentation of 'coerce'
   */
  public native function coerce(from:*, to:*):*;

  /**
   * Copies a set of named properties fom the source object to the destination object.
   * <p>Example:</p>
   * <pre>
   * var foo = { a: 1, b: 2, c: 3 };
   *
   * var bar = Ext.copy({}, foo, 'a,c');
   * // bar = { a: 1, c: 3 };
   * </pre>
   * <p>Important note: To borrow class prototype methods, use →<code>ext.Base.borrow()</code> instead.</p>
   * @param dest The destination object.
   * @param source The source object.
   * @param names Either an Array of property names, or a comma-delimited list
   * of property names to copy.
   * @param usePrototypeKeys Pass <code>true</code> to copy keys off of the
   * prototype as well as the instance.
   * @default false
   * @return The <code>dest</code> object.
   * @see ext.Base#borrow()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-copy Original Ext JS documentation of 'copy'
   */
  public native function copy(dest:Object, source:Object, names:*, usePrototypeKeys:Boolean = false):Object;

  /**
   * Copies a set of named properties fom the source object to the destination object
   * if the destination object does not already have them.
   * <p>Example:</p>
   * <pre>
   * var foo = { a: 1, b: 2, c: 3 };
   *
   * var bar = Ext.copyIf({ a:42 }, foo, 'a,c');
   * // bar = { a: 42, c: 3 };
   * </pre>
   * @param destination The destination object.
   * @param source The source object.
   * @param names Either an Array of property names, or a single string
   * with a list of property names separated by ",", ";" or spaces.
   * @return The <code>dest</code> object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-copyIf Original Ext JS documentation of 'copyIf'
   */
  public native function copyIf(destination:Object, source:Object, names:*):Object;

  [Deprecated(replacement="copy", since="6.0.1")]
  /**
   * Copies a set of named properties fom the source object to the destination object.
   * <p>Example:</p>
   * <pre>
   * var foo = { a: 1, b: 2, c: 3 };
   *
   * var bar = Ext.copyTo({}, foo, 'a,c');
   * // bar = { a: 1, c: 3 };
   * </pre>
   * <p>Important note: To borrow class prototype methods, use →<code>ext.Base.borrow()</code> instead.</p>
   * @param dest The destination object.
   * @param source The source object.
   * @param names Either an Array of property names, or a comma-delimited list
   * of property names to copy.
   * @param usePrototypeKeys Pass <code>true</code> to copy keys off of the
   * prototype as well as the instance.
   * @default false
   * @return The <code>dest</code> object.
   * @see ext.Base#borrow()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-copyTo Original Ext JS documentation of 'copyTo'
   */
  public native function copyTo(dest:Object, source:Object, names:*, usePrototypeKeys:Boolean = false):Object;

  [Deprecated(replacement="copyIf", since="6.0.1")]
  /**
   * Copies a set of named properties fom the source object to the destination object
   * if the destination object does not already have them.
   * <p>Example:</p>
   * <pre>
   * var foo = { a: 1, b: 2, c: 3 };
   *
   * var bar = Ext.copyToIf({ a:42 }, foo, 'a,c');
   * // bar = { a: 42, c: 3 };
   * </pre>
   * @param destination The destination object.
   * @param source The source object.
   * @param names Either an Array of property names, or a single string
   * with a list of property names separated by ",", ";" or spaces.
   * @return The <code>dest</code> object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-copyToIf Original Ext JS documentation of 'copyToIf'
   */
  public native function copyToIf(destination:Object, source:Object, names:*):Object;

  /**
   * Instantiate a class by either full name, alias or alternate name.
   * <p>If →<code>ext.Loader</code> is <i>enabled</i> (→<code>ext.Loader.setConfig()</code>) and the class has
   * not been defined yet, it will attempt to load the class via synchronous loading.</p>
   * <p>For example, all these three lines return the same result:</p>
   * <pre>
   *  // xtype
   *  var window = Ext.create({
   *      xtype: 'window',
   *      width: 600,
   *      height: 800,
   *      ...
   *  });
   *
   *  // alias
   *  var window = Ext.create('widget.window', {
   *      width: 600,
   *      height: 800,
   *      ...
   *  });
   *
   *  // alternate name
   *  var window = Ext.create('Ext.Window', {
   *      width: 600,
   *      height: 800,
   *      ...
   *  });
   *
   *  // full class name
   *  var window = Ext.create('Ext.window.Window', {
   *      width: 600,
   *      height: 800,
   *      ...
   *  });
   *
   *  // single object with xclass property:
   *  var window = Ext.create({
   *      xclass: 'Ext.window.Window', // any valid value for 'name' (above)
   *      width: 600,
   *      height: 800,
   *      ...
   *  });
   * </pre>
   * @param nameOrAliasOrConfig The class name or alias. Can be specified as <code>xclass</code>
   * property if only one object parameter is specified.
   * @param args Additional arguments after the name will be passed to
   * the class' constructor.
   * @return instance
   * @see ext.#Loader ext.Loader
   * @see ext.SLoader#setConfig() ext.Loader.setConfig()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-create Original Ext JS documentation of 'create'
   */
  public native function create(nameOrAliasOrConfig:Object, ...args):*;

  /**
   * Instantiate a class by its alias. This is usually invoked by the
   * shorthand →<code>ext.Ext.createByAlias()</code>.
   * <p>If →<code>ext.Loader</code> is <i>enabled</i> (→<code>ext.Loader.setConfig()</code>) and the class
   * has not been defined yet, it will attempt to load the class via synchronous
   * loading.</p>
   * <pre>
   * var window = Ext.createByAlias('widget.window', { width: 600, height: 800 });
   * </pre>
   * @param alias
   * @param args Additional arguments after the alias will be passed to the
   * class constructor.
   * @return instance
   * @see ext.SExt#createByAlias() ext.Ext.createByAlias()
   * @see ext.#Loader ext.Loader
   * @see ext.SLoader#setConfig() ext.Loader.setConfig()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-createByAlias Original Ext JS documentation of 'createByAlias'
   */
  public native function createByAlias(alias:String, ...args):*;

  /**
   * Shorthand for →<code>ext.JSON.decode()</code>
   * Decodes (parses) a JSON string to an object. If the JSON is invalid, this function throws
   * a SyntaxError unless the safe option is set.
   * @param json The JSON string.
   * @param safe <code>true</code> to return null, otherwise throw an exception
   * if the JSON is invalid.
   * @default false
   * @return The resulting object.
   * @see ext.SJSON#decode() ext.JSON.decode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-decode Original Ext JS documentation of 'decode'
   */
  public native function decode(json:String, safe:Boolean = false):Object;

  /**
   * Calls function <code>fn</code> after the number of milliseconds specified, optionally with
   * a specific <code>scope</code> (<code>this</code> pointer).
   * <p>Example usage:</p>
   * <pre>
   * var sayHi = function(name) {
   *     alert('Hi, ' + name);
   * }
   *
   * // executes immediately:
   * sayHi('Fred');
   *
   * // executes after 2 seconds:
   * Ext.defer(sayHi, 2000, this, ['Fred']);
   * </pre>
   * <p>The following syntax is useful for scheduling anonymous functions:</p>
   * <pre>
   * Ext.defer(function() {
   *     alert('Anonymous');
   * }, 100);
   * </pre>
   * <p>NOTE: The <code>Ext.Function.defer()</code> method is an alias for <code>Ext.defer()</code>.</p>
   * @param fn The function to defer.
   * @param millis The number of milliseconds for the <code>setTimeout</code> call
   * (if less than or equal to 0 the function is executed immediately).
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed. <b>If omitted, defaults to the browser window.</b>
   * @param args Overrides arguments for the call. Defaults to the arguments passed
   * by the caller.
   * @param appendArgs If <code>true</code> args are appended to call args
   * instead of overriding, or, if a number, then the args are inserted at the specified
   * position.
   * @default false
   * @return The timeout id that can be used with <code>Ext.undefer</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-defer Original Ext JS documentation of 'defer'
   */
  public native function defer(fn:Function, millis:Number, scope:Object = null, args:Array = null, appendArgs:* = false):Number;

  /**
   * Defines a class or override. A basic class is defined like this:
   * <pre>
   *  Ext.define('My.awesome.Class', {
   *      someProperty: 'something',
   *
   *      someMethod: function(s) {
   *          alert(s + this.someProperty);
   *      }
   *
   *      ...
   *  });
   *
   *  var obj = new My.awesome.Class();
   *
   *  obj.someMethod('Say '); // alerts 'Say something'
   * </pre>
   * <p>To create an anonymous class, pass <code>null</code> for the <code>className</code>:</p>
   * <pre>
   *  Ext.define(null, {
   *      constructor: function() {
   *          // ...
   *      }
   *  });
   * </pre>
   * <p>In some cases, it is helpful to create a nested scope to contain some private
   * properties. The best way to do this is to pass a function instead of an object
   * as the second parameter. This function will be called to produce the class
   * body:</p>
   * <pre>
   *  Ext.define('MyApp.foo.Bar', function() {
   *      var id = 0;
   *
   *      return {
   *          nextId: function() {
   *              return ++id;
   *          }
   *      };
   *  });
   * </pre>
   * <p><i>Note</i> that when using override, the above syntax will not override successfully,
   * because the passed function would need to be executed first to determine whether or not
   * the result is an override or defining a new object. As such, an alternative syntax that
   * immediately invokes the function can be used:</p>
   * <pre>
   *  Ext.define('MyApp.override.BaseOverride', function() {
   *      var counter = 0;
   *
   *      return {
   *          override: 'Ext.Component',
   *          logId: function() {
   *              console.log(++counter, this.id);
   *          }
   *      };
   *  }());
   * </pre>
   * <p>When using this form of <code>Ext.define</code>, the function is passed a reference to its
   * class. This can be used as an efficient way to access any static properties you
   * may have:</p>
   * <pre>
   *  Ext.define('MyApp.foo.Bar', function(Bar) {
   *      return {
   *          statics: {
   *              staticMethod: function() {
   *                  // ...
   *              }
   *          },
   *
   *          method: function() {
   *              return Bar.staticMethod();
   *          }
   *      };
   *  });
   * </pre>
   * <p>To define an override, include the <code>→override_()</code> property. The content of an
   * override is aggregated with the specified class in order to extend or modify
   * that class. This can be as simple as setting default property values or it can
   * extend and/or replace methods. This can also extend the statics of the class.</p>
   * <p>One use for an override is to break a large class into manageable pieces.</p>
   * <pre>
   *  // File: /src/app/Panel.js
   *
   *  Ext.define('My.app.Panel', {
   *      extend: 'Ext.panel.Panel',
   *      requires: [
   *          'My.app.PanelPart2',
   *          'My.app.PanelPart3'
   *      ]
   *
   *      constructor: function(config) {
   *          this.callParent(arguments); // calls Ext.panel.Panel's constructor
   *          //...
   *      },
   *
   *      statics: {
   *          method: function() {
   *              return 'abc';
   *          }
   *      }
   *  });
   *
   *  // File: /src/app/PanelPart2.js
   *  Ext.define('My.app.PanelPart2', {
   *      override: 'My.app.Panel',
   *
   *      constructor: function(config) {
   *          this.callParent(arguments); // calls My.app.Panel's constructor
   *          //...
   *      }
   *  });
   * </pre>
   * <p>Another use of overrides is to provide optional parts of classes that can be
   * independently required. In this case, the class may even be unaware of the
   * override altogether.</p>
   * <pre>
   *  Ext.define('My.ux.CoolTip', {
   *      override: 'Ext.tip.ToolTip',
   *
   *      constructor: function(config) {
   *          this.callParent(arguments); // calls Ext.tip.ToolTip's constructor
   *          //...
   *      }
   *  });
   * </pre>
   * <p>The above override can now be required as normal.</p>
   * <pre>
   *  Ext.define('My.app.App', {
   *      requires: [
   *          'My.ux.CoolTip'
   *      ]
   *  });
   * </pre>
   * <p>Overrides can also contain statics, inheritableStatics, or privates:</p>
   * <pre>
   *  Ext.define('My.app.BarMod', {
   *      override: 'Ext.foo.Bar',
   *
   *      statics: {
   *          method: function(x) {
   *              return this.callParent([x &#42; 2]); // call Ext.foo.Bar.method
   *          }
   *      }
   *  });
   * </pre>
   * <p>Starting in version 4.2.2, overrides can declare their <code>compatibility</code> based
   * on the framework version or on versions of other packages. For details on the
   * syntax and options for these checks, see <code>Ext.checkVersion</code>.</p>
   * <p>The simplest use case is to test framework version for compatibility:</p>
   * <pre>
   *  Ext.define('App.overrides.grid.Panel', {
   *      override: 'Ext.grid.Panel',
   *
   *      compatibility: '4.2.2', // only if framework version is 4.2.2
   *
   *      //...
   *  });
   * </pre>
   * <p>An array is treated as an OR, so if any specs match, the override is
   * compatible.</p>
   * <pre>
   *  Ext.define('App.overrides.some.Thing', {
   *      override: 'Foo.some.Thing',
   *
   *      compatibility: [
   *          '4.2.2',
   *          'foo&#64;1.0.1-1.0.2'
   *      ],
   *
   *      //...
   *  });
   * </pre>
   * <p>To require that all specifications match, an object can be provided:</p>
   * <pre>
   *  Ext.define('App.overrides.some.Thing', {
   *      override: 'Foo.some.Thing',
   *
   *      compatibility: {
   *          and: [
   *              '4.2.2',
   *              'foo&#64;1.0.1-1.0.2'
   *          ]
   *      },
   *
   *      //...
   *  });
   * </pre>
   * <p>Because the object form is just a recursive check, these can be nested:</p>
   * <pre>
   *  Ext.define('App.overrides.some.Thing', {
   *      override: 'Foo.some.Thing',
   *
   *      compatibility: {
   *          and: [
   *              '4.2.2',  // exactly version 4.2.2 of the framework &#42;AND&#42;
   *              {
   *                  // either (or both) of these package specs:
   *                  or: [
   *                      'foo&#64;1.0.1-1.0.2',
   *                      'bar&#64;3.0+'
   *                  ]
   *              }
   *          ]
   *      },
   *
   *      //...
   *  });
   * </pre>
   * <p>IMPORTANT: An override is only included in a build if the class it overrides is
   * required. Otherwise, the override, like the target class, is not included. In
   * Sencha Cmd v4, the <code>compatibility</code> declaration can likewise be used to remove
   * incompatible overrides from a build.</p>
   * @param className The class name to create in string dot-namespaced format,
   * for example: 'My.very.awesome.Class', 'FeedViewer.plugin.CoolPager'
   * <p>It is highly recommended to follow this simple convention:</p>
   * <ul>
   * <li>The root and the class name are 'CamelCased'</li>
   * <li>Everything else is lower-cased
   * Pass <code>null</code> to create an anonymous class.</li>
   * </ul>
   * @param data The key - value pairs of properties to apply to this class.
   * Property names can be of any valid strings, except those in the reserved listed below:
   * <ul>
   * <li>→<code>ext.ExtClass.alias</code></li>
   * <li>→<code>ext.ExtClass.alternateClassName</code></li>
   * <li>→<code>ext.ExtClass.cachedConfig</code></li>
   * <li>→<code>ext.ExtClass.config</code></li>
   * <li>→<code>ext.ExtClass.extend</code></li>
   * <li>→<code>ext.ExtClass.inheritableStatics</code></li>
   * <li>→<code>ext.ExtClass.mixins</code></li>
   * <li>→<code>ext.ExtClass.override_</code></li>
   * <li>→<code>ext.ExtClass.platformConfig</code></li>
   * <li>→<code>ext.ExtClass.privates</code></li>
   * <li>→<code>ext.ExtClass.requires</code></li>
   * <li><code>self</code></li>
   * <li>→<code>ext.ExtClass.singleton</code></li>
   * <li>→<code>ext.ExtClass.statics</code></li>
   * <li>→<code>ext.ExtClass.uses</code></li>
   * <li>→<code>ext.ExtClass.xtype</code> (for <i>Components</i> (→<code>ext.Component</code>) only)</li>
   * </ul>
   * @param createdFn Callback to execute after the class is created,
   * the execution scope of which (<code>this</code>) will be the newly created class itself.
   * @see SExt#override_()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-define Original Ext JS documentation of 'define'
   * @see ext.ExtClass#alias
   * @see ext.ExtClass#alternateClassName
   * @see ext.ExtClass#cachedConfig
   * @see ext.ExtClass#config
   * @see ext.ExtClass#extend
   * @see ext.ExtClass#inheritableStatics
   * @see ext.ExtClass#mixins
   * @see ext.ExtClass#override_
   * @see ext.ExtClass#platformConfig
   * @see ext.ExtClass#privates
   * @see ext.ExtClass#requires
   * @see ext.ExtClass#singleton
   * @see ext.ExtClass#statics
   * @see ext.ExtClass#uses
   * @see ext.ExtClass#xtype
   * @see ext.Component
   */
  public native function define(className:String, data:Object, createdFn:Function = null):Base;

  /**
   * Destroys all of the given objects. If arrays are passed, the elements of these
   * are destroyed recursively.
   * <p>What it means to "destroy" an object depends on the type of object.</p>
   * <ul>
   * <li><code>→Array</code>: Each element of the array is destroyed recursively.</li>
   * <li><code>→Object</code>: Any object with a <code>→destroy()</code> method will have that method called.</li>
   * </ul>
   * @param args Any number of objects or arrays.
   * @see Array
   * @see Object
   * @see SExt#destroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  public native function destroy(...args):void;

  /**
   * Destroys the specified named members of the given object using <code>Ext.destroy</code>. These
   * properties will be set to <code>null</code>.
   * @param object The object who's properties you wish to destroy.
   * @param args One or more names of the properties to destroy and remove from
   * the object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-destroyMembers Original Ext JS documentation of 'destroyMembers'
   */
  public native function destroyMembers(object:Object, ...args):void;

  /**
   * Iterates an array or an iterable value and invoke the given callback function for each
   * item.
   * <pre>
   * var countries = ['Vietnam', 'Singapore', 'United States', 'Russia'];
   *
   * Ext.Array.each(countries, function(name, index, countriesItSelf) {
   *     console.log(name);
   * });
   *
   * var sum = function() {
   *     var sum = 0;
   *
   *     Ext.Array.each(arguments, function(value) {
   *         sum += value;
   *     });
   *
   *     return sum;
   * };
   *
   * sum(1, 2, 3); // returns 6
   * </pre>
   * <p>The iteration can be stopped by returning <code>false</code> from the callback function.
   * Returning <code>undefined</code> (i.e <code>return;</code>) will only exit the callback function and
   * proceed with the next iteration of the loop.</p>
   * <pre>
   * Ext.Array.each(countries, function(name, index, countriesItSelf) {
   *     if (name === 'Singapore') {
   *         return false; // break here
   *     }
   * });
   * </pre>
   * <p>→<code>ext.Ext.each()</code> is alias for →<code>ext.ArrayUtil.each()</code></p>
   * @param array The value to be iterated. If this
   * argument is not iterable, the callback function is called once.
   * @param fn The callback function. If it returns <code>false</code>, the iteration
   * stops and this method returns the current <code>index</code>. Returning <code>undefined</code> (i.e
   * <code>return;</code>) will only exit the callback function and proceed with the next iteration
   * in the loop.
   * <ul>
   * <li><code>item:Object</code> (optional) —
   * The item at the current <code>index</code> in the passed <code>array</code>
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The current <code>index</code> within the <code>array</code>
   * </li>
   * <li><code>allItems:Array</code> (optional) —
   * The <code>array</code> itself which was passed as the first argument
   * </li>
   * <li><code>return:Boolean</code> (optional) —
   * Return <code>false</code> to stop iteration.
   * </li>
   * </ul>
   * @param scope The scope (<code>this</code> reference) in which the specified function is
   * executed.
   * @param reverse Reverse the iteration order (loop from the end to the
   * beginning).
   * @default false
   * @return If all array entries were iterated, this will be <code>true. If iteration was halted early because the passed fuction returned</code>false`, this will
   * be the index at which iteration was halted.
   * @see ext.SExt#each() ext.Ext.each()
   * @see ext.SArrayUtil#each() ext.ArrayUtil.each()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(array:*, fn:Function, scope:Object = null, reverse:Boolean = false):*;

  /**
   * Shorthand for →<code>ext.JSON.encode()</code>
   * Encodes an Object, Array or other value.
   * <p>If the environment's native JSON encoding is not being used (→<code>ext.Ext.USE_NATIVE_JSON</code>
   * is not set, or the environment does not support it), then ExtJS's encoding will be used.
   * This allows the developer to add a <code>toJSON</code> method to their classes which need serializing
   * to return a valid JSON representation of the object.</p>
   * @param o The variable to encode.
   * @return The JSON string.
   * @see ext.SJSON#encode() ext.JSON.encode()
   * @see ext.SExt#USE_NATIVE_JSON ext.Ext.USE_NATIVE_JSON
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-encode Original Ext JS documentation of 'encode'
   */
  public native function encode(o:Object):String;

  /**
   * Explicitly exclude files from being loaded. Useful when used in conjunction with a
   * broad include expression. Can be chained with more <code>→require()</code> and <code>→exclude()</code> methods,
   * for example:
   * <pre>
   * Ext.exclude('Ext.data.&#42;').require('&#42;');
   *
   * Ext.exclude('widget.button&#42;').require('widget.&#42;');
   * </pre>
   * @return Contains <code>→exclude()</code>, <code>→require()</code> and <code>→syncRequire()</code> methods for chaining.
   * @see SExt#require()
   * @see SExt#exclude()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-exclude Original Ext JS documentation of 'exclude'
   * @see SExt#syncRequire()
   */
  public native function exclude(excludes:*):Object;

  [Deprecated(replacement="define", since="4.0.0")]
  /**
   * This method deprecated. Use →<code>ext.Ext.define()</code> instead.
   * @return The subclass constructor from the <tt>overrides</tt> parameter,
   * or a generated one if not provided.
   * @see ext.SExt#define() ext.Ext.define()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-extend Original Ext JS documentation of 'extend'
   */
  public native function extend(superclass:Function, overrides:Object):Function;

  [Deprecated(replacement="update", since="6.5.0")]
  /**
   * A global factory method to instantiate a class from a config object. For example,
   * these two calls are equivalent:
   * <pre>
   * Ext.factory({ text: 'My Button' }, 'Ext.Button');
   * Ext.create('Ext.Button', { text: 'My Button' });
   * </pre>
   * <p>If an existing instance is also specified, it will be updated with the supplied config
   * object. This is useful if you need to either create or update an object, depending on
   * if an instance already exists. For example:</p>
   * <pre>
   * var button;
   * button = Ext.factory({ text: 'New Button' }, 'Ext.Button', button);     // Button created
   * button = Ext.factory({ text: 'Updated Button' }, 'Ext.Button', button); // Button updated
   * </pre>
   * @param config The config object to instantiate or update an instance with.
   * @param classReference The class to instantiate from (if there is a default).
   * @param instance The instance to update.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-factory Original Ext JS documentation of 'factory'
   */
  public native function factory(config:Object, classReference:String = null, instance:Object = null, aliasNamespace:* = undefined):void;

  /**
   * Shorthand for →<code>ext.GlobalEvents.fireEvent()</code>.
   * Fires the specified event with the passed parameters (minus the event name, plus
   * the <code>options</code> object passed to →<code>ext.util.Observable.addListener()</code>).
   * <p>An event may be set to bubble up an Observable parent hierarchy (See
   * →<code>ext.Component.getBubbleTarget()</code>) by calling →<code>enableBubble</code>.</p>
   * @since 6.2.0
   * @param eventName The name of the event to fire.
   * @param args Variable number of parameters are passed to handlers.
   * @return returns false if any of the handlers return false otherwise it
   * returns true.
   * @see ext.SGlobalEvents#fireEvent() ext.GlobalEvents.fireEvent()
   * @see ext.util.Observable#addListener()
   * @see ext.Component#getBubbleTarget()
   * @see SExt#enableBubble
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-fireEvent Original Ext JS documentation of 'fireEvent'
   */
  public native function fireEvent(eventName:String, ...args):Boolean;

  /**
   * Returns the first match to the given component query.
   * See →<code>ext.ComponentQuery.query()</code>.
   * @param selector The selector string to filter returned Component.
   * @param root The Container within which to perform the query.
   * If omitted, all Components within the document are included in the search.
   * <p>This parameter may also be an array of Components to filter according to the selector.</p>
   * @return The first matched Component or <code>null</code>.
   * @see ext.SComponentQuery#query() ext.ComponentQuery.query()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-first Original Ext JS documentation of 'first'
   */
  public native function first(selector:String, root:Container = null):Component;

  [Deprecated(replacement="flatten", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.flatten()</code>
   * Recursively flattens into 1-d Array. Injects Arrays inline.
   * @param array The array to flatten
   * @return The 1-d array.
   * @see ext.SArrayUtil#flatten() ext.ArrayUtil.flatten()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-flatten Original Ext JS documentation of 'flatten'
   */
  public native function flatten(array:Array):Array;

  /**
   * Gets the globally shared flyweight Element, with the passed node as the active
   * element. Do not store a reference to this element - the dom node can be overwritten
   * by other code. →<code>ext.Ext.fly()</code> is alias for →<code>ext.dom.Element.fly()</code>.
   * <p>Use this to make one-time references to DOM elements which are not going to be
   * accessed again either by application code, or by Ext's classes. If accessing an
   * element which will be processed regularly, then →<code>ext.Ext.get()</code> will be
   * more appropriate to take advantage of the caching provided by the
   * →<code>ext.dom.Element</code> class.</p>
   * <p>If this method is called with and id or element that has already been cached by
   * a previous call to Ext.get() it will return the cached Element instead of the
   * flyweight instance.</p>
   * @param dom The DOM node or <code>→id()</code>.
   * @param named Allows for creation of named reusable flyweights to prevent
   * conflicts (e.g. internally Ext uses "_global").
   * @return The shared Element object (or <code>null</code> if no matching
   * element was found).
   * @see ext.SExt#fly() ext.Ext.fly()
   * @see ext.dom.Element#fly()
   * @see ext.SExt#get() ext.Ext.get()
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-fly Original Ext JS documentation of 'fly'
   * @see SExt#id()
   */
  public native function fly(dom:*, named:String = null):Element;

  /**
   * Retrieves <code>ext.dom.Element</code> objects. →<code>ext.Ext.get()</code> is alias for →<code>ext.dom.Element.get()</code>.
   * <p><b>This method does not retrieve →<code>ext.Component</code>s.</b> This method retrieves Ext.dom.Element
   * objects which encapsulate DOM elements. To retrieve a Component by its ID, use →<code>ext.ComponentManager.get()</code>.</p>
   * <p>When passing an id, it should not include the <code>#</code> character that is used for a css selector.</p>
   * <pre>
   * // For an element with id 'foo'
   * Ext.get('foo'); // Correct
   * Ext.get('#foo'); // Incorrect
   * </pre>
   * <p>Uses simple caching to consistently return the same object. Automatically fixes if an object was recreated with
   * the same id via AJAX or DOM.</p>
   * @param element The <code>→id</code> of the node, a DOM Node or an existing Element.
   * @return The Element object (or <code>null</code> if no matching element was found).
   * @see ext.SExt#get() ext.Ext.get()
   * @see ext.dom.Element#get()
   * @see ext.Component
   * @see ext.SComponentManager#get() ext.ComponentManager.get()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-get Original Ext JS documentation of 'get'
   * @see #id
   */
  public native function get(element:*):Element;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getApplication Original Ext JS documentation of 'getApplication'
   */
  public native function getApplication():Application;

  /**
   * Returns the current document body as an →<code>ext.dom.Element</code>.
   * @return The document body.
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getBody Original Ext JS documentation of 'getBody'
   */
  public native function getBody():Element;

  /**
   * Get the class of the provided object; returns null if it's not an instance
   * of any class created with Ext.define. This is usually invoked by the
   * shorthand →<code>ext.Ext.getClass()</code>.
   * <pre>
   * var component = new Ext.Component();
   *
   * Ext.getClass(component); // returns Ext.Component
   * </pre>
   * @return class
   * @see ext.SExt#getClass() ext.Ext.getClass()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getClass Original Ext JS documentation of 'getClass'
   */
  public native function getClass(object:Object):ExtClass;

  /**
   * Get the name of the class by its reference or its instance. This is
   * usually invoked by the shorthand →<code>ext.Ext.getClassName()</code>.
   * <pre>
   * Ext.ClassManager.getName(Ext.Action); // returns "Ext.Action"
   * </pre>
   * @return className
   * @see ext.SExt#getClassName() ext.Ext.getClassName()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getClassName Original Ext JS documentation of 'getClassName'
   */
  public native function getClassName(object:*):String;

  /**
   * This is shorthand reference to →<code>ext.ComponentManager.get()</code>.
   * Looks up an existing →<code>ext.Component</code> by →<code>ext.Component.id</code>
   * @param id The component →<code>ext.Component.id</code>
   * @return The Component, <code>undefined</code> if not found, or <code>null</code> if a
   * Class was found.
   * @see ext.SComponentManager#get() ext.ComponentManager.get()
   * @see ext.Component
   * @see ext.Component#id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getCmp Original Ext JS documentation of 'getCmp'
   */
  public native function getCmp(id:String):Component;

  /**
   * Returns the current HTML document object as an →<code>ext.dom.Element</code>.
   * Typically used for attaching event listeners to the document. Note: since
   * the document object is not an HTMLElement many of the Ext.dom.Element methods
   * are not applicable and may throw errors if called on the returned
   * Element instance.
   * @return The document.
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getDoc Original Ext JS documentation of 'getDoc'
   */
  public native function getDoc():Element;

  /**
   * Return the dom node for the passed String (id), dom node, or Ext.Element.
   * Here are some examples:
   * <pre>
   * // gets dom node based on id
   * var elDom = Ext.getDom('elId');
   *
   * // gets dom node based on the dom node
   * var elDom1 = Ext.getDom(elDom);
   *
   * // If we don't know if we are working with an
   * // Ext.Element or a dom node use Ext.getDom
   * function(el){
   *     var dom = Ext.getDom(el);
   *     // do something with the dom node
   * }
   * </pre>
   * <p><b>Note:</b> the dom node to be found actually needs to exist (be rendered, etc)
   * when this method is called to be successful.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getDom Original Ext JS documentation of 'getDom'
   */
  public native function getDom(el:*):HTMLElement;

  /**
   * Returns the current document head as an →<code>ext.dom.Element</code>.
   * @return The document head.
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getHead Original Ext JS documentation of 'getHead'
   */
  public native function getHead():Element;

  /**
   * @return Namespace prefix if it's known, otherwise undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getNamespace Original Ext JS documentation of 'getNamespace'
   */
  public native function getNamespace(className:String):String;

  /**
   * This function returns the path to a resource loaded from the resources folder.
   * @param path specifies the relative path to the resource inside the resources folder
   * @param poolName specifies the resources pool name, which is either "path", "shared" or null. Important for universal apps. If in doubt use null.
   * @param packageName The Sencha package name the resource is used from.
   * @return The path to the resource
   */
  public native function getResourcePath(path:String, poolName:String = null, packageName:String = null):String;

  /**
   * Returns the size of the browser scrollbars. This can differ depending on
   * operating system settings, such as the theme or font size.
   * @param force true to force a recalculation of the value.
   * @return An object containing scrollbar sizes.
   * <ul>
   * <li><code>width:Number</code> (optional) —
   * The width of the vertical scrollbar.
   * </li>
   * <li><code>height:Number</code> (optional) —
   * The height of the horizontal scrollbar.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getScrollbarSize Original Ext JS documentation of 'getScrollbarSize'
   */
  public native function getScrollbarSize(force:Boolean = false):Object;

  /**
   * Shortcut to →<code>ext.data.StoreManager.lookup()</code>.
   * Gets a registered Store by id
   * @see ext.data.SStoreManager#lookup() ext.data.StoreManager.lookup()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getStore Original Ext JS documentation of 'getStore'
   */
  public native function getStore(name:*):Store;

  /**
   * Get the version number of the supplied package name; will return the version of
   * the framework.
   * @param packageName The package name, e.g., 'core', 'touch', 'ext'.
   * @return The version.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getVersion Original Ext JS documentation of 'getVersion'
   */
  public native function getVersion(packageName:String = null):Version;

  /**
   * Retrieves the viewport height of the window.
   * @since 6.5.0
   * @return viewportHeight
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getViewportHeight Original Ext JS documentation of 'getViewportHeight'
   */
  public native function getViewportHeight():Number;

  /**
   * Retrieves the viewport width of the window.
   * @since 6.5.0
   * @return viewportWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getViewportWidth Original Ext JS documentation of 'getViewportWidth'
   */
  public native function getViewportWidth():Number;

  /**
   * Returns the current window object as an →<code>ext.dom.Element</code>.
   * Typically used for attaching event listeners to the window. Note: since
   * the window object is not an HTMLElement many of the Ext.dom.Element methods
   * are not applicable and may throw errors if called on the returned
   * Element instance.
   * @return The window.
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-getWin Original Ext JS documentation of 'getWin'
   */
  public native function getWin():Element;

  /**
   * Convert certain characters (&amp;, &lt;, &gt;, ', and ") from their HTML character equivalents.
   * @param value The string to decode.
   * @return The decoded text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-htmlDecode Original Ext JS documentation of 'htmlDecode'
   */
  public native function htmlDecode(value:String):String;

  /**
   * Convert certain characters (&amp;, &lt;, &gt;, ', and ") to their HTML character equivalents
   * for literal display in web pages.
   * @param value The string to encode.
   * @return The encoded text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-htmlEncode Original Ext JS documentation of 'htmlEncode'
   */
  public native function htmlEncode(value:String):String;

  /**
   * Generates unique ids. If the object/element is passes and it already has an <code>→id()</code>, it is
   * unchanged.
   * @param o The object to generate an id for.
   * @param prefix The <code>→id()</code> prefix.
   * @default ext-gen
   * @return The generated <code>→id()</code>.
   * @see SExt#id()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-id Original Ext JS documentation of 'id'
   */
  public native function id(o:Object = null, prefix:String = "ext-gen"):String;

  /**
   * Calls the function <code>fn</code> repeatedly at a given interval, optionally with a
   * specific <code>scope</code> (<code>this</code> pointer).
   * <pre>
   * var sayHi = function(name) {
   *     console.log('Hi, ' + name);
   * }
   *
   * // executes every 2 seconds:
   * var timerId = Ext.interval(sayHi, 2000, this, ['Fred']);
   * </pre>
   * <p>The timer is stopped by:</p>
   * <pre>
   * Ext.uninterval(timerId);
   * </pre>
   * <p>NOTE: The <code>Ext.Function.interval()</code> method is an alias for <code>Ext.interval()</code>.</p>
   * @param fn The function to defer.
   * @param millis The number of milliseconds for the <code>setInterval</code> call
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed. <b>If omitted, defaults to the browser window.</b>
   * @param args Overrides arguments for the call. Defaults to the arguments
   * passed by the caller.
   * @param appendArgs If <code>true</code> args are appended to call args
   * instead of overriding, or, if a number, then the args are inserted at the specified
   * position.
   * @default false
   * @return The interval id that can be used with <code>Ext.uninterval</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-interval Original Ext JS documentation of 'interval'
   */
  public native function interval(fn:Function, millis:Number, scope:Object = null, args:Array = null, appendArgs:* = false):Number;

  /**
   * Returns <code>true</code> if the passed value is a JavaScript Array, <code>false</code> otherwise.
   * @param target The target to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isArray Original Ext JS documentation of 'isArray'
   */
  public native function isArray(target:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a boolean.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isBoolean Original Ext JS documentation of 'isBoolean'
   */
  public native function isBoolean(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a JavaScript Date object, <code>false</code> otherwise.
   * @param obj The object to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isDate Original Ext JS documentation of 'isDate'
   */
  public native function isDate(obj:Object):Boolean;

  /**
   * This method returns <code>true</code> if debug is enabled for the specified class. This is
   * done by checking the <code>Ext.debugConfig.hooks</code> config for the closest match to the
   * given <code>className</code>.
   * @param className The name of the class.
   * @return <code>true</code> if debug is enabled for the specified class.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isDebugEnabled Original Ext JS documentation of 'isDebugEnabled'
   */
  public native function isDebugEnabled(className:String):Boolean;

  /**
   * Returns <code>true</code> if the passed value is defined.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isDefined Original Ext JS documentation of 'isDefined'
   */
  public native function isDefined(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is an HTMLElement
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isElement Original Ext JS documentation of 'isElement'
   */
  public native function isElement(value:Object):Boolean;

  /**
   * Returns true if the passed value is empty, false otherwise. The value is deemed to be
   * empty if it is either:
   * <ul>
   * <li><code>null</code></li>
   * <li><code>undefined</code></li>
   * <li>a zero-length array</li>
   * <li>a zero-length string (Unless the <code>allowEmptyString</code> parameter is set to <code>true</code>)</li>
   * </ul>
   * @param value The value to test.
   * @param allowEmptyString <code>true</code> to allow empty strings.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isEmpty Original Ext JS documentation of 'isEmpty'
   */
  public native function isEmpty(value:Object, allowEmptyString:Boolean = false):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a JavaScript Function, <code>false</code> otherwise.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isFunction Original Ext JS documentation of 'isFunction'
   */
  public native function isFunction(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is iterable, that is, if elements of it are
   * addressable using array notation with numeric indices, <code>false</code> otherwise.
   * <p>Arrays and function <code>arguments</code> objects are iterable. Also HTML collections such as
   * <code>NodeList</code> and `HTMLCollection' are iterable.</p>
   * @param value The value to test
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isIterable Original Ext JS documentation of 'isIterable'
   */
  public native function isIterable(value:Object):Boolean;

  /**
   * Returns 'true' if the passed value is a String that matches the MS Date JSON
   * encoding format.
   * @param value The string to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isMSDate Original Ext JS documentation of 'isMSDate'
   */
  public native function isMSDate(value:String):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a number. Returns <code>false</code> for non-finite numbers.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isNumber Original Ext JS documentation of 'isNumber'
   */
  public native function isNumber(value:Object):Boolean;

  /**
   * Validates that a value is numeric.
   * @param value Examples: 1, '1', '2.34'
   * @return True if numeric, false otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isNumeric Original Ext JS documentation of 'isNumeric'
   */
  public native function isNumeric(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a JavaScript Object, <code>false</code> otherwise.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isObject Original Ext JS documentation of 'isObject'
   */
  public native function isObject(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a JavaScript 'primitive', a string, number
   * or boolean.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isPrimitive Original Ext JS documentation of 'isPrimitive'
   */
  public native function isPrimitive(value:Object):Boolean;

  /**
   * Returns <code>true</code>if the passed value is a string.
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isString Original Ext JS documentation of 'isString'
   */
  public native function isString(value:Object):Boolean;

  /**
   * Returns <code>true</code> if the passed value is a TextNode
   * @param value The value to test.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-isTextNode Original Ext JS documentation of 'isTextNode'
   */
  public native function isTextNode(value:Object):Boolean;

  /**
   * Iterates either an array or an object. This method delegates to
   * →<code>ext.ArrayUtil.each()</code> if the given value is iterable, and
   * →<code>ext.ObjectUtil.each()</code> otherwise.
   * @param object The object or array to be iterated.
   * @param fn The function to be called for each iteration. See and
   * →<code>ext.ArrayUtil.each()</code> and →<code>ext.ObjectUtil.each()</code>
   * for detailed lists of arguments passed to this function depending on the given object
   * type that is being iterated.
   * @param scope The scope (<code>this</code> reference) in which the specified function
   * is executed. Defaults to the object being iterated itself.
   * @see ext.SArrayUtil#each() ext.ArrayUtil.each()
   * @see ext.SObjectUtil#each() ext.ObjectUtil.each()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-iterate Original Ext JS documentation of 'iterate'
   */
  public native function iterate(object:*, fn:Function, scope:Object = null):void;

  /**
   * Logs a message. If a console is present it will be used. On Opera, the method
   * "opera.postError" is called. In other cases, the message is logged to an array
   * "Ext.log.out". An attached debugger can watch this array and view the log. The
   * log buffer is limited to a maximum of "Ext.log.max" entries (defaults to 250).
   * <p>If additional parameters are passed, they are joined and appended to the message.
   * A technique for tracing entry and exit of a function is this:</p>
   * <pre>
   * function foo () {
   *     Ext.log({ indent: 1 }, '&gt;&gt; foo');
   *
   *     // log statements in here or methods called from here will be indented
   *     // by one step
   *
   *     Ext.log({ outdent: 1 }, '&lt;&lt; foo');
   * }
   * </pre>
   * <p>This method does nothing in a release build.</p>
   * @param options The message to log or an options object with any
   * of the following properties:
   * <ul>
   * <li><code>msg</code>: The message to log (required).</li>
   * <li><code>level</code>: One of: "error", "warn", "info" or "log" (the default is "log").</li>
   * <li><code>dump</code>: An object to dump to the log as part of the message.</li>
   * <li><code>stack</code>: True to include a stack trace in the log.</li>
   * <li><code>indent</code>: Cause subsequent log statements to be indented one step.</li>
   * <li><code>outdent</code>: Cause this and following statements to be one step less indented.</li>
   * </ul>
   * @param message The message to log (required unless specified in
   * options object).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-log Original Ext JS documentation of 'log'
   */
  public native function log(options:* = undefined, ...message):void;

  [Deprecated(replacement="max", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.max()</code>
   * Returns the maximum value in the Array.
   * @param array The Array from which to select the maximum value.
   * @param comparisonFn a function to perform the comparison which
   * determines maximization.
   * If omitted the "&gt;" operator will be used.
   * <b>Note:</b> gt = 1; eq = 0; lt = -1
   * <ul>
   * <li><code>max</code> (optional) —
   * Current maximum value.
   * </li>
   * <li><code>item</code> (optional) —
   * The value to compare with the current maximum.
   * </li>
   * </ul>
   * @return maxValue The maximum value.
   * @see ext.SArrayUtil#max() ext.ArrayUtil.max()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-max Original Ext JS documentation of 'max'
   */
  public native function max(array:*, comparisonFn:Function = null):Object;

  [Deprecated(replacement="mean", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.mean()</code>
   * Calculates the mean of all items in the array.
   * @param array The Array to calculate the mean value of.
   * @return The mean.
   * @see ext.SArrayUtil#mean() ext.ArrayUtil.mean()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-mean Original Ext JS documentation of 'mean'
   */
  public native function mean(array:Array):Number;

  /**
   * A convenient alias method for →<code>ext.ObjectUtil.merge()</code>.
   * Merges any number of objects recursively without referencing them or their children.
   * Note: It will reference arrays if they are only present in one of the objects being merged.
   * <pre>
   * var extjs = {
   *     companyName: 'Ext JS',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer'],
   *     isSuperCool: true,
   *     office: {
   *         size: 2000,
   *         location: 'Palo Alto',
   *         isFun: true
   *     }
   * };
   *
   * var newStuff = {
   *     companyName: 'Sencha Inc.',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],
   *     office: {
   *         size: 40000,
   *         location: 'Redwood City'
   *     }
   * };
   *
   * var sencha = Ext.Object.merge(extjs, newStuff);
   *
   * // extjs and sencha then equals to
   * {
   *     companyName: 'Sencha Inc.',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],
   *     isSuperCool: true,
   *     office: {
   *         size: 40000,
   *         location: 'Redwood City',
   *         isFun: true
   *     }
   * }
   * </pre>
   * @param destination The object into which all subsequent objects are merged.
   * @param object Any number of objects to merge into the destination.
   * @return merged The destination object with all passed objects merged in.
   * @see ext.SObjectUtil#merge() ext.ObjectUtil.merge()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-merge Original Ext JS documentation of 'merge'
   */
  public native function merge(destination:Object, ...object):Object;

  [Deprecated(replacement="min", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.min()</code>
   * Returns the minimum value in the Array.
   * @param array The Array from which to select the minimum value.
   * @param comparisonFn a function to perform the comparison which
   * determines minimization.
   * If omitted the "&lt;" operator will be used.
   * <b>Note:</b> gt = 1; eq = 0; lt = -1
   * <ul>
   * <li><code>min</code> (optional) —
   * Current minimum value.
   * </li>
   * <li><code>item</code> (optional) —
   * The value to compare with the current minimum.
   * </li>
   * </ul>
   * @return minValue The minimum value.
   * @see ext.SArrayUtil#min() ext.ArrayUtil.min()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-min Original Ext JS documentation of 'min'
   */
  public native function min(array:*, comparisonFn:Function = null):Object;

  /**
   * Creates namespaces to be used for scoping variables and classes so that they are not
   * global. Specifying the last node of a namespace implicitly creates all other nodes.
   * Usage:
   * <pre>
   * Ext.namespace('Company', 'Company.data');
   *
   * // equivalent and preferable to the above syntax
   * Ext.ns('Company.data');
   *
   * Company.Widget = function() { ... };
   *
   * Company.data.CustomStore = function(config) { ... };
   * </pre>
   * @return The (last) namespace object created.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-namespace Original Ext JS documentation of 'namespace'
   */
  public native function namespace(...namespaces):Object;

  /**
   * Returns the current timestamp.
   * @return Milliseconds since UNIX epoch.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-now Original Ext JS documentation of 'now'
   */
  public native function now():Number;

  /**
   * Convenient alias for →<code>ext.Ext.namespace()</code>.
   * Creates namespaces to be used for scoping variables and classes so that they are not
   * global. Specifying the last node of a namespace implicitly creates all other nodes.
   * Usage:
   * <pre>
   * Ext.namespace('Company', 'Company.data');
   *
   * // equivalent and preferable to the above syntax
   * Ext.ns('Company.data');
   *
   * Company.Widget = function() { ... };
   *
   * Company.data.CustomStore = function(config) { ... };
   * </pre>
   * @return The (last) namespace object created.
   * @see ext.SExt#namespace() ext.Ext.namespace()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-ns Original Ext JS documentation of 'ns'
   */
  public native function ns(...namespaces):Object;

  [Deprecated(replacement="from", since="4.0.0")]
  /**
   * Validate that a value is numeric and convert it to a number if necessary.
   * Returns the specified default value if it is not.
   * <pre>
   *  Ext.Number.from('1.23', 1); // returns 1.23
   *  Ext.Number.from('abc', 1); // returns 1
   * </pre>
   * @param value
   * @param defaultValue The value to return if the original value is non-numeric
   * @return value, if numeric, defaultValue otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-num Original Ext JS documentation of 'num'
   */
  public native function num(value:Object, defaultValue:Number):Number;

  /**
   * Shorthand for →<code>ext.GlobalEvents.addListener()</code>.
   * The →<code>on()</code> method is shorthand for
   * →<code>ext.util.Observable.addListener()</code>.
   * <p>Appends an event handler to this object. For example:</p>
   * <pre>
   * myGridPanel.on("itemclick", this.onItemClick, this);
   * </pre>
   * <p>The method also allows for a single argument to be passed which is a config object
   * containing properties which specify multiple events. For example:</p>
   * <pre>
   * myGridPanel.on({
   *     cellclick: this.onCellClick,
   *     select: this.onSelect,
   *     viewready: this.onViewReady,
   *     scope: this // Important. Ensure "this" is correct during handler execution
   * });
   * </pre>
   * <p>One can also specify options for each event handler separately:</p>
   * <pre>
   * myGridPanel.on({
   *     cellclick: {fn: this.onCellClick, scope: this, single: true},
   *     viewready: {fn: panel.onViewReady, scope: panel}
   * });
   * </pre>
   * <p><i>Names</i> of methods in a specified scope may also be used:</p>
   * <pre>
   * myGridPanel.on({
   *     cellclick: {fn: 'onCellClick', scope: this, single: true},
   *     viewready: {fn: 'onViewReady', scope: panel}
   * });
   * </pre>
   * @param eventName The name of the event to listen for.
   * May also be an object who's property names are event names.
   * @param fn The method the event invokes or the <i>name</i> of
   * the method within the specified <code>scope</code>. Will be called with arguments
   * given to →<code>ext.util.Observable.fireEvent()</code> plus the <code>options</code> parameter described
   * below.
   * @param scope The scope (<code>this</code> reference) in which the handler function is
   * executed. <b>If omitted, defaults to the object which fired the event.</b>
   * @param options An object containing handler configuration.
   * <p><b>Note:</b> The options object will also be passed as the last argument to every
   * event handler.</p>
   * <p>This object may contain any of the following properties:</p>
   * <ul>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the handler function is executed. <b>If omitted,
   * defaults to the object which fired the event.</b>
   * </li>
   * <li><code>delay:Number</code> (optional) —
   * The number of milliseconds to delay the invocation of the handler after the event
   * fires.
   * </li>
   * <li><code>single:Boolean</code> (optional) —
   * True to add a handler to handle just the next firing of the event, and then remove
   * itself.
   * </li>
   * <li><code>buffer:Number</code> (optional) —
   * Causes the handler to be scheduled to run in an →<code>ext.util.DelayedTask</code> delayed
   * by the specified number of milliseconds. If the event fires again within that time,
   * the original handler is <i>not</i> invoked, but the new handler is scheduled in its place.
   * </li>
   * <li><code>onFrame:Number</code> (optional) —
   * Causes the handler to be scheduled to run at the next
   * <i>animation frame event</i> (→<code>ext.FunctionUtil.requestAnimationFrame()</code>). If the
   * event fires again before that time, the handler is not rescheduled - the handler
   * will only be called once when the next animation frame is fired, with the last set
   * of arguments passed.
   * </li>
   * <li><code>target:ext.util.Observable</code> (optional) —
   * Only call the handler if the event was fired on the target Observable, <i>not</i> if the
   * event was bubbled up from a child Observable.
   * </li>
   * <li><code>element:String</code> (optional) —
   * <b>This option is only valid for listeners bound to <i>Components</i> (→<code>ext.Component</code>).</b>
   * The name of a Component property which references an <i>element</i> (→<code>ext.dom.Element</code>)
   * to add a listener to.
   * <p>This option is useful during Component construction to add DOM event listeners to
   * elements of <i>Components</i> (→<code>ext.Component</code>) which will exist only after the
   * Component is rendered.</p>
   * <p>For example, to add a click listener to a Panel's body:</p>
   * <pre>
   *   var panel = new Ext.panel.Panel({
   *       title: 'The title',
   *       listeners: {
   *           click: this.handlePanelClick,
   *           element: 'body'
   *       }
   *   });
   * </pre>
   * <p>In order to remove listeners attached using the element, you'll need to reference
   * the element itself as seen below.</p>
   * <pre>
   *  panel.body.un(...)
   * </pre>
   * </li>
   * <li><code>delegate:String</code> (optional) —
   * A simple selector to filter the event target or look for a descendant of the target.
   * <p>The "delegate" option is only available on Ext.dom.Element instances (or
   * when attaching a listener to a Ext.dom.Element via a Component using the
   * element option).</p>
   * <p>See the <i>delegate</i> example below.</p>
   * </li>
   * <li><code>capture:Boolean</code> (optional) —
   * When set to <code>true</code>, the listener is fired in the capture phase of the event propagation
   * sequence, instead of the default bubble phase.
   * <p>The <code>capture</code> option is only available on Ext.dom.Element instances (or
   * when attaching a listener to a Ext.dom.Element via a Component using the
   * element option).</p>
   * </li>
   * <li><code>stopPropagation:Boolean</code> (optional) —
   * <b>This option is only valid for listeners bound to <i>Elements</i> (→<code>ext.dom.Element</code>).</b>
   * <code>true</code> to call →<code>ext.event.Event.stopPropagation()</code> on the event
   * object before firing the handler.
   * </li>
   * <li><code>preventDefault:Boolean</code> (optional) —
   * <b>This option is only valid for listeners bound to <i>Elements</i> (→<code>ext.dom.Element</code>).</b>
   * <code>true</code> to call →<code>ext.event.Event.preventDefault()</code> on the event
   * object before firing the handler.
   * </li>
   * <li><code>stopEvent:Boolean</code> (optional) —
   * <b>This option is only valid for listeners bound to <i>Elements</i> (→<code>ext.dom.Element</code>).</b>
   * <code>true</code> to call →<code>ext.event.Event.stopEvent()</code> on the event object
   * before firing the handler.
   * </li>
   * <li><code>args:Array</code> (optional) —
   * Optional set of arguments to pass to the handler function before the actual
   * fired event arguments. For example, if <code>args</code> is set to <code>['foo', 42]</code>,
   * the event handler function will be called with an arguments list like this:
   * <pre>
   *  handler('foo', 42, &lt;actual event arguments&gt;...);
   * </pre>
   * </li>
   * <li><code>destroyable:Boolean</code> (default = <code>false</code>) —
   * When specified as <code>true</code>, the function returns a <code>destroyable</code> object. An object
   * which implements the <code>→destroy()</code> method which removes all listeners added in this call.
   * This syntax can be a helpful shortcut to using →<code>un()</code>; particularly when
   * removing multiple listeners. <i>NOTE</i> - not compatible when using the <i>element</i>
   * option. See →<code>un()</code> for the proper syntax for removing listeners added using the
   * <i>element</i> config.
   * </li>
   * <li><code>priority:Number</code> (optional) —
   * An optional numeric priority that determines the order in which event handlers
   * are run. Event handlers with no priority will be run as if they had a priority
   * of 0. Handlers with a higher priority will be prioritized to run sooner than
   * those with a lower priority. Negative numbers can be used to set a priority
   * lower than the default. Internally, the framework uses a range of 1000 or
   * greater, and -1000 or lesser for handlers that are intended to run before or
   * after all others, so it is recommended to stay within the range of -999 to 999
   * when setting the priority of event handlers in application-level code.
   * A priority must be an integer to be valid. Fractional values are reserved for
   * internal framework use.
   * </li>
   * <li><code>order:String</code> (default = <code>'current'</code>) —
   * A legacy option that is provided for backward compatibility.
   * It is recommended to use the <code>priority</code> option instead. Available options are:
   * <ul>
   * <li><code>'before'</code>: equal to a priority of <code>100</code></li>
   * <li><code>'current'</code>: equal to a priority of <code>0</code> or default priority</li>
   * <li><code>'after'</code>: equal to a priority of <code>-100</code></li>
   * </ul>
   * </li>
   * </ul>
   * @param order A shortcut for the <code>order</code> event option. Provided for backward compatibility.
   * Please use the <code>priority</code> event option instead.
   * @default 'current'
   * @return <b>Only when the <code>destroyable</code> option is specified.</b>
   * <p>A <code>Destroyable</code> object. An object which implements the <code>→destroy()</code> method which removes
   * all listeners added in this call. For example:</p>
   * <pre>
   * this.btnListeners =  = myButton.on({
   *     destroyable: true
   *     mouseover:   function() { console.log('mouseover'); },
   *     mouseout:    function() { console.log('mouseout'); },
   *     click:       function() { console.log('click'); }
   * });
   * </pre>
   * <p>And when those listeners need to be removed:</p>
   * <pre>
   * Ext.destroy(this.btnListeners);
   * </pre>
   * <p>or</p>
   * <pre>
   * this.btnListeners.destroy();
   * </pre>
   * @see ext.SGlobalEvents#addListener() ext.GlobalEvents.addListener()
   * @see SExt#on()
   * @see ext.util.Observable#addListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-on Original Ext JS documentation of 'on'
   * @see ext.util.Observable#fireEvent()
   * @see ext.util.DelayedTask
   * @see ext.SFunctionUtil#requestAnimationFrame() ext.FunctionUtil.requestAnimationFrame()
   * @see ext.Component
   * @see ext.dom.Element
   * @see ext.event.Event#stopPropagation()
   * @see ext.event.Event#preventDefault()
   * @see ext.event.Event#stopEvent()
   * @see SExt#destroy()
   * @see SExt#un()
   */
  public native function on(eventName:*, fn:* = undefined, scope:Object = null, options:Object = null, order:String = 'current'):Object;

  /**
   * Adds a listener to be notified when the document is ready (before onload and before
   * images are loaded).
   * @param fn The method to call.
   * @param scope The scope (<code>this</code> reference) in which the handler function
   * executes. Defaults to the browser window.
   * @param options An object with extra options.
   * <ul>
   * <li><code>delay:Number</code> (default = <code>0</code>) —
   * A number of milliseconds to delay.
   * </li>
   * <li><code>priority:Number</code> (default = <code>0</code>) —
   * Relative priority of this callback. A larger
   * number will result in the callback being sorted before the others. Priorities
   * 1000 or greater and -1000 or lesser are reserved for internal framework use only.
   * </li>
   * <li><code>dom:Boolean</code> (default = <code>false</code>) —
   * Pass <code>true</code> to only wait for DOM ready, <code>false</code>
   * means full Framework and DOM readiness.
   * numbers are reserved.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-onReady Original Ext JS documentation of 'onReady'
   */
  public native function onReady(fn:Function, scope:Object = null, options:Object = null):void;

  /**
   * Overrides members of the specified <code>target</code> with the given values.
   * <p>If the <code>target</code> is a class declared using →<code>ext.Ext.define()</code>, the
   * <code>→override_()</code> method of that class is called (see →<code>ext.Base.override_()</code>) given
   * the <code>overrides</code>.</p>
   * <p>If the <code>target</code> is a function, it is assumed to be a constructor and the contents
   * of <code>overrides</code> are applied to its <code>→prototype</code> using →<code>ext.Ext.apply()</code>.</p>
   * <p>If the <code>target</code> is an instance of a class declared using →<code>ext.Ext.define()</code>,
   * the <code>overrides</code> are applied to only that instance. In this case, methods are
   * specially processed to allow them to use →<code>ext.Base.callParent()</code>.</p>
   * <pre>
   *  var panel = new Ext.Panel({ ... });
   *
   *  Ext.override(panel, {
   *      initComponent: function () {
   *          // extra processing...
   *
   *          this.callParent();
   *      }
   *  });
   * </pre>
   * <p>If the <code>target</code> is none of these, the <code>overrides</code> are applied to the <code>target</code>
   * using →<code>ext.Ext.apply()</code>.</p>
   * <p>Please refer to →<code>ext.Ext.define()</code> and →<code>ext.Base.override_()</code> for
   * further details.</p>
   * @param target The target to override.
   * @param overrides The properties to add or replace on <code>target</code>.
   * @see ext.SExt#define() ext.Ext.define()
   * @see SExt#override_()
   * @see ext.Base#override_()
   * @see SExt#prototype
   * @see ext.SExt#apply() ext.Ext.apply()
   * @see ext.Base#callParent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-override Original Ext JS documentation of 'override'
   */
  public native function override_(target:Object, overrides:Object):void;

  /**
   * Create a new function from the provided <code>fn</code>, the arguments of which are pre-set
   * to <code>args</code>. New arguments passed to the newly created callback when it's invoked
   * are appended after the pre-set ones.
   * This is especially useful when creating callbacks.
   * <p>For example:</p>
   * <pre>
   * var originalFunction = function(){
   *     alert(Ext.Array.from(arguments).join(' '));
   * };
   *
   * var callback = Ext.Function.pass(originalFunction, ['Hello', 'World']);
   *
   * callback(); // alerts 'Hello World'
   * callback('by Me'); // alerts 'Hello World by Me'
   * </pre>
   * <p>→<code>ext.Ext.pass()</code> is alias for →<code>ext.FunctionUtil.pass()</code></p>
   * @param fn The original function.
   * @param args The arguments to pass to new callback.
   * @param scope The scope (<code>this</code> reference) in which the function
   * is executed.
   * @return The new callback function.
   * @see ext.SExt#pass() ext.Ext.pass()
   * @see ext.SFunctionUtil#pass() ext.FunctionUtil.pass()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-pass Original Ext JS documentation of 'pass'
   */
  public native function pass(fn:Function, args:Array, scope:Object = null):Function;

  [Deprecated(replacement="pluck", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.pluck()</code>
   * Plucks the value of a property from each item in the Array. Example:
   * <pre>
   * // [el1.className, el2.className, ..., elN.className]
   * Ext.Array.pluck(Ext.query("p"), "className");
   * </pre>
   * @param array The Array of items to pluck the value from.
   * @param propertyName The property name to pluck from each element.
   * @return The value from each item in the Array.
   * @see ext.SArrayUtil#pluck() ext.ArrayUtil.pluck()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-pluck Original Ext JS documentation of 'pluck'
   */
  public native function pluck(array:*, propertyName:String):Array;

  /**
   * Shorthand for →<code>ext.dom.Element.query()</code><br><br>
   * Selects child nodes based on the passed CSS selector.
   * Delegates to document.querySelectorAll. More information can be found at
   * <a href="http://www.w3.org/TR/css3-selectors/">http://www.w3.org/TR/css3-selectors/</a>
   * <p>All selectors, attribute filters and pseudos below can be combined infinitely
   * in any order. For example <code>div.foo:nth-child(odd)[&#64;foo=bar].bar:first</code> would be
   * a perfectly valid selector.</p>
   * <p><b><i>Element Selectors:</i></b></p>
   * <ul>
   * <li>&#42; any element</li>
   * <li>E an element with the tag E</li>
   * <li>E F All descendant elements of E that have the tag F</li>
   * <li>E &gt; F or E/F all direct children elements of E that have the tag F</li>
   * <li>E + F all elements with the tag F that are immediately preceded by an element
   * with the tag E</li>
   * <li>E ~ F all elements with the tag F that are preceded by a sibling element with the tag E</li>
   * </ul>
   * <p><b><i>Attribute Selectors:</i></b></p>
   * <p>The use of &#64; and quotes are optional. For example, div[&#64;foo='bar'] is also a valid
   * attribute selector.</p>
   * <ul>
   * <li>E[foo] has an attribute "foo"</li>
   * <li>E[foo=bar] has an attribute "foo" that equals "bar"</li>
   * <li>E[foo^=bar] has an attribute "foo" that starts with "bar"</li>
   * <li>E[foo$=bar] has an attribute "foo" that ends with "bar"</li>
   * <li>E[foo&#42;=bar] has an attribute "foo" that contains the substring "bar"</li>
   * <li>E[foo%=2] has an attribute "foo" that is evenly divisible by 2</li>
   * <li>E[foo!=bar] has an attribute "foo" that does not equal "bar"</li>
   * </ul>
   * <p><b><i>Pseudo Classes:</i></b></p>
   * <ul>
   * <li>E:first-child E is the first child of its parent</li>
   * <li>E:last-child E is the last child of its parent</li>
   * <li>E:nth-child(n) E is the nth child of its parent (1 based as per the spec)</li>
   * <li>E:nth-child(odd) E is an odd child of its parent</li>
   * <li>E:nth-child(even) E is an even child of its parent</li>
   * <li>E:only-child E is the only child of its parent</li>
   * <li>E:checked E is an element that is has a checked attribute that is true (e.g. a radio
   * or checkbox)</li>
   * <li>E:first the first E in the resultset</li>
   * <li>E:last the last E in the resultset</li>
   * <li>E:nth(n) the nth E in the resultset (1 based)</li>
   * <li>E:odd shortcut for :nth-child(odd)</li>
   * <li>E:even shortcut for :nth-child(even)</li>
   * <li>E:not(S) an E element that does not match simple selector S</li>
   * <li>E:has(S) an E element that has a descendant that matches simple selector S</li>
   * <li>E:next(S) an E element whose next sibling matches simple selector S</li>
   * <li>E:prev(S) an E element whose previous sibling matches simple selector S</li>
   * <li>E:any(S1|S2|S2) an E element which matches any of the simple selectors S1, S2 or S3</li>
   * </ul>
   * <p><b><i>CSS Value Selectors:</i></b></p>
   * <ul>
   * <li>E{display=none} CSS value "display" that equals "none"</li>
   * <li>E{display^=none} CSS value "display" that starts with "none"</li>
   * <li>E{display$=none} CSS value "display" that ends with "none"</li>
   * <li>E{display&#42;=none} CSS value "display" that contains the substring "none"</li>
   * <li>E{display%=2} CSS value "display" that is evenly divisible by 2</li>
   * <li>E{display!=none} CSS value "display" that does not equal "none"</li>
   * </ul>
   * @param selector The CSS selector.
   * @param asDom <code>false</code> to return an array of Ext.dom.Element
   * @default true
   * @param root The root element of the query or id of
   * the root
   * @return An Array of elements (
   * HTMLElement or Ext.dom.Element if <i>asDom</i> is <i>false</i>) that match the selector.
   * If there are no matches, an empty Array is returned.
   * @see ext.dom.Element#query()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-query Original Ext JS documentation of 'query'
   */
  public native function query(selector:String, asDom:Boolean = true, root:* = undefined):*;

  /**
   * Raise an error that can include additional data and supports automatic console logging
   * if available. You can pass a string error message or an object with the <code>msg</code> attribute
   * which will be used as the error message. The object can contain any other name-value
   * attributes (or objects) to be logged along with the error.
   * <p>Note that after displaying the error message a JavaScript error will ultimately be
   * thrown so that execution will halt.</p>
   * <p>Example usage:</p>
   * <pre>
   * Ext.raise('A simple string error message');
   *
   * // or...
   *
   * Ext.define('Ext.Foo', {
   *     doSomething: function(option){
   *         if (someCondition === false) {
   *             Ext.raise({
   *                 msg: 'You cannot do that!',
   *                 option: option,   // whatever was passed into the method
   *                 code: 100 // other arbitrary info
   *             });
   *         }
   *     }
   * });
   * </pre>
   * @param err The error message string, or an object containing the
   * attribute "msg" that will be used as the error message. Any other data included in the
   * object will also be logged to the browser console, if available.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-raise Original Ext JS documentation of 'raise'
   */
  public native function raise(err:*):void;

  /**
   * Creates a new store for the given id and config, then registers it with the
   * <i>Store Manager</i> (→<code>ext.data.StoreManager</code>). Sample usage:
   * <pre>
   * Ext.regStore('AllUsers', {
   *     model: 'User'
   * });
   *
   * // the store can now easily be used throughout the application
   * new Ext.List({
   *     store: 'AllUsers',
   *     ... other config
   * });
   * </pre>
   * @param id The id to set on the new store, or the <code>config</code> object
   * that contains the <code>storeId</code> property.
   * @param config The store config if the first parameter (<code>→id()</code>) is just the
   * id.
   * @see ext.data.#StoreManager ext.data.StoreManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-regStore Original Ext JS documentation of 'regStore'
   * @see SExt#id()
   */
  public native function regStore(id:*, config:Object):void;

  /**
   * Removes an HTMLElement from the document. If the HTMLElement was previously
   * cached by a call to Ext.get(), removeNode will call the →<code>ext.dom.Element.destroy()</code> method of the →<code>ext.dom.Element</code> instance, which removes all DOM
   * event listeners, and deletes the cache reference.
   * @param node The node to remove
   * @see ext.dom.Element#destroy()
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-removeNode Original Ext JS documentation of 'removeNode'
   */
  public native function removeNode(node:HTMLElement):void;

  /**
   * Loads all classes by the given names and all their direct dependencies; optionally
   * executes the given callback function when finishes, within the optional scope.
   * @param expressions The class, classes or wildcards to load.
   * @param fn The callback function.
   * @param scope The execution scope (<code>this</code>) of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-require Original Ext JS documentation of 'require'
   */
  public native function require(expressions:*, fn:Function = null, scope:Object = null):void;

  /**
   * Resolves a resource URL that may contain a resource pool identifier token at the
   * front. The tokens are formatted as HTML tags "&lt;poolName&#64;packageName&gt;" followed
   * by a normal relative path. This token is only processed if present at the first
   * character of the given string.
   * <p>These tokens are parsed and the pieces are then passed to the
   * →<code>ext.Ext.getResourcePath</code> method.</p>
   * <p>For example:</p>
   * <pre>
   *  [{
   *      xtype: 'image',
   *      src: '&lt;shared&gt;images/foo.png'
   *  },{
   *      xtype: 'image',
   *      src: '&lt;&#64;package&gt;images/foo.png'
   *  },{
   *      xtype: 'image',
   *      src: '&lt;shared&#64;package&gt;images/foo.png'
   *  }]
   * </pre>
   * <p>In the above example, "shared" is the name of a Sencha Cmd resource pool and
   * "package" is the name of a Sencha Cmd package.</p>
   * @since 6.0.1
   * @param url The URL that may contain a resource pool token at the front.
   * @see ext.SExt#getResourcePath ext.Ext.getResourcePath
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-resolveResource Original Ext JS documentation of 'resolveResource'
   */
  public native function resolveResource(url:String):String;

  /**
   * Resumes layout activity in the whole framework.
   * <p>→<code>ext.Ext.suspendLayouts()</code> is alias of →<code>ext.Component.suspendLayouts()</code>.</p>
   * @param flush <code>true</code> to perform all the pending layouts. This can also
   * be achieved by calling →<code>ext.Component.flushLayouts()</code> directly.
   * @default false
   * @see ext.SExt#suspendLayouts() ext.Ext.suspendLayouts()
   * @see ext.Component#suspendLayouts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-resumeLayouts Original Ext JS documentation of 'resumeLayouts'
   * @see ext.Component#flushLayouts()
   */
  public native function resumeLayouts(flush:Boolean = false):void;

  /**
   * A reusable function which returns the value of <code>getId()</code> called upon a single passed
   * parameter. Useful when creating a →<code>ext.util.MixedCollection</code> of objects keyed
   * by an identifier returned from a <code>getId</code> method.
   * @see ext.util.MixedCollection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-returnId Original Ext JS documentation of 'returnId'
   */
  public native function returnId(o:*):void;

  /**
   * A reusable function which returns <code>true</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-returnTrue Original Ext JS documentation of 'returnTrue'
   */
  public native function returnTrue():Boolean;

  /**
   * Shorthand for →<code>ext.dom.Element.select()</code><br><br>
   * Selects descendant elements of this element based on the passed CSS selector to
   * enable →<code>ext.dom.Element</code> methods to be applied to many related
   * elements in one statement through the returned
   * →<code>ext.dom.CompositeElementLite</code> object.
   * @param selector The CSS selector or an array of elements
   * @param composite Return a CompositeElement as opposed to a
   * CompositeElementLite. Defaults to false.
   * @see ext.dom.Element#select()
   * @see ext.dom.Element
   * @see ext.dom.CompositeElementLite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(selector:*, composite:Boolean = false, root:* = undefined):*;

  /**
   * Sets the default font-family to use for components that support a <code>glyph</code> config.
   * @param fontFamily The name of the font-family
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-setGlyphFontFamily Original Ext JS documentation of 'setGlyphFontFamily'
   */
  public native function setGlyphFontFamily(fontFamily:String):void;

  /**
   * Set version number for the given package name.
   * @param packageName The package name, e.g. 'core', 'touch', 'ext'.
   * @param version The version, e.g. '1.2.3alpha', '2.4.0-dev'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-setVersion Original Ext JS documentation of 'setVersion'
   */
  public native function setVersion(packageName:String, version:*):SExt;

  [Deprecated(replacement="sum", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.sum()</code>
   * Calculates the sum of all items in the given array.
   * @param array The Array to calculate the sum value of.
   * @return The sum.
   * @see ext.SArrayUtil#sum() ext.ArrayUtil.sum()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-sum Original Ext JS documentation of 'sum'
   */
  public native function sum(array:Array):Number;

  /**
   * Stops layouts from happening in the whole framework.
   * <p>It's useful to suspend the layout activity while updating multiple components and
   * containers:</p>
   * <pre>
   * Ext.suspendLayouts();
   * // batch of updates...
   * Ext.resumeLayouts(true);
   * </pre>
   * <p>→<code>ext.Ext.suspendLayouts()</code> is alias of →<code>ext.Component.suspendLayouts()</code>.</p>
   * <p>See also →<code>ext.Ext.batchLayouts()</code> for more abstract way of doing this.</p>
   * @see ext.SExt#suspendLayouts() ext.Ext.suspendLayouts()
   * @see ext.Component#suspendLayouts()
   * @see ext.SExt#batchLayouts() ext.Ext.batchLayouts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-suspendLayouts Original Ext JS documentation of 'suspendLayouts'
   */
  public native function suspendLayouts():void;

  /**
   * Synchronously loads all classes by the given names and all their direct dependencies;
   * optionally executes the given callback function when finishes, within the optional scope.
   * @param expressions The class, classes or wildcards to load.
   * @param fn The callback function.
   * @param scope The execution scope (<code>this</code>) of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-syncRequire Original Ext JS documentation of 'syncRequire'
   */
  public native function syncRequire(expressions:*, fn:Function = null, scope:Object = null):void;

  /**
   * Returns the current high-resolution timestamp.
   * @since 6.0.1
   * @return Milliseconds ellapsed since arbitrary epoch.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-ticks Original Ext JS documentation of 'ticks'
   */
  public native function ticks():Number;

  /**
   * Converts any iterable (numeric indices and a length property) into a true array.
   * <pre>
   * function test() {
   *     var args = Ext.Array.toArray(arguments),
   *         fromSecondToLastArgs = Ext.Array.toArray(arguments, 1);
   *
   *     alert(args.join(' '));
   *     alert(fromSecondToLastArgs.join(' '));
   * }
   *
   * test('just', 'testing', 'here'); // alerts 'just testing here';
   *                                  // alerts 'testing here';
   *
   * // will convert the NodeList into an array
   * Ext.Array.toArray(document.getElementsByTagName('div'));
   * Ext.Array.toArray('splitted'); // returns ['s', 'p', 'l', 'i', 't', 't', 'e', 'd']
   * Ext.Array.toArray('splitted', 0, 3); // returns ['s', 'p', 'l']
   * </pre>
   * <p>→<code>ext.Ext.toArray()</code> is alias for →<code>ext.ArrayUtil.toArray()</code></p>
   * @param iterable the iterable object to be turned into a true Array.
   * @param start a zero-based index that specifies the start of extraction.
   * @default 0
   * @param end a 1-based index that specifies the end of extraction.
   * @default -1
   * @see ext.SExt#toArray() ext.Ext.toArray()
   * @see ext.SArrayUtil#toArray() ext.ArrayUtil.toArray()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-toArray Original Ext JS documentation of 'toArray'
   */
  public native function toArray(iterable:Object, start:Number = 0, end:Number = -1):Array;

  /**
   * Returns the type of the given variable in string format. List of possible values are:
   * <ul>
   * <li><code>undefined</code>: If the given value is <code>undefined</code></li>
   * <li><code>null</code>: If the given value is <code>null</code></li>
   * <li><code>string</code>: If the given value is a string</li>
   * <li><code>number</code>: If the given value is a number</li>
   * <li><code>boolean</code>: If the given value is a boolean value</li>
   * <li><code>date</code>: If the given value is a <code>→Date</code> object</li>
   * <li><code>function</code>: If the given value is a function reference</li>
   * <li><code>object</code>: If the given value is an object</li>
   * <li><code>array</code>: If the given value is an array</li>
   * <li><code>regexp</code>: If the given value is a regular expression</li>
   * <li><code>element</code>: If the given value is a DOM Element</li>
   * <li><code>textnode</code>: If the given value is a DOM text node and contains something other than
   * whitespace</li>
   * <li><code>whitespace</code>: If the given value is a DOM text node and contains only whitespace</li>
   * </ul>
   * @see Date
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-typeOf Original Ext JS documentation of 'typeOf'
   */
  public native function typeOf(value:Object):String;

  /**
   * Shorthand for →<code>ext.GlobalEvents.removeListener()</code>.
   * Removes an event handler.
   * @param eventName The type of event the handler was associated with.
   * @param fn The handler to remove. <b>This must be a reference to the function
   * passed into the
   * →<code>ext.util.Observable.addListener()</code> call.</b>
   * @param scope The scope originally specified for the handler. It
   * must be the same as the scope argument specified in the original call to
   * →<code>ext.util.Observable.addListener()</code> or the listener will not be removed.
   * @see ext.SGlobalEvents#removeListener() ext.GlobalEvents.removeListener()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-un Original Ext JS documentation of 'un'
   * @see ext.util.Observable#addListener()
   */
  public native function un(eventName:String, fn:Function, scope:Object = null):*;

  /**
   * Cancels a previously scheduled call to <code>→ext.Ext.asap()</code>.
   * <pre>
   *  var timerId = Ext.asap(me.method, me);
   *  ...
   *
   *  if (nevermind) {
   *      Ext.unasap(timerId);
   *  }
   * </pre>
   * <p>This method always returns <code>null</code> to enable simple cleanup:</p>
   * <pre>
   *  timerId = Ext.unasap(timerId);  // safe even if !timerId
   * </pre>
   * @param id The id returned by <code>→ext.Ext.asap()</code>.
   * @return Always returns <code>null</code>.
   * @see ext.SExt#asap() ext.Ext.asap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-unasap Original Ext JS documentation of 'unasap'
   */
  public native function unasap(id:Number):Object;

  /**
   * Cancels a previously scheduled call to <code>→ext.Ext.defer()</code>.
   * <pre>
   *  var timerId = Ext.defer(me.method, me);
   *  ...
   *
   *  if (nevermind) {
   *      Ext.undefer(timerId);
   *  }
   * </pre>
   * <p>This method always returns <code>null</code> to enable simple cleanup:</p>
   * <pre>
   *  timerId = Ext.undefer(timerId);  // safe even if !timerId
   * </pre>
   * @param id The id returned by <code>→ext.Ext.defer()</code>.
   * @see ext.SExt#defer() ext.Ext.defer()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-undefer Original Ext JS documentation of 'undefer'
   */
  public native function undefer(id:Number):void;

  /**
   * Cancels a previously scheduled call to <code>→ext.Ext.interval()</code>.
   * <pre>
   *  var timerId = Ext.interval(me.method, me);
   *  ...
   *
   *  if (nevermind) {
   *      Ext.uninterval(timerId);
   *  }
   * </pre>
   * <p>This method always returns <code>null</code> to enable simple cleanup:</p>
   * <pre>
   *  timerId = Ext.uninterval(timerId);  // safe even if !timerId
   * </pre>
   * @param id The id returned by <code>→ext.Ext.interval()</code>.
   * @see ext.SExt#interval() ext.Ext.interval()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-uninterval Original Ext JS documentation of 'uninterval'
   */
  public native function uninterval(id:Number):void;

  [Deprecated(replacement="unique", since="4.0.0")]
  /**
   * Old alias to →<code>ext.ArrayUtil.unique()</code>
   * Returns a new array with unique items.
   * @return results
   * @see ext.SArrayUtil#unique() ext.ArrayUtil.unique()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-unique Original Ext JS documentation of 'unique'
   */
  public native function unique(array:Array):Array;

  /**
   * This method accepts a <code>config</code> object and an existing <code>instance</code> if one exists
   * (can be <code>null</code>).
   * <p>The details are best explained by example:</p>
   * <pre>
   *  config: {
   *      header: {
   *          xtype: 'itemheader'
   *      }
   *  },
   *
   *  applyHeader: function (header, oldHeader) {
   *      return Ext.Factory.widget.update(oldHeader, header,
   *          this, 'createHeader');
   *  },
   *
   *  createHeader: function (header) {
   *      return Ext.apply({
   *          xtype: 'itemheader',
   *          ownerCmp: this
   *      }, header);
   *  }
   * </pre>
   * <p>Normally the <code>applyHeader</code> method would have to coordinate potential reuse of
   * the <code>oldHeader</code> and perhaps call <code>setConfig</code> on it with the new <code>header</code> config
   * options. If there was no <code>oldHeader</code>, of course, a new instance must be created
   * instead. These details are handled by this method. If the <code>oldHeader</code> is not
   * reused, it will be <i>destroyed</i> (→<code>ext.Base.destroy()</code>).</p>
   * <p>For derived class flexibility, the pattern of calling out to a "creator" method
   * that only returns the config object has become widely used in many components.
   * This pattern is also covered in this method. The goal is to allow the derived
   * class to <code>callParent</code> and yet not end up with an instantiated component (since
   * the type may not yet be known).</p>
   * <p>This mechanism should be used in favor of <code>Ext.factory()</code>.</p>
   * @since 6.5.1
   * @param instance
   * @param config The configuration (see →<code>create()</code>).
   * @param creator If passed, this object must provide the <code>creator</code>
   * method or the <code>creatorMethod</code> parameter.
   * @param creatorMethod The name of a creation wrapper method on the
   * given <code>creator</code> instance that "upgrades" the raw <code>config</code> object into a final
   * form for creation.
   * @param defaultsConfig The name of a config property (on the provided
   * <code>creator</code> instance) that contains defaults to be used to create instances. These
   * defaults are present in the config object passed to the <code>creatorMethod</code>.
   * @return The reconfigured <code>instance</code> or a newly created one.
   * @see ext.Base#destroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-updateWidget Original Ext JS documentation of 'updateWidget'
   * @see SExt#create()
   */
  public native function updateWidget(instance:Base, config:*, creator:Object = null, creatorMethod:String = null, defaultsConfig:String = null):Object;

  /**
   * Appends content to the query string of a URL, handling logic for whether to place
   * a question mark or ampersand.
   * @param url The URL to append to.
   * @param string The content to append to the URL.
   * @return The resulting URL
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-urlAppend Original Ext JS documentation of 'urlAppend'
   */
  public native function urlAppend(url:String, string:String):String;

  [Deprecated(replacement="fromQueryString", since="4.0.0")]
  /**
   * Alias for →<code>ext.ObjectUtil.fromQueryString()</code>.
   * Converts a query string back into an object.
   * <p>Non-recursive:</p>
   * <pre>
   * Ext.Object.fromQueryString("foo=1&amp;bar=2"); // returns {foo: '1', bar: '2'}
   * Ext.Object.fromQueryString("foo=&amp;bar=2"); // returns {foo: '', bar: '2'}
   * Ext.Object.fromQueryString("some%20price=%24300"); // returns {'some price': '$300'}
   * Ext.Object.fromQueryString("colors=red&amp;colors=green&amp;colors=blue"); // returns {colors: ['red', 'green', 'blue']}
   * </pre>
   * <p>Recursive:</p>
   * <pre>
   * Ext.Object.fromQueryString(
   *     "username=Jacky&amp;"+
   *     "dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911&amp;"+
   *     "hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;"+
   *     "hobbies[3][0]=nested&amp;hobbies[3][1]=stuff", true);
   *
   * // returns
   * {
   *     username: 'Jacky',
   *     dateOfBirth: {
   *         day: '1',
   *         month: '2',
   *         year: '1911'
   *     },
   *     hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]
   * }
   * </pre>
   * @param queryString The query string to decode
   * @param recursive Whether or not to recursively decode the string. This format is supported by
   * PHP / Ruby on Rails servers and similar.
   * @default false
   * @see ext.SObjectUtil#fromQueryString() ext.ObjectUtil.fromQueryString()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-urlDecode Original Ext JS documentation of 'urlDecode'
   */
  public native function urlDecode(queryString:String, recursive:Boolean = false):Object;

  [Deprecated(replacement="toQueryString", since="4.0.0")]
  /**
   * Takes an object and converts it to an encoded query string.
   * <p>Non-recursive:</p>
   * <pre>
   * Ext.Object.toQueryString({foo: 1, bar: 2}); // returns "foo=1&amp;bar=2"
   * Ext.Object.toQueryString({foo: null, bar: 2}); // returns "foo=&amp;bar=2"
   * Ext.Object.toQueryString({'some price': '$300'}); // returns "some%20price=%24300"
   * Ext.Object.toQueryString({date: new Date(2011, 0, 1)}); // returns "date=%222011-01-01T00%3A00%3A00%22"
   * Ext.Object.toQueryString({colors: ['red', 'green', 'blue']}); // returns "colors=red&amp;colors=green&amp;colors=blue"
   * </pre>
   * <p>Recursive:</p>
   * <pre>
   * Ext.Object.toQueryString({
   *     username: 'Jacky',
   *     dateOfBirth: {
   *         day: 1,
   *         month: 2,
   *         year: 1911
   *     },
   *     hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]
   * }, true); // returns the following string (broken down and url-decoded for ease of reading purpose):
   * // username=Jacky
   * //    &amp;dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911
   * //    &amp;hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;hobbies[3][0]=nested&amp;hobbies[3][1]=stuff
   * </pre>
   * @param object The object to encode
   * @param recursive Whether or not to interpret the object in recursive format.
   * (PHP / Ruby on Rails servers and similar).
   * @default false
   * @return queryString
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-urlEncode Original Ext JS documentation of 'urlEncode'
   */
  public native function urlEncode(object:Object, recursive:Boolean = false):String;

  /**
   * Returns the given value itself if it's not empty, as described in →<code>ext.Ext.isEmpty()</code>;
   * returns the default value (second argument) otherwise.
   * @param value The value to test.
   * @param defaultValue The value to return if the original value is empty.
   * @param allowBlank <code>true</code> to allow zero length strings to qualify
   * as non-empty.
   * @default false
   * @return value, if non-empty, else defaultValue.
   * @see ext.SExt#isEmpty() ext.Ext.isEmpty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-valueFrom Original Ext JS documentation of 'valueFrom'
   */
  public native function valueFrom(value:Object, defaultValue:Object, allowBlank:Boolean = false):Object;

  /**
   * Convenient shorthand to create a widget by its xtype or a config object.
   * <pre>
   *  var button = Ext.widget('button'); // Equivalent to Ext.create('widget.button');
   *
   *  var panel = Ext.widget('panel', { // Equivalent to Ext.create('widget.panel')
   *      title: 'Panel'
   *  });
   *
   *  var grid = Ext.widget({
   *      xtype: 'grid',
   *      ...
   *  });
   * </pre>
   * <p>If a <i>component</i> (→<code>ext.Component</code>) instance is passed, it is simply returned.</p>
   * @param name The xtype of the widget to create.
   * @param config The configuration object for the widget constructor.
   * @return The widget instance
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.html#method-widget Original Ext JS documentation of 'widget'
   */
  public native function widget(name:String = null, config:Object = null):Object;
}
}
