package ext {

[Native]
/**
 * Modified version of <a href="http://www.json.org/js.html">Douglas Crockford's JSON.js</a> that doesn't
 * mess with the Object prototype.
 * <p>Type of singleton JSON.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html Original Ext JS documentation of 'Ext.JSON'
 * @see ext.#JSON ext.JSON
 */
public class SJSON extends Object {
  /**
   * Decodes (parses) a JSON string to an object. If the JSON is invalid, this function throws
   * a SyntaxError unless the safe option is set.
   * @param json The JSON string.
   * @param safe <code>true</code> to return null, otherwise throw an exception
   * if the JSON is invalid.
   * @default false
   * @return The resulting object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html#method-decode Original Ext JS documentation of 'decode'
   */
  public native function decode(json:String, safe:Boolean = false):Object;

  /**
   * Encodes an Object, Array or other value.
   * <p>If the environment's native JSON encoding is not being used (→<code>ext.Ext.USE_NATIVE_JSON</code>
   * is not set, or the environment does not support it), then ExtJS's encoding will be used.
   * This allows the developer to add a <code>toJSON</code> method to their classes which need serializing
   * to return a valid JSON representation of the object.</p>
   * @param o The variable to encode.
   * @return The JSON string.
   * @see ext.SExt#USE_NATIVE_JSON ext.Ext.USE_NATIVE_JSON
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html#method-encode Original Ext JS documentation of 'encode'
   */
  public native function encode(o:Object):String;

  /**
   * Encodes a Date. This returns the actual string which is inserted into the JSON string
   * as the literal expression. <b>The returned value includes enclosing double quotation marks.</b>
   * <p>The default return format is <code>"yyyy-mm-ddThh:mm:ss"</code>.</p>
   * <p>To override this:</p>
   * <pre>
   * Ext.JSON.encodeDate = function(d) {
   *     return Ext.Date.format(d, '"Y-m-d"');
   * };
   * </pre>
   * @param o The Date to encode
   * @return The string literal to use in a JSON string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html#method-encodeDate Original Ext JS documentation of 'encodeDate'
   */
  public native function encodeDate(o:Date):String;

  /**
   * Encodes a String. This returns the actual string which is inserted into the JSON string
   * as the literal expression. <b>The returned value includes enclosing double quotation marks.</b>
   * <p>To override this:</p>
   * <pre>
   * Ext.JSON.encodeString = function(s) {
   *     return 'Foo' + s;
   * };
   * </pre>
   * @param s The String to encode
   * @return The string literal to use in a JSON string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html#method-encodeString Original Ext JS documentation of 'encodeString'
   */
  public native function encodeString(s:String):String;

  /**
   * The function which →<code>encode()</code> uses to encode all javascript values to their JSON
   * representations when →<code>ext.Ext.USE_NATIVE_JSON</code> is <code>false</code>.
   * <p>This is made public so that it can be replaced with a custom implementation.</p>
   * @param o Any javascript value to be converted to its JSON representation
   * @return The JSON representation of the passed value.
   * @see SJSON#encode()
   * @see ext.SExt#USE_NATIVE_JSON ext.Ext.USE_NATIVE_JSON
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.JSON.html#method-encodeValue Original Ext JS documentation of 'encodeValue'
   */
  public native function encodeValue(o:Object):String;
}
}