package ext {

[Native]
/**
 * This class provides dynamic loading support for JavaScript classes. Application code
 * does not typically need to call <code>→ext.Loader</code> except perhaps to configure path mappings
 * when not using <a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a>.
 * <pre>
 *  Ext.Loader.setPath('MyApp', 'app');
 * </pre>
 * <p>When using Sencha Cmd, this is handled by the "bootstrap" provided by the application
 * build script and such configuration is not necessary.</p>
 * <p><b>Typical Usage</b></p>
 * <p>The <code>→ext.Loader</code> is most often used behind the scenes to satisfy class references in
 * class declarations. Like so:</p>
 * <pre>
 *  Ext.define('MyApp.view.Main', {
 *      extend: 'Ext.panel.Panel',
 *
 *      mixins: [
 *          'MyApp.util.Mixin'
 *      ],
 *
 *      requires: [
 *          'Ext.grid.Panel'
 *      ],
 *
 *      uses: [
 *          'MyApp.util.Stuff'
 *      ]
 *  });
 * </pre>
 * <p>In all of these cases, <code>→ext.Loader</code> is used internally to resolve these class names
 * and ensure that the necessary class files are loaded.</p>
 * <p>During development, these files are loaded individually for optimal debugging. For a
 * production use, <a href="http://www.sencha.com/products/sencha-cmd/">Sencha Cmd</a> will replace
 * all of these strings with the actual resolved class references because it ensures that
 * the classes are all contained in the build in the correct order. In development, these
 * files will not be loaded until the <code>MyApp.view.Main</code> class indicates they are needed
 * as shown above.</p>
 * <p><b>Loading Classes</b></p>
 * <p>You can also use <code>→ext.Loader</code> directly to load classes or files. The simplest form of
 * use is <code>→ext.Ext.require()</code>.</p>
 * <p>For example:</p>
 * <pre>
 *  Ext.require('MyApp.view.Main', function () {
 *      // On callback, the MyApp.view.Main class is now loaded
 *
 *      var view = new MyApp.view.Main();
 *  });
 * </pre>
 * <p>You can alternatively require classes by alias or wildcard.</p>
 * <pre>
 * Ext.require('widget.window');
 *
 * Ext.require(['widget.window', 'layout.border', 'Ext.data.Connection']);
 *
 * Ext.require(['widget.&#42;', 'layout.&#42;', 'Ext.data.&#42;']);
 * </pre>
 * <p>The callback function is optional.</p>
 * <p><b>Note</b> Using <code>Ext.require</code> at global scope will cause <code>→ext.Ext.onReady()</code> and
 * <code>→ext.app.Application.launch()</code> methods to be deferred until the required classes
 * are loaded. It is these cases where the callback function is most often unnecessary.</p>
 * <p><b><i>Using Excludes</i></b></p>
 * <p>Alternatively, you can exclude what you don't need:</p>
 * <pre>
 * // Include everything except Ext.tree.&#42;
 * Ext.exclude('Ext.tree.&#42;').require('&#42;');
 *
 * // Include all widgets except widget.checkbox&#42; (this will exclude
 * // widget.checkbox, widget.checkboxfield, widget.checkboxgroup, etc.)
 * Ext.exclude('widget.checkbox&#42;').require('widget.&#42;');
 * </pre>
 * <p><b>Dynamic Instantiation</b></p>
 * <p>Another feature enabled by <code>→ext.Loader</code> is instantiation using class names or aliases.</p>
 * <p>For example:</p>
 * <pre>
 *  var win = Ext.create({
 *      xtype: 'window',
 *
 *      // or
 *      // xclass: 'Ext.window.Window'
 *
 *      title: 'Hello'
 *  });
 * </pre>
 * <p>This form of creation can be useful if the type to create (<code>window</code> in the above) is
 * not known statically. Internally, <code>→ext.Ext.create()</code> may need to <i>synchronously</i>
 * load the desired class and its requirements. Doing this will generate a warning in
 * the console:</p>
 * <pre>
 *  [Ext.Loader] Synchronously loading 'Ext.window.Window'...
 * </pre>
 * <p>If you see these in your debug console, you should add the indicated class(es) to the
 * appropriate <code>requires</code> array (as above) or make an <code>→ext.Ext.require()</code> call.</p>
 * <p><b>Note</b> Using <code>→ext.Ext.create()</code> has some performance overhead and is best reserved
 * for cases where the target class is not known until run-time.</p>
 * <p>Type of singleton Loader.</p>
 * @see ext.#Loader ext.Loader
 * @see ext.SExt#require() ext.Ext.require()
 * @see ext.SExt#onReady() ext.Ext.onReady()
 * @see ext.app.Application#launch()
 * @see ext.SExt#create() ext.Ext.create()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html Original Ext JS documentation of 'Ext.Loader'
 */
public class SLoader extends Object {
  [ExtConfig]
  /**
   * Appends current timestamp to script files to prevent caching.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-disableCaching Original Ext JS documentation of 'disableCaching'
   */
  public native function get disableCaching():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableCaching(value:Boolean):void;

  [ExtConfig]
  /**
   * The get parameter name for the cache buster's timestamp.
   * @default "_dc"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-disableCachingParam Original Ext JS documentation of 'disableCachingParam'
   */
  public native function get disableCachingParam():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableCachingParam(value:String):void;

  [ExtConfig]
  /**
   * Whether or not to enable the dynamic dependency loading feature.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-enabled Original Ext JS documentation of 'enabled'
   */
  public native function get enabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enabled(value:Boolean):void;

  /**
   * An array of class names to keep track of the dependency loading order.
   * This is not guaranteed to be the same everytime due to the asynchronous
   * nature of the Loader.
   * @default history
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#property-history Original Ext JS documentation of 'history'
   */
  public native function get history():Array;

  /**
   * @private
   */
  public native function set history(value:Array):void;

  [ExtConfig]
  /**
   * The mapping from namespaces to file paths...
   * <pre>
   * {
   *     'Ext': '.', // This is set by default, Ext.layout.container.Container will be
   *                 // loaded from ./layout/Container.js
   *
   *     'My': './src/my_own_folder' // My.layout.Container will be loaded from
   *                                 // ./src/my_own_folder/layout/Container.js
   * }
   * </pre>
   * <p>Note that all relative paths are relative to the current HTML document.
   * If not being specified, for example, <code>Other.awesome.Class</code> will simply be
   * loaded from <code>"./Other/awesome/Class.js"</code>.</p>
   * @default Manager.paths
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-paths Original Ext JS documentation of 'paths'
   */
  public native function get paths():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set paths(value:Object):void;

  [ExtConfig]
  /**
   * <code>false</code> to remove asynchronously loaded scripts, <code>true</code> to retain script
   * element for browser debugger compatibility and improved load performance.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-preserveScripts Original Ext JS documentation of 'preserveScripts'
   */
  public native function get preserveScripts():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preserveScripts(value:Boolean):void;

  [ExtConfig]
  /**
   * millisecond delay between asynchronous script injection (prevents stack
   * overflow on some user agents) 'false' disables delay but potentially
   * increases stack load.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-scriptChainDelay Original Ext JS documentation of 'scriptChainDelay'
   */
  public native function get scriptChainDelay():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scriptChainDelay(value:Boolean):void;

  [ExtConfig]
  /**
   * Optional charset to specify encoding of dynamic script content.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#cfg-scriptCharset Original Ext JS documentation of 'scriptCharset'
   */
  public native function get scriptCharset():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scriptCharset(value:String):void;

  /**
   * fixes up loader path configs by prepending Ext.Boot#baseUrl to the beginning
   * of the path, then delegates to Ext.Loader#addClassPathMappings
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-addBaseUrlClassPathMappings Original Ext JS documentation of 'addBaseUrlClassPathMappings'
   */
  public native function addBaseUrlClassPathMappings(pathConfig:*):void;

  /**
   * Sets a batch of path entries
   * @param paths a set of className: path mappings
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-addClassPathMappings Original Ext JS documentation of 'addClassPathMappings'
   */
  public native function addClassPathMappings(paths:Object):SLoader;

  /**
   * Get the config value corresponding to the specified name. If no name is given,
   * will return the config object
   * @param name The config property name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-getConfig Original Ext JS documentation of 'getConfig'
   */
  public native function getConfig(name:String):Object;

  /**
   * Translates a className to a file path by adding the
   * the proper prefix and converting the .'s to /'s. For example:
   * <pre>
   * Ext.Loader.setPath('My', '/path/to/My');
   *
   * // alerts '/path/to/My/awesome/Class.js'
   * alert(Ext.Loader.getPath('My.awesome.Class'));
   * </pre>
   * <p>Note that the deeper namespace levels, if explicitly set, are always resolved first.
   * For example:</p>
   * <pre>
   * Ext.Loader.setPath({
   *     'My': '/path/to/lib',
   *     'My.awesome': '/other/path/for/awesome/stuff',
   *     'My.awesome.more': '/more/awesome/path'
   * });
   *
   * // alerts '/other/path/for/awesome/stuff/Class.js'
   * alert(Ext.Loader.getPath('My.awesome.Class'));
   *
   * // alerts '/more/awesome/path/Class.js'
   * alert(Ext.Loader.getPath('My.awesome.more.Class'));
   *
   * // alerts '/path/to/lib/cool/Class.js'
   * alert(Ext.Loader.getPath('My.cool.Class'));
   *
   * // alerts 'Unknown/strange/Stuff.js'
   * alert(Ext.Loader.getPath('Unknown.strange.Stuff'));
   * </pre>
   * @return path
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-getPath Original Ext JS documentation of 'getPath'
   */
  public native function getPath(className:String):String;

  /**
   * Loads the specified script URL and calls the supplied callbacks. If this method
   * is called before →<code>ext.Ext.isReady</code>, the script's load will delay the transition
   * to ready. This can be used to load arbitrary scripts that may contain further
   * →<code>ext.Ext.require()</code> calls.
   * @param options The options object or simply the URL(s) to load.
   * <ul>
   * <li><code>url:String</code> (optional) —
   * The URL from which to load the script.
   * </li>
   * <li><code>onLoad:Function</code> (optional) —
   * The callback to call on successful load.
   * </li>
   * <li><code>onError:Function</code> (optional) —
   * The callback to call on failure to load.
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code>) for the supplied callbacks.
   * </li>
   * </ul>
   * @see ext.SExt#isReady ext.Ext.isReady
   * @see ext.SExt#require() ext.Ext.require()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-loadScript Original Ext JS documentation of 'loadScript'
   */
  public native function loadScript(options:*):void;

  /**
   * Add a new listener to be executed when all required scripts are fully loaded
   * @param fn The function callback to be executed
   * @param scope The execution scope (<code>this</code>) of the callback function.
   * @param withDomReady Pass <code>false</code> to not also wait for document
   * dom ready.
   * @default true
   * @param options Additional callback options.
   * <ul>
   * <li><code>delay:Number</code> (default = <code>0</code>) —
   * A number of milliseconds to delay.
   * </li>
   * <li><code>priority:Number</code> (default = <code>0</code>) —
   * Relative priority of this callback. Negative
   * numbers are reserved.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-onReady Original Ext JS documentation of 'onReady'
   */
  public native function onReady(fn:Function, scope:Object, withDomReady:Boolean = true, options:Object = null):void;

  /**
   * Set the configuration for the loader. This should be called right after ext-(debug).js
   * is included in the page, and before Ext.onReady. i.e:
   * <pre>
   * &lt;script type="text/javascript" src="ext-core-debug.js"&gt;&lt;/script&gt;
   * &lt;script type="text/javascript"&gt;
   *     Ext.Loader.setConfig({
   *       enabled: true,
   *       paths: {
   *           'My': 'my_own_path'
   *       }
   *     });
   * &lt;/script&gt;
   * &lt;script type="text/javascript"&gt;
   *     Ext.require(...);
   *
   *     Ext.onReady(function() {
   *       // application code here
   *     });
   * &lt;/script&gt;
   * </pre>
   * <p>Refer to config options of →<code>ext.Loader</code> for the list of possible properties</p>
   * @param config The config object to override the default values
   * @return this
   * @see ext.#Loader ext.Loader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-setConfig Original Ext JS documentation of 'setConfig'
   */
  public native function setConfig(config:Object):SLoader;

  /**
   * Sets the path of a namespace.
   * For Example:
   * <pre>
   * Ext.Loader.setPath('Ext', '.');
   * </pre>
   * @param name See →<code>ext.FunctionUtil.flexSetter()</code>
   * @param path See →<code>ext.FunctionUtil.flexSetter()</code>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Loader.html#method-setPath Original Ext JS documentation of 'setPath'
   * @see ext.SFunctionUtil#flexSetter() ext.FunctionUtil.flexSetter()
   */
  public native function setPath(name:*, path:String = null):SLoader;
}
}