package ext {

[Native]
/**
 * A collection of useful static methods to deal with numbers
 * <p>Type of singleton NumberUtil.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html Original Ext JS documentation of 'Ext.Number'
 * @see ext.#NumberUtil ext.NumberUtil
 */
public class SNumberUtil extends Object {
  /**
   * Determines if the value passed is a number and also finite.
   * This a Polyfill version of Number.isFinite(),differently than
   * the isFinite() function, this method doesn't convert the parameter to a number.
   * @default Number.isFinite || function(value) {
   *     return typeof value === 'number' && isFinite(value);
   * }
   * @since 6.2
   * <ul>
   * <li><code>value:Number</code> —
   * Number to be tested.
   * </li>
   * <li><code>null:Boolean</code> —
   * <code>true</code>, if the parameter is a number and finite, <code>false</code> otherwise.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#property-isFinite Original Ext JS documentation of 'isFinite'
   */
  public native function get isFinite():*;

  /**
   * @private
   */
  public native function set isFinite(value:*):void;

  [ArrayElementType("Number")]
  /**
   * Coerces a given index into a valid index given a <code>length</code>.
   * <p>Negative indexes are interpreted starting at the end of the collection. That is,
   * a value of -1 indicates the last item, or equivalent to <code>length - 1</code>.</p>
   * <p>When handling methods that take "begin" and "end" arguments like most array or
   * string methods, this method can be used like so:</p>
   * <pre>
   *  function foo (array, begin, end) {
   *      var range = Ext.Number.clipIndices(array.length, [begin, end]);
   *
   *      begin = range[0];
   *      end   = range[1];
   *
   *      // 0 &lt;= begin &lt;= end &lt;= array.length
   *
   *      var length = end - begin;
   *  }
   * </pre>
   * <p>For example:</p>
   * <pre>
   *  +---+---+---+---+---+---+---+---+
   *  |   |   |   |   |   |   |   |   |  length = 8
   *  +---+---+---+---+---+---+---+---+
   *    0   1   2   3   4   5   6   7
   *   -8  -7  -6  -5  -4  -3  -2  -1
   *
   *  console.log(Ext.Number.clipIndices(8, [3, 10]); // logs "[3, 8]"
   *  console.log(Ext.Number.clipIndices(8, [-5]);    // logs "[3, 8]"
   *  console.log(Ext.Number.clipIndices(8, []);
   *  console.log(Ext.Number.clipIndices(8, []);
   * </pre>
   * @param length
   * @param indices
   * @param options An object with different option flags.
   * <ul>
   * <li><code>count:Boolean</code> (default = <code>false</code>) —
   * The second number in <code>indices</code> is the
   * count not and an index.
   * </li>
   * <li><code>inclusive:Boolean</code> (default = <code>false</code>) —
   * The second number in <code>indices</code> is
   * "inclusive" meaning that the item should be considered in the range. Normally,
   * the second number is considered the first item outside the range or as an
   * "exclusive" bound.
   * </li>
   * <li><code>wrap:Boolean</code> (default = <code>true</code>) —
   * Wraps negative numbers backwards from the
   * end of the array. Passing <code>false</code> simply clips negative index values at 0.
   * </li>
   * </ul>
   * @return The normalized <code>[begin, end]</code> array where <code>end</code> is now
   * exclusive such that <code>length = end - begin</code>. Both values are between 0 and the
   * given <code>length</code> and <code>end</code> will not be less-than <code>begin</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-clipIndices Original Ext JS documentation of 'clipIndices'
   */
  public native function clipIndices(length:Number, indices:Array, options:Object = null):Array;

  /**
   * Checks whether or not the passed number is within a desired range. If the number is
   * already within the range it is returned, otherwise the min or max value is returned
   * depending on which side of the range is exceeded. Note that this method returns the
   * constrained value but does not change the current number.
   * @param number The number to check
   * @param min The minimum number in the range
   * @param max The maximum number in the range
   * @return The constrained value if outside the range, otherwise the current value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-constrain Original Ext JS documentation of 'constrain'
   */
  public native function constrain(number:Number, min:Number, max:Number):Number;

  /**
   * Corrects floating point numbers that overflow to a non-precise
   * value because of their floating nature, for example <code>0.1 + 0.2</code>
   * @param n The number
   * @return The correctly rounded number
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-correctFloat Original Ext JS documentation of 'correctFloat'
   */
  public native function correctFloat(n:Number):Number;

  /**
   * Validate that a value is numeric and convert it to a number if necessary.
   * Returns the specified default value if it is not.
   * <pre>
   *  Ext.Number.from('1.23', 1); // returns 1.23
   *  Ext.Number.from('abc', 1); // returns 1
   * </pre>
   * @param value
   * @param defaultValue The value to return if the original value is non-numeric
   * @return value, if numeric, defaultValue otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-from Original Ext JS documentation of 'from'
   */
  public native function from(value:Object, defaultValue:Number):Number;

  /**
   * Determines if two numbers <code>n1</code> and <code>n2</code> are equal within a given
   * margin of precision <code>epsilon</code>.
   * @param n1 First number.
   * @param n2 Second number.
   * @param epsilon Margin of precision.
   * @return <code>true</code>, if numbers are equal. <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-isEqual Original Ext JS documentation of 'isEqual'
   */
  public native function isEqual(n1:Number, n2:Number, epsilon:Number):Boolean;

  /**
   * Returns the base 10 logarithm of a number.
   * This will use Math.log10, if available (ES6).
   * @param x The number.
   * @return Base 10 logarithm of the number 'x'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-log10 Original Ext JS documentation of 'log10'
   */
  public native function log10(x:Number):Number;

  /**
   * Strictly parses the given value and returns the value as a number or <code>null</code> if
   * the value is not a number or contains non-numeric pieces.
   * @since 6.5.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-parseFloat Original Ext JS documentation of 'parseFloat'
   */
  public native function parseFloat(value:String):Number;

  /**
   * Strictly parses the given value and returns the value as a number or <code>null</code> if
   * the value is not an integer number or contains non-integer pieces.
   * @since 6.5.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-parseInt Original Ext JS documentation of 'parseInt'
   */
  public native function parseInt(value:String):Number;

  /**
   * Returns a random integer between the specified range (inclusive)
   * @param from Lowest value to return.
   * @param to Highest value to return.
   * @return A random integer within the specified range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-randomInt Original Ext JS documentation of 'randomInt'
   */
  public native function randomInt(from:Number, to:Number):Number;

  /**
   * Round a number to the nearest interval.
   * @since 6.2.0
   * @param value The value to round.
   * @param interval The interval to round to.
   * @return The rounded value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-roundToNearest Original Ext JS documentation of 'roundToNearest'
   */
  public native function roundToNearest(value:Number, interval:Number):Number;

  /**
   * Rounds a number to the specified precision.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-roundToPrecision Original Ext JS documentation of 'roundToPrecision'
   */
  public native function roundToPrecision(value:*, precision:*):Number;

  /**
   * Returns the sign of the given number. See also MDN for Math.sign documentation
   * for the standard method this method emulates.
   * @param x The number.
   * @return The sign of the number <code>x</code>, indicating whether the number is
   * positive (1), negative (-1) or zero (0).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-sign Original Ext JS documentation of 'sign'
   */
  public native function sign(x:Number):Number;

  /**
   * Snaps the passed number between stopping points based upon a passed increment value.
   * <p>The difference between this and →<code>snapInRange()</code> is that →<code>snapInRange()</code> uses
   * the minValue when calculating snap points:</p>
   * <pre>
   * // Returns 56 - snap points are zero based
   * r = Ext.Number.snap(56, 2, 55, 65);
   *
   * // Returns 57 - snap points are based from minValue
   * r = Ext.Number.snapInRange(56, 2, 55, 65);
   * </pre>
   * @param value The unsnapped value.
   * @param increment The increment by which the value must move.
   * @param minValue The minimum value to which the returned value must be
   * constrained. Overrides the increment.
   * @param maxValue The maximum value to which the returned value must be
   * constrained. Overrides the increment.
   * @return The value of the nearest snap target.
   * @see SNumberUtil#snapInRange()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-snap Original Ext JS documentation of 'snap'
   */
  public native function snap(value:Number, increment:Number, minValue:Number, maxValue:Number):Number;

  /**
   * Snaps the passed number between stopping points based upon a passed increment value.
   * <p>The difference between this and →<code>snap()</code> is that →<code>snap()</code> does not use
   * the minValue when calculating snap points:</p>
   * <pre>
   * // Returns 56 - snap points are zero based
   * r = Ext.Number.snap(56, 2, 55, 65);
   *
   * // Returns 57 - snap points are based from minValue
   * r = Ext.Number.snapInRange(56, 2, 55, 65);
   * </pre>
   * @param value The unsnapped value.
   * @param increment The increment by which the value must move.
   * @param minValue The minimum value to which the returned value must be
   * constrained.
   * @default 0
   * @param maxValue The maximum value to which the returned value
   * must be constrained.
   * @default Infinity
   * @return The value of the nearest snap target.
   * @see SNumberUtil#snap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-snapInRange Original Ext JS documentation of 'snapInRange'
   */
  public native function snapInRange(value:Number, increment:Number, minValue:Number = 0, maxValue:Number = Infinity):Number;

  /**
   * Formats a number using fixed-point notation
   * @param value The number to format
   * @param precision The number of digits to show after the decimal point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-toFixed Original Ext JS documentation of 'toFixed'
   */
  public native function toFixed(value:Number, precision:Number):void;

  /**
   * Truncates a number to the specified precision,
   * without rounding.
   * @since 6.5.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Number.html#method-truncateToPrecision Original Ext JS documentation of 'truncateToPrecision'
   */
  public native function truncateToPrecision(value:*, precision:*):Number;
}
}