package ext {

[Native]
/**
 * A collection of useful static methods to deal with objects.
 * <p>Type of singleton ObjectUtil.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html Original Ext JS documentation of 'Ext.Object'
 * @see ext.#ObjectUtil ext.ObjectUtil
 */
public class SObjectUtil extends Object {
  /**
   * Returns a new object with the given object as the prototype chain. This method is
   * designed to mimic the ECMA standard <code>Object.create</code> method and is assigned to that
   * function when it is available.
   * <p><b>NOTE</b> This method does not support the property definitions capability of the
   * <code>Object.create</code> method. Only the first argument is supported.</p>
   * @param object The prototype chain for the new object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-chain Original Ext JS documentation of 'chain'
   */
  public native function chain(object:Object):void;

  /**
   * This method removes all keys from the given object.
   * @param object The object from which to remove all keys.
   * @return The given object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(object:Object):Object;

  /**
   * Iterates through an object and invokes the given callback function for each iteration.
   * The iteration can be stopped by returning <code>false</code> in the callback function. For example:
   * <pre>
   * var person = {
   *     name: 'Jacky'
   *     hairColor: 'black'
   *     loves: ['food', 'sleeping', 'wife']
   * };
   *
   * Ext.Object.each(person, function(key, value, myself) {
   *     console.log(key + ":" + value);
   *
   *     if (key === 'hairColor') {
   *         return false; // stop the iteration
   *     }
   * });
   * </pre>
   * @param object The object to iterate
   * @param fn The callback function.
   * <ul>
   * <li><code>key:String</code> (optional)</li>
   * <li><code>value:Object</code> (optional)</li>
   * <li><code>object:Object</code> (optional) —
   * The object itself
   * </li>
   * </ul>
   * @param scope The execution scope (<code>this</code>) of the callback function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(object:Object, fn:Function, scope:Object = null):void;

  /**
   * Iterates through an object and invokes the given callback function for each iteration.
   * The iteration can be stopped by returning <code>false</code> in the callback function. For example:
   * <pre>
   * var items = {
   *     1: 'Hello',
   *     2: 'World'
   * };
   *
   * Ext.Object.eachValue(items, function(value) {
   *     console.log("Value: " + value);
   * });
   * </pre>
   * <p>This will log 'Hello' and 'World' in no particular order. This method is useful
   * in cases where the keys are not important to the processing, just the values.</p>
   * @param object The object to iterate
   * @param fn The callback function.
   * <ul>
   * <li><code>value:Object</code> (optional) —
   * The value of
   * </li>
   * </ul>
   * @param scope The execution scope (<code>this</code>) of the callback function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-eachValue Original Ext JS documentation of 'eachValue'
   */
  public native function eachValue(object:Object, fn:Function, scope:Object = null):void;

  /**
   * Shallow compares the contents of 2 objects using strict equality. Objects are
   * considered equal if they both have the same set of properties and the
   * value for those properties equals the other in the corresponding object.
   * <pre>
   * // Returns true
   * Ext.Object.equals({
   *     foo: 1,
   *     bar: 2
   * }, {
   *     foo: 1,
   *     bar: 2
   * });
   * </pre>
   * @return <code>true</code> if the objects are equal.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-equals Original Ext JS documentation of 'equals'
   */
  public native function equals(object1:Object, object2:Object):Boolean;

  /**
   * Freezes the given object making it immutable. This operation is by default shallow
   * and does not effect objects referenced by the given object.
   * @param obj The object to freeze.
   * @param deep Pass <code>true</code> to freeze sub-objects recursively.
   * @default false
   * @return The given object <code>obj</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-freeze Original Ext JS documentation of 'freeze'
   */
  public native function freeze(obj:Object, deep:Boolean = false):Object;

  /**
   * Converts a query string back into an object.
   * <p>Non-recursive:</p>
   * <pre>
   * Ext.Object.fromQueryString("foo=1&amp;bar=2"); // returns {foo: '1', bar: '2'}
   * Ext.Object.fromQueryString("foo=&amp;bar=2"); // returns {foo: '', bar: '2'}
   * Ext.Object.fromQueryString("some%20price=%24300"); // returns {'some price': '$300'}
   * Ext.Object.fromQueryString("colors=red&amp;colors=green&amp;colors=blue"); // returns {colors: ['red', 'green', 'blue']}
   * </pre>
   * <p>Recursive:</p>
   * <pre>
   * Ext.Object.fromQueryString(
   *     "username=Jacky&amp;"+
   *     "dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911&amp;"+
   *     "hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;"+
   *     "hobbies[3][0]=nested&amp;hobbies[3][1]=stuff", true);
   *
   * // returns
   * {
   *     username: 'Jacky',
   *     dateOfBirth: {
   *         day: '1',
   *         month: '2',
   *         year: '1911'
   *     },
   *     hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]
   * }
   * </pre>
   * @param queryString The query string to decode
   * @param recursive Whether or not to recursively decode the string. This format is supported by
   * PHP / Ruby on Rails servers and similar.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-fromQueryString Original Ext JS documentation of 'fromQueryString'
   */
  public native function fromQueryString(queryString:String, recursive:Boolean = false):Object;

  [ArrayElementType("String")]
  /**
   * Returns all keys of the given object as an array.
   * @return An array of keys from the object or any of its prototypes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-getAllKeys Original Ext JS documentation of 'getAllKeys'
   */
  public native function getAllKeys(object:Object):Array;

  /**
   * Returns the first matching key corresponding to the given value.
   * If no matching value is found, null is returned.
   * <pre>
   * var person = {
   *     name: 'Jacky',
   *     loves: 'food'
   * };
   *
   * alert(Ext.Object.getKey(person, 'food')); // alerts 'loves'
   * </pre>
   * @param object
   * @param value The value to find
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-getKey Original Ext JS documentation of 'getKey'
   */
  public native function getKey(object:Object, value:Object):String;

  [ArrayElementType("String")]
  /**
   * Returns the <code>→hasOwnProperty()</code> keys of the given object as an array.
   * <pre>
   * var values = Ext.Object.getKeys({
   *     name: 'Jacky',
   *     loves: 'food'
   * }); // ['name', 'loves']
   * </pre>
   * @return An array of keys from the object
   * @see SObjectUtil#hasOwnProperty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-getKeys Original Ext JS documentation of 'getKeys'
   */
  public native function getKeys(object:Object):Array;

  /**
   * Gets the total number of this object's own properties...
   * <pre>
   * var size = Ext.Object.getSize({
   *     name: 'Jacky',
   *     loves: 'food'
   * }); // size equals 2
   * </pre>
   * @return size
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-getSize Original Ext JS documentation of 'getSize'
   */
  public native function getSize(object:Object):Number;

  /**
   * Gets all values of the given object as an array.
   * <pre>
   * var values = Ext.Object.getValues({
   *     name: 'Jacky',
   *     loves: 'food'
   * }); // ['Jacky', 'food']
   * </pre>
   * @return An array of values from the object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues(object:Object):Array;

  /**
   * Checks if there are any properties on this object.
   * @return <code>true</code> if there no properties on the object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-isEmpty Original Ext JS documentation of 'isEmpty'
   */
  public native function isEmpty(object:Object):Boolean;

  /**
   * Merges any number of objects recursively without referencing them or their children.
   * Note: It will reference arrays if they are only present in one of the objects being merged.
   * <pre>
   * var extjs = {
   *     companyName: 'Ext JS',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer'],
   *     isSuperCool: true,
   *     office: {
   *         size: 2000,
   *         location: 'Palo Alto',
   *         isFun: true
   *     }
   * };
   *
   * var newStuff = {
   *     companyName: 'Sencha Inc.',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],
   *     office: {
   *         size: 40000,
   *         location: 'Redwood City'
   *     }
   * };
   *
   * var sencha = Ext.Object.merge(extjs, newStuff);
   *
   * // extjs and sencha then equals to
   * {
   *     companyName: 'Sencha Inc.',
   *     products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],
   *     isSuperCool: true,
   *     office: {
   *         size: 40000,
   *         location: 'Redwood City',
   *         isFun: true
   *     }
   * }
   * </pre>
   * @param destination The object into which all subsequent objects are merged.
   * @param object Any number of objects to merge into the destination.
   * @return merged The destination object with all passed objects merged in.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-merge Original Ext JS documentation of 'merge'
   */
  public native function merge(destination:Object, ...object):Object;

  /**
   * Converts a <code>name</code> - <code>value</code> pair to an array of objects with support for nested structures.
   * Useful to construct query strings. For example:
   * <pre>
   * var objects = Ext.Object.toQueryObjects('hobbies', ['reading', 'cooking', 'swimming']);
   *
   * // objects then equals:
   * [
   *     { name: 'hobbies', value: 'reading' },
   *     { name: 'hobbies', value: 'cooking' },
   *     { name: 'hobbies', value: 'swimming' },
   * ];
   *
   * var objects = Ext.Object.toQueryObjects('dateOfBirth', {
   *     day: 3,
   *     month: 8,
   *     year: 1987,
   *     extra: {
   *         hour: 4
   *         minute: 30
   *     }
   * }, true); // Recursive
   *
   * // objects then equals:
   * [
   *     { name: 'dateOfBirth[day]', value: 3 },
   *     { name: 'dateOfBirth[month]', value: 8 },
   *     { name: 'dateOfBirth[year]', value: 1987 },
   *     { name: 'dateOfBirth[extra][hour]', value: 4 },
   *     { name: 'dateOfBirth[extra][minute]', value: 30 },
   * ];
   * </pre>
   * @param name
   * @param value
   * @param recursive True to traverse object recursively
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-toQueryObjects Original Ext JS documentation of 'toQueryObjects'
   */
  public native function toQueryObjects(name:String, value:*, recursive:Boolean = false):Array;

  /**
   * Takes an object and converts it to an encoded query string.
   * <p>Non-recursive:</p>
   * <pre>
   * Ext.Object.toQueryString({foo: 1, bar: 2}); // returns "foo=1&amp;bar=2"
   * Ext.Object.toQueryString({foo: null, bar: 2}); // returns "foo=&amp;bar=2"
   * Ext.Object.toQueryString({'some price': '$300'}); // returns "some%20price=%24300"
   * Ext.Object.toQueryString({date: new Date(2011, 0, 1)}); // returns "date=%222011-01-01T00%3A00%3A00%22"
   * Ext.Object.toQueryString({colors: ['red', 'green', 'blue']}); // returns "colors=red&amp;colors=green&amp;colors=blue"
   * </pre>
   * <p>Recursive:</p>
   * <pre>
   * Ext.Object.toQueryString({
   *     username: 'Jacky',
   *     dateOfBirth: {
   *         day: 1,
   *         month: 2,
   *         year: 1911
   *     },
   *     hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]
   * }, true); // returns the following string (broken down and url-decoded for ease of reading purpose):
   * // username=Jacky
   * //    &amp;dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911
   * //    &amp;hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;hobbies[3][0]=nested&amp;hobbies[3][1]=stuff
   * </pre>
   * @param object The object to encode
   * @param recursive Whether or not to interpret the object in recursive format.
   * (PHP / Ruby on Rails servers and similar).
   * @default false
   * @return queryString
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Object.html#method-toQueryString Original Ext JS documentation of 'toQueryString'
   */
  public native function toQueryString(object:Object, recursive:Boolean = false):String;
}
}