package ext {

[Native]
/**
 * A collection of useful static methods to deal with strings.
 * <p>Type of singleton StringUtil.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html Original Ext JS documentation of 'Ext.String'
 * @see ext.#StringUtil ext.StringUtil
 */
public class SStringUtil extends Object {
  /**
   * Adds a set of character entity definitions to the set used by
   * →<code>ext.StringUtil.htmlEncode()</code> and →<code>ext.StringUtil.htmlDecode()</code>.
   * <p>This object should be keyed by the entity name sequence,
   * with the value being the textual representation of the entity.</p>
   * <pre>
   *  Ext.String.addCharacterEntities({
   *      '&amp;amp;Uuml;':'Ü',
   *      '&amp;amp;ccedil;':'ç',
   *      '&amp;amp;ntilde;':'ñ',
   *      '&amp;amp;egrave;':'è'
   *  });
   *  var s = Ext.String.htmlEncode("A string with entities: èÜçñ");
   * </pre>
   * <p><b>Note:</b> the values of the character entities defined on this object are expected
   * to be single character values. As such, the actual values represented by the
   * characters are sensitive to the character encoding of the JavaScript source
   * file when defined in string literal form. Script tags referencing server
   * resources with character entities must ensure that the 'charset' attribute
   * of the script node is consistent with the actual character encoding of the
   * server resource.</p>
   * <p>The set of character entities may be reset back to the default state by using
   * the →<code>ext.StringUtil.resetCharacterEntities()</code> method</p>
   * @param newEntities The set of character entities to add to the current
   * definitions.
   * @see ext.SStringUtil#htmlEncode() ext.StringUtil.htmlEncode()
   * @see ext.SStringUtil#htmlDecode() ext.StringUtil.htmlDecode()
   * @see ext.SStringUtil#resetCharacterEntities() ext.StringUtil.resetCharacterEntities()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-addCharacterEntities Original Ext JS documentation of 'addCharacterEntities'
   */
  public native function addCharacterEntities(newEntities:Object):void;

  /**
   * Capitalize the first letter of the given string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-capitalize Original Ext JS documentation of 'capitalize'
   */
  public native function capitalize(string:String):String;

  /**
   * Creates a <code>→RegExp</code> given a string <code>value</code> and optional flags. For example, the
   * following two regular expressions are equivalent.
   * <pre>
   *  var regex1 = Ext.String.createRegex('hello');
   *
   *  var regex2 = /^hello$/i;
   * </pre>
   * <p>The following two regular expressions are also equivalent:</p>
   * <pre>
   *  var regex1 = Ext.String.createRegex('world', false, false, false);
   *
   *  var regex2 = /world/;
   * </pre>
   * @since 5.0.0
   * @param value The String to convert to a <code>→RegExp</code>.
   * @param startsWith Pass <code>false</code> to allow a match to start
   * anywhere in the string. By default the <code>value</code> will match only at the start
   * of the string.
   * @default true
   * @param endsWith Pass <code>false</code> to allow the match to end before
   * the end of the string. By default the <code>value</code> will match only at the end of the
   * string.
   * @default true
   * @param ignoreCase Pass <code>false</code> to make the <code>→RegExp</code> case
   * sensitive (removes the 'i' flag).
   * @default true
   * @see RegExp
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-createRegex Original Ext JS documentation of 'createRegex'
   */
  public native function createRegex(value:*, startsWith:Boolean = true, endsWith:Boolean = true, ignoreCase:Boolean = true):RegExp;

  /**
   * Converts a string of characters into a legal, parse-able JavaScript <code>var</code> name
   * as long as the passed string contains at least one alphabetic character.
   * Non alphanumeric characters, and <i>leading</i> non alphabetic characters will be removed.
   * @param s A string to be converted into a <code>var</code> name.
   * @return A legal JavaScript <code>var</code> name.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-createVarName Original Ext JS documentation of 'createVarName'
   */
  public native function createVarName(s:String):String;

  /**
   * Truncate a string and add an ellipsis ('...') to the end if it exceeds
   * the specified length.
   * @param value The string to truncate.
   * @param length The maximum length to allow before truncating.
   * @param word <code>true</code> to try to find a common word break.
   * @default false
   * @return The converted text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-ellipsis Original Ext JS documentation of 'ellipsis'
   */
  public native function ellipsis(value:String, length:Number, word:Boolean = false):String;

  /**
   * Checks if a string ends with a substring
   * @param s The original string
   * @param end The substring to check
   * @param ignoreCase True to ignore the case in the comparison
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-endsWith Original Ext JS documentation of 'endsWith'
   */
  public native function endsWith(s:String, end:String, ignoreCase:Boolean = false):Boolean;

  /**
   * Escapes the passed string for ' and .
   * @param string The string to escape.
   * @return The escaped string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-escape Original Ext JS documentation of 'escape'
   */
  public native function escape(string:String):String;

  /**
   * Escapes the passed string for use in a regular expression.
   * @param string The string to escape.
   * @return The escaped string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-escapeRegex Original Ext JS documentation of 'escapeRegex'
   */
  public native function escapeRegex(string:String):String;

  /**
   * Allows you to define a tokenized string and pass an arbitrary number of arguments to replace
   * the tokens. Each token must be unique, and must increment in the format {0}, {1}, etc.
   * Example usage:
   * <pre>
   * var cls = 'my-class',
   *     text = 'Some text';
   * var s = Ext.String.format('&lt;div class="{0}"&gt;{1}&lt;/div&gt;', cls, text);
   * // s now contains the string: '&lt;div class="my-class"&gt;Some text&lt;/div&gt;'
   * </pre>
   * @param format The tokenized string to be formatted.
   * @param values The values to replace tokens <code>{0}</code>, <code>{1}</code>, etc in order.
   * @return The formatted string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-format Original Ext JS documentation of 'format'
   */
  public native function format(format:String, ...values):String;

  /**
   * Creates a string created by using the specified sequence of code points.
   * @param codePoint Codepoints from which to build the string.
   * @return A string built from the sequence of code points passed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-fromCodePoint Original Ext JS documentation of 'fromCodePoint'
   */
  public native function fromCodePoint(...codePoint):String;

  /**
   * Convert certain characters (&amp;, &lt;, &gt;, ', and ") from their HTML character equivalents.
   * @param value The string to decode.
   * @return The decoded text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-htmlDecode Original Ext JS documentation of 'htmlDecode'
   */
  public native function htmlDecode(value:String):String;

  /**
   * Convert certain characters (&amp;, &lt;, &gt;, ', and ") to their HTML character equivalents
   * for literal display in web pages.
   * @param value The string to encode.
   * @return The encoded text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-htmlEncode Original Ext JS documentation of 'htmlEncode'
   */
  public native function htmlEncode(value:String):String;

  /**
   * Inserts a substring into a string.
   * @param s The original string.
   * @param value The substring to insert.
   * @param index The index to insert the substring. Negative indexes will insert
   * from the end of the string. Example:
   * <pre>
   * Ext.String.insert("abcdefg", "h", -1); // abcdefhg
   * </pre>
   * @return The value with the inserted substring
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-insert Original Ext JS documentation of 'insert'
   */
  public native function insert(s:String, value:String, index:Number):String;

  /**
   * Pads the left side of a string with a specified character. This is especially useful
   * for normalizing number and date strings. Example usage:
   * <pre>
   * var s = Ext.String.leftPad('123', 5, '0');
   * // s now contains the string: '00123'
   * </pre>
   * @param string The original string.
   * @param size The total length of the output string.
   * @param character The character with which to pad the original
   * string.
   * @default ' '
   * @return The padded string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-leftPad Original Ext JS documentation of 'leftPad'
   */
  public native function leftPad(string:String, size:Number, character:String = ' '):String;

  /**
   * Returns a string with a specified number of repetitions a given string pattern.
   * The pattern be separated by a different string.
   * <pre>
   *  var s = Ext.String.repeat('---', 4); // = '------------'
   *  var t = Ext.String.repeat('--', 3, '/'); // = '--/--/--'
   * </pre>
   * @param pattern The pattern to repeat.
   * @param count The number of times to repeat the pattern (may be 0).
   * @param sep An option string to separate each pattern.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-repeat Original Ext JS documentation of 'repeat'
   */
  public native function repeat(pattern:String, count:Number, sep:String):String;

  /**
   * Resets the set of character entity definitions used by
   * →<code>ext.StringUtil.htmlEncode()</code> and →<code>ext.StringUtil.htmlDecode()</code> back to the
   * default state.
   * @see ext.SStringUtil#htmlEncode() ext.StringUtil.htmlEncode()
   * @see ext.SStringUtil#htmlDecode() ext.StringUtil.htmlDecode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-resetCharacterEntities Original Ext JS documentation of 'resetCharacterEntities'
   */
  public native function resetCharacterEntities():void;

  /**
   * Splits a string of space separated words into an array, trimming as needed. If the
   * words are already an array, it is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-splitWords Original Ext JS documentation of 'splitWords'
   */
  public native function splitWords(words:*):Array;

  /**
   * Checks if a string starts with a substring
   * @param s The original string
   * @param start The substring to check
   * @param ignoreCase True to ignore the case in the comparison
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-startsWith Original Ext JS documentation of 'startsWith'
   */
  public native function startsWith(s:String, start:String, ignoreCase:Boolean = false):Boolean;

  /**
   * Utility function that allows you to easily switch a string between two alternating
   * values. The passed value is compared to the current string, and if they are equal,
   * the other value that was passed in is returned. If they are already different,
   * the first value passed in is returned. Note that this method returns the new value
   * but does not change the current string.
   * <pre>
   * // alternate sort directions
   * sort = Ext.String.toggle(sort, 'ASC', 'DESC');
   *
   * // instead of conditional logic:
   * sort = (sort === 'ASC' ? 'DESC' : 'ASC');
   * </pre>
   * @param string The current string.
   * @param value The value to compare to the current string.
   * @param other The new value to use if the string already equals the first value
   * passed in.
   * @return The new value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle(string:String, value:String, other:String):String;

  /**
   * Trims whitespace from either end of a string, leaving spaces within the string intact.
   * Example:
   * <pre>
   * var s = '  foo bar  ';
   * alert('-' + s + '-');                   //alerts "- foo bar -"
   * alert('-' + Ext.String.trim(s) + '-');  //alerts "-foo bar-"
   * </pre>
   * @param string The string to trim.
   * @return The trimmed string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-trim Original Ext JS documentation of 'trim'
   */
  public native function trim(string:String):String;

  /**
   * Uncapitalize the first letter of a given string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-uncapitalize Original Ext JS documentation of 'uncapitalize'
   */
  public native function uncapitalize(string:String):String;

  /**
   * Appends content to the query string of a URL, handling logic for whether to place
   * a question mark or ampersand.
   * @param url The URL to append to.
   * @param string The content to append to the URL.
   * @return The resulting URL
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.String.html#method-urlAppend Original Ext JS documentation of 'urlAppend'
   */
  public native function urlAppend(url:String, string:String):String;
}
}