package ext {

[Native]
/**
 * A simple class to verify if a browser feature exists or not on the current device.
 * <pre>
 * if (Ext.feature.has.Canvas) {
 *     // do some cool things with canvas here
 * }
 * </pre>
 * <p>See the →<code>has()</code> property/method for details of the features that can be detected.</p>
 * <p>Type of singleton feature.</p>
 * @see Sfeature#has()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.feature.html Original Ext JS documentation of 'Ext.feature'
 * @see ext.#feature ext.feature
 */
public class Sfeature extends Object {
  /**
   * Verifies if a browser feature exists or not on the current device.
   * <p>A "hybrid" property, can be either accessed as a method call, i.e:</p>
   * <pre>
   * if (Ext.feature.has('Canvas')) {
   *     // ...
   * }
   * </pre>
   * <p>or as an object with boolean properties, i.e:</p>
   * <pre>
   * if (Ext.feature.has.Canvas) {
   *     // ...
   * }
   * </pre>
   * <p>For possible properties/parameter values see <code>→ext.supports</code>.</p>
   * @param name The feature name to check.
   * @see ext.#supports ext.supports
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.feature.html#method-has Original Ext JS documentation of 'has'
   */
  public native function has(name:String):Boolean;
}
}