package ext {
import ext.env.OS;

[Native]
/**
 * Provides useful information about the current operating system environment.
 * <p>Example:</p>
 * <pre>
 * if (Ext.os.is.Windows) {
 *     // Windows specific code here
 * }
 *
 * if (Ext.os.is.iOS) {
 *     // iPad, iPod, iPhone, etc.
 * }
 *
 * console.log("Version " + Ext.os.version);
 * </pre>
 * <p>For a full list of supported values, refer to the →<code>matches()</code> property/method.</p>
 * <p>Type of singleton os.</p>
 * @see Sos#matches()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html Original Ext JS documentation of 'Ext.os'
 * @see ext.#os ext.os
 */
public class Sos extends OS {
  /**
   * The generic type of the current device.
   * <p>Possible values:</p>
   * <ul>
   * <li>Phone</li>
   * <li>Tablet</li>
   * <li>Desktop</li>
   * </ul>
   * <p>For testing purposes the deviceType can be overridden by adding
   * a deviceType parameter to the URL of the page, like so:</p>
   * <pre>
   * http://localhost/mypage.html?deviceType=Tablet
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html#property-deviceType Original Ext JS documentation of 'deviceType'
   */
  public native function get deviceType():String;

  /**
   * @private
   */
  public native function set deviceType(value:String):void;

  /**
   * The full name of the current operating system. Possible values are:
   * <ul>
   * <li>iOS</li>
   * <li>Android</li>
   * <li>WebOS</li>
   * <li>BlackBerry,</li>
   * <li>MacOS</li>
   * <li>Windows</li>
   * <li>Linux</li>
   * <li>Other</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html#property-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  /**
   * Refer to →<code>ext.Version</code>
   * @see ext.Version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html#property-version Original Ext JS documentation of 'version'
   */
  public native function get version():Version;

  /**
   * A "hybrid" property, can be either accessed as a method call, i.e:
   * <pre>
   * if (Ext.os.is('Android')) {
   *     // ...
   * }
   * </pre>
   * <p>or as an object with boolean properties, i.e:</p>
   * <pre>
   * if (Ext.os.is.Android) {
   *     // ...
   * }
   * </pre>
   * <p>Versions can be conveniently checked as well. For example:</p>
   * <pre>
   * if (Ext.os.is.Android2) {
   *     // Equivalent to (Ext.os.is.Android &amp;&amp; Ext.os.version.equals(2))
   * }
   *
   * if (Ext.os.is.iOS32) {
   *     // Equivalent to (Ext.os.is.iOS &amp;&amp; Ext.os.version.equals(3.2))
   * }
   * </pre>
   * <p>Note that only <i>major component</i> (→<code>ext.Version.getMajor()</code>) and
   * <i>simplified</i> (→<code>ext.Version.getShortVersion()</code>) value of the version are available
   * via direct property checking. Supported values are:</p>
   * <ul>
   * <li>iOS</li>
   * <li>iPad</li>
   * <li>iPhone</li>
   * <li>iPhone5 (also true for 4in iPods).</li>
   * <li>iPod</li>
   * <li>Android</li>
   * <li>WebOS</li>
   * <li>BlackBerry</li>
   * <li>Bada</li>
   * <li>MacOS</li>
   * <li>Windows</li>
   * <li>Linux</li>
   * <li>Other</li>
   * </ul>
   * @param name The OS name to check.
   * @see ext.Version#getMajor()
   * @see ext.Version#getShortVersion()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html#method-is Original Ext JS documentation of 'is'
   */
  public native function matches(name:String):Boolean;
}
}