package ext {

[Native]
/**
 * Contains information about features supported in the current environment as well
 * as bugs detected.
 * <p>Type of singleton supports.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html Original Ext JS documentation of 'Ext.supports'
 * @see ext.#supports ext.supports
 */
public class Ssupports extends Object {
  /**
   * <code>true</code> if the browser fires focus events (focus, blur, focusin, focusout)
   * asynchronously, i.e. in a separate event loop invocation. This is only true
   * for all versions Internet Explorer; Microsoft Edge and other browsers fire
   * focus events synchronously.
   * @default 'AsyncFocusEvents'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-AsyncFocusEvents Original Ext JS documentation of 'AsyncFocusEvents'
   */
  public native function get AsyncFocusEvents():Boolean;

  /**
   * @private
   */
  public native function set AsyncFocusEvents(value:Boolean):void;

  /**
   * <code>true</code> if the device supports the HTML5 <code>audio</code> tag.
   * <p>This property is available at application boot time, before document ready.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Audio Original Ext JS documentation of 'Audio'
   */
  public native function get Audio():Boolean;

  /**
   * @private
   */
  public native function set Audio(value:Boolean):void;

  [Deprecated(replacement="Audio", since="5.0.0")]
  /**
   * <code>true</code> if the device supports the HTML5 <code>audio</code> tag.
   * @default [
   *     'Audio',
   *     'AudioTag'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-AudioTag Original Ext JS documentation of 'AudioTag'
   */
  public native function get AudioTag():Boolean;

  /**
   * @private
   */
  public native function set AudioTag(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports the getBoundingClientRect
   * method on elements.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'BoundingClientRect'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-BoundingClientRect Original Ext JS documentation of 'BoundingClientRect'
   */
  public native function get BoundingClientRect():Boolean;

  /**
   * @private
   */
  public native function set BoundingClientRect(value:Boolean):void;

  /**
   * <code>true</code> if the device supports CSS3 border radius.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'CSS3BorderRadius'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CSS3BorderRadius Original Ext JS documentation of 'CSS3BorderRadius'
   */
  public native function get CSS3BorderRadius():Boolean;

  /**
   * @private
   */
  public native function set CSS3BorderRadius(value:Boolean):void;

  /**
   * <code>true</code> if document environment supports the CSS3
   * box-shadow style.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'CSS3BoxShadow'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CSS3BoxShadow Original Ext JS documentation of 'CSS3BoxShadow'
   */
  public native function get CSS3BoxShadow():Boolean;

  /**
   * @private
   */
  public native function set CSS3BoxShadow(value:Boolean):void;

  /**
   * <code>true</code> if the device supports CSS3 linear gradients.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'CSS3LinearGradient'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CSS3LinearGradient Original Ext JS documentation of 'CSS3LinearGradient'
   */
  public native function get CSS3LinearGradient():Boolean;

  /**
   * @private
   */
  public native function set CSS3LinearGradient(value:Boolean):void;

  /**
   * <code>true</code> if document environment supports the CSS3
   * pointer-events style.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'CSSPointerEvents'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CSSPointerEvents Original Ext JS documentation of 'CSSPointerEvents'
   */
  public native function get CSSPointerEvents():Boolean;

  /**
   * @private
   */
  public native function set CSSPointerEvents(value:Boolean):void;

  /**
   * Feature detect the support of browsers that are unable to scroll elements that are
   * the same height as the native scrollbar height.
   * @default 'CannotScrollExactHeight'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CannotScrollExactHeight Original Ext JS documentation of 'CannotScrollExactHeight'
   */
  public native function get CannotScrollExactHeight():Boolean;

  /**
   * @private
   */
  public native function set CannotScrollExactHeight(value:Boolean):void;

  /**
   * <code>true</code> if the device supports Canvas.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Canvas'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Canvas Original Ext JS documentation of 'Canvas'
   */
  public native function get Canvas():Boolean;

  /**
   * @private
   */
  public native function set Canvas(value:Boolean):void;

  /**
   * <code>true</code> if created child elements
   * lose their innerHTML when modifying the innerHTML of the parent element.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'ChildContentClearedWhenSettingInnerHTML'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-ChildContentClearedWhenSettingInnerHTML Original Ext JS documentation of 'ChildContentClearedWhenSettingInnerHTML'
   */
  public native function get ChildContentClearedWhenSettingInnerHTML():Boolean;

  /**
   * @private
   */
  public native function set ChildContentClearedWhenSettingInnerHTML(value:Boolean):void;

  /**
   * <code>true</code> if document environment supports the HTML5
   * classList API.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'ClassList'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-ClassList Original Ext JS documentation of 'ClassList'
   */
  public native function get ClassList():Boolean;

  /**
   * @private
   */
  public native function set ClassList(value:Boolean):void;

  /**
   * <code>true</code> if the native DOM cloneNode method copies
   * expando properties to the newly cloned node.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'CloneNodeCopiesExpando'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CloneNodeCopiesExpando Original Ext JS documentation of 'CloneNodeCopiesExpando'
   */
  public native function get CloneNodeCopiesExpando():Boolean;

  /**
   * @private
   */
  public native function set CloneNodeCopiesExpando(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports
   * document.defaultView.getComputedStyle().
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'ComputedStyle'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-ComputedStyle Original Ext JS documentation of 'ComputedStyle'
   */
  public native function get ComputedStyle():Boolean;

  /**
   * @private
   */
  public native function set ComputedStyle(value:Boolean):void;

  /**
   * <code>true</code> if browser support CreateContextualFragment
   * range native methods.
   * See https://developer.mozilla.org/en/DOM/range.createContextualFragment
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'CreateContextualFragment'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-CreateContextualFragment Original Ext JS documentation of 'CreateContextualFragment'
   */
  public native function get CreateContextualFragment():Boolean;

  /**
   * @private
   */
  public native function set CreateContextualFragment(value:Boolean):void;

  /**
   * <code>true</code> if the device supports CSS3DTransform.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Css3dTransforms'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Css3DTransforms Original Ext JS documentation of 'Css3DTransforms'
   */
  public native function get Css3DTransforms():Boolean;

  /**
   * @private
   */
  public native function set Css3DTransforms(value:Boolean):void;

  /**
   * <code>true</code> if the device supports device motion (acceleration
   * and rotation rate).
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'DeviceMotion'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-DeviceMotion Original Ext JS documentation of 'DeviceMotion'
   */
  public native function get DeviceMotion():Boolean;

  /**
   * @private
   */
  public native function set DeviceMotion(value:Boolean):void;

  /**
   * <code>true</code> if when asking for an element's dimension via offsetWidth
   * or offsetHeight, getBoundingClientRect, etc. the browser returns the subpixel width
   * rounded to the nearest pixel.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Direct2DBug'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Direct2DBug Original Ext JS documentation of 'Direct2DBug'
   */
  public native function get Direct2DBug():Boolean;

  /**
   * @private
   */
  public native function set Direct2DBug(value:Boolean):void;

  /**
   * <code>true</code> if INPUT elements lose their
   * selection when their display style is changed. Essentially, if a text input
   * has focus and its display style is changed, the I-beam disappears.
   * <p>This bug is encountered due to the work around in place for the →<code>RightMargin</code>
   * bug. This has been observed in Safari 4.0.4 and older, and appears to be fixed
   * in Safari 5. It's not clear if Safari 4.1 has the bug, but it has the same WebKit
   * version number as Safari 5 (according to http://unixpapa.com/js/gecko.html).</p>
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'DisplayChangeInputSelectionBug'
   * @see Ssupports#RightMargin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-DisplayChangeInputSelectionBug Original Ext JS documentation of 'DisplayChangeInputSelectionBug'
   */
  public native function get DisplayChangeInputSelectionBug():*;

  /**
   * @private
   */
  public native function set DisplayChangeInputSelectionBug(value:*):void;

  /**
   * <code>true</code> if TEXTAREA elements lose their
   * selection when their display style is changed. Essentially, if a text area has
   * focus and its display style is changed, the I-beam disappears.
   * <p>This bug is encountered due to the work around in place for the →<code>RightMargin</code>
   * bug. This has been observed in Chrome 10 and Safari 5 and older, and appears to
   * be fixed in Chrome 11.</p>
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'DisplayChangeTextAreaSelectionBug'
   * @see Ssupports#RightMargin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-DisplayChangeTextAreaSelectionBug Original Ext JS documentation of 'DisplayChangeTextAreaSelectionBug'
   */
  public native function get DisplayChangeTextAreaSelectionBug():*;

  /**
   * @private
   */
  public native function set DisplayChangeTextAreaSelectionBug(value:*):void;

  /**
   * True if the browser emulates a mouseover event on tap (mobile safari).
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'EmulatedMouseOver'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-EmulatedMouseOver Original Ext JS documentation of 'EmulatedMouseOver'
   */
  public native function get EmulatedMouseOver():Boolean;

  /**
   * @private
   */
  public native function set EmulatedMouseOver(value:Boolean):void;

  /**
   * <code>true</code> if the device supports CSS float.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Float'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Float Original Ext JS documentation of 'Float'
   */
  public native function get Float():Boolean;

  /**
   * @private
   */
  public native function set Float(value:Boolean):void;

  [Deprecated(replacement="Geolocation", since="5.0.0")]
  /**
   * <code>true</code> if the device supports Geo-location.
   * @default [
   *     'Geolocation',
   *     'GeoLocation'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-GeoLocation Original Ext JS documentation of 'GeoLocation'
   */
  public native function get GeoLocation():Boolean;

  /**
   * @private
   */
  public native function set GeoLocation(value:Boolean):void;

  /**
   * <code>true</code> if the device supports GeoLocation.
   * <p>This property is available at application boot time, before document ready.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Geolocation Original Ext JS documentation of 'Geolocation'
   */
  public native function get Geolocation():Boolean;

  /**
   * @private
   */
  public native function set Geolocation(value:Boolean):void;

  /**
   * <code>true</code> if the browser will return the
   * left/top/right/bottom position as a percentage when explicitly set as a percentage value.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-GetPositionPercentage Original Ext JS documentation of 'GetPositionPercentage'
   */
  public native function get GetPositionPercentage():Boolean;

  /**
   * @private
   */
  public native function set GetPositionPercentage(value:Boolean):void;

  /**
   * True if the user agent supports the hashchange event.
   * <p>This property is available at application boot time, before document ready.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Hashchange Original Ext JS documentation of 'Hashchange'
   */
  public native function get Hashchange():Boolean;

  /**
   * @private
   */
  public native function set Hashchange(value:Boolean):void;

  /**
   * <code>true</code> if the device supports HTML5 history. See
   * https://developer.mozilla.org/en/DOM/Manipulating_the_browser_history
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'History'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-History Original Ext JS documentation of 'History'
   */
  public native function get History():Boolean;

  /**
   * @private
   */
  public native function set History(value:Boolean):void;

  /**
   * <code>true</code> if localStorage is supported.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'LocalStorage'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-LocalStorage Original Ext JS documentation of 'LocalStorage'
   */
  public native function get LocalStorage():Boolean;

  /**
   * @private
   */
  public native function set LocalStorage(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports mouseenter and mouseleave events.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'MouseEnterLeave'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-MouseEnterLeave Original Ext JS documentation of 'MouseEnterLeave'
   */
  public native function get MouseEnterLeave():Boolean;

  /**
   * @private
   */
  public native function set MouseEnterLeave(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports the mousewheel event.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'MouseWheel'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-MouseWheel Original Ext JS documentation of 'MouseWheel'
   */
  public native function get MouseWheel():Boolean;

  /**
   * @private
   */
  public native function set MouseWheel(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports placeholders
   * on numeric input fields.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'NumericInputPlaceHolder'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-NumericInputPlaceHolder Original Ext JS documentation of 'NumericInputPlaceHolder'
   */
  public native function get NumericInputPlaceHolder():Boolean;

  /**
   * @private
   */
  public native function set NumericInputPlaceHolder(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports normal css opacity.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Opacity'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Opacity Original Ext JS documentation of 'Opacity'
   */
  public native function get Opacity():Boolean;

  /**
   * @private
   */
  public native function set Opacity(value:Boolean):void;

  /**
   * <code>true</code> if the device supports different orientations.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Orientation'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Orientation Original Ext JS documentation of 'Orientation'
   */
  public native function get Orientation():Boolean;

  /**
   * @private
   */
  public native function set Orientation(value:Boolean):void;

  /**
   * <code>true</code> if the device supports the <code>orientationchange</code>
   * event.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'OrientationChange'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-OrientationChange Original Ext JS documentation of 'OrientationChange'
   */
  public native function get OrientationChange():Boolean;

  /**
   * @private
   */
  public native function set OrientationChange(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports the HTML5 placeholder attribute
   * on inputs.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Placeholder'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Placeholder Original Ext JS documentation of 'Placeholder'
   */
  public native function get Placeholder():Boolean;

  /**
   * @private
   */
  public native function set Placeholder(value:Boolean):void;

  /**
   * <code>true</code> if browser support document.createRange native method.
   * See https://developer.mozilla.org/en/DOM/range.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Range'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Range Original Ext JS documentation of 'Range'
   */
  public native function get Range():Boolean;

  /**
   * @private
   */
  public native function set Range(value:Boolean):void;

  /**
   * <code>true</code> if the device supports right margin.
   * See https://bugs.webkit.org/show_bug.cgi?id=13343 for why this is needed.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'RightMargin'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-RightMargin Original Ext JS documentation of 'RightMargin'
   */
  public native function get RightMargin():Boolean;

  /**
   * @private
   */
  public native function set RightMargin(value:Boolean):void;

  /**
   * <code>true</code> if the BoundingClientRect is
   * rotated when the element is rotated using a CSS transform.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'RotatedBoundingClientRect'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-RotatedBoundingClientRect Original Ext JS documentation of 'RotatedBoundingClientRect'
   */
  public native function get RotatedBoundingClientRect():Boolean;

  /**
   * @private
   */
  public native function set RotatedBoundingClientRect(value:Boolean):void;

  /**
   * In some browsers the right padding of an overflowing element is not accounted
   * for in its scrollWidth. The result can vary depending on whether or not
   * The element contains block-level children. This method tests the effect
   * of padding on scrollWidth when there are no block-level children inside the
   * overflowing element.
   * <p>This method returns true if the browser is affected by this bug.</p>
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'ScrollWidthInlinePaddingBug'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-ScrollWidthInlinePaddingBug Original Ext JS documentation of 'ScrollWidthInlinePaddingBug'
   */
  public native function get ScrollWidthInlinePaddingBug():Boolean;

  /**
   * @private
   */
  public native function set ScrollWidthInlinePaddingBug(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports the CSS selector API level 2.
   * https://dev.w3.org/2006/webapi/selectors-api2/
   * @default 'Selectors2'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Selectors2 Original Ext JS documentation of 'Selectors2'
   */
  public native function get Selectors2():Boolean;

  /**
   * @private
   */
  public native function set Selectors2(value:Boolean):void;

  /**
   * True if the browser fires the keydown event on specialkey autorepeat.
   * <p>note 1: IE fires ONLY the keydown event on specialkey autorepeat
   * note 2: Safari &lt; 3.1, Gecko (Mac/Linux) &amp; Opera fire only the keypress event on
   * specialkey autorepeat (research done by Jan Wolter at
   * http://unixpapa.com/js/key.html)
   * note 3: Opera 12 behaves like other modern browsers so this workaround does not
   * work anymore</p>
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'SpecialKeyDownRepeat'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-SpecialKeyDownRepeat Original Ext JS documentation of 'SpecialKeyDownRepeat'
   */
  public native function get SpecialKeyDownRepeat():Boolean;

  /**
   * @private
   */
  public native function set SpecialKeyDownRepeat(value:Boolean):void;

  /**
   * <code>true</code> if the device supports SVG.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Svg'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Svg Original Ext JS documentation of 'Svg'
   */
  public native function get Svg():Boolean;

  /**
   * @private
   */
  public native function set Svg(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports maxlength on textareas.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'TextAreaMaxLength'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-TextAreaMaxLength Original Ext JS documentation of 'TextAreaMaxLength'
   */
  public native function get TextAreaMaxLength():Boolean;

  /**
   * @private
   */
  public native function set TextAreaMaxLength(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports touch input.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Touch'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Touch Original Ext JS documentation of 'Touch'
   */
  public native function get Touch():Boolean;

  /**
   * @private
   */
  public native function set Touch(value:Boolean):void;

  /**
   * <code>true</code> if the device supports touch events (<code>touchstart</code>, <code>touchmove</code>, <code>touchend</code>).
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'TouchEvents'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-TouchEvents Original Ext JS documentation of 'TouchEvents'
   */
  public native function get TouchEvents():Boolean;

  /**
   * @private
   */
  public native function set TouchEvents(value:Boolean):void;

  /**
   * <code>true</code> if the device supports CSS3 Transitions.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default [
   *     'CssTransitions',
   *     'Transitions'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Transitions Original Ext JS documentation of 'Transitions'
   */
  public native function get Transitions():Boolean;

  /**
   * @private
   */
  public native function set Transitions(value:Boolean):void;

  /**
   * <code>true</code> if the device supports transparent color.
   * <p>This property is <i>NOT</i> available at application boot time. Only after the document
   * ready event.</p>
   * @default 'TransparentColor'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-TransparentColor Original Ext JS documentation of 'TransparentColor'
   */
  public native function get TransparentColor():Boolean;

  /**
   * @private
   */
  public native function set TransparentColor(value:Boolean):void;

  /**
   * <code>true</code> if the device supports the HTML5 <code>video</code> tag.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Video'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Video Original Ext JS documentation of 'Video'
   */
  public native function get Video():Boolean;

  /**
   * @private
   */
  public native function set Video(value:Boolean):void;

  /**
   * <code>true</code> if the device supports ViewportUnits.
   * @default 'ViewportUnits'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-ViewportUnits Original Ext JS documentation of 'ViewportUnits'
   */
  public native function get ViewportUnits():Boolean;

  /**
   * @private
   */
  public native function set ViewportUnits(value:Boolean):void;

  /**
   * <code>true</code> if the device supports VML.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'Vml'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-Vml Original Ext JS documentation of 'Vml'
   */
  public native function get Vml():Boolean;

  /**
   * @private
   */
  public native function set Vml(value:Boolean):void;

  /**
   * <code>true</code> if the browser supports XMLHttpRequest.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'XHR2'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-XHR2 Original Ext JS documentation of 'XHR2'
   */
  public native function get XHR2():Boolean;

  /**
   * <code>true</code> if the browser supports XMLHttpRequest
   * upload progress info.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'XHRUploadProgress'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-XHRUploadProgress Original Ext JS documentation of 'XHRUploadProgress'
   */
  public native function get XHRUploadProgress():Boolean;

  /**
   * @private
   */
  public native function set XHRUploadProgress(value:Boolean):void;

  /**
   * <code>true</code> if the browsers supports querySelector
   * and querySelectorAll methods on XML nodes.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'XmlQuerySelector'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-XmlQuerySelector Original Ext JS documentation of 'XmlQuerySelector'
   */
  public native function get XmlQuerySelector():Boolean;

  /**
   * @private
   */
  public native function set XmlQuerySelector(value:Boolean):void;

  /**
   * Accessibility features.
   * @default 'accessibility'
   * <ul>
   * <li><code>Images:Boolean</code> (optional) —
   * <code>true</code> if the browser is configured
   * to display images.
   * </li>
   * <li><code>BackgroundImages:Boolean</code> (optional) —
   * <code>true</code> if the browser
   * is configured to display background images.
   * </li>
   * <li><code>BorderColors:Boolean</code> (optional) —
   * <code>true</code> if the browser
   * is configured to honor CSS styling for border colors.
   * </li>
   * <li><code>LightOnDark:Boolean</code> (optional) —
   * <code>true</code> if the browser
   * is currently using reverse colors in light-on-dark accessibility mode.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-accessibility Original Ext JS documentation of 'accessibility'
   */
  public native function get accessibility():Object;

  /**
   * @private
   */
  public native function set accessibility(value:Object):void;

  /**
   * The method name which matches an element against a selector if implemented in this
   * environment.
   * <p>This property is available at application boot time, before document ready.</p>
   * @default 'matchesSelector'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.supports.html#property-matchesSelector Original Ext JS documentation of 'matchesSelector'
   */
  public native function get matchesSelector():String;

  /**
   * @private
   */
  public native function set matchesSelector(value:String):void;
}
}