package ext {

[Native("Ext.Template", require)]
/**
 * Represents an HTML fragment template. Templates may be <i>precompiled</i> (→<code>compile()</code>) for
 * greater performance.
 * <p>An instance of this class may be created by passing to the constructor either a single argument,
 * or multiple arguments:</p>
 * <p><b>Single argument: String/Array</b></p>
 * <p>The single argument may be either a String or an Array:</p>
 * <ul>
 * <li>
 * <p>String:</p>
 * <pre>
 * var t = new Ext.Template("&lt;div&gt;Hello {0}.&lt;/div&gt;");
 * t.append('some-element', ['foo']);
 * </pre>
 * </li>
 * <li>
 * <p>Array:</p>
 * <p>An Array will be combined with <code>join('')</code>.</p>
 * <pre>
 * var t = new Ext.Template([
 *     '&lt;div name="{id}"&gt;',
 *         '&lt;span class="{cls}"&gt;{name:trim} {value:ellipsis(10)}&lt;/span&gt;',
 *     '&lt;/div&gt;',
 * ]);
 * t.compile();
 * t.append('some-element', {id: 'myid', cls: 'myclass', name: 'foo', value: 'bar'});
 * </pre>
 * </li>
 * </ul>
 * <p><b>Multiple arguments: String, Object, Array, ...</b></p>
 * <p>Multiple arguments will be combined with <code>join('')</code>.</p>
 * <pre>
 * var t = new Ext.Template(
 *     '&lt;div name="{id}"&gt;',
 *         '&lt;span class="{cls}"&gt;{name} {value}&lt;/span&gt;',
 *     '&lt;/div&gt;',
 *     // a configuration object:
 *     {
 *         compiled: true,      // →<code>compile()</code> immediately
 *     }
 * );
 * </pre>
 * <p><b>Notes</b></p>
 * <ul>
 * <li>For a list of available format functions, see →<code>ext.util.Format</code>.</li>
 * <li><code>→disableFormats</code> reduces <code>→apply()</code> time when no formatting is required.</li>
 * </ul>
 * @see #compile()
 * @see ext.util.#Format ext.util.Format
 * @see #disableFormats
 * @see #apply()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html Original Ext JS documentation of 'Ext.Template'
 */
public class Template extends Base {
  /**
   * Creates a template from the passed element's value (<i>display:none</i> textarea, preferred)
   * or innerHTML.
   * @param el A DOM element or its id
   * @param config Config object
   * @return The created template
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#static-method-from Original Ext JS documentation of 'from'
   */
  public static native function from(el:*, config:Object = null):Template;

  /**
   * Creates new template.
   * @param config List of strings to be concatenated into template or template Configs.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Template(...config) {
    super();
  }

  [ExtConfig]
  /**
   * True to immediately compile the template. Defaults to false.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#cfg-compiled Original Ext JS documentation of 'compiled'
   */
  public native function get compiled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set compiled(value:Boolean):void;

  [ExtConfig]
  /**
   * True to disable format functions in the template. If the template doesn't contain
   * format functions, setting disableFormats to true will reduce apply time. Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#cfg-disableFormats Original Ext JS documentation of 'disableFormats'
   */
  public native function get disableFormats():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableFormats(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Template, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#property-isTemplate Original Ext JS documentation of 'isTemplate'
   */
  public native function get isTemplate():Boolean;

  /**
   * @private
   */
  public native function set isTemplate(value:Boolean):void;

  /**
   * Applies the supplied <code>values</code> to the template and appends the new node(s) to the specified
   * <code>el</code>.
   * <p>For example usage see <i>Ext.Template class docs</i> (→<code>ext.Template</code>).</p>
   * @param el The context element
   * @param values The template values. See →<code>applyTemplate()</code> for details.
   * @param returnElement true to return an Ext.Element.
   * @return The new node or Element
   * @see ext.Template
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-append Original Ext JS documentation of 'append'
   * @see #applyTemplate()
   */
  public native function append(el:*, values:*, returnElement:Boolean = false):*;

  /**
   * Returns an HTML fragment of this template with the specified values applied.
   * @param values The template values. Can be an array if your params are numeric:
   * <pre>
   * var tpl = new Ext.Template('Name: {0}, Age: {1}');
   * tpl.apply(['John', 25]);
   * </pre>
   * <p>or an object:</p>
   * <pre>
   * var tpl = new Ext.Template('Name: {name}, Age: {age}');
   * tpl.apply({name: 'John', age: 25});
   * </pre>
   * @return The HTML fragment
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-apply Original Ext JS documentation of 'apply'
   */
  public native function apply(values:*):String;

  /**
   * Appends the result of this template to the provided output array.
   * @param values The template values. See →<code>apply()</code>.
   * @param out The array to which output is pushed.
   * @return The given out array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-applyOut Original Ext JS documentation of 'applyOut'
   * @see #apply()
   */
  public native function applyOut(values:*, out:Array):Array;

  /**
   * Alias for →<code>apply()</code>.
   * Returns an HTML fragment of this template with the specified values applied.
   * @param values The template values. Can be an array if your params are numeric:
   * <pre>
   * var tpl = new Ext.Template('Name: {0}, Age: {1}');
   * tpl.apply(['John', 25]);
   * </pre>
   * <p>or an object:</p>
   * <pre>
   * var tpl = new Ext.Template('Name: {name}, Age: {age}');
   * tpl.apply({name: 'John', age: 25});
   * </pre>
   * @return The HTML fragment
   * @see #apply()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-applyTemplate Original Ext JS documentation of 'applyTemplate'
   */
  public native function applyTemplate(values:*):String;

  /**
   * Compiles the template into an internal function, eliminating the RegEx overhead.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-compile Original Ext JS documentation of 'compile'
   */
  public native function compile():Template;

  /**
   * Applies the supplied values to the template and inserts the new node(s) after el.
   * @param el The context element
   * @param values The template values. See →<code>applyTemplate()</code> for details.
   * @param returnElement true to return a Ext.Element.
   * @return The new node or Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-insertAfter Original Ext JS documentation of 'insertAfter'
   * @see #applyTemplate()
   */
  public native function insertAfter(el:*, values:*, returnElement:Boolean = false):*;

  /**
   * Applies the supplied values to the template and inserts the new node(s) before el.
   * @param el The context element
   * @param values The template values. See →<code>applyTemplate()</code> for details.
   * @param returnElement true to return a Ext.Element.
   * @return The new node or Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-insertBefore Original Ext JS documentation of 'insertBefore'
   * @see #applyTemplate()
   */
  public native function insertBefore(el:*, values:*, returnElement:Boolean = false):*;

  /**
   * Applies the supplied values to the template and inserts the new node(s) as the first child
   * of el.
   * @param el The context element
   * @param values The template values. See →<code>applyTemplate()</code> for details.
   * @param returnElement true to return a Ext.Element.
   * @return The new node or Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-insertFirst Original Ext JS documentation of 'insertFirst'
   * @see #applyTemplate()
   */
  public native function insertFirst(el:*, values:*, returnElement:Boolean = false):*;

  /**
   * Applies the supplied values to the template and overwrites the content of el with the new
   * node(s).
   * @param el The context element
   * @param values The template values. See →<code>applyTemplate()</code> for details.
   * @param returnElement true to return a Ext.Element.
   * @return The new node or Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-overwrite Original Ext JS documentation of 'overwrite'
   * @see #applyTemplate()
   */
  public native function overwrite(el:*, values:*, returnElement:Boolean = false):*;

  /**
   * Sets the HTML used as the template and optionally compiles it.
   * @param html
   * @param compile True to compile the template.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Template.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(html:String, compile:Boolean = false):Template;
}
}