package ext {
import ext.app.ViewController;
import ext.app.ViewModel;
import ext.container.Container;
import ext.data.Session;
import ext.dom.Element;
import ext.event.Event;
import ext.mixin.IAccessible;
import ext.mixin.IBindable;
import ext.mixin.IComponentDelegation;
import ext.mixin.IFactoryable;
import ext.mixin.IFocusable;
import ext.mixin.IInheritable;
import ext.mixin.IKeyboard;
import ext.mixin.IPluggable;
import ext.mixin.Observable;
import ext.plugin.AbstractPlugin;

[Native("Ext.Widget", require)]
/**
 * @see ext.events.Widget_eventEvent.BLUR
 * @eventType ext.events.Widget_eventEvent.BLUR
 */
[Event(name='onBlur', type='ext.events.Widget_eventEvent')]
/**
 * @see ext.events.Widget_eventEvent.FOCUS
 * @eventType ext.events.Widget_eventEvent.FOCUS
 */
[Event(name='onFocus', type='ext.events.Widget_eventEvent')]
/**
 * @see ext.events.Widget_eventEvent.FOCUS_ENTER
 * @eventType ext.events.Widget_eventEvent.FOCUS_ENTER
 */
[Event(name='onFocusEnter', type='ext.events.Widget_eventEvent')]
/**
 * @see ext.events.Widget_eventEvent.FOCUS_LEAVE
 * @eventType ext.events.Widget_eventEvent.FOCUS_LEAVE
 */
[Event(name='onFocusLeave', type='ext.events.Widget_eventEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.BEFORE_DISABLED_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.BEFORE_DISABLED_CHANGE
 */
[Event(name='onBeforeDisabledChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.DISABLED_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.DISABLED_CHANGE
 */
[Event(name='onDisabledChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.BEFORE_HEIGHT_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.BEFORE_HEIGHT_CHANGE
 */
[Event(name='onBeforeHeightChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.HEIGHT_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.HEIGHT_CHANGE
 */
[Event(name='onHeightChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.BEFORE_HIDDEN_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.BEFORE_HIDDEN_CHANGE
 */
[Event(name='onBeforeHiddenChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.HIDDEN_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.HIDDEN_CHANGE
 */
[Event(name='onHiddenChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.BEFORE_WIDTH_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.BEFORE_WIDTH_CHANGE
 */
[Event(name='onBeforeWidthChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * @see ext.events.Widget_value_oldValueEvent.WIDTH_CHANGE
 * @eventType ext.events.Widget_value_oldValueEvent.WIDTH_CHANGE
 */
[Event(name='onWidthChange', type='ext.events.Widget_value_oldValueEvent')]
/**
 * Ext.Widget is a light-weight Component that consists of nothing more than a template
 * Element that can be cloned to quickly and efficiently replicate many instances.
 * Ext.Widget is typically not instantiated directly, because the default template is
 * just a single element with no listeners. Instead Ext.Widget should be extended to
 * create Widgets that have a useful markup structure and event listeners.
 * <p>For example:</p>
 * <pre>
 *  Ext.define('MyWidget', {
 *      extend: 'Ext.Widget',
 *
 *      // The element template passed to Ext.Element.create()
 *      element: {
 *          reference: 'element',
 *          listeners: {
 *              click: 'onClick'
 *          },
 *          children: [{
 *              reference: 'innerElement',
 *              listeners: {
 *                  click: 'onInnerClick'
 *              }
 *          }]
 *      },
 *
 *      constructor: function(config) {
 *          // It is important to remember to call the Widget superclass constructor
 *          // when overriding the constructor in a derived class. This ensures that
 *          // the element is initialized from the template, and that initConfig() is
 *          // is called.
 *          this.callParent([config]);
 *
 *          // After calling the superclass constructor, the Element is available and
 *          // can safely be manipulated. Reference Elements are instances of
 *          // Ext.Element, and are cached on each Widget instance by reference name.
 *          Ext.getBody().appendChild(this.element);
 *      },
 *
 *      onClick: function() {
 *          // listeners use this Widget instance as their scope
 *          console.log('element clicked', this);
 *      },
 *
 *      onInnerClick: function() {
 *          // access the innerElement reference by name
 *          console.log('inner element clicked', this.innerElement);
 *      }
 *  });
 * </pre>
 * <p><b>From override Ext.ResponsiveWidget:</b></p>
 * The counterpart to `→<code>ext.Responsive</code>` for `→<code>ext.Widget</code>`. This override is required by
 * `→<code>ext.Responsive</code>` but will only be included if `→<code>ext.Widget</code>` is also used.
 * @see ext.Responsive
 * @see ext.Widget
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html Original Ext JS documentation of 'Ext.Widget'
 */
public class Widget extends Evented implements IInheritable, IBindable, IComponentDelegation, IPluggable, IKeyboard, IFactoryable, IFocusable, IAccessible {
  /**
   * @param config @inheritDoc
   */
  public function Widget(config:Widget = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * An object containing ARIA attributes to be set
   * on this Component's ARIA element. Use this to set the attributes that cannot be
   * determined by the Component's state, such as <code>aria-live</code>, <code>aria-flowto</code>, etc.
   * <p><b>Note</b> that this config is only meaningful at the Component rendering time,
   * and setting it after that will do nothing.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaAttributes Original Ext JS documentation of 'ariaAttributes'
   * @see #getAriaAttributes()
   * @see #setAriaAttributes()
   */
  public native function get ariaAttributes():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ariaAttributes(value:Object):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as description for this Component, set in <code>aria-describedby</code> attribute.
   * The selector works the same way as →<code>ariaLabelledBy</code>.
   * @see #ariaLabelledBy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaDescribedBy Original Ext JS documentation of 'ariaDescribedBy'
   */
  public native function get ariaDescribedBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDescribedBy(value:*):void;

  [ExtConfig]
  /**
   * ARIA label for this Component. It is best to use
   * →<code>ariaLabelledBy</code> option instead, because screen readers prefer
   * <code>aria-labelledby</code> attribute to <code>aria-label</code>. →<code>ariaLabel</code> and
   * →<code>ariaLabelledBy</code> config options are mutually exclusive.
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabel Original Ext JS documentation of 'ariaLabel'
   */
  public native function get ariaLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabel(value:String):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as label for this Component, set in <code>aria-labelledby</code> attribute.
   * If the selector is by <code>#id</code>, the label element can be any existing element,
   * not necessarily a child of the main Component element.
   * <p>→<code>ariaLabelledBy</code> and →<code>ariaLabel</code> config options are
   * mutually exclusive, and <code>→ariaLabelledBy</code> has the higher precedence.</p>
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabelledBy Original Ext JS documentation of 'ariaLabelledBy'
   */
  public native function get ariaLabelledBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabelledBy(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get ariaRole():String;

  /**
   * The base CSS class to apply to this widget's element.
   * Used as the prefix for →<code>ui</code>-specific class names.
   * Defaults to the value of →<code>classCls</code> or (<code>x-</code> + the →<code>xtype</code>) of the widget
   * if →<code>classCls</code> is <code>null</code>
   * @default null
   * @see #ui
   * @see #classCls
   * @see #xtype
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#property-baseCls Original Ext JS documentation of 'baseCls'
   */
  public native function get baseCls():*;

  /**
   * @private
   */
  public native function set baseCls(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Setting this config option adds or removes data bindings for other configs.
   * For example, to bind the <code>title</code> config:
   * <pre>
   *  var panel = Ext.create({
   *      xtype: 'panel',
   *      bind: {
   *          title: 'Hello {user.name}'
   *      }
   *  });
   * </pre>
   * <p>To dynamically add bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: 'Greetings {user.name}!'
   *  });
   * </pre>
   * <p>To remove bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: null
   *  });
   * </pre>
   * <p>The bind expressions are presented to <code>→ext.app.ViewModel.bind()</code>. The
   * <code>ViewModel</code> instance is determined by <code>→lookupViewModel()</code>.</p>
   * <p><b>Note:</b> If bind is passed as a string, it will use the
   * →<code>ext.Component.defaultBindProperty</code> for the binding.</p>
   * @default null
   * @see ext.app.ViewModel#bind()
   * @see #lookupViewModel()
   * @see ext.Component#defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-bind Original Ext JS documentation of 'bind'
   * @see #getBind()
   * @see #setBind()
   */
  public native function get bind():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set bind(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Enables or disables bordering on this component.
   * The following values are accepted:
   * <ul>
   * <li><code>null</code> or `true (default): Do nothing and allow the border to be specified
   * by the theme.</li>
   * <li><code>false</code>: suppress the default border provided by the theme.</li>
   * </ul>
   * <p>Please note that enabling bordering via this config will not add a <code>border-color</code>
   * or <code>border-style</code> CSS property to the component; you provide the <code>border-color</code>
   * and <code>border-style</code> via CSS rule or →<code>style</code> configuration
   * (if not already provide by the theme).</p>
   * <p><b><i>Using →<code>style</code>:</i></b></p>
   * <pre>
   * Ext.Viewport.add({
   *     centered: true,
   *     width: 100,
   *     height: 100,
   *
   *     style: 'border: 1px solid blue;'
   *     // ...
   * });
   * </pre>
   * <p><b><i>Using CSS:</i></b></p>
   * <pre>
   * Ext.Viewport.add({
   *     centered: true,
   *     width: 100,
   *     height: 100,
   *
   *     cls: 'my-component'
   *     // ...
   * });
   * </pre>
   * <p>And your CSS file:</p>
   * <pre>
   * .my-component {
   *     border: 1px solid red;
   * }
   * </pre>
   * @default null
   * @see #style
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-border Original Ext JS documentation of 'border'
   * @see #getBorder()
   * @see #setBorder()
   */
  public native function get border():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set border(value:Boolean):void;

  /**
   * A CSS class to apply to the main element that will be inherited down the class
   * hierarchy. Subclasses may override this property on their prototype to add their
   * own CSS class in addition to the CSS classes inherited from ancestor classes via
   * the prototype chain. For example
   * <pre>
   * Ext.define('Foo', {
   *     extend: 'Ext.Widget',
   *     classCls: 'foo'
   * });
   *
   * Ext.define('Bar', {
   *     extend: 'Foo',
   *     classCls: 'bar'
   * });
   *
   * var bar = new Bar();
   *
   * console.log(bar.element.className); // outputs 'foo bar'
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#property-classCls Original Ext JS documentation of 'classCls'
   */
  public native function get classCls():*;

  /**
   * @private
   */
  public native function set classCls(value:*):void;

  /**
   * When set to <code>true</code> during widget class definition, that class will be the "root" for
   * →<code>classCls</code> inheritance. Derived classes may set this to <code>true</code> to avoid
   * inheriting a →<code>classCls</code> from their superclass.
   * @default true
   * @see #classCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#property-classClsRoot Original Ext JS documentation of 'classClsRoot'
   */
  public native function get classClsRoot():*;

  /**
   * @private
   */
  public native function set classClsRoot(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The CSS class to add to this widget's element, in
   * addition to the →<code>baseCls</code>. In many cases, this property will be specified
   * by the derived widget class. See →<code>userCls</code> for adding additional CSS
   * classes to widget instances (such as items in a →<code>ext.container.Container</code>).
   * @default null
   * @see #baseCls
   * @see #userCls
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-cls Original Ext JS documentation of 'cls'
   * @see #getCls()
   * @see #setCls()
   */
  public native function get cls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get containsFocus():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * A string alias, a configuration object or an instance of a <code>ViewController</code> for
   * this container. Sample usage:
   * <pre>
   * Ext.define('MyApp.UserController', {
   *     alias: 'controller.user'
   * });
   *
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: 'user'
   * });
   * // Or
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: {
   *         type: 'user',
   *         someConfig: true
   *     }
   * });
   *
   * // Can also instance at runtime
   * var ctrl = new MyApp.UserController();
   * var view = new UserContainer({
   *     controller: ctrl
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-controller Original Ext JS documentation of 'controller'
   * @see #getController()
   * @see #setController()
   */
  public native function get controller():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set controller(value:*):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  public native function get defaultBindProperty():String;

  /**
   * @private
   */
  public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  public native function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultListenerScope(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether or not this component is disabled
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #getDisabled()
   * @see #setDisabled()
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  /**
   * A configuration object for Ext.Element.create() that is used to create the Element
   * template. Subclasses should avoid overriding this property and instead add elements
   * using →<code>template</code>.
   * <p>Supports all the standard options of a Ext.Element.create() config and adds 3
   * additional options:</p>
   * <ol>
   * <li>
   * <p><code>→reference</code> - this option specifies a name for Element references. These
   * references names become properties of the Widget instance and refer to Ext.Element
   * instances that were created using the template:</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       children: [{
   *           reference: 'innerElement'
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>After construction of a widget the reference elements are accessible as follows:</p>
   * <pre>
   * var foo = new FooWidget(),
   *     innerEl = foo.innerElement; // an Ext.Element that wraps the innerElement
   * </pre>
   * <p>The reference attribute is optional, but all Widgets must have a <code>'element'</code>
   * reference on some element within the template (usually the outermost one).</p>
   * <ol start="2">
   * <li>
   * <p><code>→listeners</code> - a standard listeners object as specified by →<code>ext.mixin.Observable</code>.</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       listeners: {
   *           click: 'onClick'
   *       },
   *       children: [{
   *           reference: 'innerElement',
   *           listeners: {
   *               click: 'onInnerClick'
   *           }
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>Since listeners cannot be attached without an Ext.Element reference the <code>→reference</code>
   * property MUST be specified in order to use <code>→listeners</code>.</p>
   * <p>The Widget instance is used as the scope for all listeners specified in this way,
   * so it is invalid to use the <code>scope</code> option in the <code>→listeners</code> config since it will
   * always be overwritten using <code>this</code>.</p>
   * <ol start="3">
   * <li><code>uiCls</code> - a suffix to be appended to the ui-specific CSS class for each <code>→ui</code>
   * for this widget. These ui classes are constructed by appending the <code>→ui</code> to each
   * <code>→classCls</code> or <code>→baseCls</code> for the widget. As such, <code>uiCls</code> should
   * never be used on the main <code>→element</code> reference, as its <code>uiCls</code> is computed automatically.</li>
   * </ol>
   * <p>For example, assume a widget is defined with a <code>→ui</code> of <code>'alt action'</code> and a
   * <code>uiCls</code> of <code>'inner-el'</code> on its <code>innerElement</code> reference element:</p>
   * <pre>
   *      Ext.define('Doodad', {
   *          extend: 'Ext.Widget',
   *          xtype: 'doodad',
   *
   *          classCls: 'x-doodad',
   *
   *          ui: 'alt action',
   *
   *          element: {
   *              reference: 'element',
   *
   *              children: [{
   *                  reference: 'innerElement',
   *                  cls: 'x-inner-el',
   *                  uiCls: 'inner-el'
   *              }]
   *          }
   *      });
   * </pre>
   * <p>This would result in the following markup when rendered:</p>
   * <pre>
   * &lt;div class="x-doodad x-doodad-alt x-doodad-action"&gt;
   *     &lt;div class="x-inner-el x-doodad-inner-el x-doodad-alt-inner-el x-doodad-action-inner-el"&gt;&lt;/div&gt;
   * &lt;/div&gt;
   * </pre>
   * <p>These additional classes can be used to style the reference element for a particular
   * ui; however, use of <code>uiCls</code> is not typically necessary or recommended. Reference
   * elements should usually be styled using simple descendant selectors:</p>
   * <pre>
   * .x-doodad-alt .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>When there is a possibility that widgets can be nested it is best to use direct
   * child selectors to avoid the possibility of selecting all descendants instead
   * of just the reference element for the intended widget:</p>
   * <pre>
   * .x-doodad-alt &gt; .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>Only use <code>uiCls</code> when there is a possibility of nesting, AND there may be a variable
   * number of elements between the main <code>→element</code> and the reference element in question.
   * For example, Ext.Container with docked items has a different number of elements
   * in between its <code>→element</code> and its <code>bodyElement</code> than a Container without docked items
   * because of the wrapping elements that are dynamically added to support docking.
   * To ensure it does not style all descendants it must use a <code>uiCls</code> to style its
   * <code>bodyElement</code>:</p>
   * <pre>
   * .x-container-alt-body-el {
   *     background: #fff;
   * }
   * </pre>
   * <p>Note that when <code>uiCls</code> is specified it also adds a class name that does not contain
   * the <code>→ui</code> using just the <code>→classCls</code> and/or <code>→baseCls</code> as the prefix. This class name
   * can be used for base-level styling that does not relate to any particular UI:</p>
   * <pre>
   * .x-container-body-el {
   *     position: relative;
   * }
   * </pre>
   * @default {
   *     reference: 'element'
   * }
   * @see #template
   * @see #reference
   * @see #listeners
   * @see ext.mixin.Observable
   * @see #ui
   * @see #classCls
   * @see #baseCls
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#property-element Original Ext JS documentation of 'element'
   */
  public native function get element():Object;

  /**
   * @private
   */
  public native function set element(value:Object):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  /**
   * CSS class that will be added to focused
   * component's →<code>focusClsEl</code>, and removed when component blurs.
   * @default 'x-focused'
   * @see #focusClsEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusCls(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get focusClsEl():Element;

  /**
   * @inheritDoc
   */
  public native function set focusClsEl(value:Element):void;

  /**
   * @inheritDoc
   */
  public native function get focusEl():Element;

  /**
   * @inheritDoc
   */
  public native function set focusEl(value:Element):void;

  /**
   * @inheritDoc
   */
  public native function get focusable():Boolean;

  /**
   * @inheritDoc
   */
  public native function get hasFocus():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * The height of this Component; must be a valid CSS length value, e.g: <code>300</code>, <code>100px</code>,
   * <code>30%</code>, etc. By default, if this is not explicitly set, this Component's element will
   * simply have its own natural size. If set to <code>auto</code>, it will set the width to <code>null</code>
   * meaning it will have its own natural size.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-height Original Ext JS documentation of 'height'
   * @see #getHeight()
   * @see #setHeight()
   */
  public native function get height():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set height(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Whether or not this Component is hidden (its CSS <code>display</code> property is set to <code>none</code>).
   * <p>Defaults to <code>true</code> for →<code>floated</code> Components.</p>
   * @default null
   * @see #floated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #getHidden()
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A String which specifies how this component's DOM element will be hidden. The
   * accepted values are any of these:
   * <ul>
   * <li><code>'clip'</code> : Hide using <i>clip</i> (→<code>ext.dom.Element.CLIP</code>).</li>
   * <li><code>'display'</code> : Hide using <i>display</i> (→<code>ext.dom.Element.DISPLAY</code>).</li>
   * <li><code>'offsets'</code> : Hide using positioning <i>offsets</i> (→<code>ext.dom.Element.OFFSETS</code>).</li>
   * <li><code>'opacity'</code> : Hide using <i>opacity</i> (→<code>ext.dom.Element.OPACITY</code>).</li>
   * <li><code>'visibility'</code> : Hide using <i>visibility</i> (→<code>ext.dom.Element.VISIBILITY</code>).</li>
   * </ul>
   * <p>Hiding using <code>display</code> results in having no dimensions as well as resetting
   * scroll positions to 0.</p>
   * <p>The other modes overcome this but may have different trade-offs in certain
   * circumstances.</p>
   * @default 'display'
   * @since 6.5.0
   * @see ext.dom.Element#CLIP
   * @see ext.dom.Element#DISPLAY
   * @see ext.dom.Element#OFFSETS
   * @see ext.dom.Element#OPACITY
   * @see ext.dom.Element#VISIBILITY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-hideMode Original Ext JS documentation of 'hideMode'
   * @see #getHideMode()
   * @see #setHideMode()
   */
  public native function get hideMode():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hideMode(value:String):void;

  /**
   * Template method to do any Focusable related initialization that
   * does not involve event listeners creation.
   * @default Ext.emptyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-initFocusable Original Ext JS documentation of 'initFocusable'
   */
  public native function get initFocusable():*;

  /**
   * @private
   */
  public native function set initFocusable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing handlers for keyboard events. The property names of this
   * object are the key name and any modifiers. The values of the properties are the
   * descriptors of how to handle each event.
   * <p>The handler descriptor can be simply the handler function(either the
   * literal function or the method name), or it can be an object with these
   * properties:</p>
   * <ul>
   * <li><code>handler</code>: The function or its name to call to handle the event.</li>
   * <li><code>scope</code>: The this pointer context (can be "this" or "controller").</li>
   * <li><code>event</code>: An optional override of the key event to which to listen.</li>
   * </ul>
   * <p><b>Important:</b> Calls to <code>setKeyMap</code> do not replace the entire <code>→keyMap</code> but
   * instead update the provided mappings. That is, unless <code>null</code> is passed as the
   * value of the <code>→keyMap</code> which will clear the <code>→keyMap</code> of all entries.</p>
   * <ul>
   * <li><code>scope:String</code> (optional) —
   * The default scope to apply to key handlers
   * which do not specify a scope. This is processed the same way as the scope of
   * →<code>listeners</code>. It defaults to the <code>"controller"</code>, but using <code>'this'</code>
   * means that an instance method will be used.
   * </li>
   * </ul>
   * @see #keyMap
   * @see #listeners
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   * @see #getKeyMap()
   * @see #setKeyMap()
   */
  public native function get keyMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyMap(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Enables or disables processing keys in the <code>→keyMap</code>. This value starts as
   * <code>null</code> and if it is <code>null</code> when <code>→initKeyMap()</code> is called, it will automatically
   * be set to <code>true</code>. Since <code>→initKeyMap()</code> is called by <code>→ext.Component</code> at the
   * proper time, this is not something application code normally handles.
   * @default null
   * @see #keyMap
   * @see #initKeyMap()
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMapEnabled Original Ext JS documentation of 'keyMapEnabled'
   * @see #getKeyMapEnabled()
   * @see #setKeyMapEnabled()
   */
  public native function get keyMapEnabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyMapEnabled(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of the member that should be used to listen for keydown/keypress events.
   * This is intended to be controlled at the class level not per instance.
   * @default 'el'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMapTarget Original Ext JS documentation of 'keyMapTarget'
   */
  public native function get keyMapTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyMapTarget(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get lastKeyMapEvent():Event;

  /**
   * @inheritDoc
   */
  public native function set lastKeyMapEvent(value:Event):void;

  [ExtConfig]
  [Bindable]
  /**
   * The margin to use on this Component. Can be specified as a number (in which
   * case all edges get the same margin) or a CSS string like '5 10 10 10'
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-margin Original Ext JS documentation of 'margin'
   * @see #getMargin()
   * @see #setMargin()
   */
  public native function get margin():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set margin(value:*):void;

  [ExtConfig]
  /**
   * Name for the widget to be used with →<code>ext.container.Container.lookupName()</code>
   * et al.
   * @see ext.container.Container#lookupName()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> for this component's <code>name</code> property to be tracked by its containing
   * <code>nameHolder</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-nameable Original Ext JS documentation of 'nameable'
   */
  public native function get nameable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config describes one or more plugin config objects used to create plugin
   * instances for this component.
   * <p>Plugins are a way to bundle and reuse custom functionality. Plugins should extend
   * <code>→ext.plugin.AbstractPlugin</code> but technically the only requirement for a valid plugin
   * is that it contain an <code>init</code> method that accepts a reference to its owner. Once
   * a plugin is created, the owner will call the <code>init</code> method, passing a reference
   * to itself. Each plugin can then call methods or respond to events on its owner
   * as needed to provide its functionality.</p>
   * <p>This config's value can take several different forms.</p>
   * <p>The value can be a single string with the plugin's <i>alias</i> (→<code>null</code>):</p>
   * <pre>
   *  var list = Ext.create({
   *      xtype: 'list',
   *      itemTpl: '&lt;div class="item"&gt;{title}&lt;/div&gt;',
   *      store: 'Items',
   *
   *      plugins: 'listpaging'
   *  });
   * </pre>
   * <p>In the above examples, the string "listpaging" is the type alias for
   * <code>Ext.dataview.plugin.ListPaging</code>. The full alias includes the "plugin." prefix
   * (i.e., 'plugin.listpaging').</p>
   * <p>The preferred form for multiple plugins or to configure plugins is the
   * keyed-object form (new in version 6.5):</p>
   * <pre>
   *  var list = Ext.create({
   *      xtype: 'list',
   *      itemTpl: '&lt;div class="item"&gt;{title}&lt;/div&gt;',
   *      store: 'Items',
   *
   *      plugins: {
   *          pullrefresh: true,
   *          listpaging: {
   *              autoPaging: true,
   *              weight: 10
   *          }
   *      }
   *  });
   * </pre>
   * <p>The object keys are the <code>id</code>'s as well as the default type alias. This form
   * allows the value of the <code>→plugins</code> to be merged from base class to derived class
   * and finally with the instance configuration. This allows classes to define a
   * set of plugins that derived classes or instantiators can further configure or
   * disable. This merge behavior is a feature of the
   * <i>config system</i> (→<code>ext.ExtClass.config</code>).</p>
   * <p>The <code>→plugins</code> config can also be an array of plugin aliases (arrays are not
   * merged so this form does not respect plugins defined by the class author):</p>
   * <pre>
   *  var list = Ext.create({
   *      xtype: 'list',
   *      itemTpl: '&lt;div class="item"&gt;{title}&lt;/div&gt;',
   *      store: 'Items',
   *
   *      plugins: ['listpaging', 'pullrefresh']
   *  });
   * </pre>
   * <p>An array can also contain elements that are config objects with a <code>type</code>
   * property holding the type alias:</p>
   * <pre>
   *  var list = Ext.create({
   *      xtype: 'list',
   *      itemTpl: '&lt;div class="item"&gt;{title}&lt;/div&gt;',
   *      store: 'Items',
   *
   *      plugins: ['pullrefresh', {
   *          type: 'listpaging',
   *          autoPaging: true
   *      }]
   *  });
   * </pre>
   * @default null
   * @see ext.plugin.AbstractPlugin
   * @see null
   * @see #plugins
   * @see ext.ExtClass#config
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Pluggable.html#cfg-plugins Original Ext JS documentation of 'plugins'
   * @see #getPlugins()
   * @see #setPlugins()
   */
  public native function get plugins():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set plugins(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default null
   * @since 5.0.0
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Specifies a name for this component inside its component hierarchy. This name
   * must be unique within its <i>view</i> (→<code>ext.container.Container.referenceHolder</code>)
   * or its →<code>ext.app.ViewController</code>. See the documentation in
   * →<code>ext.container.Container</code> for more information about references.
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed
   * by zero or more additional letters, underscores or digits. References are case
   * sensitive.</p>
   * @see ext.container.Container#referenceHolder
   * @see ext.app.ViewController
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-reference Original Ext JS documentation of 'reference'
   */
  public native function get reference():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reference(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Optional element to render this Component to.
   * Not required if this component is an <i>item</i> (→<code>ext.container.Container.items</code>) of a Container
   * of a Container.
   * @see ext.container.Container#items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-renderTo Original Ext JS documentation of 'renderTo'
   * @see #getRenderTo()
   * @see #setRenderTo()
   */
  public native function get renderTo():Element;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set renderTo(value:Element):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set to truthy, Color or Object value for the ripple.
   * @default null
   * @since 6.5.0
   * <ul>
   * <li><code>color:String</code> (optional) —
   * The background color of the ripple.
   * </li>
   * <li><code>position:Array</code> (optional) —
   * Position for the ripple to start at [x,y].
   * Determines if a Ripple effect should happen whenever this element is pressed.
   * <p>For example:
   * {
   * ripple: true
   * }</p>
   * <p>Or:</p>
   * <pre>
   *  {
   *      ripple: {
   *          color: 'red'
   *      }
   *  }
   * </pre>
   * <p>For complex components, individual elements can suppress ripples by adding the
   * <code>x-no-ripple</code> class to disable rippling for a tree of elements.</p>
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-ripple Original Ext JS documentation of 'ripple'
   * @see #getRipple()
   * @see #setRipple()
   */
  public native function get ripple():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ripple(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * If provided this creates a new <code>Session</code> instance for this component. If this
   * is a <code>Container</code>, this will then be inherited by all child components.
   * <p>To create a new session you can specify <code>true</code>:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: true,
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * <p>Alternatively, a config object can be provided:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: {
   *          ...
   *      },
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-session Original Ext JS documentation of 'session'
   * @see #getSession()
   * @see #setSession()
   */
  public native function get session():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set session(value:*):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to allow this component's <code>name</code> to be shared by other items in the
   * same <code>nameHolder</code>. Such items will be returned in an array from <code>lookupName</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-shareableName Original Ext JS documentation of 'shareableName'
   */
  public native function get shareableName():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shareableName(value:Boolean):void;

  [ExtConfig]
  /**
   * Additional CSS styles that will be rendered into an inline style attribute when
   * the widget is rendered.
   * <p>You can pass either a string syntax:</p>
   * <pre>
   * style: 'background:red'
   * </pre>
   * <p>Or by using an object:</p>
   * <pre>
   * style: {
   *     background: 'red'
   * }
   * </pre>
   * <p>When using the object syntax, you can define CSS Properties by using a string:</p>
   * <pre>
   * style: {
   *     'border-left': '1px solid red'
   * }
   * </pre>
   * <p>Although the object syntax is much easier to read, we suggest you to use the
   * string syntax for better performance.</p>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-style Original Ext JS documentation of 'style'
   * @see #setStyle()
   */
  public native function get style():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:*):void;

  /**
   * An array of child elements to use as the children of the main element in the →<code>element</code>
   * template. Only used if "children" are not specified explicitly in the
   * →<code>element</code> template.
   * @default []
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#property-template Original Ext JS documentation of 'template'
   */
  public native function get template():Array;

  /**
   * @private
   */
  public native function set template(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * Emulates the behavior of the CSS
   * <a href="https://www.w3.org/TR/pointerevents/#the-touch-action-css-property">touch-action</a>
   * property in a cross-browser compatible manner.
   * <p>Keys in this object are touch action names, and values are <code>false</code> to disable
   * a touch action or <code>true</code> to enable it. Accepted keys are:</p>
   * <ul>
   * <li><code>panX</code></li>
   * <li><code>panY</code></li>
   * <li><code>pinchZoom</code></li>
   * <li><code>doubleTapZoom</code></li>
   * </ul>
   * <p>All touch actions are enabled (<code>true</code>) by default, so it is usually only necessary
   * to specify which touch actions to disable. For example, the following disables
   * only horizontal scrolling and pinch-to-zoom on the component's main element:</p>
   * <pre>
   * touchAction: {
   *     panX: false,
   *     pinchZoom: false
   * }
   * </pre>
   * <p>Touch actions can be specified on reference elements using the reference element
   * name, for example:</p>
   * <pre>
   * // disables horizontal scrolling on the main element, and double-tap-zoom
   * // on the child element named "body"
   * touchAction: {
   *     panY: false
   *     body: {
   *         doubleTapZoom: false
   *     }
   * }
   * </pre>
   * <p>The primary motivation for setting the touch-action of an element is to prevent
   * the browser's default handling of a gesture such as pinch-to-zoom, or
   * drag-to-scroll, so that the application can implement its own handling of that
   * gesture on the element. Suppose, for example, a component has a custom drag
   * handler on its element and wishes to prevent horizontal scrolling of its container
   * while it is being dragged:</p>
   * <pre>
   * Ext.create('Ext.Widget', {
   *     touchAction: {
   *         panX: false
   *     },
   *     listeners: {
   *         drag: function(e) {
   *             // implement drag logic
   *         }
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-touchAction Original Ext JS documentation of 'touchAction'
   * @see #getTouchAction()
   * @see #setTouchAction()
   */
  public native function get touchAction():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set touchAction(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default null
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ui or uis to be used on this Component.
   * <p>When a ui is configured, CSS class names are added to the →<code>element</code>, created
   * by appending the ui name(s) to each →<code>classCls</code> and/or →<code>baseCls</code>.</p>
   * @default null
   * @see #element
   * @see #classCls
   * @see #baseCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-ui Original Ext JS documentation of 'ui'
   * @see #getUi()
   * @see #setUi()
   */
  public native function get ui():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ui(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more CSS classes to add to the component's primary element. This config
   * is intended solely for use by the component instantiator (the "user"), not by
   * derived classes.
   * <p>For example:</p>
   * <pre>
   *  items: [{
   *      xtype: 'button',
   *      userCls: 'my-button'
   *  ...
   *  }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-userCls Original Ext JS documentation of 'userCls'
   * @see #getUserCls()
   * @see #setUserCls()
   */
  public native function get userCls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set userCls(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <code>ViewModel</code> is a data provider for this component and its children. The
   * data contained in the <code>ViewModel</code> is typically used by adding <code>→bind</code> configs
   * to the components that want present or edit this data.
   * <p>When set, the <code>ViewModel</code> is created and links to any inherited <code>→viewModel</code>
   * instance from an ancestor container as the "parent". The <code>ViewModel</code> hierarchy,
   * once established, only supports creation or destruction of children. The
   * parent of a <code>ViewModel</code> cannot be changed on the fly.</p>
   * <p>If this is a root-level <code>ViewModel</code>, the data model connection is made to this
   * component's associated <code>Data Session (→ext.data.Session)</code>. This is
   * determined by calling <code>getInheritedSession</code>.</p>
   * @default null
   * @see #bind
   * @see #viewModel
   * @see ext.data.Session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-viewModel Original Ext JS documentation of 'viewModel'
   * @see #getViewModel()
   * @see #setViewModel()
   */
  public native function get viewModel():ViewModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set viewModel(value:ViewModel):void;

  [ExtConfig]
  [Bindable]
  /**
   * The width of this Component; must be a valid CSS length value, e.g: <code>300</code>, <code>100px</code>,
   * <code>30%</code>, etc. By default, if this is not explicitly set, this Component's element will
   * simply have its own natural size. If set to <code>auto</code>, it will set the width to <code>null</code>
   * meaning it will have its own natural size.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#cfg-width Original Ext JS documentation of 'width'
   * @see #getWidth()
   * @see #setWidth()
   */
  public native function get width():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set width(value:*):void;

  /**
   * Adds a CSS class (or classes) to this Component's rendered element.
   * @param cls The CSS class(es) to add.
   * @param prefix Optional prefix to add to each class.
   * @default ""
   * @param suffix Optional suffix to add to each class.
   * @default ""
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-addCls Original Ext JS documentation of 'addCls'
   */
  public native function addCls(cls:*, prefix:String = "", suffix:String = ""):void;

  /**
   * @inheritDoc
   */
  public native function addPlugin(plugin:*):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-applyStyle Original Ext JS documentation of 'applyStyle'
   */
  protected native function applyStyle(style:*, oldStyle:*):void;

  /**
   * Template method to do any pre-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeBlur Original Ext JS documentation of 'beforeBlur'
   */
  protected native function beforeBlur(e:Event):void;

  /**
   * Template method to do any pre-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeFocus Original Ext JS documentation of 'beforeFocus'
   */
  protected native function beforeFocus(e:Event):void;

  /**
   * @inheritDoc
   */
  public native function bubble(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * Cancel any deferred focus on this component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-cancelFocus Original Ext JS documentation of 'cancelFocus'
   */
  protected native function cancelFocus():void;

  /**
   * Destroys the Widget. This method should not be overridden in custom Widgets,
   * because it sets the flags and does final cleanup that must go last. Instead,
   * override →<code>doDestroy()</code> method to add functionality at destruction time.
   * @see #doDestroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * @inheritDoc
   */
  public native function destroyPlugin(plugin:*):AbstractPlugin;

  /**
   * Disables this Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-disable Original Ext JS documentation of 'disable'
   */
  public native function disable():void;

  /**
   * Perform the actual destruction sequence. This is the method to override in your
   * subclasses to add steps specific to the destruction of custom Component or Widget.
   * <p>As a rule of thumb, subclasses should destroy their child Components, Elements,
   * and/or other objects before calling parent method. Any object references will be
   * nulled after this method has finished, to prevent the possibility of memory leaks.</p>
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-doDestroy Original Ext JS documentation of 'doDestroy'
   */
  public native function doDestroy():void;

  /**
   * Enables this Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-enable Original Ext JS documentation of 'enable'
   */
  public native function enable():void;

  /**
   * @inheritDoc
   */
  public native function findPlugin(type:String):AbstractPlugin;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function focus(selectText:* = undefined, delay:* = undefined, callback:Function = null, scope:Function = null):Component;

  /**
   * Returns the value of <code>ariaAttributes</code>.
   * @see #ariaAttributes
   */
  public native function getAriaAttributes():Object;

  /**
   * Returns the value of <code>bind</code>.
   * @see #bind
   */
  public native function getBind():*;

  /**
   * Returns the value of <code>border</code>.
   * @see #border
   */
  public native function getBorder():Boolean;

  /**
   * Returns the value of <code>cls</code>.
   * @see #cls
   */
  public native function getCls():String;

  /**
   * Returns the value of <code>controller</code>.
   * @see #controller
   */
  public native function getController():*;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  public native function getDefaultListenerScope():Boolean;

  /**
   * Returns the value of <code>disabled</code>.
   * @see #disabled
   */
  public native function getDisabled():Boolean;

  /**
   * A template method for modifying the →<code>element</code> config before it is processed.
   * By default adds the result of <code>this.getTemplate()</code> as the <code>children</code> array of
   * →<code>element</code> if <code>children</code> were not specified in the original
   * →<code>element</code> config. Typically this method should not need to be implemented
   * in subclasses. Instead the →<code>element</code> property should be use to configure
   * the element template for a given Widget subclass.
   * <p>This method is called once when the first instance of each Widget subclass is
   * created. The element config object that is returned is cached and used as the template
   * for all successive instances. The scope object for this method is the class prototype,
   * not the instance.</p>
   * @return the element config object
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-getElementConfig Original Ext JS documentation of 'getElementConfig'
   */
  protected native function getElementConfig():Object;

  /**
   * Returns the element used to apply focus styling CSS class when Focusable's
   * →<code>focusEl</code> becomes focused. By default it is →<code>focusEl</code>.
   * @param focusEl Return focus styling element for the given
   * focused element. This is used by Components implementing multiple focusable
   * elements.
   * @return The focus styling element.
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusClsEl Original Ext JS documentation of 'getFocusClsEl'
   */
  protected native function getFocusClsEl(focusEl:Element = null):Element;

  /**
   * Returns the main focus holder element associated with this Focusable, i.e.
   * the element that will be focused when Focusable's →<code>focus()</code> method is
   * called. For most Focusables, this will be the →<code>focusEl</code>.
   * @see #focus()
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusEl Original Ext JS documentation of 'getFocusEl'
   */
  protected native function getFocusEl():Element;

  /**
   * Returns the value of <code>height</code>.
   * @see #height
   */
  public native function getHeight():*;

  /**
   * Returns the value of <code>hidden</code>.
   * @see #hidden
   */
  public native function getHidden():Boolean;

  /**
   * Returns the value of <code>hideMode</code>.
   * @see #hideMode
   */
  public native function getHideMode():String;

  /**
   * @inheritDoc
   */
  public native function getInherited(inner:Boolean = false):Object;

  /**
   * @inheritDoc
   */
  public native function getInheritedConfig(property:String, skipThis:Boolean = false):*;

  /**
   * Returns the value of <code>keyMap</code>.
   * @see #keyMap
   */
  public native function getKeyMap():Object;

  /**
   * Returns the value of <code>keyMapEnabled</code>.
   * @see #keyMapEnabled
   */
  public native function getKeyMapEnabled():Boolean;

  /**
   * Returns the value of <code>margin</code>.
   * @see #margin
   */
  public native function getMargin():*;

  /**
   * @inheritDoc
   */
  public native function getPlugin(id:String):AbstractPlugin;

  /**
   * Returns the value of <code>plugins</code>.
   * @see #plugins
   */
  public native function getPlugins():Array;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  public native function getPublishes():*;

  /**
   * Used by →<code>ext.ComponentQuery</code>, and the →<code>ext.Component.up()</code>
   * method to find the owning Component in the linkage hierarchy.
   * <p>By default this returns the Container which contains this Component.</p>
   * <p>This may be overridden by Component authors who implement ownership hierarchies
   * which are not based upon ownerCt, such as BoundLists being owned by Fields or Menus
   * being owned by Buttons.</p>
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see ext.Component#up()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-getRefOwner Original Ext JS documentation of 'getRefOwner'
   */
  protected native function getRefOwner():Component;

  /**
   * Returns the value of <code>renderTo</code>.
   * @see #renderTo
   */
  public native function getRenderTo():Element;

  /**
   * Returns the value of <code>ripple</code>.
   * @see #ripple
   */
  public native function getRipple():*;

  /**
   * Returns the value of <code>session</code>.
   * @see #session
   */
  public native function getSession():*;

  /**
   * Returns the height and width of the Component.
   * @return The current <code>→height</code> and <code>→width</code> of the Component.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-getSize Original Ext JS documentation of 'getSize'
   * @see #height
   * @see #width
   */
  public native function getSize():Object;

  /**
   * @inheritDoc
   */
  public native function getTabIndex():Number;

  /**
   * Returns the value of <code>touchAction</code>.
   * @see #touchAction
   */
  public native function getTouchAction():Object;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>ui</code>.
   * @see #ui
   */
  public native function getUi():*;

  /**
   * Returns the value of <code>userCls</code>.
   * @see #userCls
   */
  public native function getUserCls():*;

  /**
   * Returns the value of <code>viewModel</code>.
   * @see #viewModel
   */
  public native function getViewModel():*;

  /**
   * Returns the value of <code>width</code>.
   * @see #width
   */
  public native function getWidth():*;

  /**
   * Checks if the specified CSS class exists on this element's DOM node.
   * @param className The CSS class to check for.
   * @return <code>true</code> if the class exists, else <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-hasCls Original Ext JS documentation of 'hasCls'
   */
  public native function hasCls(className:String):Boolean;

  /**
   * Initializes the Element for this Widget instance. If this is the first time a
   * Widget of this type has been instantiated the →<code>element</code> config will be
   * processed to create an Element. This Element is then cached on the prototype (see
   * afterCachedConfig) so that future instances can obtain their element by simply
   * cloning the Element that was cached by the first instance.
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-initElement Original Ext JS documentation of 'initElement'
   */
  protected native function initElement():void;

  /**
   * Template method to do any event listener initialization for a Focusable.
   * This generally happens after the focusEl is available.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-initFocusableEvents Original Ext JS documentation of 'initFocusableEvents'
   */
  protected native function initFocusableEvents(force:*):void;

  /**
   * This method is called to initialize the <code>inheritedState</code> objects for this instance.
   * This amounts to typically copying certain properties from the instance to the given
   * object.
   * @since 5.0.0
   * @param inheritedState The state object for this instance.
   * @param inheritedStateInner This object is only provided for containers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-initInheritedState Original Ext JS documentation of 'initInheritedState'
   */
  protected native function initInheritedState(inheritedState:Object, inheritedStateInner:Object = null):void;

  /**
   * This method should be called when the instance is ready to start listening for
   * keyboard events. This is called automatically for <code>→ext.Component</code> and derived
   * classes. This is done after the component is rendered.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#method-initKeyMap Original Ext JS documentation of 'initKeyMap'
   */
  protected native function initKeyMap():void;

  /**
   * @inheritDoc
   */
  public native function isAncestor(possibleDescendant:Component):Boolean;

  /**
   * @inheritDoc
   */
  public native function isBound(name:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function isDescendantOf(ancestor:Component):Boolean;

  /**
   * Returns <code>true</code> if this Component is currently disabled.
   * @return <code>true</code> if currently disabled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-isDisabled Original Ext JS documentation of 'isDisabled'
   */
  public native function isDisabled():Boolean;

  /**
   * Returns <code>true</code> if this Component is not currently disabled.
   * @return <code>true</code> if not currently disabled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-isEnabled Original Ext JS documentation of 'isEnabled'
   */
  public native function isEnabled():Boolean;

  /**
   * @inheritDoc
   */
  public native function isFocusable(deep:Boolean = false):Boolean;

  /**
   * Returns <code>true</code> if this Component is currently hidden.
   * @param deep <code>true</code> to check if this component
   * is hidden because a parent container is hidden. Alternatively, a reference to the
   * top-most parent at which to stop climbing.
   * @default false
   * @return <code>true</code> if currently hidden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-isHidden Original Ext JS documentation of 'isHidden'
   */
  public native function isHidden(deep:* = false):Boolean;

  /**
   * Returns <code>true</code> if this Component is currently visible.
   * <p>A Widget is visible if its element is not hidden, <i>and</i> has been
   * →<code>rendered</code> <i>and</i> has not been destroyed.</p>
   * @param deep <code>true</code> to check if this component
   * is visible and all parents are also visible.
   * <p>Contrast this with the →<code>isHidden()</code> method which just checks the
   * hidden state of the component.</p>
   * @default false
   * @return <code>true</code> if currently visible.
   * @see #rendered
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-isVisible Original Ext JS documentation of 'isVisible'
   * @see #isHidden()
   */
  public native function isVisible(deep:Boolean = false):Boolean;

  /**
   * Tests whether or not this Component is of a specific xtype. This can test whether this
   * Component is descended from the xtype (default) or whether it is directly of the xtype
   * specified (<code>shallow = true</code>).
   * &#42;&#42;If using your own subclasses, be aware that a Component must register its own xtype
   * to participate in determination of inherited xtypes.__
   * <p>For a list of all available xtypes, see the →<code>ext.Component</code> header.</p>
   * <p>Example usage:</p>
   * <pre>
   * var t = new Ext.field.Text();
   * var isText = t.isXType('textfield'); // true
   * var isBoxSubclass = t.isXType('field'); // true, descended from Ext.field.Field
   * var isBoxInstance = t.isXType('field', true); // false, not a direct
   *                                               // Ext.field.Field instance
   * </pre>
   * @param xtype The xtype to check for this Component.
   * @param shallow <code>false</code> to check whether this Component is descended
   * from the xtype (this is the default), or <code>true</code> to check whether this Component is directly
   * of the specified xtype.
   * @return <code>true</code> if this component descends from the specified xtype, <code>false</code>
   * otherwise.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-isXType Original Ext JS documentation of 'isXType'
   */
  public native function isXType(xtype:String, shallow:Boolean = false):Boolean;

  /**
   * @inheritDoc
   */
  public native function lookupController(skipThis:Boolean = false):ViewController;

  /**
   * @inheritDoc
   */
  public native function lookupSession(skipThis:Boolean = false):Session;

  /**
   * Gets a named template instance for this class. See →<code>ext.XTemplate.getTpl()</code>.
   * @since 6.2.0
   * @param name The name of the property that holds the template.
   * @return The template, <code>null</code> if not found.
   * @see ext.XTemplate#getTpl()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-lookupTpl Original Ext JS documentation of 'lookupTpl'
   */
  public native function lookupTpl(name:String):XTemplate;

  /**
   * @inheritDoc
   */
  public native function lookupViewModel(skipThis:Boolean = false):ViewModel;

  /**
   * Tests whether this Widget matches a →<code>ext.ComponentQuery</code>
   * selector string.
   * @param selector The selector string to test against.
   * @return <code>true</code> if this Widget matches the selector.
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-is Original Ext JS documentation of 'is'
   */
  public native function matches(selector:String):Boolean;

  /**
   * Called when focus enters this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the <code>fromComponent</code> is <i>after</i> the <code>toComponent&#42; in the DOM tree, indicating that the user used</code>SHIFT+TAB<code>to move focus. Note that setting</code>tabIndex<code>values to affect tabbing order can cause this to be incorrect. Setting</code>tabIndex` values is not advised.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusEnter Original Ext JS documentation of 'onFocusEnter'
   */
  protected native function onFocusEnter(e:Object):void;

  /**
   * Called when focus exits from this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusLeave Original Ext JS documentation of 'onFocusLeave'
   */
  protected native function onFocusLeave(e:Event):void;

  /**
   * Called when focus moves <i>within</i> this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying Event object.
   * </li>
   * <li><code>toElement:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>fromElement:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the focus movement is backward in DOM order
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusMove Original Ext JS documentation of 'onFocusMove'
   */
  protected native function onFocusMove(info:Object):void;

  /**
   * Template method to do any post-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postBlur Original Ext JS documentation of 'postBlur'
   */
  protected native function postBlur(e:Event):void;

  /**
   * Template method to do any post-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postFocus Original Ext JS documentation of 'postFocus'
   */
  protected native function postFocus(e:Event):void;

  /**
   * Publish this components state to the <code>ViewModel</code>. If no arguments are given (or if
   * this is the first call), the entire state is published. This state is determined by
   * the <code>→publishes</code> property.
   * <p>This method is called only by component authors.</p>
   * @since 5.0.0
   * @param property The name of the property to update.
   * @param value The value of <code>property</code>. Only needed if <code>property</code> is given.
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-publishState Original Ext JS documentation of 'publishState'
   */
  protected native function publishState(property:String = null, value:Object = null):void;

  /**
   * Removes the given CSS class(es) from this widget's primary element.
   * @param cls The class(es) to remove.
   * @param prefix Optional prefix to prepend before each class.
   * @default ""
   * @param suffix Optional suffix to append to each class.
   * @default ""
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-removeCls Original Ext JS documentation of 'removeCls'
   */
  public native function removeCls(cls:*, prefix:String = "", suffix:String = ""):void;

  /**
   * @inheritDoc
   */
  public native function removePlugin(plugin:*, destroy:Boolean = false):AbstractPlugin;

  /**
   * Replaces specified classes with the newly specified classes.
   * It uses the →<code>addCls()</code> and →<code>removeCls()</code> methods, so if the class(es) you
   * are removing don't exist, it will still add the new classes.
   * @param oldCls The class(es) to remove.
   * @param newCls The class(es) to add.
   * @param prefix Optional prefix to prepend before each class.
   * @default ""
   * @param suffix Optional suffix to append to each class.
   * @default ""
   * @see #addCls()
   * @see #removeCls()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-replaceCls Original Ext JS documentation of 'replaceCls'
   */
  public native function replaceCls(oldCls:*, newCls:*, prefix:String = "", suffix:String = ""):void;

  /**
   * Gets the Controller or Component that is used as the event root for this view.
   * @since 5.0.0
   * @param defaultScope (Default this) The default scope to return if none is found.
   * @default this
   * @return The default listener scope.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-resolveListenerScope Original Ext JS documentation of 'resolveListenerScope'
   */
  override protected native function resolveListenerScope(defaultScope:Object = null):Object;

  /**
   * Returns the default listener scope for a "satellite" of this component.
   * Used for resolving scope for observable objects that are not part of the normal
   * Container/Component hierarchy (for example, plugins)
   * @since 5.1.1
   * @return The listener scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-resolveSatelliteListenerScope Original Ext JS documentation of 'resolveSatelliteListenerScope'
   */
  protected native function resolveSatelliteListenerScope(satellite:Observable, defaultScope:Object = null):Object;

  /**
   * Sets the value of <code>ariaAttributes</code>.
   * @param ariaAttributes The new value.
   * @see #ariaAttributes
   */
  public native function setAriaAttributes(ariaAttributes:Object):void;

  /**
   * Sets the value of <code>bind</code>.
   * @param bind The new value.
   * @see #bind
   */
  public native function setBind(bind:*):void;

  /**
   * Sets the value of <code>border</code>.
   * @param border The new value.
   * @see #border
   */
  public native function setBorder(border:Boolean):void;

  /**
   * Sets the value of <code>cls</code>.
   * @param cls The new value.
   * @see #cls
   */
  public native function setCls(cls:String):void;

  /**
   * Sets the value of <code>controller</code>.
   * @param controller The new value.
   * @see #controller
   */
  public native function setController(controller:*):void;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  public native function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Sets the value of <code>disabled</code>.
   * @param disabled The new value.
   * @see #disabled
   */
  public native function setDisabled(disabled:Boolean):void;

  /**
   * Sets the value of <code>height</code>.
   * @param height The new value.
   * @see #height
   */
  public native function setHeight(height:*):void;

  /**
   * Sets the value of <code>hidden</code>.
   * @param hidden The new value.
   * @see #hidden
   */
  public native function setHidden(hidden:Boolean):void;

  /**
   * Sets the value of <code>hideMode</code>.
   * @param hideMode The new value.
   * @see #hideMode
   */
  public native function setHideMode(hideMode:String):void;

  /**
   * Sets the value of <code>keyMap</code>.
   * @param keyMap The new value.
   * @see #keyMap
   */
  public native function setKeyMap(keyMap:Object):void;

  /**
   * Sets the value of <code>keyMapEnabled</code>.
   * @param keyMapEnabled The new value.
   * @see #keyMapEnabled
   */
  public native function setKeyMapEnabled(keyMapEnabled:Boolean):void;

  /**
   * Sets the value of <code>margin</code>.
   * @param margin The new value.
   * @see #margin
   */
  public native function setMargin(margin:*):void;

  /**
   * Sets the value of <code>plugins</code>.
   * @param plugins The new value.
   * @see #plugins
   */
  public native function setPlugins(plugins:Array):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>renderTo</code>.
   * @param renderTo The new value.
   * @see #renderTo
   */
  public native function setRenderTo(renderTo:Element):void;

  /**
   * Sets the value of <code>ripple</code>.
   * @param ripple The new value.
   * @see #ripple
   */
  public native function setRipple(ripple:*):void;

  /**
   * Sets the value of <code>session</code>.
   * @param session The new value.
   * @see #session
   */
  public native function setSession(session:*):void;

  /**
   * Sets the size of the Component.
   * @param width The new width for the Component.
   * @param height The new height for the Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-setSize Original Ext JS documentation of 'setSize'
   */
  public native function setSize(width:Number, height:Number):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:*):void;

  /**
   * @inheritDoc
   */
  public native function setTabIndex(newTabIndex:Number):void;

  /**
   * Sets the value of <code>touchAction</code>.
   * @param touchAction The new value.
   * @see #touchAction
   */
  public native function setTouchAction(touchAction:Object):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>ui</code>.
   * @param ui The new value.
   * @see #ui
   */
  public native function setUi(ui:*):void;

  /**
   * Sets the value of <code>userCls</code>.
   * @param userCls The new value.
   * @see #userCls
   */
  public native function setUserCls(userCls:*):void;

  /**
   * Sets the value of <code>viewModel</code>.
   * @param viewModel The new value.
   * @see #viewModel
   */
  public native function setViewModel(viewModel:*):void;

  /**
   * Sets the value of <code>width</code>.
   * @param width The new value.
   * @see #width
   */
  public native function setWidth(width:*):void;

  /**
   * Toggles the specified CSS class on this element (removes it if it already exists,
   * otherwise adds it).
   * @param className The CSS class to toggle.
   * @param state If specified as <code>true</code>, causes the class to be added. If
   * specified as <code>false</code>, causes the class to be removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-toggleCls Original Ext JS documentation of 'toggleCls'
   */
  public native function toggleCls(className:String, state:Boolean = false):*;

  /**
   * Walks up the ownership hierarchy looking for an ancestor Component which matches
   * the passed simple selector.
   * <p>Example:</p>
   * <pre>
   * var owningTabPanel = grid.up('tabpanel');
   * </pre>
   * @param selector The simple selector to test.
   * @param limit This may be a selector upon which to stop
   * the upward scan, or a limit of the number of steps, or Component reference to stop on.
   * @return The matching ancestor Container (or <code>undefined</code> if no match
   * was found).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-up Original Ext JS documentation of 'up'
   */
  public native function up(selector:String = null, limit:* = undefined):Container;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-updateHeight Original Ext JS documentation of 'updateHeight'
   */
  protected native function updateHeight(height:*):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Widget.html#method-updateWidth Original Ext JS documentation of 'updateWidth'
   */
  protected native function updateWidth(width:*):void;
}
}