package ext {

[Native("Ext.WindowManager", require="Ext.ZIndexManager")]
/**
 * The default global floating Component group that is available automatically.
 * <p>This manages instances of floating Components which were rendered programatically without
 * being added to a →<code>ext.container.Container</code>, and for floating Components
 * which were added into non-floating Containers.</p>
 * <p><i>Floating</i> Containers create their own instance of ZIndexManager, and floating Components
 * added at any depth below there are managed by that ZIndexManager.</p>
 * @see ext.container.Container
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.WindowManager.html Original Ext JS documentation of 'Ext.WindowManager'
 */
public const WindowManager:ZIndexManager = new ZIndexManager();
}