package ext {

[Native("Ext.ZIndexManager", require)]
/**
 * A class that manages a group of →<code>ext.Component.floating</code> Components and
 * provides z-order management, and Component activation behavior, including masking
 * below the active (topmost) Component.
 * <p><i>Floating</i> (→<code>ext.Component.floating</code>) Components which are rendered directly
 * into the document (such as →<code>ext.window.Window</code>s) which are
 * →<code>ext.Component.show()</code>n are managed by a
 * <i>global instance</i> (→<code>ext.WindowManager</code>).</p>
 * <p><i>Floating</i> (→<code>ext.Component.floating</code>) Components which are descendants of
 * →<code>ext.Component.floating</code> <i>Containers</i> (for example a
 * →<code>ext.view.BoundListView</code> within an →<code>ext.window.Window</code>,
 * or a →<code>ext.menu.Menu</code>), are managed by a ZIndexManager owned by that floating
 * Container. Therefore ComboBox dropdowns within Windows will have managed z-indices guaranteed
 * to be correct, relative to the Window.</p>
 * @see ext.Component#floating
 * @see ext.window.Window
 * @see ext.Component#show()
 * @see ext.#WindowManager ext.WindowManager
 * @see ext.view.BoundListView
 * @see ext.menu.Menu
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html Original Ext JS documentation of 'Ext.ZIndexManager'
 */
public class ZIndexManager extends Base {
  /**
   * Brings the specified Component to the front of any other active Components in this
   * ZIndexManager.
   * @param comp The id of the Component or a →<code>ext.Component</code> instance.
   * @param preventFocus Pass <code>true</code> to prevent the component being focused when moved
   * to front.
   * @return True if the component was brought to the front, else false
   * if it was already in front, or another component remains at the front due to configuration
   * (eg →<code>ext.util.Floating.alwaysOnTop</code>, or if the component was not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-bringToFront Original Ext JS documentation of 'bringToFront'
   * @see ext.Component
   * @see ext.util.Floating#alwaysOnTop
   */
  public native function bringToFront(comp:*, preventFocus:Boolean):Boolean;

  /**
   * Executes the specified function once for every Component in this ZIndexManager, passing each
   * Component as the only parameter. Returning false from the function will stop the iteration.
   * @param fn The function to execute for each item
   * @param scope The scope (this reference) in which the function
   * is executed. Defaults to the current Component in the iteration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):void;

  /**
   * Executes the specified function once for every Component in this ZIndexManager, passing each
   * Component as the only parameter. Returning false from the function will stop the iteration.
   * The components are passed to the function starting at the bottom and proceeding to the top.
   * @param fn The function to execute for each item
   * @param scope The scope (this reference) in which the function
   * is executed. Defaults to the current Component in the iteration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-eachBottomUp Original Ext JS documentation of 'eachBottomUp'
   */
  public native function eachBottomUp(fn:Function, scope:Object = null):void;

  /**
   * Executes the specified function once for every Component in this ZIndexManager, passing each
   * Component as the only parameter. Returning false from the function will stop the iteration.
   * The components are passed to the function starting at the top and proceeding to the bottom.
   * @param fn The function to execute for each item
   * @param scope The scope (this reference) in which the function
   * is executed. Defaults to the current Component in the iteration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-eachTopDown Original Ext JS documentation of 'eachTopDown'
   */
  public native function eachTopDown(fn:Function, scope:Object = null):void;

  /**
   * Gets a registered Component by id.
   * @param id The id of the Component or a →<code>ext.Component</code> instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-get Original Ext JS documentation of 'get'
   * @see ext.Component
   */
  public native function get(id:*):Component;

  /**
   * Gets the currently-active Component in this ZIndexManager.
   * @return The active Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-getActive Original Ext JS documentation of 'getActive'
   */
  public native function getActive():Component;

  /**
   * Returns zero or more Components in this ZIndexManager using the custom search function passed
   * to this method. The function should accept a single →<code>ext.Component</code> reference
   * as its only argument and should return true if the Component matches the search criteria,
   * otherwise it should return false.
   * @param fn The search function
   * @param scope The scope (<code>this</code> reference) in which the function is executed.
   * Defaults to the Component being tested. That gets passed to the function if not specified.
   * @return An array of zero or more matching floating components.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-getBy Original Ext JS documentation of 'getBy'
   */
  public native function getBy(fn:Function, scope:Object = null):Array;

  /**
   * Hides all Components managed by this ZIndexManager.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-hideAll Original Ext JS documentation of 'hideAll'
   */
  public native function hideAll():void;

  /**
   * Registers a floating →<code>ext.Component</code> with this ZIndexManager. This should not
   * need to be called under normal circumstances. Floating Components (such as Windows,
   * BoundLists and Menus) are automatically registered with a
   * →<code>ext.Component.zIndexManager</code> at render time.
   * <p>Where this may be useful is moving Windows between two ZIndexManagers. For example,
   * to bring the Ext.MessageBox dialog under the same manager as the Desktop's
   * ZIndexManager in the desktop sample app:</p>
   * <pre>
   * MyDesktop.getDesktop().getManager().register(Ext.MessageBox);
   * </pre>
   * @param comp The Component to register.
   * @see ext.Component
   * @see ext.Component#zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-register Original Ext JS documentation of 'register'
   */
  public native function register(comp:Component):void;

  /**
   * Sends the specified Component to the back of other active Components in this ZIndexManager.
   * @param comp The id of the Component or a →<code>ext.Component</code> instance
   * @return The Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-sendToBack Original Ext JS documentation of 'sendToBack'
   * @see ext.Component
   */
  public native function sendToBack(comp:*):Component;

  /**
   * Unregisters a →<code>ext.Component</code> from this ZIndexManager. This should not
   * need to be called. Components are automatically unregistered upon destruction.
   * See →<code>register()</code>.
   * @param comp The Component to unregister.
   * @see ext.Component
   * @see #register()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ZIndexManager.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(comp:Component):void;
}
}