package ext.app {
import ext.mixin.Observable;
import ext.route.IRouteMixin;

[Native("Ext.app.BaseController", require)]
/**
 * Base class for Controllers.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html Original Ext JS documentation of 'Ext.app.BaseController'
 */
public class BaseController extends Observable implements IRouteMixin {
  /**
   * Creates new Controller.
   * @param config Configuration object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function BaseController(config:BaseController = null) {
    super();
  }

  [ExtConfig("control")]
  [Bindable]
  /**
   * Adds listeners to components selected via →<code>ext.ComponentQuery</code>. Accepts an
   * object containing component paths mapped to a hash of listener functions.
   * The function value may also be a string matching the name of a method on the
   * controller.
   * <p>In the following example the <code>updateUser</code> function is mapped to to the <code>click</code>
   * event on a button component, which is a child of the <code>useredit</code> component.</p>
   * <pre>
   *  Ext.define('MyApp.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      control: {
   *          'useredit button[action=save]': {
   *              click: 'updateUser'
   *          }
   *      },
   *
   *      updateUser: function(button) {
   *          console.log('clicked the Save button');
   *      }
   *  });
   * </pre>
   * <p>The method you pass to the listener will automatically be resolved on the controller.
   * In this case, the <code>updateUser</code> method that will get executed on the <code>button</code> <code>click</code>
   * event will resolve to the <code>updateUser</code> method on the controller,</p>
   * <p>See →<code>ext.ComponentQuery</code> for more information on component selectors.</p>
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#cfg-control Original Ext JS documentation of 'control'
   * @see #getControl()
   * @see #setControl()
   */
  public native function get control_():Object;

  [ExtConfig("control")]
  [Bindable]
  /**
   * @private
   */
  public native function set control_(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The id of this controller. You can use this id when dispatching.
   * <p>For an example of dispatching, see the examples under the
   * →<code>ext.app.Controller.listen</code> config.</p>
   * <p>If an id is not explicitly set, it will default to the controller's full classname.</p>
   * @default undefined
   * @see ext.app.Controller#listen
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#cfg-id Original Ext JS documentation of 'id'
   * @see #getId()
   * @see #setId()
   */
  public native function get id():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ExtConfig("listen")]
  [Bindable]
  /**
   * Adds listeners to different event sources (also called "event domains"). The
   * primary event domain is that of components, but there are also other event domains:
   * →<code>null</code> domain that intercepts events fired from
   * →<code>ext.GlobalEvents</code> Observable instance,
   * →<code>null</code> domain can be used to listen to events
   * fired by other Controllers, →<code>ext.app.domain.StoreEventDomain</code> domain gives access to
   * Store events, and →<code>null</code> domain can be used with
   * Ext Direct Providers to listen to their events.
   * <p>To listen to "bar" events fired by a controller with id="foo":</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      listen: {
   *          controller: {
   *              '#foo': {
   *                  bar: 'onFooBar'
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * <p>To listen to "bar" events fired by any controller, and "baz" events
   * fired by Store with storeId="baz":</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      listen: {
   *          controller: {
   *              '&#42;': {
   *                  bar: 'onAnyControllerBar'
   *              }
   *          },
   *          store: {
   *              '#baz': {
   *                  baz: 'onStoreBaz'
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * <p>To listen to "idle" events fired by →<code>ext.GlobalEvents</code> when other event
   * processing is complete and Ext JS is about to return control to the browser:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      listen: {
   *          global: {            // Global events are always fired
   *              idle: 'onIdle'   // from the same object, so there
   *          }                    // are no selectors
   *      }
   *  });
   * </pre>
   * <p>As this relates to components, the following example:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      listen: {
   *          component: {
   *              'useredit button[action=save]': {
   *                  click: 'updateUser'
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * <p>Is equivalent to:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      control: {
   *          'useredit button[action=save]': {
   *              click: 'updateUser'
   *          }
   *      }
   *  });
   * </pre>
   * <p>Of course, these can all be combined in a single call and used instead of
   * <code>control</code>, like so:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      extend: 'Ext.app.Controller',
   *
   *      listen: {
   *          global: {
   *              idle: 'onIdle'
   *          },
   *          controller: {
   *              '&#42;': {
   *                  foobar: 'onAnyFooBar'
   *              },
   *              '#foo': {
   *                  bar: 'onFooBar'
   *              }
   *          },
   *          component: {
   *              'useredit button[action=save]': {
   *                  click: 'updateUser'
   *              }
   *          },
   *          store: {
   *              '#qux': {
   *                  load: 'onQuxLoad'
   *              }
   *          }
   *      }
   *  });
   * </pre>
   * @see null
   * @see ext.#GlobalEvents ext.GlobalEvents
   * @see ext.app.domain.#StoreEventDomain ext.app.domain.StoreEventDomain
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#cfg-listen Original Ext JS documentation of 'listen'
   * @see #getListen()
   * @see #setListen()
   */
  public native function get listen_():Object;

  [ExtConfig("listen")]
  [Bindable]
  /**
   * @private
   */
  public native function set listen_(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object of routes to handle hash changes. A route can be defined in a simple way:
   * <pre>
   * routes: {
   *     'foo/bar': 'handleFoo',
   *     'user/:id': 'showUser'
   * }
   * </pre>
   * <p>Where the property is the hash (which can accept a parameter defined by a colon)
   * and the value is the method on the controller to execute. The parameters will get sent
   * in the action method.</p>
   * <p>If no routes match a given hash, an →<code>ext.GlobalEvents.unmatchedroute</code> event
   * will be fired. This can be listened to in four ways:</p>
   * <pre>
   * Ext.on('unmatchedroute', function(token) {});
   *
   * Ext.define('MyApp.controller.Foo', {
   *     extend: 'Ext.app.Controller',
   *
   *     listen: {
   *         global: {
   *             unmatchedroute: 'onUnmatchedRoute'
   *         }
   *     },
   *
   *     onUnmatchedRoute: function(token) {}
   * });
   *
   * Ext.application({
   *     name: 'MyApp',
   *
   *     listen: {
   *         global: {
   *             unmatchedroute: 'onUnmatchedRoute'
   *         }
   *     },
   *
   *     onUnmatchedRoute: function(token) {}
   * });
   *
   * Ext.application({
   *     name: 'MyApp',
   *
   *     listeners: {
   *         unmatchedroute: 'onUnmatchedRoute'
   *     },
   *
   *     onUnmatchedRoute: function(token) {}
   * });
   * </pre>
   * <p>There is also a complex means of defining a route where you can use a before action
   * and even specify your own RegEx for the parameter:</p>
   * <pre>
   * routes: {
   *     'foo/bar': {
   *         action: 'handleFoo',
   *         before: 'beforeHandleFoo'
   *     },
   *     'user/:id': {
   *         action: 'showUser',
   *         before: 'beforeShowUser',
   *         conditions: {
   *             ':id': '([0-9]+)'
   *         }
   *     }
   * }
   * </pre>
   * <p>This will only match if the <code>id</code> parameter is a number.</p>
   * <p>The before action allows you to cancel an action. Every before action will get passed
   * an <code>action</code> argument with a <code>resume</code> and <code>stop</code> methods as the last argument of the
   * method and you <i>MUST</i> execute either method:</p>
   * <pre>
   * beforeHandleFoo: function (action) {
   *     // some logic here
   *
   *     // this will allow the handleFoo action to be executed
   *     action.resume();
   * },
   * handleFoo: function () {
   *     // will get executed due to true being passed in callback in beforeHandleFoo
   * },
   * beforeShowUser: function (id, action) {
   *     // allows for async process like an Ajax
   *     Ext.Ajax.request({
   *         url: 'foo.php',
   *         success: function () {
   *             // will not allow the showUser method to be executed
   *             // but will continue other queued actions.
   *             action.stop();
   *         },
   *         failure: function () {
   *             // will not allow the showUser method to be executed
   *             // and will not allow other queued actions to be executed.
   *             action.stop(true);
   *         }
   *     });
   * },
   * showUser: function (id) {
   *     // will not get executed due to false being passed in callback in beforeShowUser
   * }
   * </pre>
   * <p>You <b>MUST</b> execute the <code>→ext.route.RouteAction.resume()</code> or
   * <code>→ext.route.RouteAction.stop()</code> method on the <code>action</code> argument. Executing
   * <code>action.resume();</code> will continue the action, <code>action.stop();</code> will prevent
   * further execution.</p>
   * <p>The default RegEx that will be used is <code>([%a-zA-Z0-9\\-\\_\\s,]+)</code> but you can specify
   * any that may suit what you need to accomplish. An example of an advanced condition
   * may be to make a parameter optional and case-insensitive:</p>
   * <pre>
   * routes: {
   *     'user:id': {
   *         action: 'showUser',
   *         before: 'beforeShowUser',
   *         conditions: {
   *             ':id': '(?:(?:\/){1}([%a-z0-9_,\s\-]+))?'
   *         }
   *     }
   * }
   * </pre>
   * <p>Each route can be named; this allows for the route to be looked up by name instead of
   * url. By default, the route's name will be the url you configure but you can provide
   * the <code>→ext.route.Route.name</code> config to override the default:</p>
   * <pre>
   * routes: {
   *     'user:id': {
   *         action: 'showUser',
   *         before: 'beforeShowUser',
   *         name: 'user',
   *         conditions: {
   *             ':id': '(?:(?:\/){1}([%a-z0-9_,\s\-]+))?'
   *         }
   *     }
   * }
   * </pre>
   * <p>The <code>user:id</code> route can not be looked up via the <code>user</code> name which is useful when using
   * <code>→redirectTo()</code>.</p>
   * <p>A wildcard route can also be defined which works exactly like any other route but will
   * always execute before any other route. To specify a wildcard route, use the <code>&#42;</code>
   * as the url:</p>
   * <pre>
   * routes: {
   *     '&#42;': 'onToken'
   * }
   * </pre>
   * <p>Since a wildcard route will execute before any other route, it can delay the execution
   * of other routes allowing for such things like a user session to be retrieved:</p>
   * <pre>
   * routes: {
   *     '&#42;': {
   *         before: 'onBeforeToken'
   *     }
   * },
   *
   * onBeforeToken: function () {
   *     return Ext.Ajax.request({
   *         url: '/user/session'
   *     });
   * }
   * </pre>
   * <p>In the above example, no other route will execute unless that
   * →<code>ext.Ajax.request()</code> returns successfully.</p>
   * <p>You can also use a wildcard route if you need to defer routes until a store has been
   * loaded when an application first starts up:</p>
   * <pre>
   * routes: {
   *     '&#42;': {
   *         before: 'onBeforeToken'
   *     }
   * },
   *
   * onBeforeToken: function (action) {
   *     var store = Ext.getStore('Settings');
   *
   *     if (store.loaded) {
   *         action.resume();
   *     } else {
   *         store.on('load', action.resume, action, { single: true });
   *     }
   * }
   * </pre>
   * <p>The valid options are configurations from →<code>ext.route.RouteHandler</code> and
   * →<code>ext.route.Route</code>.</p>
   * @see ext.SGlobalEvents#unmatchedroute ext.GlobalEvents.unmatchedroute
   * @see ext.route.RouteAction#resume()
   * @see ext.route.RouteAction#stop()
   * @see ext.route.Route#name
   * @see #redirectTo()
   * @see ext.SAjax#request() ext.Ajax.request()
   * @see ext.route.RouteHandler
   * @see ext.route.Route
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Mixin.html#cfg-routes Original Ext JS documentation of 'routes'
   * @see #getRoutes()
   * @see #setRoutes()
   */
  public native function get routes():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set routes(value:Object):void;

  /**
   * Adds listeners to components selected via →<code>ext.ComponentQuery</code>. Accepts an
   * object containing component paths mapped to a hash of listener functions.
   * <p>In the following example the <code>updateUser</code> function is mapped to to the <code>click</code>
   * event on a button component, which is a child of the <code>useredit</code> component.</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.control({
   *              'useredit button[action=save]': {
   *                  click: this.updateUser
   *              }
   *          });
   *      },
   *
   *      updateUser: function(button) {
   *          console.log('clicked the Save button');
   *      }
   *  });
   * </pre>
   * <p>Or alternatively one call <code>control</code> with two arguments:</p>
   * <pre>
   *  this.control('useredit button[action=save]', {
   *      click: this.updateUser
   *  });
   * </pre>
   * <p>See →<code>ext.ComponentQuery</code> for more information on component selectors.</p>
   * @param selectors If a String, the second argument is used as the
   * listeners, otherwise an object of selectors -&gt; listeners is assumed
   * @param listeners Config for listeners.
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#method-control Original Ext JS documentation of 'control'
   */
  public native function control(selectors:*, listeners:Object = null):void;

  /**
   * Returns the value of <code>control_</code>.
   * @see #control_
   */
  public native function getControl():Object;

  /**
   * Returns the value of <code>id</code>.
   * @see #id
   */
  override public native function getId():String;

  /**
   * Returns the value of <code>listen_</code>.
   * @see #listen_
   */
  public native function getListen():Object;

  /**
   * Returns the value of <code>routes</code>.
   * @see #routes
   */
  public native function getRoutes():Object;

  /**
   * Adds listeners to different event sources (also called "event domains"). The
   * primary event domain is that of components, but there are also other event domains:
   * →<code>null</code> domain that intercepts events fired from
   * →<code>ext.GlobalEvents</code> Observable instance, →<code>null</code>
   * domain can be used to listen to events fired by other Controllers,
   * →<code>ext.app.domain.StoreEventDomain</code> domain gives access to Store events, and
   * →<code>null</code> domain can be used with Ext Direct Providers
   * to listen to their events.
   * <p>To listen to "bar" events fired by a controller with id="foo":</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.listen({
   *              controller: {
   *                  '#foo': {
   *                     bar: this.onFooBar
   *                  }
   *              }
   *          });
   *      },
   *      ...
   *  });
   * </pre>
   * <p>To listen to "bar" events fired by any controller, and "baz" events
   * fired by Store with storeId="baz":</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.listen({
   *              controller: {
   *                  '&#42;': {
   *                     bar: this.onAnyControllerBar
   *                  }
   *              },
   *              store: {
   *                  '#baz': {
   *                      baz: this.onStoreBaz
   *                  }
   *              }
   *          });
   *      },
   *      ...
   *  });
   * </pre>
   * <p>To listen to "idle" events fired by →<code>ext.GlobalEvents</code> when other event
   * processing is complete and Ext JS is about to return control to the browser:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.listen({
   *              global: {               // Global events are always fired
   *                  idle: this.onIdle   // from the same object, so there
   *              }                       // are no selectors
   *          });
   *      }
   *  });
   * </pre>
   * <p>As this relates to components, the following example:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.listen({
   *              component: {
   *                  'useredit button[action=save]': {
   *                     click: this.updateUser
   *                  }
   *              }
   *          });
   *      },
   *      ...
   *  });
   * </pre>
   * <p>Is equivalent to:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.control({
   *              'useredit button[action=save]': {
   *                 click: this.updateUser
   *              }
   *          });
   *      },
   *      ...
   *  });
   * </pre>
   * <p>Of course, these can all be combined in a single call and used instead of
   * <code>control</code>, like so:</p>
   * <pre>
   *  Ext.define('AM.controller.Users', {
   *      init: function() {
   *          this.listen({
   *              global: {
   *                  idle: this.onIdle
   *              },
   *              controller: {
   *                  '&#42;': {
   *                     foobar: this.onAnyFooBar
   *                  },
   *                  '#foo': {
   *                     bar: this.onFooBar
   *                  }
   *              },
   *              component: {
   *                  'useredit button[action=save]': {
   *                     click: this.updateUser
   *                  }
   *              },
   *              store: {
   *                  '#qux': {
   *                      load: this.onQuxLoad
   *                  }
   *              }
   *          });
   *      },
   *      ...
   *  });
   * </pre>
   * @param to Config object containing domains, selectors and listeners.
   * @param controller The controller to add the listeners to. Defaults
   * to the current controller.
   * @see null
   * @see ext.#GlobalEvents ext.GlobalEvents
   * @see ext.app.domain.#StoreEventDomain ext.app.domain.StoreEventDomain
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.BaseController.html#method-listen Original Ext JS documentation of 'listen'
   */
  public native function listen(to:Object, controller:Controller = null):void;

  /**
   * @inheritDoc
   */
  public native function redirectTo(hash:*, opt:Object):Boolean;

  /**
   * Sets the value of <code>control_</code>.
   * @param control_ The new value.
   * @see #control_
   */
  public native function setControl(control_:Object):void;

  /**
   * Sets the value of <code>id</code>.
   * @param id The new value.
   * @see #id
   */
  override public native function setId(id:String):void;

  /**
   * Sets the value of <code>listen_</code>.
   * @param listen_ The new value.
   * @see #listen_
   */
  public native function setListen(listen_:Object):void;

  /**
   * Sets the value of <code>routes</code>.
   * @param routes The new value.
   * @see #routes
   */
  public native function setRoutes(routes:Object):void;
}
}