package ext.app {
import ext.Base;
import ext.ExtClass;

[Native("Ext.app.EventDomain", require)]
/**
 * This class is a base class for an event domain. In the context of MVC, an "event domain"
 * is one or more base classes that fire events to which a Controller wants to listen. A
 * controller listens to events by describing the selectors for events of interest to it.
 * <p>Matching selectors to the firer of an event is one key aspect that defines an event
 * domain. All event domain instances must provide a <code>→match()</code> method that tests selectors
 * against the event firer.</p>
 * <p>When an event domain instance is created (typically as a <code>singleton</code>), its <code>type</code>
 * property is used to catalog the domain in the
 * →<code>ext.app.EventDomain.instances</code> map.</p>
 * <p>There are five event domains provided by default:</p>
 * <ul>
 * <li><i>Component domain</i> (→<code>null</code>). This is the primary event domain that
 * has been available since Ext JS MVC was introduced. This domain is defined as any class that
 * extends →<code>ext.Component</code>, where the selectors use
 * <i>Ext.ComponentQuery</i> (→<code>ext.ComponentQuery.query()</code>).</li>
 * <li><i>Global domain</i> (→<code>null</code>). This domain provides Controllers with access
 * to events fired from →<code>ext.GlobalEvents</code> Observable instance. These events represent
 * the state of the application as a whole, and are always anonymous. Because of this, Global
 * domain does not provide selectors at all.</li>
 * <li><i>Controller domain</i> (→<code>null</code>). This domain includes all classes
 * that extend →<code>ext.app.Controller</code>. Events fired by Controllers will be available
 * within this domain; selectors are either Controller's →<code>ext.app.Controller.id</code> or
 * '&#42;' wildcard for any Controller.</li>
 * <li><i>Store domain</i> (→<code>ext.app.domain.StoreEventDomain</code>). This domain is for classes extending
 * →<code>ext.data.AbstractStore</code>. Selectors are either Store's
 * →<code>ext.data.AbstractStore.storeId</code> or '&#42;' wildcard for any Store.</li>
 * <li><i>Direct domain</i> (→<code>null</code>). This domain includes all classes that extend
 * →<code>ext.direct.Provider</code>. Selectors are either Provider's →<code>ext.direct.Provider.id</code>
 * or '&#42;' wildcard for any Provider. This domain is optional and will be loaded only if
 * →<code>ext.direct.DirectManager</code> singleton is required in your application.</li>
 * </ul>
 * @see #match()
 * @see ext.app.EventDomain#instances
 * @see null
 * @see ext.Component
 * @see ext.SComponentQuery#query() ext.ComponentQuery.query()
 * @see ext.#GlobalEvents ext.GlobalEvents
 * @see ext.app.Controller
 * @see ext.app.Controller#id
 * @see ext.app.domain.#StoreEventDomain ext.app.domain.StoreEventDomain
 * @see ext.data.AbstractStore
 * @see ext.data.AbstractStore#storeId
 * @see ext.direct.Provider
 * @see ext.direct.Provider#id
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.EventDomain.html Original Ext JS documentation of 'Ext.app.EventDomain'
 */
public class EventDomain extends Base {
  /**
   * An object map containing <code>→ext.app.EventDomain</code> instances keyed by the value
   * of their <code>type</code> property.
   * @default {}
   * @see ext.app.EventDomain
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.EventDomain.html#static-property-instances Original Ext JS documentation of 'instances'
   */
  public static native function get instances():*;

  /**
   * @private
   */
  public static native function set instances(value:*):void;

  /**
   * @param config @inheritDoc
   */
  public function EventDomain(config:EventDomain = null) {
    super();
  }

  [ExtConfig]
  /**
   * Name of the identifier property for this event domain.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.EventDomain.html#cfg-idProperty Original Ext JS documentation of 'idProperty'
   */
  public native function get idProperty():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set idProperty(value:String):void;

  /**
   * This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.
   * Default matching is very simple: a match is true when selector equals target's
   * →<code>idProperty</code>, or when selector is '&#42;' wildcard to match any
   * target.
   * @param target The firer of the event.
   * @param selector The selector to which to match the <code>target</code>.
   * @return <code>true</code> if the <code>target</code> matches the <code>selector</code>.
   * @see #idProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.EventDomain.html#method-match Original Ext JS documentation of 'match'
   */
  protected native function match(target:Object, selector:String):Boolean;

  /**
   * This method is called by the derived class to monitor <code>fireEvent</code> calls. Any call
   * to <code>fireEvent</code> on the target Observable will be intercepted and dispatched to any
   * listening Controllers. Assuming the original <code>fireEvent</code> method does not return
   * <code>false</code>, the event is passed to the <code>→dispatch()</code> method of this object.
   * <p>This is typically called in the <code>constructor</code> of derived classes.</p>
   * @param observable The Observable to monitor for events.
   * @see #dispatch()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.EventDomain.html#method-monitor Original Ext JS documentation of 'monitor'
   */
  protected native function monitor(observable:ExtClass):void;
}
}