package ext.app {
import ext.mixin.Observable;

[Native("Ext.app.Profile", require)]
/**
 * A Profile represents a range of devices that fall under a common category. For the vast majority
 * of apps that use device profiles, the app defines a Phone profile and a Tablet profile. Doing
 * this enables you to easily customize the experience for the different sized screens offered by
 * those device types.
 * <p>Only one Profile can be active at a time, and each Profile defines a simple →<code>isActive()</code>
 * function that should return either true or false. The first Profile to return true from its
 * isActive function is set as your Application's
 * <i>current profile</i> (→<code>ext.app.Application.currentProfile</code>).</p>
 * <p>A Profile can define any number of →<code>models</code>, →<code>views</code>, →<code>controllers</code> and
 * →<code>stores</code> which will be loaded if the Profile is activated. It can also define
 * a →<code>launch()</code> function that will be called after all of its dependencies have been loaded,
 * just before the <i>application launch</i> (→<code>ext.app.Application.launch()</code>) function is called.</p>
 * <p><b><i>Sample Usage</i></b></p>
 * <p>First you need to tell your Application about your Profile(s):</p>
 * <pre>
 * Ext.application({
 *     name: 'MyApp',
 *     profiles: ['Phone', 'Tablet']
 * });
 * </pre>
 * <p>This will load app/profile/Phone.js and app/profile/Tablet.js. Here's how we might define the
 * Phone profile:</p>
 * <pre>
 * Ext.define('MyApp.profile.Phone', {
 *     extend: 'Ext.app.Profile',
 *
 *     views: ['Main'],
 *
 *     isActive: function() {
 *         return Ext.os.is('Phone');
 *     }
 * });
 * </pre>
 * <p>The isActive function returns true if we detect that we are running on a phone device. If that
 * is the case the Application will set this Profile active and load the 'Main' view specified
 * in the Profile's →<code>views</code> config.</p>
 * <p><b><i>Class Specializations</i></b></p>
 * <p>Because Profiles are specializations of an application, all of the models, views, controllers
 * and stores defined in a Profile are expected to be namespaced under the name of the Profile.
 * Here's an expanded form of the example above:</p>
 * <pre>
 * Ext.define('MyApp.profile.Phone', {
 *     extend: 'Ext.app.Profile',
 *
 *     views: ['Main'],
 *     controllers: ['Signup'],
 *     models: ['MyApp.model.Group'],
 *
 *     isActive: function() {
 *         return Ext.os.is('Phone');
 *     }
 * });
 * </pre>
 * <p>In this case, the Profile is going to load <i>app/view/phone/Main.js</i>,
 * <i>app/controller/phone/Signup.js</i> and <i>app/model/Group.js</i>. Notice that in each of the first
 * two cases the name of the profile ('phone' in this case) was injected into the class names.
 * In the third case we specified the full Model name (for Group) so the Profile name was not
 * injected.</p>
 * <p>For a fuller understanding of the ideas behind Profiles and how best to use them in your app,
 * we suggest you read the <a href="https://docs.sencha.com/touch/2.4/core_concepts/device_profiles.html">device profiles guide</a>.</p>
 * @see #isActive()
 * @see ext.app.Application#currentProfile
 * @see #models
 * @see #views
 * @see #controllers
 * @see #stores
 * @see #launch()
 * @see ext.app.Application#launch()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html Original Ext JS documentation of 'Ext.app.Profile'
 */
public class Profile extends Observable {
  /**
   * Creates a new Profile instance
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Profile(config:Profile = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The →<code>ext.app.Application</code> instance to which this Profile is
   * bound. This is set automatically.
   * @see ext.app.Application
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-application Original Ext JS documentation of 'application'
   * @see #getApplication()
   */
  public native function get application():Application;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * Any additional <i>Controllers</i> (→<code>ext.app.Controller</code>) to load for this profile.
   * Note that each item here will be prepended with the Profile namespace when loaded.
   * <p>Example usage:</p>
   * <pre>
   * controllers: [
   *     'Users',
   *     'MyApp.controller.Products'
   * ]
   * </pre>
   * <p>This will load <i>MyApp.controller.tablet.Users</i> and <i>MyApp.controller.Products</i>.</p>
   * @default []
   * @see ext.app.Controller
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-controllers Original Ext JS documentation of 'controllers'
   * @see #getControllers()
   * @see #setControllers()
   */
  public native function get controllers():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set controllers(value:Array):void;

  /**
   * <code>true</code> to identify an object as an instance of <code>→ext.app.Profile</code>
   * @default true
   * @see ext.app.Profile
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#property-isProfile Original Ext JS documentation of 'isProfile'
   */
  public native function get isProfile():Boolean;

  /**
   * @private
   */
  public native function set isProfile(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-mainView Original Ext JS documentation of 'mainView'
   * @see #getMainView()
   * @see #setMainView()
   */
  public native function get mainView():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set mainView(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * Any additional <i>Models</i> (→<code>ext.app.Application.models</code>) to load for this profile.
   * Note that each item here will be prepended with the Profile namespace when loaded.
   * <p>Example usage:</p>
   * <pre>
   * models: [
   *     'Group',
   *     'MyApp.model.User'
   * ]
   * </pre>
   * <p>This will load <i>MyApp.model.tablet.Group</i> and <i>MyApp.model.User</i>.</p>
   * @default []
   * @see ext.app.Application#models
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-models Original Ext JS documentation of 'models'
   * @see #getModels()
   * @see #setModels()
   */
  public native function get models():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set models(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of this Profile. Defaults to the last section of the class name (e.g. a profile
   * called MyApp.profile.Phone will default the name to 'Phone').
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   * @see #setName()
   */
  public native function get name():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set name(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The namespace that this Profile's classes can be found in. Defaults to the lowercase
   * Profile →<code>name</code>, for example a Profile called MyApp.profile.Phone will by default
   * have a 'phone' namespace, which means that this Profile's additional models, stores, views
   * and controllers will be loaded from the MyApp.model.phone.<i>, MyApp.store.phone.</i>,
   * MyApp.view.phone.&#42; and MyApp.controller.phone.&#42; namespaces respectively.
   * @see #name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-namespace Original Ext JS documentation of 'namespace'
   * @see #getNamespace()
   * @see #setNamespace()
   */
  public native function get namespace():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set namespace(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * Any additional <i>Stores</i> (→<code>ext.app.Application.stores</code>) to load for this profile.
   * Note that each item here will be prepended with the Profile namespace when loaded.
   * <p>Example usage:</p>
   * <pre>
   * stores: [
   *     'Users',
   *     'MyApp.store.Products'
   * ]
   * </pre>
   * <p>This will load <i>MyApp.store.tablet.Users</i> and <i>MyApp.store.Products</i>.</p>
   * @default []
   * @see ext.app.Application#stores
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-stores Original Ext JS documentation of 'stores'
   * @see #getStores()
   * @see #setStores()
   */
  public native function get stores():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stores(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * This config allows the active profile to define a set of <code>xtypes</code> and map them
   * to desired classes and default configurations. Normally an <code>xtype</code> is statically
   * declared by a <i>component</i> (→<code>ext.Component</code>) in its class definition. This
   * mechanism allows the active profile to control a set of these types.
   * <p>Example:</p>
   * <pre>
   *  views: {
   *      // The "main" xtype maps to MyApp.view.tablet.Main
   *      //
   *      main: 'MyApp.view.tablet.Main',
   *
   *      // The "inbox" xtype maps to a subclass of MyApp.view.Inbox (created
   *      // by this mechanism) that sets the "mode" config to "compact".
   *      //
   *      inbox: {
   *          xclass: 'MyApp.view.Inbox',
   *          mode: 'compact'
   *      }
   *  }
   * </pre>
   * <p>Note that class names used in this form must be full class names, unlike the
   * historical usage of <code>→views</code>. Further, these views cannot be accessed using the
   * <code>getView</code> method but rather via their assigned <code>xtype</code>.</p>
   * <p>The historical usage of this config is enabled when an array is passed. In this
   * case, these are simply additional →<code>ext.app.Application.views</code> to
   * load for this profile. Note that each item here will be prepended with the
   * Profile namespace when loaded.</p>
   * <p>Example usage:</p>
   * <pre>
   * views: [
   *     'Main',
   *     'MyApp.view.Login'
   * ]
   * </pre>
   * <p>This will load <i>MyApp.view.tablet.Main</i> and <i>MyApp.view.Login</i>. While supported,
   * this usage is discouraged in favor of <code>xtype</code> mapping.</p>
   * @default []
   * @see ext.Component
   * @see #views
   * @see ext.app.Application#views
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#cfg-views Original Ext JS documentation of 'views'
   * @see #getViews()
   * @see #setViews()
   */
  public native function get views():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set views(value:*):void;

  /**
   * Returns the value of <code>application</code>.
   * @see #application
   */
  public native function getApplication():Application;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>controllers</code>.
   * @see #controllers
   */
  public native function getControllers():Array;

  /**
   * Returns the value of <code>mainView</code>.
   * @see #mainView
   */
  public native function getMainView():String;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>models</code>.
   * @see #models
   */
  public native function getModels():Array;

  /**
   * Returns the value of <code>name</code>.
   * @see #name
   */
  public native function getName():String;

  /**
   * Returns the value of <code>namespace</code>.
   * @see #namespace
   */
  public native function getNamespace():String;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>stores</code>.
   * @see #stores
   */
  public native function getStores():Array;

  /**
   * Returns the value of <code>views</code>.
   * @see #views
   */
  public native function getViews():*;

  /**
   * This method is called once the profile is determined to be the active profile. This
   * initialization is performed before controllers are initialized and therefore also
   * before launch.
   * @since 6.0.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#method-init Original Ext JS documentation of 'init'
   */
  protected native function init():void;

  /**
   * Determines whether or not this Profile is active on the device isActive is executed on.
   * Should return true if this profile is meant to be active on this device, false otherwise.
   * Each Profile should implement this function (the default implementation just returns false).
   * @return True if this Profile should be activated on the device it is running on,
   * false otherwise
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#method-isActive Original Ext JS documentation of 'isActive'
   */
  public native function isActive():Boolean;

  /**
   * The launch function is called by the →<code>ext.app.Application</code> if this
   * Profile's →<code>isActive()</code> function returned true. This is typically the best place to run
   * any profile-specific app launch code. Example usage:
   * <pre>
   * launch: function() {
   *     Ext.create('MyApp.view.tablet.Main');
   * }
   * </pre>
   * @see ext.app.Application
   * @see #isActive()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.Profile.html#method-launch Original Ext JS documentation of 'launch'
   */
  public native function launch():void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>controllers</code>.
   * @param controllers The new value.
   * @see #controllers
   */
  public native function setControllers(controllers:Array):void;

  /**
   * Sets the value of <code>mainView</code>.
   * @param mainView The new value.
   * @see #mainView
   */
  public native function setMainView(mainView:String):void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>models</code>.
   * @param models The new value.
   * @see #models
   */
  public native function setModels(models:Array):void;

  /**
   * Sets the value of <code>name</code>.
   * @param name The new value.
   * @see #name
   */
  public native function setName(name:String):void;

  /**
   * Sets the value of <code>namespace</code>.
   * @param namespace The new value.
   * @see #namespace
   */
  public native function setNamespace(namespace:String):void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>stores</code>.
   * @param stores The new value.
   * @see #stores
   */
  public native function setStores(stores:Array):void;

  /**
   * Sets the value of <code>views</code>.
   * @param views The new value.
   * @see #views
   */
  public native function setViews(views:*):void;
}
}