package ext.app {
import ext.Component;
import ext.data.Session;
import ext.data.Store;
import ext.mixin.IFactoryable;

[Native("Ext.app.ViewController", require)]
/**
 * A view controller is a controller that can be attached to a specific view
 * instance so it can manage the view and its child components. Each instance of the view
 * will have a new view controller, so the instances are isolated.
 * <p>When a view controller is specified on a view, events and other handlers that use strings as
 * values will be automatically connected with the appropriate methods in the controller's class.</p>
 * <p>Sample usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('MyViewController', {
 *     extend : 'Ext.app.ViewController',
 *     alias: 'controller.myview',
 *
 *     // This method is called as a "handler" for the Add button in our view
 *     onAddClick: function() {
 *         Ext.Msg.alert('Add', 'The Add button was clicked');
 *     }
 * });
 *
 * Ext.define('MyView', {
 *     extend: 'Ext.Panel',
 *     controller: 'myview',
 *
 *     items: [{
 *         xtype: 'button',
 *         text: 'Add',
 *         handler: 'onAddClick',  // calls MyViewController's onAddClick method
 *     }]
 * });
 *
 * Ext.onReady(function() {
 *     new MyView({
 *         renderTo: Ext.getBody(),
 *         width: 400,
 *         height: 200
 *     });
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html Original Ext JS documentation of 'Ext.app.ViewController'
 */
public class ViewController extends BaseController implements IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function ViewController(config:ViewController = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A declarative set of bindings to the →<code>getViewModel()</code> for this
   * controller. The key should be the method, the value should be
   * the bind statement:
   * <pre>
   * Ext.define('MyApp.TestController', {
   *     extend: 'Ext.app.ViewController',
   *
   *     bindings: {
   *         onTotalChange: '{total}',
   *         onCoordsChange: '({x}, {y})',
   *         onProductChange: {
   *             amount: '{qty}',
   *             rating: '{rating}'
   *         }
   *     },
   *
   *      onTotalChange: function(total) {
   *          console.log(total);
   *      },
   *
   *      onCoordsChange: function(coords) {
   *          console.log('The coordinates are: ', coords);
   *      },
   *
   *      onProductChange: function(productInfo) {
   *          console.log('Amount: ', productInfo.amount,' Rating: ', productInfo.rating);
   *      }
   * });
   * </pre>
   * @since 6.5.0
   * @see #getViewModel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#cfg-bindings Original Ext JS documentation of 'bindings'
   * @see #getBindings()
   * @see #setBindings()
   */
  public native function get bindings():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set bindings(value:Object):void;

  /**
   * If this property is specified by the target class of this mixin its properties are
   * used to configure the created <code>→ext.Factory</code>.
   * @default {
   *     // configure Factoryable
   *     type: 'controller'
   * }
   * @see ext.Factory
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#property-factoryConfig Original Ext JS documentation of 'factoryConfig'
   */
  public native function get factoryConfig():Object;

  /**
   * @private
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * Template method called by the owning component's
   * →<code>ext.Component.afterRender()</code> method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param component The owner component attached to the
   * ViewController
   * @see ext.Component#afterRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-afterRender Original Ext JS documentation of 'afterRender'
   */
  public native function afterRender(component:Component):void;

  /**
   * Called before the view initializes. This is called before the view's
   * initComponent method has been called.
   * @param view The view
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-beforeInit Original Ext JS documentation of 'beforeInit'
   */
  protected native function beforeInit(view:Component):void;

  /**
   * Template method called by the owning component's
   * →<code>ext.Component.beforeRender()</code> method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param component The owner component attached to the
   * ViewController
   * @see ext.Component#beforeRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-beforeRender Original Ext JS documentation of 'beforeRender'
   */
  public native function beforeRender(component:Component):void;

  /**
   * Template method called by the owning component's
   * →<code>ext.Component.onBoxReady()</code> method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param component The owner component attached to the
   * ViewController
   * @see ext.Component#onBoxReady()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-boxReady Original Ext JS documentation of 'boxReady'
   */
  public native function boxReady(component:Component):void;

  /**
   * This method closes the associated view. The manner in which this is done (that is,
   * the method called to close the view) is specified by <code>closeViewAction</code>.
   * <p>It is common for views to map one or more events to this method to allow the view
   * to be closed.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-closeView Original Ext JS documentation of 'closeView'
   */
  public native function closeView():void;

  /**
   * Destroy the view controller.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Fires an event on the view. See →<code>ext.Component.fireEvent()</code>.
   * @param eventName The name of the event to fire.
   * @param args Variable number of parameters are passed to handlers.
   * @return returns false if any of the handlers return false otherwise it returns
   * true.
   * @see ext.Component#fireEvent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-fireViewEvent Original Ext JS documentation of 'fireViewEvent'
   */
  protected native function fireViewEvent(eventName:String, ...args):Boolean;

  /**
   * Returns the value of <code>bindings</code>.
   * @see #bindings
   */
  public native function getBindings():Object;

  /**
   * Returns an object holding the descendants of this view keyed by their
   * <code>→ext.Component.reference</code>. This object should not be held
   * past the scope of the function calling this method. It will not be valid if items
   * are added or removed from this or any sub-container.
   * <p>The intended usage is shown here (assume there are 3 components with reference
   * values of "foo", "bar" and "baz" at some level below this container):</p>
   * <pre>
   *  onClick: function () {
   *      var refs = this.getReferences();
   *
   *      // using "refs" we can access any descendant by its "reference"
   *
   *      refs.foo.getValue() + refs.bar.getValue() + refs.baz.getValue();
   *  }
   * </pre>
   * <p>If <code>this</code> component has a <code>→ext.Component.reference</code> assigned
   * to it, that is <b>not</b> included in this object. That reference is understood to
   * belong to the ancestor container configured as the <code>referenceHolder</code>.</p>
   * @since 5.0.0
   * @return An object with each child reference. This will be <code>null</code> if this
   * container has no descendants with a <code>→ext.Component.reference</code>
   * specified.
   * @see ext.Component#reference
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-getReferences Original Ext JS documentation of 'getReferences'
   */
  public native function getReferences():Object;

  /**
   * Get a →<code>ext.data.Session</code> attached to the view for this controller.
   * See →<code>ext.Component.lookupSession()</code>.
   * @since 5.0.0
   * @return The session. <code>null</code> if no session is found.
   * @see ext.data.Session
   * @see ext.Component#lookupSession()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-getSession Original Ext JS documentation of 'getSession'
   */
  public native function getSession():Session;

  /**
   * Get a →<code>ext.data.Store</code> attached to the <i>ViewModel</i> (→<code>getViewModel()</code>) attached to
   * this controller. See →<code>ext.app.ViewModel.getStore()</code>.
   * @since 5.0.0
   * @param name The name of the store.
   * @return The store. <code>null</code> if no store is found, or there is no
   * →<code>ext.app.ViewModel</code> attached to the view for this controller.
   * @see ext.data.Store
   * @see #getViewModel()
   * @see ext.app.ViewModel#getStore()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-getStore Original Ext JS documentation of 'getStore'
   * @see ext.app.ViewModel
   */
  public native function getStore(name:String):Store;

  /**
   * Get the view for this controller.
   * @return The view.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-getView Original Ext JS documentation of 'getView'
   */
  public native function getView():Component;

  /**
   * Get a →<code>ext.app.ViewModel</code> attached to the view for this controller.
   * See →<code>ext.Component.lookupViewModel()</code>.
   * @since 5.0.0
   * @return The ViewModel. <code>null</code> if no ViewModel is found.
   * @see ext.app.ViewModel
   * @see ext.Component#lookupViewModel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-getViewModel Original Ext JS documentation of 'getViewModel'
   */
  public native function getViewModel():ViewModel;

  /**
   * Called when the view initializes. This is called after the view's initComponent
   * method has been called.
   * @param view The view
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-init Original Ext JS documentation of 'init'
   */
  protected native function init(view:Component):void;

  /**
   * Called when the view model instance for an attached view is first created.
   * @param viewModel The ViewModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-initViewModel Original Ext JS documentation of 'initViewModel'
   */
  protected native function initViewModel(viewModel:ViewModel):void;

  /**
   * Gets a reference to the component with the specified →<code>ext.Component.reference</code>
   * value.
   * <p>The method is a short-hand for the →<code>lookupReference()</code> method.</p>
   * @since 6.0.1
   * @param key The name of the reference to lookup.
   * @return The component, <code>null</code> if the reference doesn't exist.
   * @see ext.Component#reference
   * @see #lookupReference()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-lookup Original Ext JS documentation of 'lookup'
   */
  public native function lookup(key:String):Component;

  /**
   * Gets a reference to the component with the specified →<code>ext.Component.reference</code>
   * value.
   * <p>The →<code>lookup()</code> method is a short-hand version of this method.</p>
   * @since 5.0.0
   * @param key The name of the reference to lookup.
   * @return The component, <code>null</code> if the reference doesn't exist.
   * @see ext.Component#reference
   * @see #lookup()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-lookupReference Original Ext JS documentation of 'lookupReference'
   */
  public native function lookupReference(key:String):Component;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.ViewController.html#method-setBind Original Ext JS documentation of 'setBind'
   */
  public native function setBind():void;

  /**
   * Sets the value of <code>bindings</code>.
   * @param bindings The new value.
   * @see #bindings
   */
  public native function setBindings(bindings:Object):void;
}
}