package ext.app.bind {
import ext.util.Schedulable;

[Native("Ext.app.bind.BaseBinding", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class is the base for <code>Binding</code> and <code>MultiBinding</code>.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.BaseBinding.html Original Ext JS documentation of 'Ext.app.bind.BaseBinding'
 */
public class BaseBinding extends Schedulable {
  /**
   * @param config @inheritDoc
   */
  public function BaseBinding(config:BaseBinding = null) {
    super();
  }

  [ExtConfig]
  /**
   * This option instructs the binding to call its <code>→destroy()</code> method immediately after
   * delivering the initial value.
   * @default false
   * @since 5.0.0
   * @see #destroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.BaseBinding.html#cfg-single Original Ext JS documentation of 'single'
   */
  public native function get single():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set single(value:Boolean):void;
}
}