package ext.app.bind {

[Native("Ext.app.bind.Binding", require)]
/**
 * This class is created to manage a direct bind. <code>→ext.app.ViewModel</code> returns this from
 * its →<code>ext.app.ViewModel.bind()</code> method.
 * @see ext.app.ViewModel
 * @see ext.app.ViewModel#bind()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html Original Ext JS documentation of 'Ext.app.bind.Binding'
 */
public class Binding extends BaseBinding {
  /**
   * @param config @inheritDoc
   */
  public function Binding(config:Binding = null) {
    super();
  }

  [ExtConfig]
  /**
   * Normally a binding is only notified of changes to its bound property, but if that
   * property is an object it is sometimes helpful to be notified of changes to its
   * properties. To receive notifications of changes to all properties of a bound object,
   * set this to <code>true</code>.
   * @default false
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#cfg-deep Original Ext JS documentation of 'deep'
   */
  public native function get deep():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deep(value:Boolean):void;

  /**
   * Binds to the <code>validation</code> association for the bound property. For example, when a
   * binding is bound to something like this:
   * <pre>
   *  var binding = viewModel.bind('{theUser.name}', ...);
   * </pre>
   * <p>The validation status for the "name" property can be requested like so:</p>
   * <pre>
   *  var validationBinding = binding.bindValidation(fn, scope);
   * </pre>
   * <p>Calling this method in the above example would be equivalent to the following bind:</p>
   * <pre>
   *  var validationBinding = viewModel.bind('{theUser.validation.name}', fn, scope);
   * </pre>
   * <p>The primary reason to use this method is in cases where the original bind expression
   * is not known.</p>
   * <p>For example, this method is used by <code>→ext.form.field.BaseField</code> when given the
   * <code>→ext.Component.modelValidation</code> config is set. As such it
   * not common for users to need to call this method.</p>
   * @since 5.0.0
   * @param callback The function to call when the validation changes.
   * @param scope The scope on which to call the <code>callback</code>.
   * @return A binding to the validation of the bound property.
   * @see ext.form.field.BaseField
   * @see ext.Component#modelValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-bindValidation Original Ext JS documentation of 'bindValidation'
   */
  public native function bindValidation(callback:Function, scope:Object = null):Binding;

  /**
   * Destroys this binding. No further calls will be made to the callback method. No
   * methods should be called on this binding after calling this method.
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the diagnostic name for this binding.
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-getFullName Original Ext JS documentation of 'getFullName'
   */
  public native function getFullName():String;

  /**
   * Returns the current value of the bound property. If this binding is not
   * <i>available</i> (→<code>isAvailable()</code>) the value will be <code>undefined</code>.
   * @since 5.0.0
   * @return The value of the bound property.
   * @see #isAvailable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():*;

  /**
   * Returns <code>true</code> if the bound property is available. If this returns <code>false</code>,
   * it generally means the value is not reachable because the a parent value is
   * not present.
   * @since 5.1.2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-isAvailable Original Ext JS documentation of 'isAvailable'
   */
  public native function isAvailable():Boolean;

  /**
   * Returns <code>true</code> if the bound property is loading. In the general case this means
   * that the value is just not available yet. In specific cases, when the bound property
   * is an <code>→ext.data.Model</code> it means that a request to the server is in progress to get
   * the record. For an <code>→ext.data.Store</code> it means that
   * <code>→ext.data.Store.load()</code> has been called on the store but it is
   * still in progress.
   * @since 5.0.0
   * @see ext.data.Model
   * @see ext.data.Store
   * @see ext.data.Store#load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-isLoading Original Ext JS documentation of 'isLoading'
   */
  public native function isLoading():Boolean;

  /**
   * This method returns <code>true</code> if this binding can only be read. If this method returns
   * <code>false</code> then the binding can be set using <code>→setValue()</code> (meaning this binding can be
   * a two-way binding).
   * @since 5.0.0
   * @see #setValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-isReadOnly Original Ext JS documentation of 'isReadOnly'
   */
  public native function isReadOnly():Boolean;

  /**
   * Tells the bound property to refresh itself. This has meaning when the bound property
   * is something like an <code>→ext.data.Model</code> and an <code>→ext.data.Store</code> but does nothing in
   * most cases.
   * @since 5.0.0
   * @see ext.data.Model
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-refresh Original Ext JS documentation of 'refresh'
   */
  public native function refresh():void;

  /**
   * Sets the value of the bound property. This will throw an error in debug mode if
   * this binding <code>→isReadOnly()</code>. This method will climb to set data on
   * a parent view model of this binding if appropriate. See "Inheriting Data" in the
   * →<code>ext.app.ViewModel</code> class introduction for more information.
   * @since 5.0.0
   * @param value The new value.
   * @see #isReadOnly()
   * @see ext.app.ViewModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.app.bind.Binding.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  public native function setValue(value:*):void;
}
}