package ext.button {
import ext.Component;
import ext.Template;
import ext.event.Event;
import ext.menu.Menu;
import ext.mixin.IQueryable;

[Native("Ext.button.Button", require)]
/**
 * @see ext.button.events.Button_pressedEvent.BEFORE_TOGGLE
 * @eventType ext.button.events.Button_pressedEvent.BEFORE_TOGGLE
 */
[Event(name='onBeforeToggle', type='ext.button.events.Button_pressedEvent')]
/**
 * @see ext.button.events.Button_eEvent.CLICK
 * @eventType ext.button.events.Button_eEvent.CLICK
 */
[Event(name='onClick', type='ext.button.events.Button_eEvent')]
/**
 * @see ext.button.events.Button_newGlyph_oldGlyphEvent.GLYPH_CHANGE
 * @eventType ext.button.events.Button_newGlyph_oldGlyphEvent.GLYPH_CHANGE
 */
[Event(name='onGlyphChange', type='ext.button.events.Button_newGlyph_oldGlyphEvent')]
/**
 * @see ext.button.events.Button_oldIcon_newIconEvent.ICON_CHANGE
 * @eventType ext.button.events.Button_oldIcon_newIconEvent.ICON_CHANGE
 */
[Event(name='onIconChange', type='ext.button.events.Button_oldIcon_newIconEvent')]
/**
 * @see ext.button.events.Button_menuEvent.MENU_HIDE
 * @eventType ext.button.events.Button_menuEvent.MENU_HIDE
 */
[Event(name='onMenuHide', type='ext.button.events.Button_menuEvent')]
/**
 * @see ext.button.events.Button_menuEvent.MENU_SHOW
 * @eventType ext.button.events.Button_menuEvent.MENU_SHOW
 */
[Event(name='onMenuShow', type='ext.button.events.Button_menuEvent')]
/**
 * @see ext.button.events.Button_menu_eEvent.MENU_TRIGGER_OUT
 * @eventType ext.button.events.Button_menu_eEvent.MENU_TRIGGER_OUT
 */
[Event(name='onMenuTriggerOut', type='ext.button.events.Button_menu_eEvent')]
/**
 * @see ext.button.events.Button_menu_eEvent.MENU_TRIGGER_OVER
 * @eventType ext.button.events.Button_menu_eEvent.MENU_TRIGGER_OVER
 */
[Event(name='onMenuTriggerOver', type='ext.button.events.Button_menu_eEvent')]
/**
 * @see ext.button.events.Button_eEvent.MOUSE_OUT
 * @eventType ext.button.events.Button_eEvent.MOUSE_OUT
 */
[Event(name='onMouseOut', type='ext.button.events.Button_eEvent')]
/**
 * @see ext.button.events.Button_eEvent.MOUSE_OVER
 * @eventType ext.button.events.Button_eEvent.MOUSE_OVER
 */
[Event(name='onMouseOver', type='ext.button.events.Button_eEvent')]
/**
 * @see ext.button.events.Button_oldText_newTextEvent.TEXT_CHANGE
 * @eventType ext.button.events.Button_oldText_newTextEvent.TEXT_CHANGE
 */
[Event(name='onTextChange', type='ext.button.events.Button_oldText_newTextEvent')]
/**
 * @see ext.button.events.Button_pressedEvent.TOGGLE
 * @eventType ext.button.events.Button_pressedEvent.TOGGLE
 */
[Event(name='onToggle', type='ext.button.events.Button_pressedEvent')]
/**
 * Create simple buttons with this component. Customizations include <i>aligned</i> (→<code>iconAlign</code>)
 * <i>icons</i> (→<code>iconCls</code>), <i>dropdown menus</i> (→<code>menu</code>), <i>tooltips</i> (→<code>tooltip</code>)
 * and <i>sizing options</i> (→<code>scale</code>). Specify a →<code>handler</code> to run code when
 * a user clicks the button, or use →<code>listeners</code> for other events such as
 * →<code>event:onMouseOver</code>. Example usage:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     text: 'Click me',
 *     renderTo: Ext.getBody(),
 *     handler: function() {
 *         alert('You clicked the button!');
 *     }
 * });
 * </pre>
 * <p>The →<code>handler</code> configuration can also be updated dynamically using the →<code>setHandler()</code>
 * method. Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     text    : 'Dynamic Handler Button',
 *     renderTo: Ext.getBody(),
 *     handler : function() {
 *         // this button will spit out a different number every time you click it.
 *         // so firstly we must check if that number is already set:
 *         if (this.clickCount) {
 *             // looks like the property is already set, so lets just add 1 to that number
 *             // and alert the user
 *             this.clickCount++;
 *             alert('You have clicked the button "' + this.clickCount +
 *                   '" times.\n\nTry clicking it again..');
 *         } else {
 *             // if the clickCount property is not set, we will set it and alert the user
 *             this.clickCount = 1;
 *             alert('You just clicked the button for the first time!\n\n' +
 *                   'Try pressing it again..');
 *         }
 *     }
 * });
 * </pre>
 * <p>A button within a container:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Container', {
 *     renderTo: Ext.getBody(),
 *     items   : [
 *         {
 *             xtype: 'button',
 *             text : 'My Button'
 *         }
 *     ]
 * });
 * </pre>
 * <p>A useful option of Button is the →<code>scale</code> configuration. This configuration has three
 * different options:</p>
 * <ul>
 * <li><code>'small'</code></li>
 * <li><code>'medium'</code></li>
 * <li><code>'large'</code></li>
 * </ul>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     renderTo: document.body,
 *     text    : 'Click me',
 *     scale   : 'large'
 * });
 * </pre>
 * <p>Buttons can also be toggled. To enable this, you simple set the →<code>enableToggle</code> property
 * to <code>true</code>.
 * Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     renderTo: Ext.getBody(),
 *     text: 'Click Me',
 *     enableToggle: true
 * });
 * </pre>
 * <p>You can assign a menu to a button by using the →<code>menu</code> configuration. This standard
 * configuration can either be a reference to a <i>menu</i> (→<code>ext.menu.Menu</code>) object,
 * a <i>menu</i> (→<code>ext.menu.Menu</code>) id or a <i>menu</i> (→<code>ext.menu.Menu</code>) config blob. When assigning
 * a menu to a button, an arrow is automatically added to the button. You can change the alignment
 * of the arrow using the →<code>arrowAlign</code> configuration on button.
 * Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     text      : 'Menu button',
 *     renderTo  : Ext.getBody(),
 *     arrowAlign: 'bottom',
 *     menu      : [
 *         {text: 'Item 1'},
 *         {text: 'Item 2'},
 *         {text: 'Item 3'},
 *         {text: 'Item 4'}
 *     ]
 * });
 * </pre>
 * <p>Using listeners, you can easily listen to events fired by any component, using the
 * →<code>listeners</code> configuration or using the →<code>addListener()</code> method.
 * Button has a variety of different listeners:</p>
 * <ul>
 * <li><code>click</code></li>
 * <li><code>toggle</code></li>
 * <li><code>→event:onMouseOver</code></li>
 * <li><code>→event:onMouseOut</code></li>
 * <li><code>mouseshow</code></li>
 * <li><code>→event:onMenuHide</code></li>
 * <li><code>→event:onMenuTriggerOver</code></li>
 * <li><code>→event:onMenuTriggerOut</code></li>
 * </ul>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Button', {
 *     text     : 'Button',
 *     renderTo : Ext.getBody(),
 *     listeners: {
 *         click: function() {
 *             // this == the button, as we are in the local scope
 *             this.setText('I was clicked!');
 *         },
 *         mouseover: function() {
 *             // set a new config which says we moused over, if not already set
 *             if (!this.mousedOver) {
 *                 this.mousedOver = true;
 *                 alert('You moused over a button!\n\nI wont do this again.');
 *             }
 *         }
 *     }
 * });
 * </pre>
 * @see #iconAlign
 * @see #iconCls
 * @see #menu
 * @see #tooltip
 * @see #scale
 * @see #handler
 * @see #listeners
 * @see #event:onMouseOver
 * @see #setHandler()
 * @see #enableToggle
 * @see ext.menu.Menu
 * @see #arrowAlign
 * @see #addListener()
 * @see #event:onMouseOut
 * @see #event:onMenuHide
 * @see #event:onMenuTriggerOver
 * @see #event:onMenuTriggerOut
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html Original Ext JS documentation of 'Ext.button.Button'
 */
public class Button extends Component implements IQueryable {
  /**
   * @param config @inheritDoc
   */
  public function Button(config:Button = null) {
    super();
  }

  [ExtConfig]
  /**
   * False to not allow a pressed Button to be depressed. Only valid when →<code>enableToggle</code>
   * is true.
   * @default true
   * @see #enableToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-allowDepress Original Ext JS documentation of 'allowDepress'
   */
  public native function get allowDepress():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDepress(value:Boolean):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'button'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * The side of the Button box to render the arrow if the button has an associated
   * →<code>menu</code>. Two values are allowed:
   * <ul>
   * <li>'right'</li>
   * <li>'bottom'</li>
   * </ul>
   * @default 'right'
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-arrowAlign Original Ext JS documentation of 'arrowAlign'
   */
  public native function get arrowAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set arrowAlign(value:String):void;

  [ExtConfig]
  /**
   * The className used for the inner arrow element if the button has a menu.
   * @default 'arrow'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-arrowCls Original Ext JS documentation of 'arrowCls'
   */
  public native function get arrowCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set arrowCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>false</code> to hide the button arrow. Only applicable for <i>Split Buttons</i> (→<code>ext.button.SplitButton</code>) and buttons configured with a →<code>menu</code>.
   * @default true
   * @see ext.button.SplitButton
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-arrowVisible Original Ext JS documentation of 'arrowVisible'
   * @see #getArrowVisible()
   * @see #setArrowVisible()
   */
  public native function get arrowVisible():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set arrowVisible(value:Boolean):void;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default {
   *     tag: 'a',
   *     hidefocus: 'on',
   *     unselectable: 'on'
   * }
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to add to all buttons.
   * @default Ext.baseCSSPrefix + 'btn'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * An object literal of parameters to pass to the url when the →<code>href</code> property
   * is specified.
   * @see #href
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-baseParams Original Ext JS documentation of 'baseParams'
   */
  public native function get baseParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseParams(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'btnEl',
   *     'btnWrap',
   *     'btnInnerEl',
   *     'btnIconEl',
   *     'arrowEl',
   *     'tooltipEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * The DOM event that will fire the handler of the button. This can be any valid event name
   * (dblclick, contextmenu).
   * @default 'click'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-clickEvent Original Ext JS documentation of 'clickEvent'
   */
  public native function get clickEvent():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clickEvent(value:String):void;

  [ExtConfig]
  /**
   * A CSS class string to apply to the button's main element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  override public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set cls(value:String):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'text'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * Whether or not to destroy any associated menu when this button is destroyed.
   * In addition, a value of <code>true</code> for this config will destroy the currently bound menu when
   * a new menu is set in →<code>setMenu()</code> unless overridden by that method's destroyMenu function
   * argument.
   * @default true
   * @see #setMenu()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-destroyMenu Original Ext JS documentation of 'destroyMenu'
   */
  public native function get destroyMenu():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set destroyMenu(value:Boolean):void;

  [ExtConfig]
  /**
   * True if this button is disabled.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  override public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * True to enable pressed/not pressed toggling. If a →<code>toggleGroup</code> is specified, this
   * option will be set to true.
   * @default false
   * @see #toggleGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-enableToggle Original Ext JS documentation of 'enableToggle'
   */
  public native function get enableToggle():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableToggle(value:Boolean):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to have the Component inject framing elements within the Component
   * at render time to provide a graphical rounded frame around the Component content.
   * <p>This is only necessary when running on outdated, or non standard-compliant browsers
   * such as Microsoft's Internet Explorer prior to version 9 which do not support rounded corners
   * natively.</p>
   * <p>The extra space taken up by this framing is available from the read only property
   * →<code>frameSize</code>.</p>
   * @default true
   * @see #frameSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-frame Original Ext JS documentation of 'frame'
   */
  override public native function get frame():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set frame(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * False to disable visual cues on mouseover, mouseout and mousedown.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-handleMouseEvents Original Ext JS documentation of 'handleMouseEvents'
   */
  public native function get handleMouseEvents():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handleMouseEvents(value:Boolean):void;

  [ExtConfig]
  /**
   * A function called when the button is clicked (can be used instead of click event).
   * <p>See also →<code>clickEvent</code></p>
   * <ul>
   * <li><code>button:ext.button.Button</code> —
   * This button.
   * </li>
   * <li><code>e:ext.event.Event</code> —
   * The click event.
   * </li>
   * </ul>
   * @see #clickEvent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-handler Original Ext JS documentation of 'handler'
   * @see #setHandler()
   */
  public native function get handler():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * True if this button is hidden.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-hidden Original Ext JS documentation of 'hidden'
   * @see #setHidden()
   */
  override public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * The URL to open when the button is clicked. Specifying this config causes the Button to be
   * rendered with the specified URL as the <code>→href</code> attribute of its <code>&lt;a&gt;</code> Element.
   * <p>This is better than specifying a click handler of</p>
   * <pre>
   * function() { window.location = "http://www.sencha.com" }
   * </pre>
   * <p>because the UI will provide meaningful hints to the user as to what to expect upon clicking
   * the button, and will also allow the user to open in a new tab or window, bookmark or drag
   * the URL, or directly save the URL stream to disk.</p>
   * <p>See also the →<code>hrefTarget</code> config.</p>
   * @see #href
   * @see #hrefTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-href Original Ext JS documentation of 'href'
   * @see #setHref()
   */
  public native function get href():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set href(value:String):void;

  [ExtConfig]
  /**
   * The target attribute to use for the underlying anchor. Only used if the →<code>href</code>
   * property is specified.
   * @default '_blank'
   * @see #href
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-hrefTarget Original Ext JS documentation of 'hrefTarget'
   */
  public native function get hrefTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hrefTarget(value:String):void;

  [ExtConfig]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-icon Original Ext JS documentation of 'icon'
   * @see #setIcon()
   */
  public native function get icon():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The side of the Button box to render the icon. Four values are allowed:
   * <ul>
   * <li>'top'</li>
   * <li>'right'</li>
   * <li>'bottom'</li>
   * <li>'left'</li>
   * </ul>
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-iconAlign Original Ext JS documentation of 'iconAlign'
   * @see #getIconAlign()
   * @see #setIconAlign()
   */
  public native function get iconAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconAlign(value:String):void;

  [ExtConfig]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Button, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-isButton Original Ext JS documentation of 'isButton'
   */
  public native function get isButton():Boolean;

  /**
   * @private
   */
  public native function set isButton(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing handlers for keyboard events. The property names of this
   * object are the key name and any modifiers. The values of the properties are the
   * descriptors of how to handle each event.
   * <p>The handler descriptor can be simply the handler function(either the
   * literal function or the method name), or it can be an object with these
   * properties:</p>
   * <ul>
   * <li><code>→handler</code>: The function or its name to call to handle the event.</li>
   * <li><code>→scope</code>: The this pointer context (can be "this" or "controller").</li>
   * <li><code>event</code>: An optional override of the key event to which to listen.</li>
   * </ul>
   * <p><b>Important:</b> Calls to <code>setKeyMap</code> do not replace the entire <code>→keyMap</code> but
   * instead update the provided mappings. That is, unless <code>null</code> is passed as the
   * value of the <code>→keyMap</code> which will clear the <code>→keyMap</code> of all entries.</p>
   * @default {
   *     scope: 'this',
   *     SPACE: 'onEnterKey',
   *     ENTER: 'onEnterKey',
   *     DOWN: 'onDownKey'
   * }
   * @see #handler
   * @see #scope
   * @see #keyMap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   * @see #getKeyMap()
   * @see #setKeyMap()
   */
  override public native function get keyMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set keyMap(value:Object):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The →<code>ext.menu.Menu</code> object associated with this Button when configured with the
   * →<code>menu</code> config option.
   * @see ext.menu.Menu
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-menu Original Ext JS documentation of 'menu'
   * @see #getMenu()
   */
  public native function get menu():Menu;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menu(value:Menu):void;

  [ExtConfig]
  /**
   * The position to align the menu to (see →<code>ext.util.Positionable.alignTo()</code> for more
   * details).
   * @default 'tl-bl?'
   * @see ext.util.Positionable#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-menuAlign Original Ext JS documentation of 'menuAlign'
   */
  public native function get menuAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menuAlign(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum width for this button (used to give a set of buttons a common width).
   * See also →<code>ext.panel.Panel</code>.→<code>ext.panel.Panel.minButtonWidth</code>.
   * @see ext.panel.Panel
   * @see ext.panel.Panel#minButtonWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  override public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to this component's Element when the mouse
   * moves over the Element, and removed when the mouse moves out. This can be useful for adding
   * customized 'active' or 'hover' styles to the component or any of its children using standard
   * CSS rules.
   * @default Ext.baseCSSPrefix + 'btn-over'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-overCls Original Ext JS documentation of 'overCls'
   */
  override public native function get overCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set overCls(value:String):void;

  [ExtConfig]
  /**
   * If used in a →<code>ext.toolbar.Toolbar</code>, the text to be used if this item is shown
   * in the overflow menu.
   * See also →<code>ext.toolbar.Item</code>.<code>→ext.toolbar.Item.overflowText</code>.
   * @see ext.toolbar.Toolbar
   * @see ext.toolbar.Item
   * @see ext.toolbar.Item#overflowText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-overflowText Original Ext JS documentation of 'overflowText'
   */
  public native function get overflowText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowText(value:String):void;

  [ExtConfig]
  /**
   * Specifies the padding for this component. The padding can be a single numeric value to apply
   * to all sides or it can be a CSS style specification for each style,
   * for example: '10 5 3 10' (top, right, bottom, left).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-padding Original Ext JS documentation of 'padding'
   */
  override public native function get padding():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set padding(value:*):void;

  [ExtConfig]
  /**
   * An object literal of parameters to pass to the url when the →<code>href</code> property
   * is specified. Any params override →<code>baseParams</code>. New params can be set using
   * the →<code>setParams()</code> method.
   * @see #href
   * @see #baseParams
   * @see #setParams()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-params Original Ext JS documentation of 'params'
   */
  public native function get params():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set params(value:Object):void;

  [ExtConfig]
  /**
   * True if this button is pressed (only if enableToggle = true).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-pressed Original Ext JS documentation of 'pressed'
   * @see #setPressed()
   */
  public native function get pressed():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set pressed(value:Boolean):void;

  [ExtConfig]
  /**
   * Is set to <code>true</code> to prevent the default action when the →<code>clickEvent</code> is processed.
   * This provides focus control for clicks and stops scrolling on some devices when using
   * the keyboard to simulate clicks. Set this to <code>false</code> if you need to listen directly
   * to element events (for example, to use <code>window.open()</code> in response to a click).
   * @default true
   * @see #clickEvent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function get preventDefault():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventDefault(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default {
   *     pressed: 1
   * }
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default '<span id="{id}-btnWrap" data-ref="btnWrap" role="presentation" unselectable="on" style="{btnWrapStyle}" ' + 'class="{btnWrapCls} {btnWrapCls}-{ui} {splitCls}{childElCls}">' + '<span id="{id}-btnEl" data-ref="btnEl" role="presentation" unselectable="on" style="{btnElStyle}" ' + 'class="{btnCls} {btnCls}-{ui} {textCls} {noTextCls} {hasIconCls} ' + '{iconAlignCls} {textAlignCls} {btnElAutoHeightCls}{childElCls}">' + '<tpl if="iconBeforeText">{[values.$comp.renderIcon(values)]}</tpl>' + '<span id="{id}-btnInnerEl" data-ref="btnInnerEl" unselectable="on" ' + 'class="{innerCls} {innerCls}-{ui}{childElCls}">{text}</span>' + '<tpl if="!iconBeforeText">{[values.$comp.renderIcon(values)]}</tpl>' + '</span>' + '</span>' + '{[values.$comp.getAfterMarkup ? values.$comp.getAfterMarkup(values) : ""]}' + // if "closable" (tab) add a close element icon
   * '<tpl if="closable">' + '<span id="{id}-closeEl" data-ref="closeEl" class="{baseCls}-close-btn">' + '<tpl if="closeText">' + ' {closeText}' + '</tpl>' + '</span>' + '</tpl>' + // Split buttons have additional tab stop for the arrow element
   * '<tpl if="split">' + '<span id="{id}-arrowEl" class="{arrowElCls}" data-ref="arrowEl" ' + 'role="button" hidefocus="on" unselectable="on"' + '<tpl if="tabIndex != null"> tabindex="{tabIndex}"</tpl>' + '<tpl foreach="arrowElAttributes"> {$}="{.}"</tpl>' + ' style="{arrowElStyle}"' + '>{arrowElText}</span>' + '</tpl>' + '<div id="{id}-tooltipEl" data-ref="tooltipEl" role="presentation" class="{tooltipCls}"></div>'
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  /**
   * True to repeat fire the click event while the mouse is down. This can also be a
   * →<code>ext.util.ClickRepeater</code> config object.
   * @default false
   * @see ext.util.ClickRepeater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-repeat Original Ext JS documentation of 'repeat'
   */
  public native function get repeat():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set repeat(value:*):void;

  [ExtConfig]
  /**
   * The size of the Button. Three values are allowed:
   * <ul>
   * <li>'small' - Results in the button element being 16px high.</li>
   * <li>'medium' - Results in the button element being 24px high.</li>
   * <li>'large' - Results in the button element being 32px high.</li>
   * </ul>
   * @default 'small'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-scale Original Ext JS documentation of 'scale'
   * @see #setScale()
   */
  public native function get scale():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set scale(value:String):void;

  [ExtConfig]
  /**
   * The scope (<b>this</b> reference) in which the <code>→handler</code> and <code>→toggleHandler</code>
   * is executed. Defaults to this Button.
   * @see #handler
   * @see #toggleHandler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * True to force an attached →<code>menu</code> with no items to be shown when clicking
   * this button. By default, the menu will not show if it is empty.
   * @default false
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-showEmptyMenu Original Ext JS documentation of 'showEmptyMenu'
   */
  public native function get showEmptyMenu():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showEmptyMenu(value:Boolean):void;

  [ExtConfig]
  /**
   * The possible values for shrinkWrap are...
   * <ul>
   * <li>0 (or <code>false</code>): Neither width nor height depend on content.</li>
   * <li>1: Width depends on content (shrink wraps), but height does not.</li>
   * <li>2: Height depends on content (shrink wraps), but width does not.</li>
   * <li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>
   * </ul>
   * <p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed
   * to a block-level element.</p>
   * @default 3
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-shrinkWrap Original Ext JS documentation of 'shrinkWrap'
   */
  override public native function get shrinkWrap():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shrinkWrap(value:*):void;

  [ExtConfig]
  /**
   * Sets a DOM tabIndex for this button. tabIndex may be set to <code>-1</code> in order to remove
   * the button from the tab rotation.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  /**
   * A →<code>ext.Template</code> used to create the Button's DOM structure.
   * <p>Instances, or subclasses which need a different DOM structure may provide a different
   * template layout in conjunction with an implementation of →<code>getTemplateArgs()</code>.</p>
   * @see ext.Template
   * @see #getTemplateArgs()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#property-template Original Ext JS documentation of 'template'
   */
  public native function get template():Template;

  /**
   * @private
   */
  public native function set template(value:Template):void;

  [ExtConfig]
  [Bindable]
  /**
   * The button text to be used as innerHTML (html tags are accepted).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The text alignment for this button (center, left, right).
   * @default 'center'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-textAlign Original Ext JS documentation of 'textAlign'
   * @see #getTextAlign()
   * @see #setTextAlign()
   */
  public native function get textAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set textAlign(value:String):void;

  [ExtConfig]
  /**
   * The group this toggle button is a member of (only 1 per group can be pressed).
   * If a toggleGroup is specified, the →<code>enableToggle</code> configuration will automatically
   * be set to true.
   * @see #enableToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-toggleGroup Original Ext JS documentation of 'toggleGroup'
   */
  public native function get toggleGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toggleGroup(value:String):void;

  [ExtConfig]
  /**
   * Function called when a Button with →<code>enableToggle</code> set to true is clicked.
   * <ul>
   * <li><code>button:ext.button.Button</code> (optional) —
   * This button.
   * </li>
   * <li><code>state:Boolean</code> (optional) —
   * The next state of the Button, true means pressed.
   * </li>
   * </ul>
   * @see #enableToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-toggleHandler Original Ext JS documentation of 'toggleHandler'
   */
  public native function get toggleHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toggleHandler(value:*):void;

  [ExtConfig]
  /**
   * The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted)
   * or QuickTips config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   * @see #setTooltip()
   */
  public native function get tooltip():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set tooltip(value:*):void;

  [ExtConfig]
  /**
   * The type of tooltip to use. Either 'qtip' for QuickTips or 'title' for title attribute.
   * @default 'qtip'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-tooltipType Original Ext JS documentation of 'tooltipType'
   */
  public native function get tooltipType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tooltipType(value:String):void;

  [ExtConfig]
  /**
   * The value of this button. Only applicable when used as an item of a
   * <i>Segmented Button</i> (→<code>ext.button.SegmentedButton</code>).
   * @see ext.button.SegmentedButton
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#cfg-value Original Ext JS documentation of 'value'
   */
  public native function get value():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set value(value:*):void;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * Programmatically activate the button.
   * @param e Optional event to process.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-click Original Ext JS documentation of 'click'
   */
  public native function click(e:Event = null):void;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  /**
   * Returns the value of <code>arrowVisible</code>.
   * @see #arrowVisible
   */
  public native function getArrowVisible():Boolean;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Returns the value of <code>iconAlign</code>.
   * @see #iconAlign
   */
  public native function getIconAlign():String;

  /**
   * Returns the value of <code>keyMap</code>.
   * @see #keyMap
   */
  override public native function getKeyMap():Object;

  /**
   * Get the →<code>menu</code> for this button.
   * @return The menu. <code>null</code> if no menu is configured.
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-getMenu Original Ext JS documentation of 'getMenu'
   */
  public native function getMenu():Menu;

  /**
   * Returns the value of <code>minWidth</code>.
   * @see #minWidth
   */
  override public native function getMinWidth():Number;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * This method returns an object which provides substitution parameters for the
   * <i>XTemplate</i> (→<code>renderTpl</code>) used to create this Button's DOM structure.
   * <p>Instances or subclasses which use a different Template to create a different DOM structure
   * may need to provide their own implementation of this method.</p>
   * @return Substitution data for a Template. The default implementation which provides
   * data for the default →<code>template</code> returns an Object containing the following properties:
   * <ul>
   * <li><code>innerCls:String</code> (optional) —
   * A CSS class to apply to the button's text element.
   * </li>
   * <li><code>splitCls:String</code> (optional) —
   * A CSS class to determine the presence and position
   * of an arrow icon. (<code>'x-btn-arrow'</code> or <code>'x-btn-arrow-bottom'</code> or <code>''</code>)
   * </li>
   * <li><code>iconUrl:String</code> (optional) —
   * The url for the button icon.
   * </li>
   * <li><code>iconCls:String</code> (optional) —
   * The CSS class for the button icon.
   * </li>
   * <li><code>glyph:String</code> (optional) —
   * The glyph to use as the button icon.
   * </li>
   * <li><code>glyphCls:String</code> (optional) —
   * The CSS class to use for the glyph element.
   * </li>
   * <li><code>glyphFontFamily:String</code> (optional) —
   * The CSS font-family to use for the glyph element.
   * </li>
   * <li><code>text:String</code> (optional) —
   * The →<code>text</code> to display ion the Button.
   * </li>
   * </ul>
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-getTemplateArgs Original Ext JS documentation of 'getTemplateArgs'
   * @see #template
   * @see #text
   */
  public native function getTemplateArgs():Object;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>textAlign</code>.
   * @see #textAlign
   */
  public native function getTextAlign():String;

  /**
   * Returns true if the button has a menu and it is visible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-hasVisibleMenu Original Ext JS documentation of 'hasVisibleMenu'
   */
  public native function hasVisibleMenu():Boolean;

  /**
   * Hides this button's menu (if it has one)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-hideMenu Original Ext JS documentation of 'hideMenu'
   */
  public native function hideMenu():void;

  /**
   * Returns true if the passed event's x/y coordinates are within the trigger region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-isWithinTrigger Original Ext JS documentation of 'isWithinTrigger'
   */
  protected native function isWithinTrigger(e:Event):void;

  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * Sets the value of <code>arrowVisible</code>.
   * @param arrowVisible The new value.
   * @see #arrowVisible
   */
  public native function setArrowVisible(arrowVisible:Boolean):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Assigns this Button's click handler
   * @param handler The function to call when the button is clicked
   * @param scope The scope (<code>this</code> reference) in which the handler function
   * is executed. Defaults to this Button.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setHandler Original Ext JS documentation of 'setHandler'
   */
  public native function setHandler(handler:Function, scope:Object = null):Button;

  /**
   * Sets the href of the embedded anchor element to the passed URL.
   * <p>Also appends any configured →<code>baseParams</code> and parameters set through
   * →<code>setParams()</code>.</p>
   * @param href The URL to set in the anchor element.
   * @see #baseParams
   * @see #setParams()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setHref Original Ext JS documentation of 'setHref'
   */
  public native function setHref(href:String):void;

  /**
   * Sets the background image (inline style) of the button. This method also changes the value
   * of the →<code>icon</code> config internally.
   * @param icon The path to an image to display in the button
   * @return this
   * @see #icon
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setIcon Original Ext JS documentation of 'setIcon'
   */
  public native function setIcon(icon:String):Button;

  /**
   * Sets the value of <code>iconAlign</code>.
   * @param iconAlign The new value.
   * @see #iconAlign
   */
  public native function setIconAlign(iconAlign:String):void;

  /**
   * Sets the CSS class that provides a background image to use as the button's icon. This method
   * also changes the value of the →<code>iconCls</code> config internally.
   * @param cls The CSS class providing the icon image
   * @return this
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setIconCls Original Ext JS documentation of 'setIconCls'
   */
  public native function setIconCls(cls:String):Button;

  /**
   * Sets the value of <code>keyMap</code>.
   * @param keyMap The new value.
   * @see #keyMap
   */
  override public native function setKeyMap(keyMap:Object):void;

  /**
   * Sets a new menu for this button. Pass a falsy value to unset the current menu.
   * To destroy the previous menu for this button, explicitly pass <code>false</code> as the second argument.
   * If this is not set, the destroy will depend on the value of →<code>destroyMenu</code>.
   * @param menu Accepts a menu component, a menu id or a
   * menu config.
   * @param destroyMenu By default, will destroy the previous set menu and remove
   * it from the menu manager. Pass <code>false</code> to prevent the destroy.
   * @see #destroyMenu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setMenu Original Ext JS documentation of 'setMenu'
   */
  public native function setMenu(menu:*, destroyMenu:Boolean):void;

  /**
   * Sets the value of <code>minWidth</code>.
   * @param minWidth The new value.
   * @see #minWidth
   */
  override public native function setMinWidth(minWidth:Number):void;

  /**
   * Sets the href of the link dynamically according to the params passed, and any
   * →<code>baseParams</code> configured.
   * <pre>
   * var button = Ext.create('Ext.button.Button', {
   *     renderTo   : document.body,
   *     text       : 'Open',
   *     href       : 'http://www.sencha.com',
   *     baseParams : {
   *         foo : 'bar'
   *     }
   * });
   *
   * button.setParams({
   *     company : 'Sencha'
   * });
   * </pre>
   * <p>When clicked, this button will open a new window with the url http://www.sencha.com/?foo=bar&amp;company=Sencha because
   * the button was configured with the →<code>baseParams</code> to have <code>foo</code> = <code>'bar'</code>
   * and then used →<code>setParams()</code> to set the <code>company</code> parameter to <code>'Sencha'</code>.</p>
   * <p><b>Only valid if the Button was originally configured with a →<code>href</code></b></p>
   * @param params Parameters to use in the href URL.
   * @see #baseParams
   * @see #setParams()
   * @see #href
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setParams Original Ext JS documentation of 'setParams'
   */
  public native function setParams(params:Object):void;

  /**
   * Sets the <code>pressed</code> state of this button.
   * @param pressed Pass <code>false</code> to clear the <code>pressed</code> state.
   * @default true
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setPressed Original Ext JS documentation of 'setPressed'
   */
  public native function setPressed(pressed:Boolean = true):Button;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Method to change the scale of the button. See →<code>scale</code> for allowed configurations.
   * @param scale The scale to change to.
   * @see #scale
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setScale Original Ext JS documentation of 'setScale'
   */
  public native function setScale(scale:String):void;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):Button;

  /**
   * Sets the value of <code>textAlign</code>.
   * @param textAlign The new value.
   * @see #textAlign
   */
  public native function setTextAlign(textAlign:String):void;

  /**
   * Sets the tooltip for this Button.
   * @param tooltip This may be:
   * <ul>
   * <li><b>String</b> : A string to be used as innerHTML (html tags are accepted) to show
   * in a tooltip</li>
   * <li><b>Object</b> : A configuration object for →<code>ext.tip.QuickTipManager.register()</code>.</li>
   * </ul>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-setTooltip Original Ext JS documentation of 'setTooltip'
   * @see ext.tip.SQuickTipManager#register() ext.tip.QuickTipManager.register()
   */
  public native function setTooltip(tooltip:*, initial:* = undefined):Button;

  /**
   * Shows this button's menu (if it has one)
   * @param clickEvent (private)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-showMenu Original Ext JS documentation of 'showMenu'
   */
  public native function showMenu(clickEvent:Object):void;

  /**
   * If a state it passed, it becomes the pressed state otherwise the current state is toggled.
   * @param state Force a particular state
   * @param suppressEvent True to stop events being fired when calling
   * this method.
   * @default false
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle(state:Boolean = false, suppressEvent:Boolean = false):Button;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}