package ext.button {
import ext.menu.CheckItem;
import ext.menu.Menu;

[Native("Ext.button.Cycle", require)]
/**
 * @see ext.button.events.CycleButton_itemEvent.CHANGE
 * @eventType ext.button.events.CycleButton_itemEvent.CHANGE
 */
[Event(name='onChange', type='ext.button.events.CycleButton_itemEvent')]
/**
 * A specialized SplitButton that contains a menu of →<code>ext.menu.CheckItem</code> elements. The button
 * automatically cycles through each menu item on click, raising the button's →<code>event:onChange</code> event
 * (or calling the button's →<code>changeHandler</code> function, if supplied) for the active menu item.
 * Clicking on the arrow section of the button displays the dropdown menu just like a normal
 * SplitButton.
 * Example usage:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.button.Cycle', {
 *     showText: true,
 *     prependText: 'View as ',
 *     renderTo: Ext.getBody(),
 *     menu: {
 *         id: 'view-type-menu',
 *         items: [{
 *             text: 'text only',
 *             iconCls: 'view-text',
 *             checked: true
 *         },{
 *             text: 'HTML',
 *             iconCls: 'view-html'
 *         }]
 *     },
 *     changeHandler: function(cycleBtn, activeItem) {
 *         Ext.Msg.alert('Change View', activeItem.text);
 *     }
 * });
 * </pre>
 * @see ext.menu.CheckItem
 * @see #event:onChange
 * @see #changeHandler
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html Original Ext JS documentation of 'Ext.button.Cycle'
 */
public class CycleButton extends SplitButton {
  /**
   * @param config @inheritDoc
   */
  public function CycleButton(config:CycleButton = null) {
    super();
  }

  [ExtConfig]
  /**
   * A callback function that will be invoked each time the active menu item in the button's menu
   * has changed. If this callback is not supplied, the SplitButton will instead fire the
   * →<code>event:onChange</code> event on active item change. The changeHandler function will be called with
   * the following argument list: (SplitButton this, Ext.menu.CheckItem item)
   * @see #event:onChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-changeHandler Original Ext JS documentation of 'changeHandler'
   */
  public native function get changeHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set changeHandler(value:*):void;

  [ExtConfig]
  /**
   * The charCode to be used as the static icon for this button. This icon will always be
   * displayed regardless of which item is selected in the dropdown list. This override
   * the default behavior of changing the button's icon to match the selected item's icon
   * on change. This property expects a format consistent with that of →<code>glyph</code>
   * @see #glyph
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-forceGlyph Original Ext JS documentation of 'forceGlyph'
   */
  public native function get forceGlyph():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forceGlyph(value:*):void;

  [ExtConfig]
  /**
   * A css class which sets an image to be used as the static icon for this button. This icon will
   * always be displayed regardless of which item is selected in the dropdown list. This overrides
   * the default behavior of changing the button's icon to match the selected item's icon
   * on change.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-forceIcon Original Ext JS documentation of 'forceIcon'
   */
  public native function get forceIcon():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forceIcon(value:String):void;

  [Deprecated(replacement="menu", since="4.0")]
  [ExtConfig]
  /**
   * An array of →<code>ext.menu.CheckItem</code> <b>config</b> objects to be used when creating
   * the button's menu items (e.g., <code>{text:'Foo', iconCls:'foo-icon'}</code>)
   * @see ext.menu.CheckItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-items Original Ext JS documentation of 'items'
   */
  public native function get items():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set items(value:Array):void;

  /**
   * The →<code>ext.menu.Menu</code> object used to display the
   * <i>CheckItems</i> (→<code>ext.menu.CheckItem</code>) representing the available choices.
   * @see ext.menu.Menu
   * @see ext.menu.CheckItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#property-menu Original Ext JS documentation of 'menu'
   */
  override public native function get menu():Menu;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set menu(value:Menu):void;

  [ExtConfig]
  /**
   * A static string to prepend before the active item's text when displayed as the button's text
   * (only applies when showText = true).
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-prependText Original Ext JS documentation of 'prependText'
   */
  public native function get prependText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prependText(value:String):void;

  [ExtConfig]
  /**
   * True to display the active item's text as the button text. The Button will show its
   * configured →<code>text</code> if this config is omitted.
   * @default false
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#cfg-showText Original Ext JS documentation of 'showText'
   */
  public native function get showText():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showText(value:Boolean):void;

  /**
   * Gets the currently active menu item.
   * @return The active item
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#method-getActiveItem Original Ext JS documentation of 'getActiveItem'
   */
  public native function getActiveItem():CheckItem;

  /**
   * Sets the button's active menu item.
   * @param item The item to activate
   * @param suppressEvent True to prevent the →<code>event:onChange</code> event and
   * →<code>changeHandler</code> from firing.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#method-setActiveItem Original Ext JS documentation of 'setActiveItem'
   * @see #event:onChange
   * @see #changeHandler
   */
  public native function setActiveItem(item:CheckItem, suppressEvent:Boolean = false):void;

  /**
   * This is normally called internally on button click, but can be called externally to advance
   * the button's active item programmatically to the next one in the menu. If the current item
   * is the last one in the menu the active item will be set to the first item in the menu.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#method-toggleSelected Original Ext JS documentation of 'toggleSelected'
   */
  public native function toggleSelected():void;
}
}