package ext.button {
import ext.container.Container;

[Native("Ext.button.Segmented", require)]
/**
 * @see ext.button.events.SegmentedButton_newValue_oldValueEvent.CHANGE
 * @eventType ext.button.events.SegmentedButton_newValue_oldValueEvent.CHANGE
 */
[Event(name='onChange', type='ext.button.events.SegmentedButton_newValue_oldValueEvent')]
/**
 * @see ext.button.events.SegmentedButton_button_isPressedEvent.TOGGLE
 * @eventType ext.button.events.SegmentedButton_button_isPressedEvent.TOGGLE
 */
[Event(name='onToggle', type='ext.button.events.SegmentedButton_button_isPressedEvent')]
/**
 * SegmentedButton is a container for a group of →<code>ext.button.Button</code>s. You
 * may populate the segmented button's children by adding buttons to the items config.
 * The segmented button's children enjoy the same customizations as regular buttons, such as
 * menu, tooltip, etc. You can see usages of the various configuration
 * possibilities in the example below.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.button.Segmented', {
 *      renderTo: Ext.getBody(),
 *      allowMultiple: true,
 *      items: [{
 *           text: 'Segment Item 1',
 *           menu: [{
 *               text: 'Menu Item 1'
 *           }]
 *      },{
 *           text: 'Segment Item 2',
 *           tooltip: 'My custom tooltip'
 *      },{
 *           text: 'Segment Item 3'
 *      }],
 *      listeners: {
 *           toggle: function(container, button, pressed) {
 *                console.log("User toggled the '" + button.text + "' button: " +
 *                            (pressed ? 'on' : 'off'));
 *           }
 *      }
 * });
 * </pre>
 * @see ext.button.Button
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html Original Ext JS documentation of 'Ext.button.Segmented'
 */
public class SegmentedButton extends Container {
  /**
   * @param config @inheritDoc
   */
  public function SegmentedButton(config:SegmentedButton = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Allow toggling the pressed state of each button.
   * Only applicable when →<code>allowMultiple</code> is <code>false</code>.
   * @default false
   * @see #allowMultiple
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-allowDepress Original Ext JS documentation of 'allowDepress'
   * @see #getAllowDepress()
   * @see #setAllowDepress()
   */
  public native function get allowDepress():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowDepress(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Allow multiple pressed buttons.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-allowMultiple Original Ext JS documentation of 'allowMultiple'
   * @see #getAllowMultiple()
   * @see #setAllowMultiple()
   */
  public native function get allowMultiple():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowMultiple(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to enable pressed/not pressed toggling.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-allowToggle Original Ext JS documentation of 'allowToggle'
   * @see #getAllowToggle()
   * @see #setAllowToggle()
   */
  public native function get allowToggle():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowToggle(value:Boolean):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'segmented-button'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'value'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * The default <i>xtype</i> (→<code>ext.Component</code>) of child Components to create in this Container when
   * a child item is specified as a raw configuration object, rather than as an instantiated
   * Component.
   * @default 'button'
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-defaultType Original Ext JS documentation of 'defaultType'
   */
  override public native function get defaultType():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set defaultType(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default →<code>ext.Component.ui</code> to use for buttons in this segmented button.
   * Buttons can override this default by specifying their own UI
   * @default 'default'
   * @see ext.Component#ui
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-defaultUI Original Ext JS documentation of 'defaultUI'
   * @see #getDefaultUI()
   * @see #setDefaultUI()
   */
  public native function get defaultUI():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultUI(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If →<code>allowMultiple</code> is <code>true</code>, this config may be set to <code>true</code> to indicate that
   * at least one button in the set must remain pressed at all times.
   * <p>If no →<code>value</code> is configured, and no child buttons are configured <code>pressed</code>,
   * the first child button is set <code>pressed: true</code></p>
   * @default false
   * @see #allowMultiple
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-forceSelection Original Ext JS documentation of 'forceSelection'
   * @see #getForceSelection()
   * @see #setForceSelection()
   */
  public native function get forceSelection():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set forceSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Important</b>: In order for child items to be correctly sized and
   * positioned, typically a layout manager <b>must</b> be specified through
   * the <code>→layout</code> configuration option.
   * <p>The sizing and positioning of child →<code>items</code> is the responsibility of
   * the Container's layout manager which creates and manages the type of layout
   * you have in mind. For example:</p>
   * <p>If the layout configuration is not explicitly specified for
   * a general purpose container (e.g. Container or Panel) the
   * <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used
   * which does nothing but render child components sequentially into the
   * Container (no sizing or positioning will be performed in this situation).</p>
   * <p><b>layout</b> may be specified as either as an Object or as a String:</p>
   * <p><b><i>Specify as an Object</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: {
   *     type: 'vbox',
   *     align: 'left'
   * }
   * </pre>
   * <ul>
   * <li>
   * <p><b>type</b></p>
   * <p>The layout type to be used for this container. If not specified,
   * a default →<code>ext.layout.container.AutoLayout</code> will be created and used.</p>
   * <p>Valid layout <code>type</code> values are listed in →<code>null</code>.</p>
   * </li>
   * <li>
   * <p>Layout specific configuration properties</p>
   * <p>Additional layout specific configuration properties may also be
   * specified. For complete details regarding the valid config options for
   * each layout type, see the layout class corresponding to the <code>type</code>
   * specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Specify as a String</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: 'vbox'
   * </pre>
   * <ul>
   * <li>
   * <p><b>layout</b></p>
   * <p>The layout <code>type</code> to be used for this container (see →<code>null</code>
   * for list of valid values).</p>
   * <p>Additional layout specific configuration properties. For complete
   * details regarding the valid config options for each layout type, see the
   * layout class corresponding to the <code>→layout</code> specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Configuring the default layout type</i></b></p>
   * <p>If a certain Container class has a default layout (For example a
   * →<code>ext.toolbar.Toolbar</code> with a default <code>Box</code> layout), then to simply configure
   * the default layout, use an object, but without the <code>type</code> property:</p>
   * <pre>
   * xtype: 'toolbar',
   * layout: {
   *     pack: 'center'
   * }
   * </pre>
   * @default 'segmentedbutton'
   * @see #layout
   * @see #items
   * @see ext.layout.container.AutoLayout
   * @see null
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'value'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>→value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default [
   *     'value'
   * ]
   * @see #value
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The value of this button. When →<code>allowMultiple</code> is <code>false</code>, value is a
   * String or Number. When →<code>allowMultiple</code> is <code>true</code>, value is an array
   * of values. A value corresponds to a child button's →<code>ext.button.Button.value</code>, or its index if no child button values match the given value.
   * <p>Using the <code>→value</code> config of the child buttons with single toggle:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var button = Ext.create('Ext.button.Segmented', {
   *     renderTo: Ext.getBody(),
   *     value: 'optTwo', // begin with "Option Two" selected
   *     items: [{
   *         text: 'Option One',
   *         value: 'optOne'
   *     }, {
   *         text: 'Option Two',
   *         value: 'optTwo'
   *     }, {
   *         text: 'Option Three',
   *         value:  'optThree'
   *     }]
   * });
   *
   * console.log(button.getValue()); // optTwo
   *
   * // Sets the value to optOne, and sets the pressed state of the "Option One" button
   * button.setValue('optOne');
   *
   * console.log(button.getValue()); // optOne
   * </pre>
   * <p>Using multiple toggle, and index-based values:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var button = Ext.create('Ext.button.Segmented', {
   *     renderTo: Ext.getBody(),
   *     allowMultiple: true
   *     value: [1, 2], // begin with "Option Two" and "Option Three" selected
   *     items: [{
   *         text: 'Option One'
   *     }, {
   *         text: 'Option Two'
   *     }, {
   *         text: 'Option Three'
   *     }]
   * });
   *
   * // Sets value to [0, 2], and sets pressed state of "Option One" and "Option Three"
   * button.setValue([0, 2]);
   *
   * console.log(button.getValue()); // [0, 2]
   *
   * // Remove all pressed buttons, and set value to null
   * button.setValue(null);
   * </pre>
   * @see #allowMultiple
   * @see ext.button.Button#value
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to align the buttons vertically
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#cfg-vertical Original Ext JS documentation of 'vertical'
   * @see #getVertical()
   * @see #setVertical()
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  /**
   * Returns the value of <code>allowDepress</code>.
   * @see #allowDepress
   */
  public native function getAllowDepress():Boolean;

  /**
   * Returns the value of <code>allowMultiple</code>.
   * @see #allowMultiple
   */
  public native function getAllowMultiple():Boolean;

  /**
   * Returns the value of <code>allowToggle</code>.
   * @see #allowToggle
   */
  public native function getAllowToggle():Boolean;

  /**
   * Returns the value of <code>defaultUI</code>.
   * @see #defaultUI
   */
  public native function getDefaultUI():String;

  /**
   * Returns the value of <code>forceSelection</code>.
   * @see #forceSelection
   */
  public native function getForceSelection():Boolean;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():*;

  /**
   * Returns the value of <code>vertical</code>.
   * @see #vertical
   */
  public native function getVertical():Boolean;

  /**
   * Sets the value of <code>allowDepress</code>.
   * @param allowDepress The new value.
   * @see #allowDepress
   */
  public native function setAllowDepress(allowDepress:Boolean):void;

  /**
   * Sets the value of <code>allowMultiple</code>.
   * @param allowMultiple The new value.
   * @see #allowMultiple
   */
  public native function setAllowMultiple(allowMultiple:Boolean):void;

  /**
   * Sets the value of <code>allowToggle</code>.
   * @param allowToggle The new value.
   * @see #allowToggle
   */
  public native function setAllowToggle(allowToggle:Boolean):void;

  /**
   * Sets the value of <code>defaultUI</code>.
   * @param defaultUI The new value.
   * @see #defaultUI
   */
  public native function setDefaultUI(defaultUI:String):void;

  /**
   * Sets the value of <code>forceSelection</code>.
   * @param forceSelection The new value.
   * @see #forceSelection
   */
  public native function setForceSelection(forceSelection:Boolean):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:*):void;

  /**
   * Sets the value of <code>vertical</code>.
   * @param vertical The new value.
   * @see #vertical
   */
  public native function setVertical(vertical:Boolean):void;
}
}