package ext.button {

[Native("Ext.button.Split", require)]
/**
 * @see ext.button.events.SplitButton_eEvent.ARROW_CLICK
 * @eventType ext.button.events.SplitButton_eEvent.ARROW_CLICK
 */
[Event(name='onArrowClick', type='ext.button.events.SplitButton_eEvent')]
/**
 * A split button that provides a built-in dropdown arrow that can fire an event separately
 * from the default click event of the button. Typically this would be used to display a dropdown
 * menu that provides additional options to the primary button action, but any custom handler
 * can provide the arrowclick implementation.
 * Example usage:
 * <p><b>Example:</b></p>
 * <pre>
 * // display a dropdown menu:
 * Ext.create('Ext.button.Split', {
 *     renderTo: Ext.getBody(),
 *     text: 'Options',
 *     // handle a click on the button itself
 *     handler: function() {
 *         alert("The button was clicked");
 *     },
 *     menu: new Ext.menu.Menu({
 *         items: [
 *             // these will render as dropdown menu items when the arrow is clicked:
 *             {text: 'Item 1', handler: function(){ alert("Item 1 clicked"); }},
 *             {text: 'Item 2', handler: function(){ alert("Item 2 clicked"); }}
 *         ]
 *     })
 * });
 * </pre>
 * <p>Instead of showing a menu, you can provide any type of custom functionality you want when
 * the dropdown arrow is clicked:</p>
 * <pre>
 * Ext.create('Ext.button.Split', {
 *     renderTo: 'button-ct',
 *     text: 'Options',
 *     handler: optionsHandler,
 *     arrowHandler: myCustomHandler
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Split.html Original Ext JS documentation of 'Ext.button.Split'
 */
public class SplitButton extends Button {
  /**
   * @param config @inheritDoc
   */
  public function SplitButton(config:SplitButton = null) {
    super();
  }

  [ExtConfig]
  /**
   * A function called when the arrow button is clicked (can be used instead of click event)
   * <ul>
   * <li><code>this:ext.button.SplitButton</code> (optional)</li>
   * <li><code>e:js.Event</code> (optional) —
   * The click event.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Split.html#cfg-arrowHandler Original Ext JS documentation of 'arrowHandler'
   * @see #setArrowHandler()
   */
  public native function get arrowHandler():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set arrowHandler(value:*):void;

  [ExtConfig]
  /**
   * The title attribute of the arrow.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Split.html#cfg-arrowTooltip Original Ext JS documentation of 'arrowTooltip'
   */
  public native function get arrowTooltip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set arrowTooltip(value:String):void;

  /**
   * Sets this button's arrow click handler.
   * @param handler The function to call when the arrow is clicked.
   * @param scope Scope for the function passed above.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Split.html#method-setArrowHandler Original Ext JS documentation of 'setArrowHandler'
   */
  public native function setArrowHandler(handler:Function, scope:Object = null):void;
}
}