package ext.button.events {
import ext.button.Button;
import ext.menu.Menu;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.button.events.Button_menuEvent")]
public class Button_menuEvent extends FlExtEvent {
  /**
   * If this button has a menu, this event fires when it is hidden
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#event-menuhide Original Ext JS documentation of 'menuhide'
   * @see ext.button.Button
   * @eventType onMenuHide
   */
  public static const MENU_HIDE:String = "onMenuHide";
  /**
   * If this button has a menu, this event fires when it is shown
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#event-menushow Original Ext JS documentation of 'menushow'
   * @see ext.button.Button
   * @eventType onMenuShow
   */
  public static const MENU_SHOW:String = "onMenuShow";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "menu", "eOpts"];

  public function Button_menuEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get menu():Menu;

  public native function get source():Button;
}
}