package ext.button.events {
import ext.button.Button;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.button.events.Button_pressedEvent")]
public class Button_pressedEvent extends FlExtEvent {
  /**
   * Fires before the 'pressed' state of this button changes (only if enableToggle = true)
   * If a handler returns <code>false</code>, the toggle is vetoed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#event-beforetoggle Original Ext JS documentation of 'beforetoggle'
   * @see ext.button.Button
   * @eventType onBeforeToggle
   */
  public static const BEFORE_TOGGLE:String = "onBeforeToggle";
  /**
   * Fires when the 'pressed' state of this button changes (only if enableToggle = true)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Button.html#event-toggle Original Ext JS documentation of 'toggle'
   * @see ext.button.Button
   * @eventType onToggle
   */
  public static const TOGGLE:String = "onToggle";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "pressed", "eOpts"];

  public function Button_pressedEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get pressed():Boolean;

  public native function get source():Button;
}
}