package ext.button.events {
import ext.button.CycleButton;
import ext.menu.CheckItem;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.button.events.CycleButton_itemEvent")]
public class CycleButton_itemEvent extends FlExtEvent {
  /**
   * Fires after the button's active menu item has changed. Note that if a →<code>changeHandler</code>
   * function is set on this CycleButton, it will be called instead on active item change and this
   * change event will not be fired.
   * @see ext.button.CycleButton#changeHandler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Cycle.html#event-change Original Ext JS documentation of 'change'
   * @see ext.button.CycleButton
   * @eventType onChange
   */
  public static const CHANGE:String = "onChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "item", "eOpts"];

  public function CycleButton_itemEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The menu item that was selected
   */
  public native function get item():CheckItem;

  public native function get source():CycleButton;
}
}