package ext.button.events {
import ext.button.Button;
import ext.button.SegmentedButton;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.button.events.SegmentedButton_button_isPressedEvent")]
public class SegmentedButton_button_isPressedEvent extends FlExtEvent {
  /**
   * Fires when any child button's pressed state has changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#event-toggle Original Ext JS documentation of 'toggle'
   * @see ext.button.SegmentedButton
   * @eventType onToggle
   */
  public static const TOGGLE:String = "onToggle";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "button", "isPressed", "eOpts"];

  public function SegmentedButton_button_isPressedEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The toggled button.
   */
  public native function get button():Button;

  /**
   * <code>true</code> to indicate if the button was pressed.
   */
  public native function get isPressed():Boolean;

  public native function get source():SegmentedButton;
}
}