package ext.button.events {
import ext.button.SegmentedButton;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.button.events.SegmentedButton_newValue_oldValueEvent")]
public class SegmentedButton_newValue_oldValueEvent extends FlExtEvent {
  /**
   * Fires when any child button's pressed state has changed and caused the value to change.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.button.Segmented.html#event-change Original Ext JS documentation of 'change'
   * @see ext.button.SegmentedButton
   * @eventType onChange
   */
  public static const CHANGE:String = "onChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "newValue", "oldValue", "eOpts"];

  public function SegmentedButton_newValue_oldValueEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new value.
   */
  public native function get newValue():Array;

  /**
   * The old value.
   */
  public native function get oldValue():Array;

  public native function get source():SegmentedButton;
}
}