package ext.chart {
import ext.Component;
import ext.chart.axis.Axis;
import ext.chart.interactions.AbstractInteraction;
import ext.chart.legend.store.LegendStore;
import ext.data.Store;
import ext.draw.DrawContainer;
import ext.panel.Panel;

[Native("Ext.chart.AbstractChart", require)]
/**
 * @see ext.chart.events.AbstractChartEvent.BEFORE_REFRESH
 * @eventType ext.chart.events.AbstractChartEvent.BEFORE_REFRESH
 */
[Event(name='onBeforeRefresh', type='ext.chart.events.AbstractChartEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_CLICK
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_CLICK
 */
[Event(name='onItemClick', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_DBLCLICK
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_DBLCLICK
 */
[Event(name='onItemDblclick', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_newItem_oldItemEvent.ITEM_HIGHLIGHT
 * @eventType ext.chart.events.AbstractChart_newItem_oldItemEvent.ITEM_HIGHLIGHT
 */
[Event(name='onItemHighlight', type='ext.chart.events.AbstractChart_newItem_oldItemEvent')]
/**
 * @see ext.chart.events.AbstractChart_newItem_oldItemEvent.ITEM_HIGHLIGHT_CHANGE
 * @eventType ext.chart.events.AbstractChart_newItem_oldItemEvent.ITEM_HIGHLIGHT_CHANGE
 */
[Event(name='onItemHighlightChange', type='ext.chart.events.AbstractChart_newItem_oldItemEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_DOWN
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_DOWN
 */
[Event(name='onItemMouseDown', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_MOVE
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_MOVE
 */
[Event(name='onItemMouseMove', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_OUT
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_OUT
 */
[Event(name='onItemMouseOut', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_OVER
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_OVER
 */
[Event(name='onItemMouseOver', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_UP
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_MOUSE_UP
 */
[Event(name='onItemMouseUp', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChart_item_eventEvent.ITEM_TAP
 * @eventType ext.chart.events.AbstractChart_item_eventEvent.ITEM_TAP
 */
[Event(name='onItemTap', type='ext.chart.events.AbstractChart_item_eventEvent')]
/**
 * @see ext.chart.events.AbstractChartEvent.REDRAW
 * @eventType ext.chart.events.AbstractChartEvent.REDRAW
 */
[Event(name='onRedraw', type='ext.chart.events.AbstractChartEvent')]
/**
 * @see ext.chart.events.AbstractChartEvent.REFRESH
 * @eventType ext.chart.events.AbstractChartEvent.REFRESH
 */
[Event(name='onRefresh', type='ext.chart.events.AbstractChartEvent')]
/**
 * @see ext.chart.events.AbstractChart_newStore_oldStoreEvent.STORE_CHANGE
 * @eventType ext.chart.events.AbstractChart_newStore_oldStoreEvent.STORE_CHANGE
 */
[Event(name='onStoreChange', type='ext.chart.events.AbstractChart_newStore_oldStoreEvent')]
/**
 * The Ext.chart package provides the capability to visualize data.
 * Each chart binds directly to a <i>store</i> (→<code>ext.data.Store</code>) enabling automatic
 * updates of the chart. A chart configuration object has some overall styling
 * options as well as an array of axes and series. A chart instance example could
 * look like this:
 * <pre>
 * Ext.create('Ext.chart.CartesianChart', {
 *     width: 800,
 *     height: 600,
 *     animation: {
 *         easing: 'backOut',
 *         duration: 500
 *     },
 *     store: store1,
 *     legend: {
 *         position: 'right'
 *     },
 *     axes: [
 *         // ...some axes options...
 *     ],
 *     series: [
 *         // ...some series options...
 *     ]
 * });
 * </pre>
 * <p>In this example we set the <code>→width</code> and <code>→height</code> of a chart; We decide whether
 * our series are animated or not and we select a store to be bound to the chart;
 * We also set the legend to the right part of the chart.</p>
 * <p>You can register certain interactions such as →<code>ext.chart.interactions.PanZoomInteraction</code>
 * on the chart by specifying an array of names or more specific config objects.
 * All the events will be wired automatically.</p>
 * <p>You can also listen to series <code>itemXXX</code> events on both chart and series level.</p>
 * <p>For example:</p>
 * <pre>
 * Ext.create('Ext.chart.CartesianChart', {
 *     plugins: {
 *         chartitemevents: {
 *             moveEvents: true
 *         }
 *     },
 *     store: {
 *         fields: ['pet', 'households', 'total'],
 *         data: [
 *             {pet: 'Cats', households: 38, total: 93},
 *             {pet: 'Dogs', households: 45, total: 79},
 *             {pet: 'Fish', households: 13, total: 171}
 *         ]
 *     },
 *     axes: [{
 *         type: 'numeric',
 *         position: 'left'
 *     }, {
 *         type: 'category',
 *         position: 'bottom'
 *     }],
 *     series: [{
 *         type: 'bar',
 *         xField: 'pet',
 *         yField: 'households',
 *         listeners: {
 *             itemmousemove: function (series, item, event) {
 *                 console.log('itemmousemove', item.category, item.field);
 *             }
 *         }
 *     }, {
 *         type: 'line',
 *         xField: 'pet',
 *         yField: 'total',
 *         marker: true
 *     }],
 *     listeners: { // Listen to itemclick events on all series.
 *         itemclick: function (chart, item, event) {
 *             console.log('itemclick', item.category, item.field);
 *         }
 *     }
 * });
 * </pre>
 * <p>Important! It's generally a poor design choice to put interactive charts
 * inside scrollable views, in such cases it's not possible to tell
 * which component should respond to the interaction.
 * Since charts are typically interactive their default touch action config
 * looks as follows: →<code>ext.draw.DrawContainer.touchAction</code>.
 * If you do have a chart inside a scrollable view, even if it has no interactions,
 * you have to set its <code>→touchAction</code> config to the following:</p>
 * <pre>
 * touchAction: {
 *     panX: true,
 *     panY: true
 * }
 * </pre>
 * <p>Otherwise, if a touch action started on a chart, a swipe will not scroll
 * the view.</p>
 * <p>For more information about the axes and series configurations please check
 * the documentation of each series (Line, Bar, Pie, etc).</p>
 * <p><b>From override Ext.chart.overrides.AbstractChart:</b></p>
 * @see ext.data.Store
 * @see #width
 * @see #height
 * @see ext.chart.interactions.PanZoomInteraction
 * @see ext.draw.DrawContainer#touchAction
 * @see #touchAction
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html Original Ext JS documentation of 'Ext.chart.AbstractChart'
 */
public class AbstractChart extends DrawContainer {
  /**
   * @inheritDoc
   */
  public function AbstractChart(config:AbstractChart = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Defaults to <code>easeInOut</code> easing with a 500ms duration.
   * See →<code>ext.draw.modifier.AnimationModifier</code> for possible configuration options.
   * @default true
   * @see ext.draw.modifier.AnimationModifier
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-animation Original Ext JS documentation of 'animation'
   * @see #getAnimation()
   * @see #setAnimation()
   */
  public native function get animation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set animation(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of →<code>ext.chart.axis.Axis</code> instances or config objects.
   * For example:
   * <pre>
   * axes: [{
   *     type: 'numeric',
   *     position: 'left',
   *     title: 'Number of Hits',
   *     minimum: 0
   * }, {
   *     type: 'category',
   *     position: 'bottom',
   *     title: 'Month of the Year'
   * }]
   * </pre>
   * @default []
   * @see ext.chart.axis.Axis
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-axes Original Ext JS documentation of 'axes'
   * @see #getAxes()
   * @see #setAxes()
   */
  public native function get axes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set axes(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set the chart background.
   * This can be a gradient object, image, or color.
   * <p>For example, if <code>→background</code> were to be a color we could set the object as</p>
   * <pre>
   * background: '#ccc'
   * </pre>
   * <p>You can specify an image by using:</p>
   * <pre>
   * background: {
   *     type: 'image',
   *     src: 'http://path.to.image/'
   * }
   * </pre>
   * <p>Also you can specify a gradient by using the gradient object syntax:</p>
   * <pre>
   * background: {
   *     type: 'linear',
   *     degrees: 0,
   *     stops: [
   *         {
   *             offset: 0,
   *             color: 'white'
   *         },
   *         {
   *             offset: 1,
   *             color: 'blue'
   *         }
   *     ]
   * }
   * </pre>
   * @see #background
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Chart captions can be used to place titles, subtitles, credits and other captions
   * inside a chart. For example:
   * <pre>
   * captions: {
   *     title: {
   *         text: 'Consumer Price Index'
   *     },
   *     subtitle: {
   *         text: 'from 2007 to 2017'
   *     },
   *     credits: {
   *         text: 'Source: 'bls.gov'
   *     }
   * }
   * </pre>
   * <p>One can use any names for properties in the <code>→captions</code> config, but the <code>→title</code>,
   * <code>subtitle</code> and <code>credits</code> ones have a special meaning - they are automatically
   * themeable. The <code>→title</code> and <code>subtitle</code> are automatically docked to the top of
   * a chart and the <code>credits</code> to the bottom. The <code>→title</code> uses the largest and
   * the heaviest font, while the <code>credits</code> - the smallest and the lightest.</p>
   * <p>Other captions besides those three can be easily defined as well:</p>
   * <pre>
   * captions: {
   *     myFancyCaption: {
   *         docked: 'bottom',
   *         align: 'left',
   *         style: {
   *             fontSize: 18,
   *             fontWeight: 'bold',
   *             fontFamily: 'Verdana'
   *         }
   *     }
   * }
   * </pre>
   * <p>If a caption config only specifies text, a shorthand syntax is also possible:</p>
   * <pre>
   * captions: {
   *     title: 'Consumer Price Index'
   * }
   * </pre>
   * <ul>
   * <li><code>title:ext.chart.ChartCaption</code> (optional)</li>
   * <li><code>subtitle:ext.chart.ChartCaption</code> (optional)</li>
   * <li><code>credits:ext.chart.ChartCaption</code> (optional)</li>
   * </ul>
   * @see #captions
   * @see #title
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-captions Original Ext JS documentation of 'captions'
   * @see #getCaptions()
   * @see #setCaptions()
   */
  public native function get captions():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set captions(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of colors/gradients to override the color of items and legends.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-colors Original Ext JS documentation of 'colors'
   * @see #getColors()
   * @see #setColors()
   */
  public native function get colors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set colors(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The current highlight item in the chart.
   * The object must be the one that you get from item events.
   * <p>Note that series can also own highlight items.
   * This notion is separate from this one and should not be used at the same time.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-highlightItem Original Ext JS documentation of 'highlightItem'
   * @see #getHighlightItem()
   * @see #setHighlightItem()
   */
  public native function get highlightItem():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightItem(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The amount of inset padding in pixels for the chart.
   * Inset padding is the padding from the boundary of the chart to any
   * of its contents.
   * @default {
   *     top: 10,
   *     left: 10,
   *     right: 10,
   *     bottom: 10
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-insetPadding Original Ext JS documentation of 'insetPadding'
   * @see #getInsetPadding()
   * @see #setInsetPadding()
   */
  public native function get insetPadding():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set insetPadding(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Interactions are optional modules that can be plugged in to a chart
   * to allow the user to interact with the chart and its data in special ways.
   * The <code>→interactions</code> config takes an Array of Object configurations,
   * each one corresponding to a particular interaction class identified
   * by a <code>type</code> property:
   * <pre>
   * new Ext.chart.AbstractChart({
   *     renderTo: Ext.getBody(),
   *     width: 800,
   *     height: 600,
   *     store: store1,
   *     axes: [
   *         // ...some axes options...
   *     ],
   *     series: [
   *         // ...some series options...
   *     ],
   *     interactions: [{
   *         type: 'interactiontype'
   *         // ...additional configs for the interaction...
   *     }]
   * });
   * </pre>
   * <p>When adding an interaction which uses only its default configuration
   * (no extra properties other than <code>type</code>), you can alternately specify
   * only the type as a String rather than the full Object:</p>
   * <pre>
   * interactions: ['reset', 'rotate']
   * </pre>
   * <p>The current supported interaction types include:</p>
   * <ul>
   * <li><i>panzoom</i> (→<code>ext.chart.interactions.PanZoomInteraction</code>) - allows pan and zoom of axes</li>
   * <li><i>itemhighlight</i> (→<code>ext.chart.interactions.ItemHighlightInteraction</code>) - allows highlighting
   * of series data points</li>
   * <li><i>iteminfo</i> (→<code>ext.chart.interactions.ItemInfoInteraction</code>) - allows displaying details of
   * a data point in a popup panel</li>
   * <li><i>rotate</i> (→<code>ext.chart.interactions.RotateInteraction</code>) - allows rotation of pie and radar series</li>
   * </ul>
   * <p>See the documentation for each of those interaction classes to see how they
   * can be configured.</p>
   * <p>Additional custom interactions can be registered using <code>'interactions.'</code> alias prefix.</p>
   * @default []
   * @see #interactions
   * @see ext.chart.interactions.PanZoomInteraction
   * @see ext.chart.interactions.ItemHighlightInteraction
   * @see ext.chart.interactions.ItemInfoInteraction
   * @see ext.chart.interactions.RotateInteraction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-interactions Original Ext JS documentation of 'interactions'
   * @see #getInteractions()
   * @see #setInteractions()
   */
  public native function get interactions():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set interactions(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The legend config for the chart. If specified, a legend block will be shown
   * next to the chart.
   * Each legend item displays the →<code>ext.chart.series.Series.title</code>
   * of the series, the color of the series and allows to toggle the visibility
   * of the series (at least one series should remain visible).
   * <p>Sencha Charts support two types of legends: sprite based and DOM based.</p>
   * <p>The sprite based legend can be shown in chart →<code>ext.draw.DrawContainer.preview()</code>
   * and is a part of the downloaded <i>chart image</i> (→<code>ext.draw.DrawContainer.download()</code>).
   * The sprite based legend is always displayed in full and takes as much space as necessary,
   * the legend items are split into columns to use the available space efficiently.
   * The sprite based legend is styled via a <i>chart theme</i> (→<code>ext.chart.theme.ChartTheme</code>).</p>
   * <p>The DOM based legend supports RTL.
   * It occupies a fixed width or height and scrolls when the content overflows.
   * The DOM based legend is styled via CSS rules.</p>
   * <p>By default the sprite legend is used. The type can be explicitly specified:</p>
   * <pre>
   * legend: {
   *     type: 'dom',  // 'sprite' is another possible value
   *     docked: 'top'
   * }
   * </pre>
   * <p>If the legend config is set to <code>true</code>, the sprite legend will be used
   * docked to the bottom.</p>
   * @default null
   * @see ext.chart.series.Series#title
   * @see ext.draw.DrawContainer#preview()
   * @see ext.draw.DrawContainer#download()
   * @see ext.chart.theme.ChartTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-legend Original Ext JS documentation of 'legend'
   * @see #getLegend()
   * @see #setLegend()
   */
  public native function get legend():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set legend(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of →<code>ext.chart.series.Series</code> instances or config objects.
   * For example:
   * <pre>
   * series: [{
   *     type: 'column',
   *     axis: 'left',
   *     listeners: {
   *         'afterrender': function() {
   *             console.log('afterrender');
   *         }
   *     },
   *     xField: 'category',
   *     yField: 'data1'
   * }]
   * </pre>
   * @default []
   * @see ext.chart.series.Series
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-series Original Ext JS documentation of 'series'
   * @see #getSeries()
   * @see #setSeries()
   */
  public native function get series():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set series(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The data source to which the chart is bound.
   * Acceptable values for this property are:
   * <ul>
   * <li><b>any →<code>ext.data.Store</code> class / subclass</b></li>
   * <li><b>an <i>ID of a store</i> (→<code>ext.data.Store.storeId</code>)</b></li>
   * <li><b>a →<code>ext.data.Store</code> config object</b>. When passing a config you can
   * specify the store type by alias. Passing a config object with a store type will
   * dynamically create a new store of that type when the chart is instantiated.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   * Ext.define('MyApp.store.Customer', {
   *     extend: 'Ext.data.Store',
   *     alias: 'store.customerstore',
   *
   *     fields: ['name', 'value']
   * });
   *
   *
   * Ext.create({
   *     xtype: 'cartesian',
   *     renderTo: document.body,
   *     height: 400,
   *     width: 400,
   *     store: {
   *         type: 'customerstore',
   *         data: [{
   *             name: 'metric one',
   *             value: 10
   *         }]
   *     },
   *     axes: [{
   *         type: 'numeric',
   *         position: 'left',
   *         title: {
   *             text: 'Sample Values',
   *             fontSize: 15
   *         },
   *         fields: 'value'
   *     }, {
   *         type: 'category',
   *         position: 'bottom',
   *         title: {
   *             text: 'Sample Values',
   *             fontSize: 15
   *         },
   *         fields: 'name'
   *     }],
   *     series: {
   *         type: 'bar',
   *         xField: 'name',
   *         yField: 'value'
   *     }
   * });
   * </pre>
   * @default 'ext-empty-store'
   * @see ext.data.Store
   * @see ext.data.Store#storeId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set store(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The style for the chart component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  override public native function get style():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set style(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the theme to be used. A theme defines the colors and styles
   * used by the series, axes, markers and other chart components.
   * Please see the documentation for the →<code>ext.chart.theme.ChartTheme</code> class
   * for more information.
   * <p>Possible theme values are:</p>
   * <ul>
   * <li>'green', 'sky', 'red', 'purple', 'blue', 'yellow'</li>
   * <li>'category1' to 'category6'</li>
   * <li>and the above theme names with the '-gradients' suffix, e.g. 'green-gradients'</li>
   * </ul>
   * <p>IMPORTANT: You should require the themes you use; for example, to use:</p>
   * <pre>
   * theme: 'blue'
   * </pre>
   * <p>the <code>Ext.chart.theme.Blue</code> class should be required:</p>
   * <pre>
   * requires: 'Ext.chart.theme.Blue'
   * </pre>
   * <p>To require all chart themes:</p>
   * <pre>
   * requires: 'Ext.chart.theme.&#42;'
   * </pre>
   * @default "default"
   * @see ext.chart.theme.ChartTheme
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#cfg-theme Original Ext JS documentation of 'theme'
   * @see #getTheme()
   * @see #setTheme()
   */
  public native function get theme():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set theme(value:String):void;

  /**
   * Adds a →<code>ext.chart.series.Series</code> to this chart.
   * <p>The Series (or array) passed will be added to the existing series. If an <code>→id</code> is specified
   * in a new Series, any existing Series of that <code>→id</code> will be updated.</p>
   * <p>The chart will be redrawn in response to the change.</p>
   * @param newSeries A
   * config object describing the Series to add, or an instantiated Series object. Or an array
   * of these.
   * @see ext.chart.series.Series
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-addSeries Original Ext JS documentation of 'addSeries'
   */
  public native function addSeries(newSeries:*):void;

  /**
   * Changes the data store bound to this chart and refreshes it.
   * @param store The store to bind to this chart.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  public native function bindStore(store:Store):void;

  /**
   * Cancel a scheduled layout.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-cancelChartLayout Original Ext JS documentation of 'cancelChartLayout'
   */
  public native function cancelChartLayout():void;

  /**
   * Returns the value of <code>animation</code>.
   * @see #animation
   */
  public native function getAnimation():*;

  /**
   * Returns the value of <code>axes</code>.
   * @see #axes
   */
  public native function getAxes():*;

  /**
   * Returns an axis instance based on the type of data passed.
   * @param axis You may request an axis by passing
   * an id, the number of the array key returned by →<code>getAxes</code>, or an axis instance.
   * @return The axis requested.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-getAxis Original Ext JS documentation of 'getAxis'
   * @see #getAxes
   */
  public native function getAxis(axis:*):Axis;

  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():Object;

  /**
   * Returns the value of <code>captions</code>.
   * @see #captions
   */
  public native function getCaptions():Object;

  /**
   * Returns the value of <code>colors</code>.
   * @see #colors
   */
  public native function getColors():Array;

  /**
   * Returns the value of <code>highlightItem</code>.
   * @see #highlightItem
   */
  public native function getHighlightItem():Object;

  /**
   * Returns the value of <code>insetPadding</code>.
   * @see #insetPadding
   */
  public native function getInsetPadding():*;

  /**
   * Get an interaction by type.
   * @param type The type of the interaction.
   * @return The interaction. <code>null</code>
   * if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-getInteraction Original Ext JS documentation of 'getInteraction'
   */
  public native function getInteraction(type:String):AbstractInteraction;

  /**
   * Returns the value of <code>interactions</code>.
   * @see #interactions
   */
  public native function getInteractions():Array;

  /**
   * Given an x/y point relative to the chart, find and return the first series item that
   * matches that point.
   * @return An object with <code>→series</code> and <code>item</code> properties, or <code>false</code> if no item found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-getItemForPoint Original Ext JS documentation of 'getItemForPoint'
   * @see #series
   */
  public native function getItemForPoint(x:Number, y:Number):Object;

  /**
   * Returns the value of <code>legend</code>.
   * @see #legend
   */
  public native function getLegend():*;

  /**
   * Return the legend store that contains all the legend information.
   * This information is collected from all the series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-getLegendStore Original Ext JS documentation of 'getLegendStore'
   */
  public native function getLegendStore():LegendStore;

  /**
   * Returns the value of <code>series</code>.
   * @see #series
   */
  public native function getSeries():*;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  public native function getStore():*;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Returns the value of <code>theme</code>.
   * @see #theme
   */
  public native function getTheme():String;

  /**
   * Redraw the chart. If animations are set this will animate the chart too.
   * Note: the actual redraw is performed in a subclass.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-redraw Original Ext JS documentation of 'redraw'
   */
  public native function redraw():void;

  /**
   * Remove a →<code>ext.chart.series.Series</code> from this chart.
   * The Series (or array) passed will be removed from the existing series.
   * <p>The chart will be redrawn in response to the change.</p>
   * @param series The Series or the <code>→id</code> of the Series
   * to remove. May be an array.
   * @see ext.chart.series.Series
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-removeSeries Original Ext JS documentation of 'removeSeries'
   * @see #id
   */
  public native function removeSeries(series:*):void;

  /**
   * Decrements chart's layout suspend count.
   * When the suspend count is decremented to zero,
   * a layout is scheduled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-resumeChartLayout Original Ext JS documentation of 'resumeChartLayout'
   */
  public native function resumeChartLayout():void;

  /**
   * Decrements axis thickness suspend count.
   * When axis thickness suspend count is decremented to zero,
   * chart layout is performed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-resumeThicknessChanged Original Ext JS documentation of 'resumeThicknessChanged'
   */
  public native function resumeThicknessChanged():void;

  /**
   * Schedule a layout at next frame.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-scheduleLayout Original Ext JS documentation of 'scheduleLayout'
   */
  public native function scheduleLayout():void;

  /**
   * Sets the value of <code>animation</code>.
   * @param animation The new value.
   * @see #animation
   */
  public native function setAnimation(animation:*):void;

  /**
   * Sets the value of <code>axes</code>.
   * @param axes The new value.
   * @see #axes
   */
  public native function setAxes(axes:*):void;

  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:Object):void;

  /**
   * Sets the value of <code>captions</code>.
   * @param captions The new value.
   * @see #captions
   */
  public native function setCaptions(captions:Object):void;

  /**
   * Sets the value of <code>colors</code>.
   * @param colors The new value.
   * @see #colors
   */
  public native function setColors(colors:Array):void;

  /**
   * Sets the value of <code>highlightItem</code>.
   * @param highlightItem The new value.
   * @see #highlightItem
   */
  public native function setHighlightItem(highlightItem:Object):void;

  /**
   * Sets the value of <code>insetPadding</code>.
   * @param insetPadding The new value.
   * @see #insetPadding
   */
  public native function setInsetPadding(insetPadding:*):void;

  /**
   * Sets the value of <code>interactions</code>.
   * @param interactions The new value.
   * @see #interactions
   */
  public native function setInteractions(interactions:Array):void;

  /**
   * Sets the value of <code>legend</code>.
   * @param legend The new value.
   * @see #legend
   */
  public native function setLegend(legend:*):void;

  /**
   * Sets the value of <code>series</code>.
   * @param series The new value.
   * @see #series
   */
  public native function setSeries(series:*):void;

  /**
   * Sets the value of <code>store</code>.
   * @param store The new value.
   * @see #store
   */
  public native function setStore(store:*):void;

  /**
   * Sets the value of <code>style</code>.
   * @param property The style property to be set, or an object of
   * multiple styles.
   * @param value The value to apply to the given property, or null if an
   * object was passed.
   * @see #style
   */
  override public native function setStyle(property:*, value:String = null):Component;

  /**
   * Sets the value of <code>theme</code>.
   * @param theme The new value.
   * @see #theme
   */
  public native function setTheme(theme:String):void;

  /**
   * Suspends chart's layout.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-suspendChartLayout Original Ext JS documentation of 'suspendChartLayout'
   */
  public native function suspendChartLayout():void;

  /**
   * Prevent axes from triggering chart layout when their thickness changes.
   * E.g. during an interaction that makes changes to the axes,
   * or when chart layout was triggered by something else,
   * for example a chart resize event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.AbstractChart.html#method-suspendThicknessChanged Original Ext JS documentation of 'suspendThicknessChanged'
   */
  public native function suspendThicknessChanged():void;
}
}