package ext.chart {
[Native("Ext.chart.CartesianChart", require)]
/**
 * Represents a chart that uses cartesian coordinates.
 * A cartesian chart has two directions, X direction and Y direction.
 * The series and axes are coordinated along these directions.
 * By default the x direction is horizontal and y direction is vertical,
 * You can swap the direction by setting the →<code>flipXY</code> config to <code>true</code>.
 * <p>Cartesian series often treats x direction an y direction differently.
 * In most cases, data on x direction are assumed to be monotonically increasing.
 * Based on this property, cartesian series can be trimmed and summarized properly
 * to gain a better performance.</p>
 * <p>Please check out the summary for the →<code>ext.chart.AbstractChart</code> as well,
 * for helpful tips and important details.</p>
 * @see #flipXY
 * @see ext.chart.AbstractChart
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.CartesianChart.html Original Ext JS documentation of 'Ext.chart.CartesianChart'
 */
public class CartesianChart extends AbstractChart {
  /**
   * @inheritDoc
   */
  public function CartesianChart(config:CartesianChart = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Flip the direction of X and Y axis.
   * If flipXY is <code>true</code>, the X axes will be vertical and Y axes will be horizontal.
   * Note that <i>positions</i> (→<code>ext.chart.axis.Axis.position</code>) of chart axes have
   * to be updated accordingly: axes positioned to the <code>top</code> and <code>bottom</code> should
   * be positioned to the <code>left</code> or <code>right</code> and vice versa.
   * @default false
   * @see ext.chart.axis.Axis#position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.CartesianChart.html#cfg-flipXY Original Ext JS documentation of 'flipXY'
   * @see #getFlipXY()
   * @see #setFlipXY()
   */
  public native function get flipXY():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set flipXY(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The amount of inner padding in pixels.
   * Inner padding is the padding from the innermost axes to the series.
   * @default {
   *     top: 0,
   *     left: 0,
   *     right: 0,
   *     bottom: 0
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.CartesianChart.html#cfg-innerPadding Original Ext JS documentation of 'innerPadding'
   * @see #getInnerPadding()
   * @see #setInnerPadding()
   */
  public native function get innerPadding():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set innerPadding(value:Object):void;

  /**
   * Returns the value of <code>flipXY</code>.
   * @see #flipXY
   */
  public native function getFlipXY():Boolean;

  /**
   * Returns the value of <code>innerPadding</code>.
   * @see #innerPadding
   */
  public native function getInnerPadding():Object;

  /**
   * Layout the axes and series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.chart.CartesianChart.html#method-performLayout Original Ext JS documentation of 'performLayout'
   */
  public native function performLayout():void;

  /**
   * Sets the value of <code>flipXY</code>.
   * @param flipXY The new value.
   * @see #flipXY
   */
  public native function setFlipXY(flipXY:Boolean):void;

  /**
   * Sets the value of <code>innerPadding</code>.
   * @param innerPadding The new value.
   * @see #innerPadding
   */
  public native function setInnerPadding(innerPadding:Object):void;
}
}